<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>IISER Pune Login</title>

<!-- Bootstrap 5 CDN -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
    body {
        background: #f8f9fa;
    }
    .login-card {
        max-width: 750px;
        margin: 60px auto;
        border-radius: 10px;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    .form-control {
        background: #eaf1ff;
    }
   .captcha-left {
    background: #e8e3d0;      /* same beige color */
  padding: 7px 18px;
    border-radius: 6px 0 0 6px;
    font-weight: 700;
    font-size: 20px;
    display: flex;
    align-items: center;
}
.captcha-input {
    border-radius: 0 6px 6px 0 !important;
    height: 48px;
    font-size: 16px;
}
    .btn-login {
        background: #008fa2;
        color: #fff;
        font-weight: 600;
        padding: 8px 25px;
    }
    .btn:hover {
    color: #fff;
    background-color: #f3ac17;
    border-color: var(--bs-btn-hover-border-color);
}
</style>
</head>

<body>

<div class="container">
    <div class="login-card p-5 bg-white">

        <!-- Heading -->
<!--
        <h2 class="text-center mb-3">
            <strong>IIM </strong> 
            <span style="color:#d62828;">Lucknow</span>
        </h2>
-->

        <!-- Logo -->
        <div class="text-center mb-4">
            <img src="assets/images/logo.png" width="300" alt="Logo">
        </div>

        <!-- Form -->
        <form>

            <!-- Email / Roll Number -->
            <label class="mb-1">Email or Roll Number</label>
            <input type="text" class="form-control mb-3" placeholder="Enter Email or Roll Number">

            <!-- Password -->
            <label class="mb-1">Password</label>
<div class="input-group mb-3">
    <input type="password" class="form-control" id="passwordInput" placeholder="Password">
    <span class="input-group-text bg-light" id="togglePassword" style="cursor:pointer;">
        <i class="bi bi-eye" id="eyeIcon"></i>
    </span>
</div>

            <!-- Captcha -->
        <label class="mb-1">Captcha</label>
<div class="d-flex mb-3">
    <div class="captcha-left">40366</div>
    <input type="text" class="form-control captcha-input" placeholder="Type Here">
</div>

            <!-- Login Button -->
         <button class="btn btn-login"><a href="dashboard.php" style="color: #fff;
    text-decoration: none;">LOG IN</a></button> 

        </form>
    </div>
</div>

<!-- Bootstrap Icons & JS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.2/font/bootstrap-icons.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.getElementById("togglePassword").addEventListener("click", function () {
    const passwordField = document.getElementById("passwordInput");
    const icon = document.getElementById("eyeIcon");

    if (passwordField.type === "password") {
        passwordField.type = "text";     // Show password
        icon.classList.remove("bi-eye");
        icon.classList.add("bi-eye-slash");
    } else {
        passwordField.type = "password"; // Hide password
        icon.classList.remove("bi-eye-slash");
        icon.classList.add("bi-eye");
    }
});
</script>
</body>
</html>