<?php

header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT, GET, POST");
include_once '../session/session.php';
include_once '../classes/common.php';
include_once '../classes/class_appapk.php';

$objadmin = new class_appapk();
$Object_common = new common();

ini_set("display_errors", 0);

$postdata = file_get_contents("php://input");
$jsonValue = json_decode($postdata, true);

$action = empty($jsonValue["action"]) ? "action_empty" : $jsonValue["action"];
$staff_id = empty($jsonValue["staff_id"]) ? "staff_id_empty" : $jsonValue["staff_id"];
$staff_type = empty($jsonValue["staff_type"]) ? "staff_type_empty" : $jsonValue["staff_type"];
$lead_id = empty($jsonValue["lead_id"]) ? "lead_id_empty" : $jsonValue["lead_id"];
$file_type = empty($jsonValue["file_type"]) ? "file_type_empty" : $jsonValue["file_type"];

$arr = array();

if ($action == "action_empty") {
    $arr["res_status"] = "2";
    $arr["res_msg"] = "Source Not Found!";
} else if ($staff_id == "staff_id_empty") {
    $arr["res_status"] = "3";
    $arr["res_msg"] = "Staff Id Not Found!";
} else if ($staff_type == "staff_type_empty") {
    $arr["res_status"] = "4";
    $arr["res_msg"] = "Staff Type Not Found!";
} else if ($lead_id == "lead_id_empty") {
    $arr["res_status"] = "9";
    $arr["res_msg"] = "Lead Id Not Found!";
} else if ($file_type == "file_type_empty") {
    $arr["res_status"] = "10";
    $arr["res_msg"] = "File Type Not Found!";
} else if ($action != "getfiles_490669") {
    $arr["res_status"] = "6";
    $arr["res_msg"] = "Invalid Source!";
} else {

    $added_date = DATE('Y-m-d H:i:s');

    $objadmin->staff_id = $staff_id;
    $objadmin->staff_type = $staff_type;
    $objadmin->lead_id = $lead_id;
    $objadmin->file_type = $file_type;

    if (($file_type == "survey_upload_files") || ($file_type == "survey_add_photos") || ($file_type == "survey_add_videos") || ($file_type == "installer_add_photos") || ($file_type == "installer_add_videos")) {
        $result_leadlist = $objadmin->GetAPPFileist();
        $lead_count = mysqli_num_rows($result_leadlist);
        $arr["res_status"] = "1";
        $arr["lead_count"] = $lead_count;
        if (($lead_count) > 0) {
            $i = 1;
            $arr_details = array();
            while ($row_leadlist = mysqli_fetch_array($result_leadlist)) {
                $file_upload = "https://sritechapp.com/solar-project/upload_design/" . $row_leadlist['file_upload'];
                $arr_details[] = array('lead_id' => $row_leadlist['lead_id'], 'file_id' => $row_leadlist['id'], 'file_type' => $row_leadlist['file_type'], 'file_title' => $row_leadlist['file_title'], 'file_upload' => $file_upload, 'add_date' => $row_leadlist['add_date']);
                $i++;
            }
            $arr["lead_details"] = $arr_details;
        } else {
            $arr["res_status"] = "5";
            $arr["res_msg"] = "Records not found!";
        }
    } else {
        $arr["res_status"] = "13";
        $arr["res_msg"] = "Invalid File Type!";
    }
}

$RES = json_encode($arr);
echo $RES;
?>