<?php
ob_start();
$page_name_info = "manage_lead";
include_once '../session/admin-session.php';
include_once '../classes/settings.php';
include_once '../classes/common.php';
include_once '../classes/class_admin.php';
include_once '../classes/validation.php';

$Object_setting = new class_settings();
$serversiteurl = $Object_setting->siteurl;
$objadmin = new class_admin();

$added_by = $_SESSION['staff_sessionid'];
$added_by = $objadmin->added_by = $added_by;

$result_companylist = $objadmin->GetMasterCompanyList();
?>
<style type="text/css">
    .form-control, .asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=text], .jsgrid .jsgrid-table .jsgrid-filter-row select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=number], .select2-container--default .select2-selection--single, .select2-container--default .select2-selection--single .select2-search__field, .typeahead, .tt-query, .tt-hint {
        border: 1px solid #2c2e33;
        height: calc(2.25rem + 2px);
        font-weight: normal;
        font-size: 0.875rem;
        padding: 0.625rem 0.6875rem;
        background-color: #2A3038;
        border-radius: 2px;
        color: #000;
    }
    select.form-control, select.asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row select, .select2-container--default select.select2-selection--single, .select2-container--default .select2-selection--single select.select2-search__field, select.typeahead, select.tt-query, select.tt-hint {
        padding: .4375rem .75rem;
        border: 0;
        color: #000 !important;
        background: #fff;
    }
    .form-control:focus, .asColorPicker-input:focus, .dataTables_wrapper select:focus, .jsgrid .jsgrid-table .jsgrid-filter-row input:focus[type=text], .jsgrid .jsgrid-table .jsgrid-filter-row select:focus, .jsgrid .jsgrid-table .jsgrid-filter-row input:focus[type=number], .select2-container--default .select2-selection--single:focus, .select2-container--default .select2-selection--single .select2-search__field:focus, .typeahead:focus, .tt-query:focus, .tt-hint:focus {
        background: #fff;
    }
</style>
<div class="content-wrapper" style="background: #fff;">
    <div class="page-header">
        <h3 class="page-title" style="color:#000;"> Lead Listing </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Lead</a></li>
                <li class="breadcrumb-item active" aria-current="page">Lead Listing</li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <form class="row" name="frmFilter" id="frmFilter" method="POST">
                        <div class="col-9"></div>
                        <div class="col-3">
                            <select name="filter_status" onchange="return FilterApplicantList();" id="filter_status" class="form-control" style="color:white;">
                                <option value="">All Status</option>
                                <option value="10">New Lead</option>
                                <option value="11">Follow-up</option>
                                <option value="12">Not Interested</option>
                                <option value="13">Requested for Site Survey</option>
                                <option value="14">Assign Project Incharge</option>
                                <option value="15">Site Survey</option>
                                <option value="16">Site Survey Work Complete</option>
                                <option value="17">Solar Design</option>
                                <option value="18">Solar Design Work Complete</option>
                                <option value="19">Cost Estimator</option>
                                <option value="20">Proposal Approved by Client</option>
                                <option value="21">Assign Installer & Material Order</option>
                                <option value="22">Material Deliver</option>
                                <option value="23">Installation Completed</option>
                                <!--                                <option value="18">Receive Work Order</option>
                                <option value="19">Installer & Incharge Assign</option>
                                <option value="20">Delivering Material</option>
                                <option value="21">Installation</option>
                                <option value="22">Site Inspection</option>
                                <option value="23">Net Metering</option>
                                <option value="24">Handing Over Certificate</option>
                                <option value="25">Compiling and filing all the papers</option>-->
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-sm-12 text-center">
                            <div id="divProcessingF" class="alert alert-info" style="display: none;">Processing... Please wait.</div>
                        </div>
                        <!--</div>-->
                    </form>
                    <div class="table-responsive">
                        <table id="tbladminList" class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                            <thead>
                                <tr>
                                    <th data-orderable="false">SN</th>
                                    <th data-orderable="false">Customer Name</th>
                                    <th data-orderable="false">Mobile Number</th>
                                    <th data-orderable="false">Address</th>
                                    <th data-orderable="false">City</th>
                                    <th data-orderable="false">Followup</th>
                                    <th data-orderable="false">Add Date</th>
                                    <th data-orderable="false">Status</th>
                                    <th data-orderable="false">Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div id="teleleadstatus_modalid" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <!--<h4 class="modal-title">Modal Header</h4>-->
            </div>
            <div class="modal-body">
                <form class="forms-sample row" action="" id="leadstatustelecaller_formid" method="post">
                    <div class="col-12" style="display: none;">
                        <div class="form-group">
                            <label for="followUpDate">Status</label>
                            <select name="leadch_status" readonly="" onmousedown="(function (e) {
                                        e.preventDefault();
                                    })(event, this)" id="leadch_status" class="form-control">
                                <option value="11">Follow-up</option>
                                <option value="12">Not Interested</option>
                                <option value="13">Requested for Site Survey</option>
                                <option value="14">Assign Project Incharge</option>
                                <option value="15">Site Survey</option>
                                <option value="16">Site Survey Work Complete</option>
                                <option value="17">Solar Design</option>
                                <option value="18">Solar Design Work Complete</option>
                                <option value="19">Cost Estimator</option>
                                <option value="20">Proposal Approved by Client</option>
                                <option value="21">Assign Installer & Material Order</option>
                                <option value="22">Material Deliver</option>
                                <option value="23">Installation Completed</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-12" style="display: none;" id="assignstaff_divid">
                        <div class="form-group">
                            <label for="staffid_labelid" id="staffid_labelid"></label>
                            <select style="background: white;" id="staff_id" name="staff_id" class="form-control">

                            </select>
                        </div>
                    </div>
                    <div class="col-12" style="display: none;" id="assignstorkeeperid_divid">
                        <div class="form-group">
                            <label for="saleshead_id">Store Keeper</label>
                            <select style="background: white;" id="storekeeper_id" name="storekeeper_id" class="form-control">

                            </select>
                        </div>
                    </div>
                    <div class="col-12" style="display: none;" id="assignsaleshead_divid">
                        <div class="form-group">
                            <label for="saleshead_id">Sales Executive</label>
                            <select style="background: white;" id="saleshead_id" name="saleshead_id" class="form-control">

                            </select>
                        </div>
                    </div>
                    <div class="col-12" style="display: none;" id="assigncompany_divid">
                        <div class="form-group">
                            <label for="company_id">Company</label>
                            <select style="background: white;" id="company_id" name="company_id" class="form-control">
                                <?php
                                if (mysqli_num_rows($result_companylist) > 0) {
                                    while ($row_companylist = mysqli_fetch_array($result_companylist)) {
                                        ?>
                                        <option value="<?php echo $row_companylist['company_id']; ?>"><?php echo $row_companylist['company_name']; ?></option>  
                                        <?php
                                    }
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-12" id="followup_divid">
                        <div class="form-group">
                            <label for="followUpDate" id="followup_labelid">Follow-up Date</label>
                            <input style="background: white;" type="date" id="followup_date" name="followup_date" class="form-control clrfield">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label for="address">Notes</label>
                            <input style="background: white;" type="text" id="notes" name="notes" class="form-control clrfield" placeholder="Enter Notes">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <input type="hidden" name="hidden_leadid" id="hidden_leadid" class="form-control" value="">
                            <a class="login-btn btn btn btn-danger profile-save-btn" id="processing_divid" style="display: none;">Processing...</a>
                            <input type="submit" class="btn btn-primary mb-2" id="statuschange_btnid" name="statuschange_btnid" value="Save" style="    width: 50%;
                                   height: 39px;">
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<button type="button" style="display: none;" id="teleleadstatus_btnid" class="btn btn-info btn-lg" data-toggle="modal" data-target="#teleleadstatus_modalid">Open Modal</button>
<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include '../masters/admin-master.php';
?>

<script type="text/javascript" language="javascript" >

    $(document).ready(function () {
        AdminLeadsListing();
        function AdminLeadsListing() {
            var dataTable = $('#tbladminList').DataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'ajax': {
                    'url': 'lead-add.inc.php?action=show_leadlist',
                    "type": "POST",
                    "data": function (d) {
                        d.form = JSON.stringify($("#frmFilter").serializeArray());
                    }
                }
                ,
                'columns': [
                    {
                        data: 'sno'
                    }
                    ,
                    {
                        data: 'customer_name'
                    }
                    ,
                    {
                        data: 'mobile_number'
                    }
                    ,
                    {
                        data: 'address'
                    }
                    ,
                    {
                        data: 'city'
                    }
                    ,
                    {
                        data: 'followup_date'
                    }
                    ,
                    {
                        data: 'added_date'
                    }
                    ,
                    {
                        data: 'status'
                    }
                    ,
                    {
                        data: 'action'
                    }
                ],
                columnDefs: [
                    {
                        className: 'text-center', targets: [0]
                    }
                ],
                "lengthMenu": [500, 1000, 10000],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'Lead List',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5, 6]
                        }
                    }
                ]
            }
            );
        }
    }
    );

    function FilterApplicantList() {
        $('#tbladminList').DataTable().ajax.reload();
    }

    function TelecallerLeadStatusChange(lead_id, leadstatus) {
        $('.clrfield').val('');
        $('#hidden_leadid').val(lead_id);
        $('#leadch_status').val(leadstatus);
        $('#followup_divid').hide();
        $('#assignsaleshead_divid').hide();
        $('#assignstorkeeperid_divid').hide();
        $('#assigncompany_divid').hide();
        if (leadstatus == '11') {
            $('#followup_labelid').html('Follow-up Date');
            $('#assignstaff_divid').hide();
            $('#followup_divid').show();
            $('#assignsaleshead_divid').hide();
            $('#assigncompany_divid').hide();
        } else if (leadstatus == '12') {
            $('#followup_divid').hide();
            $('#assignstaff_divid').hide();
            $('#assignsaleshead_divid').hide();
            $('#assigncompany_divid').hide();
        } else if (leadstatus == '13') {
            $('#followup_divid').hide();
            $('#assignstaff_divid').hide();
            $('#assignsaleshead_divid').hide();
            $('#assigncompany_divid').hide();
        } else if ((leadstatus == '14') || (leadstatus == '15') || (leadstatus == '17') || (leadstatus == '19') || (leadstatus == '21')) {
            $.ajax({
                type: "POST",
                url: "get-stafflist.php",
                data: "hidden_leadid=" + lead_id + "&leadch_status=" + leadstatus,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    $('#staff_id').html(data_arr[0]);
                    if (leadstatus == '19') {
                        $('#saleshead_id').html(data_arr[1]);
                    }
                    if (leadstatus == '21') {
                        $('#storekeeper_id').html(data_arr[1]);
                    }
                }
            }
            );
            $('#followup_labelid').html('Meeting Date');
            $('#followup_divid').hide();
            if (leadstatus == '14') {
                $('#staffid_labelid').html('Select Project Incharge');
                $('#assignsaleshead_divid').hide();
                $('#assigncompany_divid').hide();
            } else if (leadstatus == '15') {
                $('#staffid_labelid').html('Site Inspection Engineer');
                $('#assignsaleshead_divid').hide();
                $('#assigncompany_divid').hide();
            } else if (leadstatus == '17') {
                $('#staffid_labelid').html('Solar Designer');
                $('#assignsaleshead_divid').hide();
                $('#assigncompany_divid').hide();
            } else if (leadstatus == '19') {
                $('#staffid_labelid').html('Cost Estimator');
                $('#assignsaleshead_divid').show();
                $('#assigncompany_divid').show();
            } else if (leadstatus == '21') {
                $('#staffid_labelid').html('Installer');
                $('#assignstorkeeperid_divid').show();
            }

            $('#assignstaff_divid').show();
        }

        $('#teleleadstatus_btnid').click();
    }
</script>