<?php
include_once '../session/admin-session.php';
include_once '../classes/class_admin.php';
include_once '../classes/validation.php';
include_once '../classes/common.php';
ob_start();

$log = new common();
$objadm = new class_admin();
$val = new validation();

/* Getting the List of semester */
$resultSem = $objadm->MasterSemesterList();
$SemNameArr = array();
while ($rowsem = mysqli_fetch_assoc($resultSem)) {
    $SemNameArr[$rowsem['sem_num']] = $rowsem['new_name'];
}

$ProjectFlags = $objadm->MasterActiveMSProjectFlagSetting();
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-xl-12 col-xxl-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">MS Projects Flags</h5>

                </div>
                <div class="card-body">

                    <div class="container mt-4">
                        <div class="section-title"><i>*Click the OPEN/CLOSE button to toggle the action.</i></div>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Project Start Sem</th>
                                    <th>Invite Proposal</th>
                                    <th>Mid Year Thesis</th>
                                    <th>Final Thesis</th>
                                    <th>Mid Year Report</th>
                                    <th>Final Report</th>
                                    <th>Viva Marks</th>
                                    <th>Student View Report</th>
                                    <th>Student View Marks</th>
                                </tr>
                            </thead>
                            <tbody>

                                <!-- Sample row for each batch -->
                                <?php
                                while ($row = mysqli_fetch_array($ProjectFlags)) {

                                    $prj_invite = $row['prj_invite'];
                                    $mid_thesis_upload = $row['mid_thesis_upload'];
                                    $end_thesis_upload = $row['end_thesis_upload'];
                                    $mid_report_upload = $row['mid_report_upload'];
                                    $end_report_upload = $row['end_report_upload'];
                                    $viva_marks_upload = $row['viva_marks_upload'];
                                    $students_view = $row['students_view'];
                                    $students_marks = $row['students_marks'];

                                    $semester_name = $SemNameArr[$row['start_sem']];

                                    $flag_pk_id = $row['flag_sr'];
                                    ?>
                                    <tr>
                                        <td><?php echo $semester_name; ?></td>
                                        <td>
                                            <?php if ($prj_invite == "Y") { ?>
                                                <input type="button" class="btn btn-success" value="OPEN" onclick="FunUpdateProjectFlags('prj_invite', 'CLOSE', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } else { ?>
                                                <input type="button" class="btn btn-danger" value="CLOSE" onclick="FunUpdateProjectFlags('prj_invite', 'OPEN', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if ($mid_thesis_upload == "Y") { ?>
                                                <input type="button" class="btn btn-success" value="OPEN" onclick="FunUpdateProjectFlags('mid_thesis_upload', 'CLOSE', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } else { ?>
                                                <input type="button" class="btn btn-danger" value="CLOSE" onclick="FunUpdateProjectFlags('mid_thesis_upload', 'OPEN', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if ($end_thesis_upload == "Y") { ?>
                                                <input type="button" class="btn btn-success" value="OPEN" onclick="FunUpdateProjectFlags('end_thesis_upload', 'CLOSE', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } else { ?>
                                                <input type="button" class="btn btn-danger" value="CLOSE" onclick="FunUpdateProjectFlags('end_thesis_upload', 'OPEN', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php
                                            if ($mid_report_upload == "Y") {
                                                ?>
                                                <input type="button" class="btn btn-success" value="OPEN" onclick="FunUpdateProjectFlags('mid_report_upload', 'CLOSE', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } else { ?>
                                                <input type="button" class="btn btn-danger" value="CLOSE" onclick="FunUpdateProjectFlags('mid_report_upload', 'OPEN', '<?php echo $flag_pk_id; ?>')"/>
                                                <?php
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <?php
                                            if ($end_report_upload == "Y") {
                                                ?>
                                                <input type="button" class="btn btn-success" value="OPEN" onclick="FunUpdateProjectFlags('end_report_upload', 'CLOSE', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } else { ?>
                                                <input type="button" class="btn btn-danger" value="CLOSE" onclick="FunUpdateProjectFlags('end_report_upload', 'OPEN', '<?php echo $flag_pk_id; ?>')"/>
                                                <?php
                                            }
                                            ?>
                                        </td>
                                        <td>
                                                <?php
                                            if ($viva_marks_upload == "Y") {
                                                ?>
                                                <input type="button" class="btn btn-success" value="OPEN" onclick="FunUpdateProjectFlags('viva_marks_upload', 'CLOSE', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } else { ?>
                                                <input type="button" class="btn btn-danger" value="CLOSE" onclick="FunUpdateProjectFlags('viva_marks_upload', 'OPEN', '<?php echo $flag_pk_id; ?>')"/>
                                                <?php
                                            }
                                            ?>
                                        </td>
                                               <td>
                                                <?php
                                            if ($students_view == "Y") {
                                                ?>
                                                <input type="button" class="btn btn-success" value="OPEN" onclick="FunUpdateProjectFlags('students_view', 'CLOSE', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } else { ?>
                                                <input type="button" class="btn btn-danger" value="CLOSE" onclick="FunUpdateProjectFlags('students_view', 'OPEN', '<?php echo $flag_pk_id; ?>')"/>
                                                <?php
                                            }
                                            ?>
                                        </td>
                                        
                                            <td>
                                                <?php
                                            if ($students_marks == "Y") {
                                                ?>
                                                <input type="button" class="btn btn-success" value="OPEN" onclick="FunUpdateProjectFlags('students_marks', 'CLOSE', '<?php echo $flag_pk_id; ?>')"/>
                                            <?php } else { ?>
                                                <input type="button" class="btn btn-danger" value="CLOSE" onclick="FunUpdateProjectFlags('students_marks', 'OPEN', '<?php echo $flag_pk_id; ?>')"/>
                                                <?php
                                            }
                                            ?>
                                        </td>

                                    </tr>
                                        <?php } ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

    </div>
</div>
<?php
$pagemaincontent = ob_get_contents();
ob_clean();
$PAGENAME = 'control_system_flags';
$HTMLTITLE = '';
$HTMLDESCRIPTION = '';
$HTMLKEYWORDS = '';
include("admin-master.php");
?>
<script type="text/javascript">

    function FunUpdateProjectFlags(col_name, ActionStr, RefId) {
        if (confirm("Are you sure you want to " + ActionStr + "?")) {
            $.post("admin-action.php",
                    {
                        col_name: col_name,
                        activity: ActionStr,
                        ref_id: RefId,
                        action: "project-flag-update"
                    },
                    function (response) {
                        window.location.href = 'ms-projects-flags.php';
                        alert('Flag is updated successfully!');
                    });
        }
    }

</script>