<?php
ob_start();
include_once './manage-templateitems.inc.php';
$page_name_info = "manage_templateitems";
?>
<style type="text/css">
    .form-control, .asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=text], .jsgrid .jsgrid-table .jsgrid-filter-row select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=number], .select2-container--default .select2-selection--single, .select2-container--default .select2-selection--single .select2-search__field, .typeahead, .tt-query, .tt-hint {
        border: 1px solid #2c2e33;
        height: calc(2.25rem + 2px);
        font-weight: normal;
        font-size: 0.875rem;
        padding: 0.625rem 0.6875rem;
        background-color: #2A3038;
        border-radius: 2px;
        color: #000;
    }
    select.form-control, select.asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row select, .select2-container--default select.select2-selection--single, .select2-container--default .select2-selection--single select.select2-search__field, select.typeahead, select.tt-query, select.tt-hint {
        padding: .4375rem .75rem;
        border: 0;
        color: #000 !important;
    }
</style>
<div class="content-wrapper" style="background: #fff;">
    <div class="page-header">
        <h3 class="page-title" style="color:#000;"> Manage Template Items </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Template</a></li>
                <li class="breadcrumb-item active" aria-current="page">Manage Template Items</li>
            </ol>
        </nav>
    </div>
    <?php
    if (mysqli_num_rows($result_templatelist) > 0) {
        if (mysqli_num_rows($result_templateitemlist) === 0) {
            ?>
            <div class="row">
                <div class="col-12 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <form class="forms-sample row" action="" id="copytemplateadd_formid" method="post">
                                <div class="col-12 " id="copytemplate_successmsgid" style="display: none;">
                                    <div class="clearfix"></div><br/>
                                    <div class="alert alert-success text-center" style="margin-bottom: 0px;">Items Successfully Saved</div>
                                    <div class="clearfix"></div><br/>
                                </div>
                                <div class="col-3"></div>
                                <div class="col-4">
                                    <div class="form-group">
                                        <label>Items Copy from Template</label>
                                        <div>
                                            <select class="form-control clrfield" name="copy_template" id="copy_template" style="background-color: #fafdf4;">
                                                <option value="">Select Template</option>
                                                <?php while ($row_templatelist = mysqli_fetch_array($result_templatelist)) { ?>
                                                    <option value="<?php echo $row_templatelist['id']; ?>"><?php echo $row_templatelist['template_name']; ?> KWP</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-2">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div>
                                            <input type="hidden" name="orignaltemplate_id" id="orignaltemplate_id" class="form-control" value="<?php echo common::StrFromDb($template_id); ?>">
                                            <a class="login-btn btn btn btn-danger profile-save-btn" id="copytemplateprocessing_divid" style="display: none;">Processing...</a>
                                            <input type="submit" class="btn btn-block btn-primary" id="copytemplate_btnid" name="copytemplate_btnid" value="Save" style="height: 39px;">
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
    }
    ?>
    <div class="row">
        <div class="col-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <form class="forms-sample row" action="" id="templateitemsadd_formid" method="post">
                        <div class="col-12 " id="signup_successmsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-success text-center" style="margin-bottom: 0px;">Template Items Successfully Saved</div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-3">
                            <div class="form-group">
                                <label>Type</label>
                                <div>
                                    <select class="form-control clrfield" name="type" id="type" style="background-color: #fafdf4;">
                                        <option value="">Select Type</option>
                                        <option value="MAIN ITEMS" <?php if ($row_memberdetails['type'] == "MAIN ITEMS") { ?> selected="" <?php } ?>>MAIN ITEMS</option>
                                        <option value="MISCELLENEOUS ITEMS" <?php if ($row_memberdetails['type'] == "MISCELLENEOUS ITEMS") { ?> selected="" <?php } ?>>MISCELLENEOUS ITEMS</option>
                                        <option value="OTHER WORKS" <?php if ($row_memberdetails['type'] == "OTHER WORKS") { ?> selected="" <?php } ?>>OTHER WORKS</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Select Category</label>
                                <div>
                                    <select class="form-control clrfield" onchange="ChangeProductCategory(this.value);" name="category_id" id="category_id" style="background-color: #fafdf4;">
                                        <option value="">Select Category</option>
                                        <?php while ($row_categorylist = mysqli_fetch_array($result_categorylist)) { ?>
                                            <option value="<?php echo $row_categorylist['id']; ?>" <?php if ($row_categorylist['id'] == $row_memberdetails['category_id']) { ?> selected="" <?php } ?>><?php echo $row_categorylist['category_name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-5">
                            <div class="form-group">
                                <label>Select Product</label>
                                <div>
                                    <select class="form-control clrfield" onchange="ChangeSelectedProduct(this.value);" name="product_id" id="product_id" style="background-color: #fafdf4;">
                                        <option value="">Select Product</option>
                                        <?php while ($rowproductlist = mysqli_fetch_array($resultproductlist)) { ?>
                                            <option value="<?php echo $rowproductlist['id'] . "-" . $rowproductlist['product_rate']; ?>" <?php if ($rowproductlist['id'] == $row_memberdetails['product_id']) { ?> selected="" <?php } ?>><?php echo $rowproductlist['product_name'] . " " . $rowproductlist['product_specification'] . " " . $rowproductlist['capacity'] . " - " . $rowproductlist['brand_name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Amount</label>
                                <div>
                                    <input type="text" name="item_amount" id="item_amount" autocomplete="item_amount" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['item_amount']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Quantity</label>
                                <div>
                                    <input type="number" name="quantity" id="quantity" autocomplete="quantity" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['quantity']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <input type="hidden" name="hidden_templateitemid" id="hidden_templateitemid" class="form-control clrfield" value="<?php echo common::StrFromDb($templateitem_id); ?>">
                                    <input type="hidden" name="template_id" id="template_id" class="form-control" value="<?php echo common::StrFromDb($template_id); ?>">
                                    <a class="login-btn btn btn btn-danger profile-save-btn" id="processing_divid" style="display: none;">Processing...</a>
                                    <input type="submit" class="btn btn-block btn-primary" id="register_btnid" name="register_btnid" value="Save" style="height: 39px;">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <h4 style="color:#000;">
        Template View
        <div class="clearfix"></div>
    </h4>
    <div class="row">
        <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                            <thead>                            
                                <tr>
                                    <th>S.NO.</th>
                                    <th>DISCRIPTION</th>
                                    <th>SPECIFICATIONS</th>
                                    <th>MAKE</th>
                                    <th style="text-align: center;">QTY</th>
                                    <th style="text-align: center;">UNIT</th>
                                    <th>RATE</th>   
                                    <th style="text-align: right;">AMOUNT</th>   
                                    <th>ACTION</th>
                                </tr>
                                <tr>
                                    <td colspan="9" style="text-align: center;background: #59c560;">
                                        <strong>MAIN ITEMS</strong>
                                    </td>
                                </tr>
                                <?php
                                $m = 1;
                                $main_total_amount = 0;
                                foreach ((array) $row_templatelist_mainarray AS $row_templatelist_mainkey) {
                                    $quantity_amount = $row_templatelist_mainkey['item_amount'] * $row_templatelist_mainkey['quantity'];
                                    $main_total_amount = $quantity_amount + $main_total_amount;
                                    ?>
                                    <tr>
                                        <td><?php echo $m; ?></td>
                                        <td><?php echo $row_templatelist_mainkey['product_name']; ?></td>
                                        <td><?php echo $row_templatelist_mainkey['product_specification'] . " " . $row_templatelist_mainkey['capacity']; ?></td>
                                        <td><?php echo $row_templatelist_mainkey['brand_name']; ?></td>
                                        <td style="text-align: center;">
                                            <input type="text" style="width: 60px;" value="<?php echo $row_templatelist_mainkey['quantity']; ?>"/>
                                        </td>
                                        <td style="text-align: center;"><?php echo $row_templatelist_mainkey['unit_type']; ?></td>
                                        <td>
                                            <input type="text" style="width: 90px;" value="<?php echo $row_templatelist_mainkey['item_amount']; ?>"/>
                                        </td>   
                                        <td style="text-align: right;"><?php echo number_format((float) $quantity_amount, 2, '.', ''); ?></td>   
                                        <td>
                                            <a style="color: #fff;" href="manage-templateitems.php?template_id=<?php echo $template_id; ?>&templateitem_id=<?php echo $row_templatelist_mainkey['id']; ?>&action=edit">Edit</a> | 
                                            <a style="cursor: pointer;color: #fff;" onclick="RemoveTemplateItems('<?php echo $template_id; ?>', '<?php echo $row_templatelist_mainkey[id]; ?>');">Remove</a>
                                        </td>
                                    </tr>
                                    <?php
                                    $m++;
                                }
                                ?>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <strong><?php echo number_format((float) $main_total_amount, 2, '.', ''); ?></strong>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td colspan="9" style="text-align: center;background: #59c560;">
                                        <strong>MISCELLENEOUS ITEMS</strong>
                                    </td>
                                </tr>
                                <?php
                                $miscelleneous_total_amount = 0;
                                foreach ((array) $row_templatelist_miscelleneousarray AS $row_templatelist_miscelleneouskey) {
                                    $quantity_amount = $row_templatelist_miscelleneouskey['item_amount'] * $row_templatelist_miscelleneouskey['quantity'];
                                    $miscelleneous_total_amount = $quantity_amount + $miscelleneous_total_amount;
                                    ?>
                                    <tr>
                                        <td><?php echo $m; ?></td>
                                        <td><?php echo $row_templatelist_miscelleneouskey['product_name']; ?></td>
                                        <td><?php echo $row_templatelist_miscelleneouskey['product_specification'] . " " . $row_templatelist_miscelleneouskey['capacity']; ?></td>
                                        <td><?php echo $row_templatelist_miscelleneouskey['brand_name']; ?></td>
                                        <td style="text-align: center;">
                                            <input type="text" style="width: 60px;" value="<?php echo $row_templatelist_miscelleneouskey['quantity']; ?>"/>
                                        </td>
                                        <td style="text-align: center;"><?php echo $row_templatelist_miscelleneouskey['unit_type']; ?></td>
                                        <td>
                                            <input type="text" style="width: 90px;" value="<?php echo $row_templatelist_miscelleneouskey['item_amount']; ?>"/>
                                        </td>   
                                        <td style="text-align: right;"><?php echo number_format((float) $quantity_amount, 2, '.', ''); ?></td>   
                                        <td>
                                            <a style="color: #fff;" href="manage-templateitems.php?template_id=<?php echo $template_id; ?>&templateitem_id=<?php echo $row_templatelist_miscelleneouskey['id']; ?>&action=edit">Edit</a> | 
                                            <a style="cursor: pointer;color: #fff;" onclick="RemoveTemplateItems('<?php echo $template_id; ?>', '<?php echo $row_templatelist_miscelleneouskey[id]; ?>');">Remove</a>
                                        </td>
                                    </tr>
                                    <?php
                                    $m++;
                                }
                                ?>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <strong><?php echo number_format((float) $miscelleneous_total_amount, 2, '.', ''); ?></strong>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td colspan="9" style="text-align: center;background: #59c560;">
                                        <strong>OTHER WORKS</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td><strong>Total Material Cost</strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <strong><?php echo number_format((float) $main_total_amount + $miscelleneous_total_amount, 2, '.', ''); ?></strong>
                                    </td>
                                    <td></td>
                                </tr>
                                <?php
                                $otherwork_total_amount = 0;
                                foreach ((array) $row_templatelist_otherworksarray AS $row_templatelist_otherworkskey) {
                                    $quantity_amount = $row_templatelist_otherworkskey['item_amount'] * $row_templatelist_otherworkskey['quantity'];
                                    $otherwork_total_amount = $quantity_amount + $otherwork_total_amount;
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td><?php echo $row_templatelist_otherworkskey['product_name']; ?></td>
                                        <td><?php echo $row_templatelist_otherworkskey['product_specification'] . " " . $row_templatelist_otherworkskey['capacity']; ?></td>
                                        <td><?php echo $row_templatelist_otherworkskey['brand_name']; ?></td>
                                        <td style="text-align: center;">
                                            <input type="text" style="width: 60px;" value="<?php echo $row_templatelist_otherworkskey['quantity']; ?>"/>
                                        </td>
                                        <td style="text-align: center;"><?php echo $row_templatelist_otherworkskey['unit_type']; ?></td>
                                        <td>
                                            <input type="text" style="width: 90px;" value="<?php echo $row_templatelist_otherworkskey['item_amount']; ?>"/>
                                        </td>   
                                        <td style="text-align: right;"><?php echo number_format((float) $quantity_amount, 2, '.', ''); ?></td>   
                                        <td>
                                            <a style="color: #fff;" href="manage-templateitems.php?template_id=<?php echo $template_id; ?>&templateitem_id=<?php echo $row_templatelist_otherworkskey['id']; ?>&action=edit">Edit</a> | 
                                            <a style="cursor: pointer;color: #fff;" onclick="RemoveTemplateItems('<?php echo $template_id; ?>', '<?php echo $row_templatelist_otherworkskey[id]; ?>');">Remove</a>
                                        </td>
                                    </tr>
                                    <?php
                                    $mi++;
                                }
                                ?>
                                <tr>
                                    <td></td>
                                    <td>Total Cost without Overheads</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <strong><?php echo number_format((float) $main_total_amount + $miscelleneous_total_amount + $otherwork_total_amount, 2, '.', ''); ?></strong>
                                    </td>
                                    <td></td>
                                </tr>
                                <?php
                                $ttlcostwithoutoverheads = $main_total_amount + $miscelleneous_total_amount + $otherwork_total_amount;
                                $ttlcostwithoverheads = ($row_templatedetails['overheads'] / 100) * $ttlcostwithoutoverheads;
                                $ttlcostwithoverheads = number_format((float) $ttlcostwithoverheads, 2, '.', '');
                                $ttlcost = $ttlcostwithoutoverheads + $ttlcostwithoverheads;
                                ?>
                                <tr>
                                    <td></td>
                                    <td>Overheads</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td>
                                        <input type="text" onblur="ChangeTemplateOverHeads();" style="width: 50px;" id="template_overheads" name="template_overheads" value="<?php echo $row_templatedetails['overheads']; ?>"/> %
                                    </td>
                                    <td style="text-align: right;">
                                        <?php echo $ttlcostwithoverheads; ?>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td><strong>Total Cost</strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <strong><?php echo number_format((float) $ttlcost, 2, '.', ''); ?></strong>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td colspan="9" style="text-align: center;background: #59c560;">
                                        <strong>FINAL PRICING</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td>Total Overall</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <strong><?php echo number_format((float) $ttlcost, 2, '.', ''); ?></strong>
                                    </td>
                                    <td></td>
                                </tr>
                                <?php
                                $profit_inpercentage = ($row_templatedetails['profit'] / 100) * $ttlcost;
                                $profit_inpercentage = number_format((float) $profit_inpercentage, 2, '.', '');
                                $grandtotal = $ttlcost + $profit_inpercentage;
                                ?>
                                <tr>
                                    <td></td>
                                    <td>Profit</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td>
                                        <input type="text" onblur="ChangeTemplateProfit();" style="width: 50px;" id="template_profit" name="template_profit" value="<?php echo $row_templatedetails['profit']; ?>"/> %
                                    </td>
                                    <td style="text-align: right;">
                                        <?php echo $profit_inpercentage; ?>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td>Grand Total</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <strong><?php echo $grandtotal; ?></strong>
                                    </td>
                                    <td></td>
                                </tr>
                                <?php
                                $gst_inpercentage = ($row_templatedetails['gst'] / 100) * $grandtotal;
                                $gst_inpercentage = number_format((float) $gst_inpercentage, 2, '.', '');
                                $salesprice = $grandtotal + $gst_inpercentage;
                                ?>
                                <tr>
                                    <td></td>
                                    <td>GST</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td>
                                        <input type="text" onblur="ChangeTemplateGST();" style="width: 50px;" id="template_gst" name="template_gst" value="<?php echo $row_templatedetails['gst']; ?>"/> %
                                    </td>
                                    <td style="text-align: right;">
                                        <?php echo $gst_inpercentage; ?>
                                    </td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td>Sales Price</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <strong><?php echo $salesprice; ?></strong>
                                    </td>
                                    <td></td>
                                </tr>
                                <?php
                                $sales_perkilowatt = $salesprice / $row_templatedetails['template_name'];
                                $sales_perkilowatt = number_format((float) $sales_perkilowatt, 2, '.', '');
                                ?>
                                <tr>
                                    <td></td>
                                    <td>Sale Price Per KWP</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="text-align: right;">
                                        <strong><?php echo $sales_perkilowatt; ?></strong>
                                    </td>
                                    <td></td>
                                </tr>
                            </thead>                                
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include '../masters/admin-master.php';
?>

<script type="text/javascript" language="javascript" >

    function ChangeSelectedProduct(itemidamount) {
        itemidamount = itemidamount.trim();
        itemidamount_arr = itemidamount.split('-');
        $('#item_amount').val(itemidamount_arr[1]);
    }

    function ChangeProductCategory(category_id) {
        $.ajax({
            type: "POST",
            url: "get-productcategory.php",
            data: "category_id=" + category_id + "&action=get-productcategory",
            success: function (data) {
                $('#product_id').html(data);
            }
        });
    }

    function RemoveTemplateItems(template_id, templateitem_id) {
        if (confirm("Are you sure you want to perform this action?")) {
            $.ajax({
                type: "POST",
                url: "manage-templateitems.inc.php",
                data: "template_id=" + template_id + "&templateitem_id=" + templateitem_id + "&action=active_inactive",
                success: function (data) {
                    alert('Action successfully performed');
                    window.location = 'manage-templateitems.php?template_id=' + template_id;
                }
            });
        }
    }

    function ChangeTemplateOverHeads() {
        var template_overheads = $('#template_overheads').val();
        var template_id = $('#template_id').val();
        $.ajax({
            type: "POST",
            url: "manage-templateitems.inc.php",
            data: "template_id=" + template_id + "&template_overheads=" + template_overheads + "&action=template_overheads",
            success: function (data) {
                alert('Action successfully performed');
                window.location = 'manage-templateitems.php?template_id=' + template_id;
            }
        });
    }

    function ChangeTemplateProfit() {
        var template_profit = $('#template_profit').val();
        var template_id = $('#template_id').val();
        $.ajax({
            type: "POST",
            url: "manage-templateitems.inc.php",
            data: "template_id=" + template_id + "&template_profit=" + template_profit + "&action=template_profit",
            success: function (data) {
                alert('Action successfully performed');
                window.location = 'manage-templateitems.php?template_id=' + template_id;
            }
        });
    }

    function ChangeTemplateGST() {
        var template_gst = $('#template_gst').val();
        var template_id = $('#template_id').val();
        $.ajax({
            type: "POST",
            url: "manage-templateitems.inc.php",
            data: "template_id=" + template_id + "&template_gst=" + template_gst + "&action=template_gst",
            success: function (data) {
                alert('Action successfully performed');
                window.location = 'manage-templateitems.php?template_id=' + template_id;
            }
        });
    }
</script>