<?php
ob_start();
include_once './manage-subadmin.inc.php';
$page_name_info = "manage_subadmin";
?>
<div class="content-wrapper" style="    background: #fff;">
    <div class="page-header">
        <h3 class="page-title" style="color:#000;"> Manage Subadmin </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Subadmin</a></li>
                <li class="breadcrumb-item active" aria-current="page">Manage Subadmin</li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Add Subadmin</h4>
                    <form class="forms-sample row" action="" id="staffadd_formid" method="post">
                        <div class="col-12" id="signup_errormsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-danger text-center" style="margin-bottom: 0px;">Staff already exists with the <span id="alreadyexistemailandmobile"></span> you entered</div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-12 " id="signup_successmsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-success text-center" style="margin-bottom: 0px;">Subadmin Successfully Saved</div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-4" style="display: none;">
                            <div class="form-group">
                                <label>Staff Type</label>
                                <div>
                                    <select <?php if ($_REQUEST['action'] == "edit") { ?> readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)" <?php } ?> class="form-control clrfield" name="staff_type" id="staff_type">
                                        <option value="Subadmin">Subadmin</option>
                                        <option value="Telecaller" <?php if ($row_memberdetails['staff_type'] == "Telecaller") { ?> selected="" <?php } ?>>Telecaller</option>
                                        <option value="Sales_Executive" <?php if ($row_memberdetails['staff_type'] == "Sales_Executive") { ?> selected="" <?php } ?>>Sales Executive</option>
                                        <option value="Site_Inspection_Engineer" <?php if ($row_memberdetails['staff_type'] == "Site_Inspection_Engineer") { ?> selected="" <?php } ?>>Site Inspection Engineer</option>
                                        <option value="Solar_Designer" <?php if ($row_memberdetails['staff_type'] == "Solar_Designer") { ?> selected="" <?php } ?>>Solar Designer</option>
                                        <option value="Project_Incharge" <?php if ($row_memberdetails['staff_type'] == "Project_Incharge") { ?> selected="" <?php } ?>>Project Incharge</option>
                                        <option value="Store_Keeper" <?php if ($row_memberdetails['staff_type'] == "Store_Keeper") { ?> selected="" <?php } ?>>Store Keeper</option>
                                        <option value="Installer" <?php if ($row_memberdetails['staff_type'] == "Installer") { ?> selected="" <?php } ?>>Installer</option>
                                        <option value="Cost_Estimator" <?php if ($row_memberdetails['staff_type'] == "Cost_Estimator") { ?> selected="" <?php } ?>>Cost Estimator</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Name</label>
                                <div>
                                    <input type="text" name="staff_name" id="staff_name" autocomplete="staff_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['staff_name']); ?>" style="    background: white;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Email Id</label>
                                <div>
                                    <input type="email" name="email_id" id="email_id" autocomplete="email_id" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['staff_email']); ?>" style="    background: white;">
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Mobile Number</label>
                                <div>
                                    <input type="number" name="mobile_number" id="mobile_number" autocomplete="mobile_number" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['staff_mobile']); ?>" size="20" style="    background: white;">    
                                </div>
                            </div>
                        </div>
                        <div class="col-4" style="display: none;">
                            <div class="form-group">
                                <label>City</label>
                                <div>
                                    <select class="form-control clrfield" name="city" id="city" style="    background: white;">
                                        <option value="Lucknow,Gorakhpur,Varanasi">Select City</option>
                                        <option value="Lucknow" <?php if ($row_memberdetails['staff_location'] == "Lucknow") { ?> selected="" <?php } ?>>Lucknow</option>
                                        <option value="Gorakhpur" <?php if ($row_memberdetails['staff_location'] == "Gorakhpur") { ?> selected="" <?php } ?>>Gorakhpur</option>
                                        <option value="Varanasi" <?php if ($row_memberdetails['staff_location'] == "Varanasi") { ?> selected="" <?php } ?>>Varanasi</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-4" style="display: none;">
                            <div class="form-group">
                                <label>Company Name</label>
                                <div>
                                    <input type="text" name="company_name" id="company_name" autocomplete="company_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['staff_company']); ?>">
                                </div>
                            </div>
                        </div>
                        <?php if ($_REQUEST['action'] != "edit") { ?>
                            <div class="col-4">
                                <div class="form-group">
                                    <label>Password</label>
                                    <div>
                                        <input type="password" style="background-color: #fafdf4;" name="password" id="password" autocomplete="password" class="form-control clrfield" value="">
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <div></div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <input type="hidden" name="hidden_leadid" id="hidden_leadid" class="form-control clrfield" value="<?php echo common::StrFromDb($staff_id); ?>">
                                    <a class="login-btn btn btn btn-danger profile-save-btn" id="processing_divid" style="display: none;">Processing...</a>
                                    <input type="submit" class="btn btn-primary mb-2" id="register_btnid" name="register_btnid" value="Save" style="    width: 50%;
    height: 39px;">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <h4>
        Subadmin Listing
        <div class="clearfix"></div>
    </h4>
    <div class="row">
        <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <form class="row" name="frmFilter" id="frmFilter" method="POST" style="display: none;">
                        <div class="col-9"></div>
                        <div class="col-3">
                            <select name="filter_type" onchange="return FilterApplicantList();" id="filter_type" class="form-control">
                                <option value="Subadmin">Subadmin</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-sm-12 text-center">
                            <div id="divProcessingF" class="alert alert-info" style="display: none;">Processing... Please wait.</div>
                        </div>
                        <!--</div>-->
                    </form>
                    <div class="table-responsive">
                        <table id="tbladminList" class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                            <thead>                            
                                <tr>
                                    <th data-orderable="false">SN</th>
                                    <th data-orderable="false">Name</th>
                                    <th data-orderable="false">Mobile Number</th>
                                    <th data-orderable="false">Email Id</th>
                                    <!--<th data-orderable="false">City</th>-->
                                    <!--<th data-orderable="false">Company Name</th>-->
                                    <!--<th data-orderable="false">Added Date</th>--> 
                                    <th data-orderable="false">Status</th> 
                                    <th data-orderable="false">Action</th>  
                                </tr>
                            </thead>                                
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include '../masters/admin-master.php';
?>

<script type="text/javascript" language="javascript" >

    $(document).ready(function () {
        AdminLeadsListing();
        function AdminLeadsListing() {
            var dataTable = $('#tbladminList').DataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'ajax': {
                    'url': 'manage-subadmin.inc.php?action=show_leadlist',
                    "type": "POST",
                    "data": function (d) {
                        d.form = JSON.stringify($("#frmFilter").serializeArray());
                    }
                },
                'columns': [
                    {data: 'sno'},
                    {data: 'staff_name'},
                    {data: 'mobile_number'},
                    {data: 'email_id'},
//                    {data: 'city'},
//                    {data: 'company_name'},
//                    {data: 'added_date'},
                    {data: 'status'},
                    {data: 'action'}
                ],
                columnDefs: [
                    {className: 'text-center', targets: [0]}
                ],
                "lengthMenu": [500, 1000, 10000],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'Staff List',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5, 6]
                        }
                    }
                ]
            }
            );
        }
    });

    function FilterApplicantList() {
        $('#tbladminList').DataTable().ajax.reload();
    }

    function AdminStaffStatusChange(staff_id, status) {
        if (confirm("Are you sure you want to perform this action?")) {
            $.ajax({
                type: "POST",
                url: "manage-staff.inc.php",
                data: "staff_id=" + staff_id + "&status=" + status + "&action=active_inactive",
                success: function (data) {
                    alert('Action successfully performed');
                    window.location = 'manage-subadmin.php';
                }
            });
        }
    }
</script>