<?php
ob_start();
include_once './manage-staff.inc.php';
$page_name_info = "manage_staff";
?>
<style type="text/css">
    .form-control, .asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=text], .jsgrid .jsgrid-table .jsgrid-filter-row select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=number], .select2-container--default .select2-selection--single, .select2-container--default .select2-selection--single .select2-search__field, .typeahead, .tt-query, .tt-hint {
        border: 1px solid #2c2e33;
        height: calc(2.25rem + 2px);
        font-weight: normal;
        font-size: 0.875rem;
        padding: 0.625rem 0.6875rem;
        background-color: #2A3038;
        border-radius: 2px;
        color: #000;
    }
    select.form-control, select.asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row select, .select2-container--default select.select2-selection--single, .select2-container--default .select2-selection--single select.select2-search__field, select.typeahead, select.tt-query, select.tt-hint {
        padding: .4375rem .75rem;
        border: 0;
        color: #000 !important;
    }
</style>
<div class="content-wrapper" style="background: #fff;">
    <div class="page-header">
        <h3 class="page-title" style="color:#000;"> Manage Staff </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Staff</a></li>
                <li class="breadcrumb-item active" aria-current="page">Manage Staff</li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Add Staff</h4>
                    <form class="forms-sample row" action="" id="staffadd_formid" method="post">
                        <div class="col-12" id="signup_errormsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-danger text-center" style="margin-bottom: 0px;">Staff already exists with the <span id="alreadyexistemailandmobile"></span> you entered</div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-12 " id="signup_successmsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-success text-center" style="margin-bottom: 0px;">Staff Successfully Saved</div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Staff Type</label>
                                <div>
                                    <select <?php if ($_REQUEST['action'] == "edit") { ?> readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)" <?php } ?> class="form-control clrfield" name="staff_type" id="staff_type" style="background-color: #fafdf4;">
                                        <option value="">Select Type</option>
                                        <option value="Telecaller" <?php if ($row_memberdetails['staff_type'] == "Telecaller") { ?> selected="" <?php } ?>>Telecaller</option>
                                        <option value="Sales_Executive" <?php if ($row_memberdetails['staff_type'] == "Sales_Executive") { ?> selected="" <?php } ?>>Sales Executive</option>
                                        <option value="Site_Inspection_Engineer" <?php if ($row_memberdetails['staff_type'] == "Site_Inspection_Engineer") { ?> selected="" <?php } ?>>Site Inspection Engineer</option>
                                        <option value="Solar_Designer" <?php if ($row_memberdetails['staff_type'] == "Solar_Designer") { ?> selected="" <?php } ?>>Solar Designer</option>
                                        <option value="Project_Incharge" <?php if ($row_memberdetails['staff_type'] == "Project_Incharge") { ?> selected="" <?php } ?>>Project Incharge</option>
                                        <option value="Store_Keeper" <?php if ($row_memberdetails['staff_type'] == "Store_Keeper") { ?> selected="" <?php } ?>>Store Keeper</option>
                                        <option value="Installer" <?php if ($row_memberdetails['staff_type'] == "Installer") { ?> selected="" <?php } ?>>Installer</option>
                                        <option value="Cost_Estimator" <?php if ($row_memberdetails['staff_type'] == "Cost_Estimator") { ?> selected="" <?php } ?>>Cost Estimator</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Staff Name</label>
                                <div>
                                    <input type="text" name="staff_name" id="staff_name" autocomplete="staff_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['staff_name']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Email Id</label>
                                <div>
                                    <input type="email" name="email_id" id="email_id" autocomplete="email_id" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['staff_email']); ?>" style="background-color: #fafdf4;">
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Mobile Number</label>
                                <div>
                                    <input type="number" name="mobile_number" id="mobile_number" autocomplete="mobile_number" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['staff_mobile']); ?>" size="20" style="background-color: #fafdf4;">    
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>City</label>
                                <div>
                                    <select class="form-control clrfield" name="city" id="city" style="background-color: #fafdf4;">
                                        <option value="">Select City</option>
                                        <option value="Lucknow" <?php if ($row_memberdetails['staff_location'] == "Lucknow") { ?> selected="" <?php } ?>>Lucknow</option>
                                        <option value="Gorakhpur" <?php if ($row_memberdetails['staff_location'] == "Gorakhpur") { ?> selected="" <?php } ?>>Gorakhpur</option>
                                        <option value="Varanasi" <?php if ($row_memberdetails['staff_location'] == "Varanasi") { ?> selected="" <?php } ?>>Varanasi</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Company Name</label>
                                <div>
                                    <input type="text" name="company_name" id="company_name" autocomplete="company_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['staff_company']); ?>" style="background-color: #fafdf4;">
                                </div>
                            </div>
                        </div>
                        <?php if ($_REQUEST['action'] != "edit") { ?>
                            <div class="col-4">
                                <div class="form-group">
                                    <label>Password</label>
                                    <div>
                                        <input type="password" name="password" id="password" autocomplete="password" class="form-control clrfield" value="" style="background-color: #fafdf4;">
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <div></div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <input type="hidden" name="hidden_leadid" id="hidden_leadid" class="form-control clrfield" value="<?php echo common::StrFromDb($staff_id); ?>">
                                    <a class="login-btn btn btn btn-danger profile-save-btn" id="processing_divid" style="display: none;">Processing...</a>
                                    <input type="submit" class="btn btn-primary mb-2" id="register_btnid" name="register_btnid" value="Save" style="    width: 50%;
                                           height: 39px;">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <h4 style="color:#000;">
        Staff Listing
        <div class="clearfix"></div>
    </h4>
    <div class="row">
        <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <form class="row" name="frmFilter" id="frmFilter" method="POST">
                        <div class="col-9"></div>
                        <div class="col-3">
                            <select name="filter_type" onchange="return FilterApplicantList();" id="filter_type" class="form-control" style="color: white;">
                                <option value="">All Type</option>
                                <option value="Telecaller">Telecaller</option>
                                <option value="Sales_Executive">Sales Executive</option>
                                <option value="Site_Inspection_Engineer">Site Inspection Engineer</option>
                                <option value="Solar_Designer">Solar Designer</option>
                                <option value="Project_Incharge">Project Incharge</option>
                                <option value="Store_Keeper">Store Keeper</option>
                                <option value="Installer">Installer</option>
                                <option value="Cost_Estimator">Cost Estimator</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-sm-12 text-center">
                            <div id="divProcessingF" class="alert alert-info" style="display: none;">Processing... Please wait.</div>
                        </div>
                        <!--</div>-->
                    </form>
                    <div class="table-responsive">
                        <table id="tbladminList" class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                            <thead>                            
                                <tr>
                                    <th data-orderable="false">SN</th>
                                    <th data-orderable="false">Staff Type</th>
                                    <th data-orderable="false">Staff Name</th>
                                    <th data-orderable="false">Mobile Number</th>
                                    <th data-orderable="false">Email Id</th>
                                    <th data-orderable="false">City</th>
                                    <!--<th data-orderable="false">Company Name</th>-->
                                    <!--<th data-orderable="false">Added Date</th>--> 
                                    <th data-orderable="false">Status</th> 
                                    <th data-orderable="false">Action</th>  
                                </tr>
                            </thead>                                
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include '../masters/admin-master.php';
?>

<script>
    function OpenPaidListMember(event_id) {
        $.ajax({
            type: "POST",
            url: "event-paidlist.php",
            data: "event_id=" + event_id + "&action=event_paidlist",
            success: function (data) {
                $('#paidmemberlis_divid').html(data);
                $('#paidmemberlist_smodalid').modal('show');
            }
        });
    }

    function MakeEventAttendance(event_id, mid, event_attendance) {
        $.ajax({
            type: "POST",
            url: "event-attendance.php",
            data: "event_id=" + event_id + "&mid=" + mid + "&event_attendance=" + event_attendance + "&action=event_attendance",
            success: function (data) {
                $('#attan_' + mid).html(data);
            }
        });
    }

</script>

<script type="text/javascript" language="javascript" >

    $(document).ready(function () {
        AdminLeadsListing();
        function AdminLeadsListing() {
            var dataTable = $('#tbladminList').DataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'ajax': {
                    'url': 'manage-staff.inc.php?action=show_leadlist',
                    "type": "POST",
                    "data": function (d) {
                        d.form = JSON.stringify($("#frmFilter").serializeArray());
                    }
                },
                'columns': [
                    {data: 'sno'},
                    {data: 'staff_type'},
                    {data: 'staff_name'},
                    {data: 'mobile_number'},
                    {data: 'email_id'},
                    {data: 'city'},
//                    {data: 'company_name'},
//                    {data: 'added_date'},
                    {data: 'status'},
                    {data: 'action'}
                ],
                columnDefs: [
                    {className: 'text-center', targets: [0]}
                ],
                "lengthMenu": [500, 1000, 10000],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'List',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5, 6]
                        }
                    }
                ]
            }
            );
        }
    });

    function FilterApplicantList() {
        $('#tbladminList').DataTable().ajax.reload();
    }

    function AdminStaffStatusChange(staff_id, status) {
        if (confirm("Are you sure you want to perform this action?")) {
            $.ajax({
                type: "POST",
                url: "manage-staff.inc.php",
                data: "staff_id=" + staff_id + "&status=" + status + "&action=active_inactive",
                success: function (data) {
                    alert('Action successfully performed');
                    window.location = 'manage-staff.php';
                }
            });
        }
    }
</script>