<?php
ob_start();
include_once './manage-company.inc.php';
$page_name_info = "manage_company";
?>
<style type="text/css">
    .form-control, .asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=text], .jsgrid .jsgrid-table .jsgrid-filter-row select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=number], .select2-container--default .select2-selection--single, .select2-container--default .select2-selection--single .select2-search__field, .typeahead, .tt-query, .tt-hint {
        border: 1px solid #2c2e33;
        height: calc(2.25rem + 2px);
        font-weight: normal;
        font-size: 0.875rem;
        padding: 0.625rem 0.6875rem;
        background-color: #2A3038;
        border-radius: 2px;
        color: #000;
    }
    select.form-control, select.asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row select, .select2-container--default select.select2-selection--single, .select2-container--default .select2-selection--single select.select2-search__field, select.typeahead, select.tt-query, select.tt-hint {
        padding: .4375rem .75rem;
        border: 0;
        color: #000 !important;
    }
</style>
<div class="content-wrapper" style="background: #fff;">
    <div class="page-header">
        <h3 class="page-title" style="color:#000;"> Manage Company </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Company</a></li>
                <li class="breadcrumb-item active" aria-current="page">Manage Company</li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <form class="forms-sample row" action="" id="companyadd_formid" method="post" enctype="multipart/form-data">
                        <div class="col-12 " id="signup_successmsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-success text-center" style="margin-bottom: 0px;">Company Successfully Saved</div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-12 " id="signup_errormsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-danger text-center" style="margin-bottom: 0px;" id="signup_errormsgconentid"></div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Company Name</label>
                                <div>
                                    <input type="text" name="company_name" id="company_name" autocomplete="company_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['company_name']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Email Id</label>
                                <div>
                                    <input type="text" name="email_id" id="email_id" autocomplete="email_id" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['email_id']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Phone Number</label>
                                <div>
                                    <input type="text" name="phone_number" id="phone_number" autocomplete="phone_number" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['phone_number']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Short Name</label>
                                <div>
                                    <input type="text" name="short_name" id="short_name" autocomplete="short_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['short_name']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label for="contactInfo">Location</label>
                                <select class="form-control clrfield" id="company_location" name="company_location" style="background: white;">
                                    <option value="Lucknow" <?php if ($row_memberdetails['company_location'] == "Lucknow") { ?> selected="" <?php } ?>>Lucknow</option>
                                    <option value="Gorakhpur" <?php if ($row_memberdetails['company_location'] == "Gorakhpur") { ?> selected="" <?php } ?>>Gorakhpur</option>
                                    <option value="Varanasi" <?php if ($row_memberdetails['company_location'] == "Varanasi") { ?> selected="" <?php } ?>>Varanasi</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-7">
                            <div class="form-group">
                                <label>Company Address</label>
                                <div>
                                    <input type="text" name="company_address" id="company_address" autocomplete="company_address" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['company_address']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="form-group">
                                <label>Upload Logo</label>
                                <div>
                                    <input type="file" style="background: #fff;" class="form-control input-sm" name="company_logo" id="company_logo"/>
                                    <div class="clearfix"></div>
                                    <small style="color:red;">Upload only jpg or png format file. Maximum file size: 1MB.</small>
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-12">
                            <h4>Details for Authorised Person</h4>
                            <label></label>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Name</label>
                                <div>
                                    <input type="text" name="person_name" id="person_name" autocomplete="person_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['person_name']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Email Id</label>
                                <div>
                                    <input type="text" name="person_emailid" id="person_emailid" autocomplete="person_emailid" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['person_emailid']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Phone Number</label>
                                <div>
                                    <input type="text" name="person_phonenumber" id="person_phonenumber" autocomplete="person_phonenumber" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['person_phonenumber']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-12">
                            <h4>Bank Details</h4>
                            <label></label>
                        </div>
                        <div class="clearfix"></div><br/>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Account Holder Name</label>
                                <div>
                                    <input type="text" name="account_holder" id="account_holder" autocomplete="account_holder" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['account_holder']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Account Number</label>
                                <div>
                                    <input type="text" name="account_number" id="account_number" autocomplete="account_number" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['account_number']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>IFSC Code</label>
                                <div>
                                    <input type="text" name="ifsc_code" id="ifsc_code" autocomplete="ifsc_code" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['ifsc_code']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Branch</label>
                                <div>
                                    <input type="text" name="branch" id="branch" autocomplete="branch" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['branch']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="form-group">
                                <label>Type of Account</label>
                                <div>
                                    <select name="account_type" id="account_type" autocomplete="account_type" class="form-control clrfield" style="background-color: #fafdf4;"> 
                                        <option value="">Select Account Type</option>
                                        <option value="Current Account" <?php if ($row_memberdetails['account_type'] == "Current Account") { ?> selected="" <?php } ?>>Current Account</option>
                                        <option value="Saving Account" <?php if ($row_memberdetails['account_type'] == "Saving Account") { ?> selected="" <?php } ?>>Saving Account</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label></label>
                                <div>
                                    <input type="hidden" name="hidden_companyid" id="hidden_companyid" class="form-control clrfield" value="<?php echo common::StrFromDb($company_id); ?>">
                                    <input type="hidden" name="hidden_companylogo" id="hidden_companylogo" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['company_logo']); ?>">
                                    <a class="login-btn btn btn btn-danger profile-save-btn" id="processing_divid" style="display: none;">Processing...</a>
                                    <input type="submit" class="btn btn-primary mb-2" id="register_btnid" name="register_btnid" value="Save" style="    width: 50%;
                                           height: 39px;">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <h4 style="color:#000;">
        Company Listing
        <div class="clearfix"></div>
    </h4>
    <div class="row">
        <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="tbladminList" class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                            <thead>                            
                                <tr>
                                    <th data-orderable="false">SN</th>
                                    <th data-orderable="false">Company Name</th>
                                    <th data-orderable="false">Email Id</th>
                                    <th data-orderable="false">Phone Number</th>
                                    <th data-orderable="false">Short Name</th>
                                    <th data-orderable="false">Company Address</th>
                                    <th data-orderable="false">Action</th> 
                                </tr>
                            </thead>                                
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include '../masters/admin-master.php';
?>

<script type="text/javascript" language="javascript" >

    $(document).ready(function () {
        AdminCompanyListing();
        function AdminCompanyListing() {
            var dataTable = $('#tbladminList').DataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'ajax': {
                    'url': 'manage-company.inc.php?action=show_companylist',
                    "type": "POST",
                    "data": function (d) {
                        d.form = JSON.stringify($("#frmFilter").serializeArray());
                    }
                },

                'columns': [
                    {data: 'sno'},
                    {data: 'company_name'},
                    {data: 'email_id'},
                    {data: 'phone_number'},
                    {data: 'short_name'},
                    {data: 'company_address'},
                    {data: 'action'}
                ],
                columnDefs: [
                    {className: 'text-center', targets: [0]}
                ],
                "lengthMenu": [500, 1000, 10000],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'List',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5]
                        }
                    }
                ]
            }
            );
        }
    });

    function FilterApplicantList() {
        $('#tbladminList').DataTable().ajax.reload();
    }

    function AdminCompanyStatusChange(company_id, status) {
        if (confirm("Are you sure you want to perform this action?")) {
            $.ajax({
                type: "POST",
                url: "manage-company.inc.php",
                data: "company_id=" + company_id + "&status=" + status + "&action=active_inactive",
                success: function (data) {
                    alert('Action successfully performed');
                    window.location = 'manage-company.php';
                }
            });
        }
    }
</script>