<?php
ob_start();
include_once './create-costsheet.inc.php';
$page_name_info = "create_costsheet";
?>
<style type="text/css">
    .form-control, .asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=text], .jsgrid .jsgrid-table .jsgrid-filter-row select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=number], .select2-container--default .select2-selection--single, .select2-container--default .select2-selection--single .select2-search__field, .typeahead, .tt-query, .tt-hint {
        border: 1px solid #2c2e33;
        height: calc(2.25rem + 2px);
        font-weight: normal;
        font-size: 0.875rem;
        padding: 0.625rem 0.6875rem;
        background-color: #2A3038;
        border-radius: 2px;
        color: #000;
    }
    select.form-control, select.asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row select, .select2-container--default select.select2-selection--single, .select2-container--default .select2-selection--single select.select2-search__field, select.typeahead, select.tt-query, select.tt-hint {
        padding: .4375rem .75rem;
        border: 0;
        color: #000 !important;
    }

</style>
<div class="content-wrapper" style="background: #fff;">
    <div class="page-header">
        <h3 class="page-title" style="color:#000;"> Create/View Cost Sheet </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Cost Sheet</a></li>

                <li class="breadcrumb-item active" aria-current="page"><?php if ($row_templatedetails['costsheet_status'] == "20") { ?>Create/<?php } ?>View Cost Sheet</li>
            </ol>
        </nav>
    </div>

    <div class="row">
        <div class="col-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <form class="forms-sample row" action="" id="selecttemplatelead_formid" method="post">
                        <div class="col-12 " id="copytemplate_successmsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-success text-center" style="margin-bottom: 0px;">Items Successfully Saved</div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Enter KWP</label>
                                <div class="input-group">
                                    <input type="text" <?php if ($row_templatedetails['costsheet_name'] != "") { ?> readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)" style="background-color: #d6dbcc;" <?php } else { ?> style="background-color: #fafdf4;" <?php } ?> name="costsheet_name" id="costsheet_name" autocomplete="costsheet_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_templatedetails['costsheet_name']); ?>"> 
                                    <div class="input-group-append">
                                        <span class="input-group-text" style="color: #fff;">KWP</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Electricity Rate</label>
                                <div>
                                    <input type="text" <?php if ($row_templatedetails['electricity_rate'] != "") { ?> readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)"  style="background-color: #d6dbcc;" <?php } else { ?> style="background-color: #fafdf4;" <?php } ?> name="electricity_rate" id="electricity_rate" autocomplete="electricity_rate" class="form-control clrfield" value="<?php echo common::StrFromDb($row_templatedetails['electricity_rate']); ?>" > 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>GST Input</label>
                                <div>
                                    <select <?php if ($row_templatedetails['costsheet_name'] != "") { ?> readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)"  style="background-color: #d6dbcc;" <?php } else { ?> style="background-color: #fafdf4;" <?php } ?> class="form-control clrfield" name="gst_input" id="gst_input">
                                        <option value="">Select GST Input</option>
                                        <option value="Yes" <?php if ($row_templatedetails['gst_input'] == "Yes") { ?> selected="" <?php } ?>>Yes</option>
                                        <option value="No" <?php if ($row_templatedetails['gst_input'] == "No") { ?> selected="" <?php } ?>>No</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Income Tax Rate</label>
                                <div>
                                    <select <?php if ($row_templatedetails['costsheet_name'] != "") { ?> readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)"  style="background-color: #d6dbcc;" <?php } else { ?> style="background-color: #fafdf4;" <?php } ?> class="form-control clrfield" onchange="ChangeIncomeTaxrate(this.value);" name="incometax_rate" id="incometax_rate">
                                        <option value="">Income Tax Rate</option>
                                        <option value="Yes" <?php if ($row_templatedetails['incometax_rate'] == "Yes") { ?> selected="" <?php } ?>>Yes</option>
                                        <option value="No" <?php if ($row_templatedetails['incometax_rate'] == "No") { ?> selected="" <?php } ?>>No</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-2" id="incometax_value_divid" <?php if ($row_templatedetails['incometax_rate'] != "Yes") { ?> style="display: none;" <?php } ?>>
                            <div class="form-group">
                                <label>Enter Rate</label>
                                <div>
                                    <input type="text" <?php if ($row_templatedetails['costsheet_name'] != "") { ?> readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)"  style="background-color: #d6dbcc;" <?php } else { ?> style="background-color: #fafdf4;" <?php } ?> name="incometax_value" id="incometax_value" autocomplete="incometax_value" class="form-control clrfield" value="<?php echo common::StrFromDb($row_templatedetails['incometax_value']); ?>" > 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>DCR / Non DCR</label>
                                <div>
                                    <select <?php if ($row_templatedetails['costsheet_name'] != "") { ?> readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)"  style="background-color: #d6dbcc;" <?php } else { ?> style="background-color: #fafdf4;" <?php } ?> class="form-control clrfield" onchange="ChangeDCRNonDCR();" name="dcr_nondcr" id="dcr_nondcr">
                                        <option value="">Select Type</option>
                                        <option value="DCR" <?php if ($row_templatedetails['dcr_nondcr'] == "DCR") { ?> selected="" <?php } ?>>DCR</option>
                                        <option value="Non DCR" <?php if ($row_templatedetails['dcr_nondcr'] == "Non DCR") { ?> selected="" <?php } ?>>Non DCR</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Type</label>
                                <div>
                                    <select <?php if ($row_templatedetails['costsheet_name'] != "") { ?> readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)"  style="background-color: #d6dbcc;" <?php } else { ?> style="background-color: #fafdf4;" <?php } ?> class="form-control clrfield" onchange="ChangeDCRNonDCR();" name="dcr_nondcr_type" id="dcr_nondcr_type">
                                        <option value="">Select Type</option>
                                        <option value="On-Grid" <?php if ($row_templatedetails['dcr_nondcr_type'] == "On-Grid") { ?> selected="" <?php } ?>>On-Grid</option>
                                        <option value="Off-Grid" <?php if ($row_templatedetails['dcr_nondcr_type'] == "Off-Grid") { ?> selected="" <?php } ?>>Off-Grid</option>
                                        <option value="Hybrid" <?php if ($row_templatedetails['dcr_nondcr_type'] == "Hybrid") { ?> selected="" <?php } ?>>Hybrid</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <?php
                        if ($row_templatedetails['costsheet_name'] == "") {
                            ?>
                            <div class="col-2">
                                <div class="form-group">
                                    <label>Select Template</label>
                                    <div>
                                        <select class="form-control clrfield" onclick="ClickTemplateDropDown();" name="copy_template" id="copy_template" style="background-color: #fafdf4;">
                                            <option value="">Select Template</option>
                                            <?php while ($row_templatelist = mysqli_fetch_array($result_templatelist)) { ?>
                                                <option value="<?php echo $row_templatelist['id']; ?>"><?php echo $row_templatelist['template_name']; ?> KWP</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-2">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <div>
                                        <input type="hidden" name="lead_id" id="lead_id" class="form-control" value="<?php echo common::StrFromDb($lead_id); ?>">
                                        <a class="login-btn btn btn btn-danger profile-save-btn" id="copytemplateprocessing_divid" style="display: none;">Processing...</a>
                                        <input type="submit" class="btn btn-block btn-primary" id="copytemplate_btnid" name="copytemplate_btnid" value="View Cost Sheet" style="height: 39px;">
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php
    if ($row_templatedetails['costsheet_name'] != "") {
        if ($row_templatedetails['costsheet_status'] == "20") {
            ?>
            <div class="row">
                <div class="col-12 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <form class="forms-sample row" action="" id="costsheetitemsadd_formid" method="post">
                                <div class="col-12 " id="signup_successmsgid" style="display: none;">
                                    <div class="clearfix"></div><br/>
                                    <div class="alert alert-success text-center" style="margin-bottom: 0px;">Template Items Successfully Saved</div>
                                    <div class="clearfix"></div><br/>
                                </div>
                                <div class="col-3">
                                    <div class="form-group">
                                        <label>Type</label>
                                        <div>
                                            <select class="form-control clrfield" name="type" id="type" style="background-color: #fafdf4;">
                                                <option value="">Select Type</option>
                                                <option value="MAIN ITEMS" <?php if ($row_memberdetails['type'] == "MAIN ITEMS") { ?> selected="" <?php } ?>>MAIN ITEMS</option>
                                                <option value="MISCELLENEOUS ITEMS" <?php if ($row_memberdetails['type'] == "MISCELLENEOUS ITEMS") { ?> selected="" <?php } ?>>MISCELLENEOUS ITEMS</option>
                                                <option value="OTHER WORKS" <?php if ($row_memberdetails['type'] == "OTHER WORKS") { ?> selected="" <?php } ?>>OTHER WORKS</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-2">
                                    <div class="form-group">
                                        <label>Select Category</label>
                                        <div>
                                            <select class="form-control clrfield" onchange="ChangeProductCategory(this.value);" name="category_id" id="category_id" style="background-color: #fafdf4;">
                                                <option value="">Select Category</option>
                                                <?php while ($row_categorylist = mysqli_fetch_array($result_categorylist)) { ?>
                                                    <option value="<?php echo $row_categorylist['id']; ?>" <?php if ($row_categorylist['id'] == $row_memberdetails['category_id']) { ?> selected="" <?php } ?>><?php echo $row_categorylist['category_name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-5">
                                    <div class="form-group">
                                        <label>Select Product</label>
                                        <div>
                                            <select class="form-control clrfield" onchange="ChangeSelectedProduct(this.value);" name="product_id" id="product_id" style="background-color: #fafdf4;">
                                                <option value="">Select Product</option>
                                                <?php while ($rowproductlist = mysqli_fetch_array($resultproductlist)) { ?>
                                                    <option value="<?php echo $rowproductlist['id'] . "-" . $rowproductlist['product_rate']; ?>" <?php if ($rowproductlist['id'] == $row_memberdetails['product_id']) { ?> selected="" <?php } ?>><?php echo $rowproductlist['product_name'] . " " . $rowproductlist['product_specification'] . " " . $rowproductlist['capacity'] . " - " . $rowproductlist['brand_name']; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-2">
                                    <div class="form-group">
                                        <label>Amount</label>
                                        <div>
                                            <input type="text" name="item_amount" id="item_amount" autocomplete="item_amount" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['item_amount']); ?>" style="background-color: #fafdf4;"> 
                                        </div>
                                    </div>
                                </div>
                                <div class="col-2">
                                    <div class="form-group">
                                        <label>Quantity</label>
                                        <div>
                                            <input type="number" name="quantity" id="quantity" autocomplete="quantity" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['quantity']); ?>" style="background-color: #fafdf4;"> 
                                        </div>
                                    </div>
                                </div>
                                <div class="col-2">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <div>
                                            <input type="hidden" name="hidden_templateitemid" id="hidden_templateitemid" class="form-control clrfield" value="<?php echo common::StrFromDb($templateitem_id); ?>">
                                            <input type="hidden" name="lead_id" id="lead_id" class="form-control" value="<?php echo common::StrFromDb($lead_id); ?>">
                                            <a class="login-btn btn btn btn-danger profile-save-btn" id="processing_divid" style="display: none;">Processing...</a>
                                            <input type="submit" class="btn btn-block btn-primary" id="register_btnid" name="register_btnid" value="Submit" style="height: 39px;">
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
            <h4 style="color:#000;">
                Template View
                <div class="clearfix"></div>
            </h4>
        <?php } ?>
        <div class="row">
            <div class="col-lg-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                                <thead>                            
                                    <tr>
                                        <th>S.NO.</th>
                                        <th>DISCRIPTION</th>
                                        <th>SPECIFICATIONS</th>
                                        <th>MAKE</th>
                                        <th style="text-align: center;">QTY</th>
                                        <th style="text-align: center;">UNIT</th>
                                        <th>RATE</th>   
                                        <th style="text-align: right;">AMOUNT</th> 
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <th>ACTION</th>
                                        <?php } ?>
                                    </tr>
                                    <tr>
                                        <td <?php if ($row_templatedetails['costsheet_status'] == "20") { ?> colspan="9" <?php } else { ?> colspan="8" <?php } ?> style="text-align: center;background: #59c560;">
                                            <strong>MAIN ITEMS</strong>
                                        </td>
                                    </tr>
                                    <?php
                                    $m = 1;
                                    $main_total_amount = 0;
                                    foreach ((array) $row_templatelist_mainarray AS $row_templatelist_mainkey) {
                                        $quantity_amount = $row_templatelist_mainkey['item_amount'] * $row_templatelist_mainkey['quantity'];
                                        $main_total_amount = $quantity_amount + $main_total_amount;
                                        ?>
                                        <tr>
                                            <td><?php echo $m; ?></td>
                                            <td><?php echo $row_templatelist_mainkey['product_name']; ?></td>
                                            <td><?php echo $row_templatelist_mainkey['product_specification'] . " " . $row_templatelist_mainkey['capacity']; ?></td>
                                            <td><?php echo $row_templatelist_mainkey['brand_name']; ?></td>
                                            <td style="text-align: center;">
                                                <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                    <input type="text" style="width: 60px;" value="<?php echo $row_templatelist_mainkey['quantity']; ?>"/>
                                                <?php } else { ?>
                                                    <?php echo $row_templatelist_mainkey['quantity']; ?>
                                                <?php } ?>
                                            </td>
                                            <td style="text-align: center;"><?php echo $row_templatelist_mainkey['unit_type']; ?></td>
                                            <td>
                                                <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                    <input type="text" style="width: 90px;" value="<?php echo $row_templatelist_mainkey['item_amount']; ?>"/>
                                                <?php } else { ?>
                                                    <?php echo $row_templatelist_mainkey['item_amount']; ?>
                                                <?php } ?>
                                            </td>   
                                            <td style="text-align: right;"><?php echo number_format((float) $quantity_amount, 2, '.', ''); ?></td>   
                                            <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                <td>
                                                    <a style="color: #fff;" href="create-costsheet.php?lead_id=<?php echo $lead_id; ?>&templateitem_id=<?php echo $row_templatelist_mainkey['id']; ?>&action=edit">Edit</a> | 
                                                    <a style="cursor: pointer;color: #fff;" onclick="RemoveCostSheetItems('<?php echo $lead_id; ?>', '<?php echo $row_templatelist_mainkey[id]; ?>');">Remove</a>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                        <?php
                                        $m++;
                                    }
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">
                                            <strong><?php echo number_format((float) $main_total_amount, 2, '.', ''); ?></strong>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <tr>
                                        <td <?php if ($row_templatedetails['costsheet_status'] == "20") { ?> colspan="9" <?php } else { ?> colspan="8" <?php } ?> style="text-align: center;background: #59c560;">
                                            <strong>MISCELLENEOUS ITEMS</strong>
                                        </td>
                                    </tr>
                                    <?php
                                    $miscelleneous_total_amount = 0;
                                    foreach ((array) $row_templatelist_miscelleneousarray AS $row_templatelist_miscelleneouskey) {
                                        $quantity_amount = $row_templatelist_miscelleneouskey['item_amount'] * $row_templatelist_miscelleneouskey['quantity'];
                                        $miscelleneous_total_amount = $quantity_amount + $miscelleneous_total_amount;
                                        ?>
                                        <tr>
                                            <td><?php echo $m; ?></td>
                                            <td><?php echo $row_templatelist_miscelleneouskey['product_name']; ?></td>
                                            <td><?php echo $row_templatelist_miscelleneouskey['product_specification'] . " " . $row_templatelist_miscelleneouskey['capacity']; ?></td>
                                            <td><?php echo $row_templatelist_miscelleneouskey['brand_name']; ?></td>
                                            <td style="text-align: center;">
                                                <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                    <input type="text" style="width: 60px;" value="<?php echo $row_templatelist_miscelleneouskey['quantity']; ?>"/>
                                                <?php } else { ?>
                                                    <?php echo $row_templatelist_miscelleneouskey['quantity']; ?>
                                                <?php } ?>
                                            </td>
                                            <td style="text-align: center;"><?php echo $row_templatelist_miscelleneouskey['unit_type']; ?></td>
                                            <td>
                                                <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                    <input type="text" style="width: 90px;" value="<?php echo $row_templatelist_miscelleneouskey['item_amount']; ?>"/>
                                                <?php } else { ?>
                                                    <?php echo $row_templatelist_miscelleneouskey['item_amount']; ?>
                                                <?php } ?>
                                            </td>   
                                            <td style="text-align: right;"><?php echo number_format((float) $quantity_amount, 2, '.', ''); ?></td>   
                                            <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                <td>
                                                    <a style="color: #fff;" href="create-costsheet.php?lead_id=<?php echo $lead_id; ?>&templateitem_id=<?php echo $row_templatelist_miscelleneouskey['id']; ?>&action=edit">Edit</a> | 
                                                    <a style="cursor: pointer;color: #fff;" onclick="RemoveCostSheetItems('<?php echo $lead_id; ?>', '<?php echo $row_templatelist_miscelleneouskey[id]; ?>');">Remove</a>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                        <?php
                                        $m++;
                                    }
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">
                                            <strong><?php echo number_format((float) $miscelleneous_total_amount, 2, '.', ''); ?></strong>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <tr>
                                        <td <?php if ($row_templatedetails['costsheet_status'] == "20") { ?> colspan="9" <?php } else { ?> colspan="8" <?php } ?> style="text-align: center;background: #59c560;">
                                            <strong>OTHER WORKS</strong>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td><strong>Total Material Cost</strong></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">
                                            <strong><?php echo number_format((float) $main_total_amount + $miscelleneous_total_amount, 2, '.', ''); ?></strong>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <?php
                                    $otherwork_total_amount = 0;
                                    foreach ((array) $row_templatelist_otherworksarray AS $row_templatelist_otherworkskey) {
                                        $quantity_amount = $row_templatelist_otherworkskey['item_amount'] * $row_templatelist_otherworkskey['quantity'];
                                        $otherwork_total_amount = $quantity_amount + $otherwork_total_amount;
                                        ?>
                                        <tr>
                                            <td></td>
                                            <td><?php echo $row_templatelist_otherworkskey['product_name']; ?></td>
                                            <td><?php echo $row_templatelist_otherworkskey['product_specification'] . " " . $row_templatelist_otherworkskey['capacity']; ?></td>
                                            <td><?php echo $row_templatelist_otherworkskey['brand_name']; ?></td>
                                            <td style="text-align: center;">
                                                <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                    <input type="text" style="width: 60px;" value="<?php echo $row_templatelist_otherworkskey['quantity']; ?>"/>
                                                <?php } else { ?>
                                                    <?php echo $row_templatelist_otherworkskey['quantity']; ?>
                                                <?php } ?>
                                            </td>
                                            <td style="text-align: center;"><?php echo $row_templatelist_otherworkskey['unit_type']; ?></td>
                                            <td>
                                                <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                    <input type="text" style="width: 90px;" value="<?php echo $row_templatelist_otherworkskey['item_amount']; ?>"/>
                                                <?php } else { ?>
                                                    <?php echo $row_templatelist_otherworkskey['item_amount']; ?>
                                                <?php } ?>
                                            </td>   
                                            <td style="text-align: right;"><?php echo number_format((float) $quantity_amount, 2, '.', ''); ?></td>   
                                            <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                <td>
                                                    <a style="color: #fff;" href="create-costsheet.php?lead_id=<?php echo $lead_id; ?>&templateitem_id=<?php echo $row_templatelist_otherworkskey['id']; ?>&action=edit">Edit</a> | 
                                                    <a style="cursor: pointer;color: #fff;" onclick="RemoveCostSheetItems('<?php echo $lead_id; ?>', '<?php echo $row_templatelist_otherworkskey[id]; ?>');">Remove</a>
                                                </td>
                                            <?php } ?>
                                        </tr>
                                        <?php
                                        $mi++;
                                    }
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td>Total Cost without Overheads</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">
                                            <strong><?php echo number_format((float) $main_total_amount + $miscelleneous_total_amount + $otherwork_total_amount, 2, '.', ''); ?></strong>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <?php
                                    $ttlcostwithoutoverheads = $main_total_amount + $miscelleneous_total_amount + $otherwork_total_amount;
                                    $ttlcostwithoverheads = ($row_templatedetails['costsheet_overheads'] / 100) * $ttlcostwithoutoverheads;
                                    $ttlcostwithoverheads = number_format((float) $ttlcostwithoverheads, 2, '.', '');
                                    $ttlcost = $ttlcostwithoutoverheads + $ttlcostwithoverheads;
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td>Overheads</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td>
                                            <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                <input type="text" onblur="ChangeCostSheetOverHeads();" style="width: 50px;" id="template_overheads" name="template_overheads" value="<?php echo $row_templatedetails['costsheet_overheads']; ?>"/> %
                                            <?php } else { ?>
                                                <?php echo $row_templatedetails['costsheet_overheads']; ?> %
                                            <?php } ?>
                                        </td>
                                        <td style="text-align: right;">
                                            <?php echo $ttlcostwithoverheads; ?>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td><strong>Total Cost</strong></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">
                                            <strong><?php echo number_format((float) $ttlcost, 2, '.', ''); ?></strong>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <tr>
                                        <td <?php if ($row_templatedetails['costsheet_status'] == "20") { ?> colspan="9" <?php } else { ?> colspan="8" <?php } ?> style="text-align: center;background: #59c560;">
                                            <strong>FINAL PRICING</strong>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Total Overall</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">
                                            <strong><?php echo number_format((float) $ttlcost, 2, '.', ''); ?></strong>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <?php
                                    $profit_inpercentage = ($row_templatedetails['costsheet_profit'] / 100) * $ttlcost;
                                    $profit_inpercentage = number_format((float) $profit_inpercentage, 2, '.', '');
                                    $grandtotal = $ttlcost + $profit_inpercentage;
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td>Profit</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td>
                                            <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                <input type="text" onblur="ChangeCostSheetProfit();" style="width: 50px;" id="template_profit" name="template_profit" value="<?php echo $row_templatedetails['costsheet_profit']; ?>"/> %
                                            <?php } else { ?>
                                                <?php echo $row_templatedetails['costsheet_profit']; ?> %
                                            <?php } ?>
                                        </td>
                                        <td style="text-align: right;">
                                            <?php echo $profit_inpercentage; ?>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Grand Total</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">
                                            <strong><?php echo $grandtotal; ?></strong>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <?php
                                    $gst_inpercentage = ($row_templatedetails['costsheet_gst'] / 100) * $grandtotal;
                                    $gst_inpercentage = number_format((float) $gst_inpercentage, 2, '.', '');
                                    $salesprice = $grandtotal + $gst_inpercentage;
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td>GST</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td>
                                            <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                                <input type="text" onblur="ChangeCostSheetGST();" style="width: 50px;" id="template_gst" name="template_gst" value="<?php echo $row_templatedetails['costsheet_gst']; ?>"/> %
                                            <?php } else { ?>
                                                <?php echo $row_templatedetails['costsheet_gst']; ?> %
                                            <?php } ?>
                                        </td>
                                        <td style="text-align: right;">
                                            <?php echo $gst_inpercentage; ?>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Sales Price</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">
                                            <strong><?php echo $salesprice; ?></strong>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                    <?php
                                    $sales_perkilowatt = $salesprice / $row_templatedetails['costsheet_name'];
                                    $sales_perkilowatt = number_format((float) $sales_perkilowatt, 2, '.', '');
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td>Sale Price Per KWP</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td style="text-align: right;">
                                            <strong><?php echo $sales_perkilowatt; ?></strong>
                                        </td>
                                        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
                                            <td></td>
                                        <?php } ?>
                                    </tr>
                                </thead>                                
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if ($row_templatedetails['costsheet_status'] == "20") { ?>
            <div class="row">
                <div class="col-6">
                    <a onclick="SaveCostSheet('<?php echo $lead_id; ?>');" class="btn btn-success btn-block btn-xs" style="margin-top:5px;color:#fff;font-size: 14px;"><strong>CostSheet Save</strong></a>
                </div>
                <div class="col-6">
                    <a onclick="SaveCostSheetWithMaster('<?php echo $lead_id; ?>');" class="btn btn-success btn-block btn-xs" style="margin-top:5px;color:#fff;font-size: 14px;"><strong>CostSheet Save with Master Template</strong></a>
                </div>
            </div>
        <?php } else {
            ?>
            <h4 style="color:#000;">
                ROI
                <div class="clearfix"></div>
            </h4>
            <div class="row">
                <div class="col-lg-12 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                                    <thead> 
                                        <tr style="background-color: #0697f2;font-weight: bold;">
                                            <td>Total Connection in Kwatt</td>
                                            <td><?php echo $row_templatedetails['costsheet_name']; ?></td>
                                        </tr>                                
                                        <tr>
                                            <td>Rate per KWATT</td>
                                            <td><?php echo $sales_perkilowatt; ?></td>
                                        </tr>                                
                                        <tr>
                                            <td>Sales Price including GST</td>
                                            <td><?php echo $salesprice; ?></td>
                                        </tr>                                
                                        <tr>
                                            <td>GST Rate</td>
                                            <td><?php echo $row_templatedetails['costsheet_gst']; ?></td>
                                        </tr>                                
                                        <tr style="background-color: #67c54a;font-weight: bold;<?php if ($row_templatedetails['gst_input'] == "No") { ?> display: none; <?php } ?>">
                                            <td>Savings on GST Input</td>
                                            <td><?php echo $gst_inpercentage; ?></td>
                                        </tr>                                
                                        <tr style="<?php if ($row_templatedetails['gst_input'] == "No") { ?> display: none; <?php } ?>">
                                            <td>Net Price without GST</td>
                                            <td><?php echo $grandtotal; ?></td>
                                        </tr>
                                        <?php
                                        
                                        if ($row_templatedetails['gst_input'] == "No") {
                                            $depreciation_calamount=$salesprice;
                                        } else {
                                            $depreciation_calamount=$grandtotal;
                                        }
                                        
                                        $average_powergeneration = 4 * 25 * $row_templatedetails['costsheet_name'];
                                        $average_powergeneration = number_format((float) $average_powergeneration, 2, '.', '');
                                        $z = 1;
                                        $y = 1;
                                        
                                        $total_depreciation_taxsaving = 0;
                                        for ($x = 1; $x <= 500; $x++) {
                                            if ($x == 1) {
                                                $wdvone = $depreciation_calamount;
                                            } elseif ($x == 2) {
                                                $wdvone = $depreciation_calamount - $depreciationone_value;
                                            } else {
                                                $wdvone = $wdvone - $depreciationone_value;
                                            }
                                            $depreciationone_value = (40 / 100) * $wdvone;
                                            $depreciationone_value = number_format((float) $depreciationone_value, 2, '.', '');
                                            
                                            
                                            
                                            
                                            ?>
                                            <tr <?php if ($row_templatedetails['incometax_rate'] == "No") { ?> style="display: none;" <?php } ?>>
                                                <td>Depreciation <?php echo $y; ?> Year @40 % on WDV</td>
                                                <td><?php echo $depreciationone_value; ?></td>
                                            </tr>
                                            <?php
                                            $depreciationone_taxsaving = ($row_templatedetails['incometax_value'] / 100) * $depreciationone_value;
                                            $depreciationone_taxsaving = number_format((float) $depreciationone_taxsaving, 2, '.', '');
                                            ?>
                                            <tr <?php if ($row_templatedetails['incometax_rate'] == "No") { ?> style="display: none;" <?php } ?>>
                                                <td>Saving of Income Tax in Year -<?php echo $y; ?></td>
                                                <td><?php echo $depreciationone_taxsaving; ?></td>
                                            </tr>
                                            <?php
                                            $total_depreciation_taxsaving = $depreciationone_taxsaving + $total_depreciation_taxsaving;
                                            $total_depreciation_taxsaving = number_format((float) $total_depreciation_taxsaving, 2, '.', '');

                                            $totalaverage_powergeneration = $average_powergeneration * $y;
                                            $netsaving_fouryearbill = $row_templatedetails['electricity_rate'] * $totalaverage_powergeneration;
                                            $netsaving_fouryearbill = number_format((float) $netsaving_fouryearbill, 2, '.', '');

                                            if (($row_templatedetails['gst_input'] == "Yes") && ($row_templatedetails['incometax_rate'] == "Yes")) {
                                                $totalsaving_fouryear = $gst_inpercentage + $total_depreciation_taxsaving + $netsaving_fouryearbill;
                                            } elseif (($row_templatedetails['gst_input'] == "Yes") && ($row_templatedetails['incometax_rate'] == "No")) {
                                                $totalsaving_fouryear = $gst_inpercentage + $netsaving_fouryearbill;
                                            } elseif (($row_templatedetails['gst_input'] == "No") && ($row_templatedetails['incometax_rate'] == "Yes")) {
                                                $totalsaving_fouryear = $total_depreciation_taxsaving + $netsaving_fouryearbill;
                                            } elseif (($row_templatedetails['gst_input'] == "No") && ($row_templatedetails['incometax_rate'] == "No")) {
                                                $totalsaving_fouryear = $netsaving_fouryearbill;
                                            }

                                            $totalsaving_fouryear = number_format((float) $totalsaving_fouryear, 2, '.', '');
                                            if ($totalsaving_fouryear > $salesprice) {
                                                $x = 500;
                                            }
                                            $y++;
                                        }
                                        $z = $y - 1;
                                        ?>
                                        <tr style="background-color: #67c54a;font-weight: bold; <?php if ($row_templatedetails['incometax_rate'] == "No") { ?> display: none; <?php } ?>">
                                            <td>Savings on TAX</td>
                                            <td><?php echo $total_depreciation_taxsaving; ?></td>
                                        </tr>
                                        <?php for ($w = 1; $w <= $z; $w++) { ?>
                                            <tr>
                                                <td>Average Power Generation Year -<?php echo $w; ?></td>
                                                <td><?php echo $average_powergeneration; ?></td>
                                            </tr>
                                        <?php } ?>
                                        <tr>
                                            <td>Rate of Electricity</td>
                                            <td><?php echo $row_templatedetails['electricity_rate']; ?></td>
                                        </tr>
                                        <?php
                                        ?>
                                        <tr style="background-color: #67c54a;font-weight: bold;">
                                            <td>Net Saving on electrcity bill in <?php echo $z; ?> Years</td>
                                            <td><?php echo $netsaving_fouryearbill; ?></td>
                                        </tr>
                                        <tr style="background-color: #c2a047;font-weight: bold;">
                                            <td><strong>Total Savings in <?php echo $z; ?> Years</strong></td>
                                            <td><strong><?php echo $totalsaving_fouryear; ?></strong></td>
                                        </tr>
                                        <tr>
                                            <td>Cost Recovered in years approx</td>
                                            <td><?php echo $z; ?> </td>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
    }
    ?>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include '../masters/admin-master.php';
?>

<script type="text/javascript" language="javascript" >

    function ChangeSelectedProduct(itemidamount) {
        itemidamount = itemidamount.trim();
        itemidamount_arr = itemidamount.split('-');
        $('#item_amount').val(itemidamount_arr[1]);
    }

    function ChangeProductCategory(category_id) {
        $.ajax({
            type: "POST",
            url: "get-productcategory.php",
            data: "category_id=" + category_id + "&action=get-productcategory",
            success: function (data) {
                $('#product_id').html(data);
            }
        });
    }

    function RemoveCostSheetItems(lead_id, templateitem_id) {
        if (confirm("Are you sure you want to perform this action?")) {
            $.ajax({
                type: "POST",
                url: "create-costsheet.inc.php",
                data: "lead_id=" + lead_id + "&templateitem_id=" + templateitem_id + "&action=active_inactive",
                success: function (data) {
                    alert('Action successfully performed');
                    window.location = 'create-costsheet.php?lead_id=' + lead_id;
                }
            });
        }
    }

    function ChangeCostSheetOverHeads() {
        var template_overheads = $('#template_overheads').val();
        var lead_id = $('#lead_id').val();
        $.ajax({
            type: "POST",
            url: "create-costsheet.inc.php",
            data: "lead_id=" + lead_id + "&template_overheads=" + template_overheads + "&action=template_overheads",
            success: function (data) {
                alert('Action successfully performed');
                window.location = 'create-costsheet.php?lead_id=' + lead_id;
            }
        });
    }

    function ChangeCostSheetProfit() {
        var template_profit = $('#template_profit').val();
        var lead_id = $('#lead_id').val();
        $.ajax({
            type: "POST",
            url: "create-costsheet.inc.php",
            data: "lead_id=" + lead_id + "&template_profit=" + template_profit + "&action=template_profit",
            success: function (data) {
                alert('Action successfully performed');
                window.location = 'create-costsheet.php?lead_id=' + lead_id;
            }
        });
    }

    function ChangeCostSheetGST() {
        var template_gst = $('#template_gst').val();
        var lead_id = $('#lead_id').val();
        $.ajax({
            type: "POST",
            url: "create-costsheet.inc.php",
            data: "lead_id=" + lead_id + "&template_gst=" + template_gst + "&action=template_gst",
            success: function (data) {
                alert('Action successfully performed');
                window.location = 'create-costsheet.php?lead_id=' + lead_id;
            }
        });
    }

    function SaveCostSheet(lead_id) {
        $.ajax({
            type: "POST",
            url: "create-costsheet.inc.php",
            data: "lead_id=" + lead_id + "&action=savecostsheet",
            success: function (data) {
                alert('Action successfully performed');
                window.location = 'create-costsheet.php?lead_id=' + lead_id;
            }
        });
    }

    function SaveCostSheetWithMaster(lead_id) {
        $.ajax({
            type: "POST",
            url: "create-costsheet.inc.php",
            data: "lead_id=" + lead_id + "&action=savemastercostsheet",
            success: function (data) {
                alert('Action successfully performed');
                window.location = 'create-costsheet.php?lead_id=' + lead_id;
            }
        });
    }

    function ChangeIncomeTaxrate(taxrate) {
        if (taxrate === 'Yes') {
            $('#incometax_value_divid').show();
        } else if (taxrate === 'No') {
            $('#incometax_value_divid').hide();
        }
    }

    function ChangeDCRNonDCR() {
        var dcr_nondcr = $('#dcr_nondcr').val();
        var dcr_nondcr_type = $('#dcr_nondcr_type').val();
        if ((dcr_nondcr !== '') && (dcr_nondcr_type !== '')) {
            $.ajax({
                type: "POST",
                url: "gettemplate.php",
                data: "dcr_nondcr=" + dcr_nondcr + "&dcr_nondcr_type=" + dcr_nondcr_type + "&action=get_template",
                success: function (data) {
                    $('#copy_template').html(data);
                }
            });
        }
    }

    function ClickTemplateDropDown() {
        var dcr_nondcr = $('#dcr_nondcr').val();
        var dcr_nondcr_type = $('#dcr_nondcr_type').val();
        if (dcr_nondcr === '') {
            alert('Please Select DCR/Non DCR');
        } else if (dcr_nondcr_type === '') {
            alert('Please Select Type');
        }
    }
</script>