$().ready(function () {

    $("#adminlogin_formid").validate({
        rules: {
            mob_email: {
                required: true
            },
            password: {
                required: true
            }
        },
        messages: {
            mob_email: {
                required: "Please enter email id or mobile number"
            },
            password: {
                required: "Please enter password"
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#login_errormsgid').hide();
            $('#login_successmsgid').hide();
            $.post("slogin.inc.php", $("#adminlogin_formid").serialize(), function (data) {
                data = data.trim();
                data_arr = data.split('<!explode>');
                if (data_arr[0] === '20') {
                    $('#login_errormsgid').show();
                } else if (data_arr[0] === '10') {
                    $('#login_successmsgid').show();
                    if (data_arr[1] === "ADM") {
                        window.location = './smin/index.php';
                    } else if (data_arr[1] === "Telecaller") {
                        window.location = './smin/index.php';
                    } else if (data_arr[1] === "Sales_Executive") {
                        window.location = './smin/index.php';
                    } else {
                        window.location = './smin/index.php';
                    }
                }
            });
        }
    });
    $("#adminchangepassword_formid").validate({
        rules: {
            password: {
                required: true
            },
            confirm_password: {
                required: true
            }
        },
        messages: {
            password: {
                required: "Please enter new password"
            },
            confirm_password: {
                required: "Please enter confirm password"
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#changepasswordmsg').html('');
            var password = $('#password').val();
            var confirm_password = $('#confirm_password').val();
            if (password != confirm_password) {
                $('#changepasswordmsg').html('<div class="text-center alert alert-danger">Please enter the same value again</div>');
            } else {
                $.post("update-password.inc.php", $("#adminchangepassword_formid").serialize(), function (data) {
                    data = data.trim();
                    $('#password').val('');
                    $('#confirm_password').val('');
                    $('#changepasswordmsg').html('<div class="text-center alert alert-success">Password Successfully Updated</div>');
                });
            }
        }
    });
    $("#staffadd_formid").validate({
        rules: {
            staff_name: {
                required: true,
                customvalidation: true
            },
            email_id: {
                required: true,
                email: true
            },
            staff_type: {
                required: true
            },
            city: {
                required: true
            },
            mobile_number: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10,
                customphonenumbervalidation: true
            },
            password: {
                required: true
            }
        },
        messages: {
            staff_name: {
                required: "Please enter name."
            },
            email_id: {
                required: "Please enter email id."
            },
            staff_type: {
                required: "Please select staff type."
            },
            city: {
                required: "Please select city."
            },
            mobile_number: {
                required: "Please enter mobile number."
            },
            password: {
                required: "Please enter password."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#register_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#staffadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "manage-staff.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'email_mobile') {
                        $('#signup_errormsgid').show();
                        $('#alreadyexistemailandmobile').html('email and phone number');
                    } else if (data_arr[0] == 'email_exist') {
                        $('#signup_errormsgid').show();
                        $('#alreadyexistemailandmobile').html('e-mail');
                    } else if (data_arr[0] == 'mobile_exist') {
                        $('#signup_errormsgid').show();
                        $('#alreadyexistemailandmobile').html('phone number');
                    } else if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#signup_successmsgid').show();
                        $('#tbladminList').DataTable().ajax.reload();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });
    $("#leadadd_formid").validate({
        rules: {
            lead_Source: {
                required: true,
                customvalidation: true
            },
            customer_name: {
                required: true,
                customvalidation: true
            },
            email_id: {
//                required: true,
                email: true
            },
            address: {
                required: true
            },
            city: {
                required: true
            },
            mobile_number: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10,
                customphonenumbervalidation: true
            },
            assigned_telecaller: {
                required: true
            }
        },
        messages: {
            lead_Source: {
                required: "Please select source."
            },
            customer_name: {
                required: "Please enter name."
            },
            email_id: {
                required: "Please enter email id."
            },
            address: {
                required: "Please enter address."
            },
            city: {
                required: "Please select city."
            },
            mobile_number: {
                required: "Please enter mobile number."
            },
            assigned_telecaller: {
                required: "Please enter password."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#register_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#leadadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "lead-add.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'email_mobile') {
                        $('#signup_errormsgid').show();
                        $('#alreadyexistemailandmobile').html('email and phone number');
                    } else if (data_arr[0] == 'email_exist') {
                        $('#signup_errormsgid').show();
                        $('#alreadyexistemailandmobile').html('e-mail');
                    } else if (data_arr[0] == 'mobile_exist') {
                        $('#signup_errormsgid').show();
                        $('#alreadyexistemailandmobile').html('phone number');
                    } else if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#signup_successmsgid').show();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });
    $("#leadstatustelecaller_formid").validate({
        rules: {
            leadch_status: {
                required: true
            }
        },
        messages: {
            leadch_status: {
                required: "Please select status."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            var formData = new FormData($('#leadstatustelecaller_formid')[0]);
            $.ajax({
                type: "POST",
                url: "lead-status.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] === 'success') {
                        alert('Status Successfully Updated');
                        $('#tbladminList').DataTable().ajax.reload();
                        $('.close').click();
                    } else {
                        alert(data_arr[1]);
                    }
                }
            });
        }
    });

    $("#categoryadd_formid").validate({
        rules: {
            category_name: {
                required: true
            }
        },
        messages: {
            category_name: {
                required: "Please enter name."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#category_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#categoryadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "manage-category.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#signup_successmsgid').show();
                        $('#tbladminList').DataTable().ajax.reload();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });

    $("#brandadd_formid").validate({
        rules: {
            brand_name: {
                required: true
            }
        },
        messages: {
            brand_name: {
                required: "Please enter name."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#category_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#brandadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "manage-brand.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#signup_successmsgid').show();
                        $('#tbladminList').DataTable().ajax.reload();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });

    $("#productadd_formid").validate({
        rules: {
            category_id: {
                required: true
            },
            product_name: {
                required: true
            },
            product_rate: {
                required: true
            },
            unit_type: {
                required: true
            }
        },
        messages: {
            category_id: {
                required: "Please select category."
            },
            product_name: {
                required: "Please enter program name."
            },
            product_rate: {
                required: "Please enter rate."
            },
            unit_type: {
                required: "Please select type."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#category_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#productadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "manage-product.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#signup_successmsgid').show();
                        $('#tbladminList').DataTable().ajax.reload();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });

    $("#templateadd_formid").validate({
        rules: {
            dcr_nondcr: {
                required: true
            },
            dcr_nondcr_type: {
                required: true
            },
            template_name: {
                required: true
            }
        },
        messages: {
            dcr_nondcr: {
                required: "Please select dcr/nondcr."
            },
            dcr_nondcr_type: {
                required: "Please select type."
            },
            template_name: {
                required: "Please enter name."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#template_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#templateadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "manage-template.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#signup_successmsgid').show();
                        $('#tbladminList').DataTable().ajax.reload();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });

    $("#templateitemsadd_formid").validate({
        rules: {
            type: {
                required: true
            },
            product_id: {
                required: true
            },
            item_amount: {
                required: true
            },
            quantity: {
                required: true
            }
        },
        messages: {
            type: {
                required: "Please select type."
            },
            product_id: {
                required: "Please select product."
            },
            item_amount: {
                required: "Please enter amount."
            },
            quantity: {
                required: "Please enter quantity."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#template_btnid').hide();
            $('#processing_divid').show();
            var template_id = $('#template_id').val();
            var formData = new FormData($('#templateitemsadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "manage-templateitems.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#signup_successmsgid').show();
                        window.location = 'manage-templateitems.php?template_id=' + template_id;
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });

    $("#copytemplateadd_formid").validate({
        rules: {
            copy_template: {
                required: true
            }
        },
        messages: {
            copy_template: {
                required: "Please select template."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#copytemplate_successmsgid').hide();
            $('#copytemplate_btnid').hide();
            $('#copytemplateprocessing_divid').show();
            var template_id = $('#template_id').val();
            var formData = new FormData($('#copytemplateadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "manage-templateitems.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#copytemplate_successmsgid').show();
                        window.location = 'manage-templateitems.php?template_id=' + template_id;
                    }
                    $('#copytemplateprocessing_divid').hide();
                    $('#copytemplate_btnid').show();
                }
            });
        }
    });

    $("#selecttemplatelead_formid").validate({
        rules: {
            costsheet_name: {
                required: true,
                custompricevalidation: true
            },
            gst_input: {
                required: true
            },
            incometax_rate: {
                required: true
            },
            electricity_rate: {
                required: true,
                custompricevalidation: true
            },
            dcr_nondcr: {
                required: true
            },
            dcr_nondcr_type: {
                required: true
            },
            incometax_value: {
//                required: true,
                custompricevalidation: true
            },
            copy_template: {
                required: true
            }
        },
        messages: {
            costsheet_name: {
                required: "Please enter KWP."
            },
            gst_input: {
                required: "Please select GST Input."
            },
            incometax_rate: {
                required: "Please select Income tax rate."
            },
            electricity_rate: {
                required: "Please enter electricity rate."
            },
            dcr_nondcr: {
                required: "Please select DCR/Non DCR."
            },
            dcr_nondcr_type: {
                required: "Please select Type."
            },
            incometax_value: {
                required: "Please enter tax."
            },
            copy_template: {
                required: "Please select template."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#copytemplate_successmsgid').hide();
            $('#copytemplate_btnid').hide();
            $('#copytemplateprocessing_divid').show();
            var lead_id = $('#lead_id').val();
            var formData = new FormData($('#selecttemplatelead_formid')[0]);
            $.ajax({
                type: "POST",
                url: "create-costsheet.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#copytemplate_successmsgid').show();
                        window.location = 'create-costsheet.php?lead_id=' + lead_id;
                    }
                    $('#copytemplateprocessing_divid').hide();
                    $('#copytemplate_btnid').show();
                }
            });
        }
    });

    $("#costsheetitemsadd_formid").validate({
        rules: {
            type: {
                required: true
            },
            product_id: {
                required: true
            },
            item_amount: {
                required: true
            },
            quantity: {
                required: true
            }
        },
        messages: {
            type: {
                required: "Please select type."
            },
            product_id: {
                required: "Please select product."
            },
            item_amount: {
                required: "Please enter amount."
            },
            quantity: {
                required: "Please enter quantity."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#template_btnid').hide();
            $('#processing_divid').show();
            var lead_id = $('#lead_id').val();
            var formData = new FormData($('#costsheetitemsadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "create-costsheet.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#signup_successmsgid').show();
                        window.location = 'create-costsheet.php?lead_id=' + lead_id;
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });

    $("#companyadd_formid").validate({
        rules: {
            company_name: {
                required: true
            },
            email_id: {
                required: true
            },
            phone_number: {
                required: true
            },
            short_name: {
                required: true
            },
            company_address: {
                required: true
            },
            person_name: {
                required: true
            },
            person_emailid: {
                required: true
            },
            person_phonenumber: {
                required: true
            },
            account_holder: {
                required: true
            },
            account_number: {
                required: true
            },
            ifsc_code: {
                required: true
            },
            branch: {
                required: true
            },
            account_type: {
                required: true
            }
        },
        messages: {
            company_name: {
                required: "Please enter company name."
            },
            email_id: {
                required: "Please enter email id."
            },
            phone_number: {
                required: "Please enter number."
            },
            short_name: {
                required: "Please enter short name."
            },
            company_address: {
                required: "Please enter address."
            },
            person_name: {
                required: "Please enter name."
            },
            person_emailid: {
                required: "Please enter email id."
            },
            person_phonenumber: {
                required: "Please enter phone number."
            },
            account_holder: {
                required: "Please enter account holder."
            },
            account_number: {
                required: "Please enter account number."
            },
            ifsc_code: {
                required: "Please enter ifsc code."
            },
            branch: {
                required: "Please enter branch."
            },
            account_type: {
                required: "Please select account type."
            }
        },
        tooltip_options: {
            '_all_': {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#register_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#companyadd_formid')[0]);
            $.ajax({
                type: "POST",
                url: "manage-company.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    var hidden_companyid = $('#hidden_companyid').val();
                    if (data_arr[0] == 'success') {
                        $('.clrfield').val('');
                        $('#signup_successmsgid').show();
                        if (hidden_companyid == '') {
                            $('#tbladminList').DataTable().ajax.reload();
                        } else {
                            window.location = 'manage-company.php';
                        }
                    } else {
                        $('#signup_errormsgconentid').html(data_arr[0]);
                        $('#signup_errormsgid').show();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });

    $("#inspectionchecklist_formid").validate({
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#category_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#inspectionchecklist_formid')[0]);
            $.ajax({
                type: "POST",
                url: "inspection-checklist.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('#signup_successmsgid').show();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });

    $("#netmeteringchecklist_formid").validate({
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#category_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#netmeteringchecklist_formid')[0]);
            $.ajax({
                type: "POST",
                url: "netmetering-checklist.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('#signup_successmsgid').show();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });

    $("#subsidychecklist_formid").validate({
        submitHandler: function () {
            $('#signup_successmsgid').hide();
            $('#signup_errormsgid').hide();
            $('#category_btnid').hide();
            $('#processing_divid').show();
            var formData = new FormData($('#subsidychecklist_formid')[0]);
            $.ajax({
                type: "POST",
                url: "subsidy-checklist.inc.php",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = $.trim(data);
                    var data_arr = data.split("<!explode>");
                    if (data_arr[0] == 'success') {
                        $('#signup_successmsgid').show();
                    } else {
                        $('#errormsgid').html(data);
                        $('#signup_errormsgid').show();
                    }
                    $('#processing_divid').hide();
                    $('#register_btnid').show();
                }
            });
        }
    });


    $.validator.addMethod("customvalidation",
            function (value, element) {
                if (value !== "") {
                    return /^[A-Za-z ]+$/.test(value);
                } else {
                    return true;
                }
            },
            "Sorry, no special characters allowed"
            );
    $.validator.addMethod("custompricevalidation",
            function (value, element) {
                if (value !== "") {
                    return /^[0-9.]+$/.test(value);
                } else {
                    return true;
                }
            },
            "Sorry, only numbers allowed"
            );
    $.validator.addMethod("customphonenumbervalidation",
            function (value, element) {
                if (value !== "") {
                    return /^[0-9+]+$/.test(value);
                } else {
                    return true;
                }
            },
            "Sorry, only numbers allowed"
            );
    $.validator.addMethod("customvalidationwithdots",
            function (value, element) {
                if (value !== "") {
                    return /^[A-Za-z0-9.,-/ ]+$/.test(value);
                } else {
                    return true;
                }
            },
            "Sorry, no special characters allowed"
            );
});
