<?php

header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT, GET, POST");
include_once '../session/session.php';
include_once '../classes/common.php';
include_once '../classes/class_appapk.php';

$objadmin = new class_appapk();
$Object_common = new common();

ini_set("display_errors", 0);

$postdata = file_get_contents("php://input");
$jsonValue = json_decode($postdata, true);

$action = empty($jsonValue["action"]) ? "action_empty" : $jsonValue["action"];
$staff_id = empty($jsonValue["staff_id"]) ? "staff_id_empty" : $jsonValue["staff_id"];
$staff_type = empty($jsonValue["staff_type"]) ? "staff_type_empty" : $jsonValue["staff_type"];

$arr = array();

if ($action == "action_empty") {
    $arr["res_status"] = "2";
    $arr["res_msg"] = "Source Not Found!";
} else if ($staff_id == "staff_id_empty") {
    $arr["res_status"] = "3";
    $arr["res_msg"] = "Staff Id Not Found!";
} else if ($staff_type == "staff_type_empty") {
    $arr["res_status"] = "4";
    $arr["res_msg"] = "Staff Type Not Found!";
} else if ($action != "dashboard_490669") {
    $arr["res_status"] = "6";
    $arr["res_msg"] = "Invalid Source!";
} else {

    $added_date = DATE('Y-m-d H:i:s');

    $objadmin->staff_id = $staff_id;
    $objadmin->staff_type = $staff_type;

    $result_pendingleadlist = $objadmin->GetPendingLeadList();
    $pending_leads = mysqli_num_rows($result_pendingleadlist);

    $result_leadlist = $objadmin->GetLeadList();
    $total_leads = mysqli_num_rows($result_leadlist);
    $arr["res_status"] = "1";
    $arr["total_leads"] = $total_leads;
    $arr["pending_leads"] = $pending_leads;
    if (($total_leads) > 0) {
        $i = 1;
        $arr_details = array();
        while ($row_leadlist = mysqli_fetch_array($result_leadlist)) {
            if ($i < 26) {

                if ($row_leadlist['status'] == "10") {
                    $current_status = "New Lead";
                } elseif ($row_leadlist['status'] == "11") {
                    $current_status = "Follow-up";
                } elseif ($row_leadlist['status'] == "12") {
                    $current_status = "Not Interested";
                } elseif ($row_leadlist['status'] == "13") {
                    $current_status = "Requested for Site Survey";
                } elseif ($row_leadlist['status'] == "14") {
                    $current_status = "Assigned Project Incharge";
                } elseif ($row_leadlist['status'] == "15") {
                    $current_status = "Site Survey";
                } elseif ($row_leadlist['status'] == "16") {
                    $current_status = "Site Survey Work Complete";
                } elseif ($row_leadlist['status'] == "17") {
                    $current_status = "Solar Designer Assign";
                } elseif ($row_leadlist['status'] == "18") {
                    $current_status = "Solar Design Work Complete";
                } elseif ($row_leadlist['status'] == "19") {
                    if ($row_leadlist['proposal_status'] == "10") {
                        $current_status = "Proposal Submit";
                    } else {
                        $current_status = "Preparing Proposal";
                    }
                } elseif ($row_leadlist['status'] == "20") {
                    $current_status = "Proposal Approved by Client";
                } elseif ($row_leadlist['status'] == "21") {
                    $current_status = "Assigned Installer & Material Order";
                } elseif ($row_leadlist['status'] == "22") {
                    $current_status = "Material Delivered";
                } elseif ($row_leadlist['status'] == "23") {
                    $current_status = "Installation Completed";
                }

                if ($row_leadlist['survey_finalsubmit'] == "10") {
                    $survey_finalsubmit = "Yes";
                } else {
                    $survey_finalsubmit = "No";
                }

                if ($row_leadlist['installer_finalsubmit'] == "10") {
                    $installer_finalsubmit = "Yes";
                } else {
                    $installer_finalsubmit = "No";
                }
                if ($staff_type == "Site_Inspection_Engineer") {
                    $arr_details[] = array('lead_id' => $row_leadlist['lead_id'], 'customer_name' => $row_leadlist['customer_name'], 'mobile_number' => $row_leadlist['mobile_number'], 'current_status' => $current_status, 'address' => $row_leadlist['address'], 'status' => $row_leadlist['status'], 'survey_date' => $row_leadlist['survey_datetime'], 'survey_notes' => $row_leadlist['survey_notes'], 'lead_type' => $row_leadlist['lead_type'], 'email_id' => $row_leadlist['email_id'], 'survey_finalsubmit' => $survey_finalsubmit);
                } elseif ($staff_type == "Installer") {
                    $arr_details[] = array('lead_id' => $row_leadlist['lead_id'], 'customer_name' => $row_leadlist['customer_name'], 'mobile_number' => $row_leadlist['mobile_number'], 'current_status' => $current_status, 'address' => $row_leadlist['address'], 'status' => $row_leadlist['status'], 'installation_date' => $row_leadlist['installer_datetime'], 'installation_notes' => $row_leadlist['installer_notes'], 'lead_type' => $row_leadlist['lead_type'], 'email_id' => $row_leadlist['email_id'], 'installer_finalsubmit' => $installer_finalsubmit);
                }
            }
            $i++;
        }
        $arr["lead_details"] = $arr_details;
    } else {
        $arr["res_status"] = "5";
        $arr["res_msg"] = "Records not found!";
    }
}

$RES = json_encode($arr);
echo $RES;
?>