<?php
ob_start();
include_once './manage-product.inc.php';
$page_name_info = "manage_product";
?>
<style type="text/css">
    .form-control, .asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=text], .jsgrid .jsgrid-table .jsgrid-filter-row select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=number], .select2-container--default .select2-selection--single, .select2-container--default .select2-selection--single .select2-search__field, .typeahead, .tt-query, .tt-hint {
        border: 1px solid #2c2e33;
        height: calc(2.25rem + 2px);
        font-weight: normal;
        font-size: 0.875rem;
        padding: 0.625rem 0.6875rem;
        background-color: #2A3038;
        border-radius: 2px;
        color: #000;
    }
    select.form-control, select.asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row select, .select2-container--default select.select2-selection--single, .select2-container--default .select2-selection--single select.select2-search__field, select.typeahead, select.tt-query, select.tt-hint {
        padding: .4375rem .75rem;
        border: 0;
        color: #000 !important;
    }
</style>
<div class="content-wrapper" style="background: #fff;">
    <div class="page-header">
        <h3 class="page-title" style="color:#000;"> Manage Product </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Product</a></li>
                <li class="breadcrumb-item active" aria-current="page">Manage Product</li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Add Product</h4>
                    <form class="forms-sample row" action="" id="productadd_formid" method="post">
                        <div class="col-12 " id="signup_successmsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-success text-center" style="margin-bottom: 0px;">Product Successfully Saved</div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-3">
                            <div class="form-group">
                                <label>Category</label>
                                <div>
                                    <select class="form-control clrfield" name="category_id" id="category_id" style="background-color: #fafdf4;">
                                        <option value="">Select Category</option>
                                        <?php while ($rowmastercategory = mysqli_fetch_array($resultmastercategory)) { ?>
                                            <option value="<?php echo $rowmastercategory['id']; ?>" <?php if ($rowmastercategory['id'] == $row_memberdetails['category_id']) { ?> selected="" <?php } ?>><?php echo $rowmastercategory['category_name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="form-group">
                                <label>Product Name</label>
                                <div>
                                    <input type="text" name="product_name" id="product_name" autocomplete="product_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['product_name']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="form-group">
                                <label>Product Specification</label>
                                <div>
                                    <input type="text" name="product_specification" id="product_specification" autocomplete="product_specification" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['product_specification']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label>Capacity</label>
                                <div>
                                    <input type="text" name="capacity" id="capacity" autocomplete="capacity" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['capacity']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="form-group">
                                <label>Brand</label>
                                <div>
                                    <select class="form-control clrfield" name="brand_id" id="brand_id" style="background-color: #fafdf4;">
                                        <option value="">Select Brand</option>
                                        <?php while ($rowmasterbrand = mysqli_fetch_array($resultmasterbrand)) { ?>
                                            <option value="<?php echo $rowmasterbrand['id']; ?>" <?php if ($rowmasterbrand['id'] == $row_memberdetails['brand_id']) { ?> selected="" <?php } ?>><?php echo $rowmasterbrand['brand_name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="form-group">
                                <label>Rate</label>
                                <div>
                                    <input type="text" name="product_rate" id="product_rate" autocomplete="product_rate" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['product_rate']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div class="form-group">
                                <label>Unit Type</label>
                                <div>
                                    <select class="form-control clrfield" name="unit_type" id="unit_type" style="background-color: #fafdf4;">
                                        <option value="">Select Type</option>
                                        <option value="NOS" <?php if ($row_memberdetails['unit_type'] == "NOS") { ?> selected="" <?php } ?>>NOS</option>
                                        <option value="MTR" <?php if ($row_memberdetails['unit_type'] == "MTR") { ?> selected="" <?php } ?>>MTR</option>
                                        <option value="PIC" <?php if ($row_memberdetails['unit_type'] == "PIC") { ?> selected="" <?php } ?>>PIC</option>
                                        <option value="PAIR" <?php if ($row_memberdetails['unit_type'] == "PAIR") { ?> selected="" <?php } ?>>PAIR</option>
                                        <option value="WATT" <?php if ($row_memberdetails['unit_type'] == "WATT") { ?> selected="" <?php } ?>>WATT</option>
                                        <option value="KWATT" <?php if ($row_memberdetails['unit_type'] == "KWATT") { ?> selected="" <?php } ?>>KWATT</option>
                                        <option value="PKT" <?php if ($row_memberdetails['unit_type'] == "PKT") { ?> selected="" <?php } ?>>PKT</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <input type="hidden" name="hidden_productid" id="hidden_productid" class="form-control clrfield" value="<?php echo common::StrFromDb($product_id); ?>">
                                    <a class="login-btn btn btn btn-danger profile-save-btn" id="processing_divid" style="display: none;">Processing...</a>
                                    <input type="submit" class="btn btn-primary mb-2" id="register_btnid" name="register_btnid" value="Save" style="    width: 50%;
                                           height: 39px;">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <h4 style="color:#000;">
        Product Listing
        <div class="clearfix"></div>
    </h4>
    <div class="row">
        <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="tbladminList" class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                            <thead>                            
                                <tr>
                                    <th data-orderable="false">SN</th>
                                    <th data-orderable="false">Category</th>
                                    <th data-orderable="false">Product</th>
                                    <th data-orderable="false">Specification</th>
                                    <th data-orderable="false">Capacity</th>
                                    <th data-orderable="false">Brand</th>
                                    <th data-orderable="false">Rate</th>
                                    <th data-orderable="false">Unit Type</th>
                                    <th data-orderable="false">Action</th>  
                                </tr>
                            </thead>                                
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include '../masters/admin-master.php';
?>

<script type="text/javascript" language="javascript" >

    $(document).ready(function () {
        AdminProductListing();
        function AdminProductListing() {
            var dataTable = $('#tbladminList').DataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'ajax': {
                    'url': 'manage-product.inc.php?action=show_productlist',
                    "type": "POST",
                    "data": function (d) {
                        d.form = JSON.stringify($("#frmFilter").serializeArray());
                    }
                },

                'columns': [
                    {data: 'sno'},
                    {data: 'category'},
                    {data: 'product_name'},
                    {data: 'product_specification'},
                    {data: 'capacity'},
                    {data: 'brand'},
                    {data: 'product_rate'},
                    {data: 'unit_type'},
                    {data: 'action'}
                ],
                columnDefs: [
                    {className: 'text-center', targets: [0]}
                ],
                "lengthMenu": [500, 1000, 10000],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'List',
                        exportOptions: {
                            columns: [0, 1, 2]
                        }
                    }
                ]
            }
            );
        }
    });

    function FilterApplicantList() {
        $('#tbladminList').DataTable().ajax.reload();
    }

    function AdminProductStatusChange(product_id, status) {
        if (confirm("Are you sure you want to perform this action?")) {
            $.ajax({
                type: "POST",
                url: "manage-product.inc.php",
                data: "product_id=" + product_id + "&status=" + status + "&action=active_inactive",
                success: function (data) {
                    alert('Action successfully performed');
                    window.location = 'manage-product.php';
                }
            });
        }
    }
</script>