<?php

class common {

    public static function StrToDB($str) {
        $str = str_replace("'", "&#39;", $str);
        $str = str_replace('"', "&#34;", $str);
        $str = str_replace("\n", "&#nl", $str);
        $str = str_replace("\r", "&#rl", $str);
//        $str = str_replace(";", "&#99", $str);

        return $str;
    }

    public static function StrFromDb($str) {
        $str = str_replace("&#39;", "'", $str);
        $str = str_replace("&#34;", '"', $str);
        $str = str_replace("&#nl", "\n", $str);
//        $str = str_replace("&#nl", "\n", $str);
        $str = str_replace("&#rl", "\r", $str);
//        $str = str_replace("&#99", ";", $str);

        return $str;
    }

    public static function StrFromDbWithNewLine($str) {
        $str = str_replace("&#39;", "'", $str);
        $str = str_replace("&#34;", '"', $str);
        $str = str_replace("&#nl", "<br/>", $str);
//        $str = str_replace("&#nl", "\n", $str);
        $str = str_replace("&#rl", "\r", $str);
//        $str = str_replace("&#99", ";", $str);

        return $str;
    }

    public static function cleanupinvaliddata($str) {
        $str = preg_replace('/[^a-z0-9 ,@!_\.$#&*]/i', '', $str);
        return $str;
    }

    public function uniqueid($ct) {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "AbcDE123IJKLMN67QRSTUVWXYZ";
        $data .= "aBCdefghijklmn123opq45rs67tuv89wxyz";
        $data .= "0FGH45OP89";
        for ($i = 0; $i < $ct; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }

    public function uniquenumbers($ct) {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "1973085246";
        $data .= "6425803791";
        $data .= "0258147369";
        for ($i = 0; $i < $ct; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }

    public function uniqueotpcode($ct) {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "1592634870";
        for ($i = 0; $i < $ct; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }

    public function GenerateOTP($ct) {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "0123456789987654321015975364820472569035040";
        for ($i = 0; $i < $ct; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }

    public function GetID($type) {
        $ID = "";
        switch ($type) {
            case "PRO":
                $ID = 'G' . date('mdhi') . $this->uniquenumbers(2);
                break;
            case "ORD":
                $ID = 'ORD' . date('mdhi') . $this->uniquenumbers(2);
                break;
        }
        return $ID;
    }

    public function DeleteImage($type, $file_name) {
        switch ($type) {
            case "pro":
                $img_dirlarge = "prodimg/";
                break;
            case "bra":
                $img_dirlarge = "brandimg/";
                break;
            case "prf":
                $img_dirlarge = "profimgimg/";
                break;
        }
        unlink($img_dirlarge . $file_name);
        unlink($img_dirlarge . "s_" . $file_name);
        return "ok";
    }

    public function CreateThumb($type, $file_name) {
        //PRF - profile, PRO-product,BRA-brand
        switch ($type) {
            case "pro":
                $img_dirlarge = "prodimg/";
                break;
            case "bra":
                $img_dirlarge = "brandimg/";
                break;
            case "prf":
                $img_dirlarge = "profimgimg/";
                break;
        }
//Clean the Filename
        $img = explode('.', $file_name);
//Thumbnail file
        $image_filePath = $img_dirlarge . $file_name; //$_FILES['imageSource']['tmp_name'];
//Rename the thumbnail Image
        $krowAvatar = "s_" . $img[0] . "." . $img[1];
        $img_thumbLarge = $img_dirlarge . $krowAvatar;
//String lower case
        $extension = strtolower($img[1]);
//Check the file format before upload
        if (in_array($extension, array('jpg', 'jpeg', 'gif', 'png', 'bmp'))) {
            //Find the height and width of the image
            list($gotwidth, $gotheight, $gottype, $gotattr) = getimagesize($image_filePath);
            //Find the image type
            //---------- To create thumbnail of image---------------
            if ($extension == "jpg" || $extension == "jpeg") {
                $src = imagecreatefromjpeg($image_filePath);
            } else if ($extension == "png") {
                $src = imagecreatefrompng($image_filePath);
            } else {
                $src = imagecreatefromgif($image_filePath);
            }
            //Get the height and width of uploaded image
            list($width, $height) = getimagesize($image_filePath);

// ----------------------------------------------------
            //Set new width for image
            $newwidthLarge = 50;

            //Set new height for image
            // $newheightLarge=160;
            // or Calculate and scale it proportanly
            $newheightLarge = round(($height * $newwidthLarge) / $height);

// ----------------------------------------------------
            //Creating the thumbnail from true color
            $tmp = imagecreatetruecolor($newwidthLarge, $newheightLarge);
            //Enable image interlace property
            imageinterlace($tmp, 1);
            //Create a image with given dimension
            imagecopyresampled($tmp, $src, 0, 0, 0, 0, $newwidthLarge, $newheightLarge, $width, $height);
            //Put the image data to newly created Image
            $createImageSave = imagejpeg($tmp, $img_thumbLarge, 100);
        }
        return $file_name;
    }

    //put your code here

    public function humanTiming($time) {
        $time = time() - $time; // to get the time since that moment
        $tokens = array(
            31536000 => 'year',
            2592000 => 'month',
            604800 => 'week',
            86400 => 'day',
            3600 => 'hour',
            60 => 'minute',
            1 => 'second'
        );
        foreach ($tokens as $unit => $text) {
            if ($time < $unit)
                continue;
            $numberOfUnits = floor($time / $unit);
            return $numberOfUnits . ' ' . $text . (($numberOfUnits > 1) ? 's' : '');
        }
    }

//    function IND_money_format($money) {
//        $len = strlen($money);
//        $m = '';
//        $money = strrev($money);
//        for ($i = 0; $i < $len; $i++) {
//            if (( $i == 3 || ($i > 3 && ($i - 1) % 2 == 0) ) && $i != $len) {
//                $m .= ',';
//            }
//            $m .= $money[$i];
//        }
//        return strrev($m);
//    }

    function IND_money_format($num) {
        $nums = explode(".", $num);
        if (count($nums) > 2) {
            return "0";
        } else {
            if (count($nums) == 1) {
                $nums[1] = "00";
            }
            $num = $nums[0];
            $explrestunits = "";
            if (strlen($num) > 3) {
                $lastthree = substr($num, strlen($num) - 3, strlen($num));
                $restunits = substr($num, 0, strlen($num) - 3);
                $restunits = (strlen($restunits) % 2 == 1) ? "0" . $restunits : $restunits;
                $expunit = str_split($restunits, 2);
                for ($i = 0; $i < sizeof($expunit); $i++) {

                    if ($i == 0) {
                        $explrestunits .= (int) $expunit[$i] . ",";
                    } else {
                        $explrestunits .= $expunit[$i] . ",";
                    }
                }
                $thecash = $explrestunits . $lastthree;
            } else {
                $thecash = $num;
            }
            return $thecash . "." . $nums[1];
        }
    }

    function money_format($number) {
        $format = "%i";
        $regex = '/%((?:[\^!\-]|\+|\(|\=.)*)([0-9]+)?' .
                '(?:#([0-9]+))?(?:\.([0-9]+))?([in%])/';
        if (setlocale(LC_MONETARY, 0) == 'C') {
            setlocale(LC_MONETARY, '');
        }
        $locale = localeconv();
        preg_match_all($regex, $format, $matches, PREG_SET_ORDER);
        foreach ($matches as $fmatch) {
            $value = floatval($number);
            $flags = array(
                'fillchar' => preg_match('/\=(.)/', $fmatch[1], $match) ?
                $match[1] : ' ',
                'nogroup' => preg_match('/\^/', $fmatch[1]) > 0,
                'usesignal' => preg_match('/\+|\(/', $fmatch[1], $match) ?
                $match[0] : '+',
                'nosimbol' => preg_match('/\!/', $fmatch[1]) > 0,
                'isleft' => preg_match('/\-/', $fmatch[1]) > 0
            );
            $width = trim($fmatch[2]) ? (int) $fmatch[2] : 0;
            $left = trim($fmatch[3]) ? (int) $fmatch[3] : 0;
            $right = trim($fmatch[4]) ? (int) $fmatch[4] : $locale['int_frac_digits'];
            $conversion = $fmatch[5];

            $positive = true;
            if ($value < 0) {
                $positive = false;
                $value *= -1;
            }
            $letter = $positive ? 'p' : 'n';

            $prefix = $suffix = $cprefix = $csuffix = $signal = '';

            $signal = $positive ? $locale['positive_sign'] : $locale['negative_sign'];
            switch (true) {
                case $locale["{$letter}_sign_posn"] == 1 && $flags['usesignal'] == '+':
                    $prefix = $signal;
                    break;
                case $locale["{$letter}_sign_posn"] == 2 && $flags['usesignal'] == '+':
                    $suffix = $signal;
                    break;
                case $locale["{$letter}_sign_posn"] == 3 && $flags['usesignal'] == '+':
                    $cprefix = $signal;
                    break;
                case $locale["{$letter}_sign_posn"] == 4 && $flags['usesignal'] == '+':
                    $csuffix = $signal;
                    break;
                case $flags['usesignal'] == '(':
                case $locale["{$letter}_sign_posn"] == 0:
                    $prefix = '(';
                    $suffix = ')';
                    break;
            }
            if (!$flags['nosimbol']) {
                $currency = $cprefix .
                        ($conversion == 'i' ? $locale['int_curr_symbol'] : $locale['currency_symbol']) .
                        $csuffix;
            } else {
                $currency = '';
            }
            $space = $locale["{$letter}_sep_by_space"] ? ' ' : '';

            $value = number_format($value, $right, $locale['mon_decimal_point'], $flags['nogroup'] ? '' : $locale['mon_thousands_sep']);
            $value = @explode($locale['mon_decimal_point'], $value);

            $n = strlen($prefix) + strlen($currency) + strlen($value[0]);
            if ($left > 0 && $left > $n) {
                $value[0] = str_repeat($flags['fillchar'], $left - $n) . $value[0];
            }
            $value = implode($locale['mon_decimal_point'], $value);
            if ($locale["{$letter}_cs_precedes"]) {
                $value = $prefix . $currency . $space . $value . $suffix;
            } else {
                $value = $prefix . $value . $space . $currency . $suffix;
            }
            if ($width > 0) {
                $value = str_pad($value, $width, $flags['fillchar'], $flags['isleft'] ?
                        STR_PAD_RIGHT : STR_PAD_LEFT);
            }

            $format = str_replace($fmatch[0], $value, $format);
        }
        $format = str_replace("INR ", "", "$format");
        $format = str_replace("USD", "", "$format");
        return $format;
    }

    public static function urlformation($textforurl) {

        $filtered_words = array(
            'a', 'an', 'as', 'at', 'before', 'but', 'by', 'for', 'from', 'is', 'in', 'into',
            'like', 'of', 'off', 'on', 'onto', 'per', 'since', 'than', 'the', 'this', 'that', 'to', 'up',
            'via', 'with'
        );

        $textforurl_array = explode(' ', $textforurl);
        $textforurl_array_final = array_diff($textforurl_array, $filtered_words);
        $textforurl_new = implode(' ', $textforurl_array_final);

        $textforurl_new = strtolower($textforurl_new);

        $textforurl_new = str_replace("-", " ", $textforurl_new);
        $textforurl_new = preg_replace('/[^A-Za-z0-9 -]/', '', $textforurl_new);
        $textforurl_new = trim(preg_replace('/\s+/', ' ', $textforurl_new));
        $textforurl_new = str_replace(" ", "-", $textforurl_new);
        $textforurl_new = str_replace(".", "", $textforurl_new);
        $textforurl_new = str_replace("&", "", $textforurl_new);
        $textforurl_new = str_replace(",", "-", $textforurl_new);


        return $textforurl_new;
    }

    public static function SearchKeyword($textforurl) {

        $filtered_words = array(
            'a', 'an', 'as', 'at', 'before', 'but', 'by', 'for', 'from', 'is', 'in', 'into',
            'like', 'of', 'off', 'on', 'onto', 'per', 'since', 'than', 'the', 'this', 'that', 'to', 'up',
            'via', 'with'
        );

        $textforurl_array = explode(' ', $textforurl);
        $textforurl_array_final = array_diff($textforurl_array, $filtered_words);
        $textforurl_new = implode(',', $textforurl_array_final);

        $textforurl_new = strtolower($textforurl_new);

        $textforurl_new = str_replace("-", " ", $textforurl_new);
        $textforurl_new = preg_replace('/[^A-Za-z0-9 -,]/', '', $textforurl_new);
        $textforurl_new = trim(preg_replace('/\s+/', ' ', $textforurl_new));
        $textforurl_new = str_replace(" ", "-", $textforurl_new);
        $textforurl_new = str_replace(".", "", $textforurl_new);
        $textforurl_new = str_replace("&", "", $textforurl_new);
        return $textforurl_new;
    }

    public static function GetCurrentFinancialYear() {
        if (date('m') > 4) {
            $year = date('y') . "-" . (date('y') + 1);
        } else {
            $year = (date('y') - 1) . "-" . date('y');
        }
        return $year;
    }

    public static function GetFullCurrentFinancialYear() {
        if (date('m') > 4) {
            $year = date('Y') . "-" . (date('Y') + 1);
        } else {
            $year = (date('Y') - 1) . "-" . date('Y');
        }
        return $year;
    }

    public static function CalculateMonthFromDateRange($date1, $date2) {
        $ts1 = strtotime($date1);
        $ts2 = strtotime($date2);
        $year1 = date('Y', $ts1);
        $year2 = date('Y', $ts2);

        $month1 = date('m', $ts1);
        $month2 = date('m', $ts2);

        $diff = (($year2 - $year1) * 12) + ($month2 - $month1);
        return $diff + 1;
    }

    public static function GetAmountInWord($number) {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(0 => '', 1 => 'one', 2 => 'two',
            3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
            7 => 'seven', 8 => 'eight', 9 => 'nine',
            10 => 'ten', 11 => 'eleven', 12 => 'twelve',
            13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
            16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
            19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
            40 => 'forty', 50 => 'fifty', 60 => 'sixty',
            70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
        $digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
        while ($i < $digits_length) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else
                $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal) ? " " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return $Rupees . " " . $paise . " Only";
    }

    function str_decrypt($decodeMe) {

        $decode = base64_decode($decodeMe); //Decoding the string from base64.
        $decode = strrev($decode);
        return $decode; //Returns the decoded string.
    }

    function str_encrypt($encodeMe) {

        $encode = strrev($encodeMe);
        $encode = base64_encode($encode); //Encoding the string to base64.
        return $encode; //Returns the encoded string.
    }

    function recalluniquePaymentidfunc($usertype) {
        $this->uniquePaymentid($usertype);
    }

    function uniquePaymentid($usertype) {
        $Objdb = new class_db();
        $querycount = "SELECT COUNT(id) as count_payment FROM gmg_addpoints_tbl";
        $Objdb->sproc_name = $querycount;
        $resultcount = $Objdb->SelectQuery();
        list($count_payment) = mysqli_fetch_row($resultcount);
        $count_number = $count_payment + 1;
        $last_increment_number = str_pad($count_number, 3, "0", STR_PAD_LEFT);
        $payment_id = $usertype . mt_rand(111, 999) . $last_increment_number;
        $querycountfinal = "SELECT id FROM gmg_addpoints_tbl WHERE payment_id='$payment_id'";
        $Objdb->sproc_name = $querycountfinal;
        $resultcountfinal = $Objdb->SelectQuery();
        $count_unique = mysqli_num_rows($resultcountfinal);
        if ($count_unique == 0) {
            return $payment_id;
        } else {
            $this->recalluniquePaymentidfunc($usertype);
        }
    }

}

?>
