<?php
$allowed_origin = 'https://sritechapp.com/rcues-room-booking';
header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: $allowed_origin");
header("Access-Control-Allow-Methods: PUT, GET, POST");
include_once '../classes/DB.class.php';
include_once '../classes/common.php';
include_once '../classes/validation.php';
require_once('../tcpdf/tcpdf.php');



class MYPDF extends TCPDF {

    public function Header() {
        $this->SetFont('helvetica', 'B', 8);
        $view_tbl .= '';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    public function Footer() {

        $this->SetY(-50);

        $this->SetFont('helvetica', 'I', 8);

        $view_tbl .= '';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }

}

ini_set("display_errors", 0);

$db = new DB();
$val = new validation();
$com = new common();

$action = empty($_POST["action"]) ? "" : $_POST["action"];
$added_by = empty($_POST["added_by"]) ? "" : $_POST["added_by"];

$added_date = DATE('Y-m-d H:i:s');
if ($action == "") {
    $arr["res_status"] = "2";
    $arr["res_msg"] = "Source Not Found!";
} else {

    switch ($action) {

        case "event-add":

            $event_name = empty($_POST["event_name"]) ? "" : $_POST["event_name"];
            $event_name = preg_replace("/[^a-zA-Z0-9_-]/", "", $event_name);
            
            
            $event_details = empty($_POST["event_details"]) ? "" : $_POST["event_details"];
            $event_details = preg_replace("/[^a-zA-Z0-9_-]/", "", $event_details);

            $ins_array = array(
                "event_name" => common::StrToDB($event_name),
                "event_details" => common::StrToDB($event_details),
                "added_date" => "$added_date",
                "added_by" => "$added_by"
            );

            $db->insert($ins_array, "rcuesr_event_tbl");

            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";

        case "event-edit":

            $event_name = empty($_POST["event_name"]) ? "" : $_POST["event_name"];
            $event_name = preg_replace("/[^a-zA-Z0-9_-]/", "", $event_name);
            
            $event_details = empty($_POST["event_details"]) ? "" : $_POST["event_details"];
            $event_details = preg_replace("/[^a-zA-Z0-9_-]/", "", $event_details);
            
            $event_pk_id = empty($_POST["event_pk_id"]) ? "" : $_POST["event_pk_id"];
            $event_pk_id = preg_replace("/[^a-zA-Z0-9_-]/", "", $event_pk_id);

            $update_array = array(
                "event_name" => common::StrToDB($event_name),
                "event_details" => common::StrToDB($event_details)
            );

            $db->update($update_array, "rcuesr_event_tbl", "event_pk_id='$event_pk_id'");

            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";

            break;

        case "room-book":
            
            $error_flag = 2;

            $applicant_name = empty($_POST["applicant_name"]) ? "" : $_POST["applicant_name"];
            $applicant_name = preg_replace("/[^a-zA-Z0-9_]/", "", $applicant_name);
            
            $applicant_post = empty($_POST["applicant_post"]) ? "" : $_POST["applicant_post"];
            $applicant_post = preg_replace("/[^a-zA-Z0-9_]/", "", $applicant_post);
            
            $applicant_department = empty($_POST["applicant_department"]) ? "" : $_POST["applicant_department"];
            $applicant_department = preg_replace("/[^a-zA-Z0-9_]/", "", $applicant_department);
            
            $mobile_number = empty($_POST["mobile_number"]) ? "" : $_POST["mobile_number"];
            $mobile_number = preg_replace("/[^a-zA-Z0-9_]/", "", $mobile_number);
            
            
            $applicant_address = empty($_POST["applicant_address"]) ? "" : $_POST["applicant_address"];
            $applicant_address = preg_replace("/[^a-zA-Z0-9_,-]/", "", $applicant_address);
            
            $id_type = empty($_POST["id_type"]) ? "" : $_POST["id_type"];
            $id_type = preg_replace("/[^a-zA-Z0-9_]/", "", $id_type);
            
            $id_number = empty($_POST["id_number"]) ? "" : $_POST["id_number"];
            $id_number = preg_replace("/[^a-zA-Z0-9_]/", "", $id_number);
            
            $upload_id_file = empty($_FILES['upload_id_file']['name']) ? "" : $_FILES['upload_id_file']['name'];
            
            $event_option = empty($_POST['event_option']) ? "" : $_POST['event_option'];
            $event_option = preg_replace("/[^a-zA-Z0-9_]/", "", $event_option);
            
            
            $total_person = empty($_POST['total_person']) ? "" : $_POST['total_person'];
            $total_person = preg_replace("/[^a-zA-Z0-9_]/", "", $total_person);
            
            
            $total_days = empty($_POST['total_days']) ? "" : $_POST['total_days'];
            $total_days = preg_replace("/[^a-zA-Z0-9_]/", "", $total_days);
            
            
            $total_room = empty($_POST['total_room']) ? "" : trim($_POST['total_room']);
             $total_room = preg_replace("/[^a-zA-Z0-9_]/", "", $total_room);
            
            
            $room_number = empty($_POST['room_number']) ? "" : trim($_POST['room_number']);
            $room_number = preg_replace("/[^a-zA-Z0-9_,-]/", "", $room_number);
            
            
            $arrival_date = empty($_POST['arrival_date']) ? "" : $_POST['arrival_date'];
            $arrival_date = preg_replace("/[^a-zA-Z0-9_,-]/", "", $arrival_date);
            
            
            $arrival_time = empty($_POST['arrival_time']) ? "" : $_POST['arrival_time'];
            $arrival_time = preg_replace("/[^a-zA-Z0-9_:-]/", "", $arrival_time);
            
            
            $room_rate = empty($_POST['room_rate']) ? "0.00" : $_POST['room_rate'];
            $room_rate = preg_replace("/[^a-zA-Z0-9_.-]/", "", $room_rate);
            
            
            $adl_charges = empty($_POST['adl_charges']) ? "0.00" : $_POST['adl_charges'];
            $adl_charges = preg_replace("/[^a-zA-Z0-9_.-]/", "", $adl_charges);
            
            $room_tax = empty($_POST['room_tax']) ? "0.00" : $_POST['room_tax'];
            $room_tax = preg_replace("/[^a-zA-Z0-9_.-]/", "", $room_tax);
             
            $room_amount = empty($_POST['room_amount']) ? "0.00" : $_POST['room_amount'];
            $room_amount = preg_replace("/[^a-zA-Z0-9_.-]/", "", $room_amount);
            
            $pan_number = empty($_POST['pan_number']) ? "" : $_POST['pan_number'];
            $pan_number = preg_replace("/[^a-zA-Z0-9_.-]/", "", $pan_number);
            
            $gst_number = empty($_POST['gst_number']) ? "" : $_POST['gst_number'];
            $gst_number = preg_replace("/[^a-zA-Z0-9_.-]/", "", $gst_number);
            
            $sharing_check = empty($_POST['sharing_check']) ? "NO" : "YES";
            
            
            $applicant_name_second = empty($_POST['applicant_name_second']) ? "" : $_POST['applicant_name_second'];
            $applicant_name_second = preg_replace("/[^a-zA-Z0-9_.-]/", "", $applicant_name_second);
            
            $mobile_number_second = empty($_POST['mobile_number_second']) ? "" : $_POST['mobile_number_second'];
            $mobile_number_second = preg_replace("/[^a-zA-Z0-9_.-]/", "", $mobile_number_second);
            
            
            $id_type_second = empty($_POST['id_type_second']) ? "" : $_POST['id_type_second'];
            $id_type_second = preg_replace("/[^a-zA-Z0-9_.-]/", "", $id_type_second);
            
            $id_number_second = empty($_POST['id_number_second']) ? "" : $_POST['id_number_second'];
            $id_number_second = preg_replace("/[^a-zA-Z0-9_.-]/", "", $id_number_second);
            
            $upload_id_file_second = empty($_FILES['upload_id_file_second']['name']) ? "" : $_FILES['upload_id_file_second']['name'];
           
            $applicant_post_second = empty($_POST['applicant_post_second']) ? "" : $_POST['applicant_post_second'];
            $applicant_post_second = preg_replace("/[^a-zA-Z0-9_.-]/", "", $applicant_post_second);
            
            
            $applicant_department_second = empty($_POST['applicant_department_second']) ? "" : $_POST['applicant_department_second'];
            $applicant_department_second = preg_replace("/[^a-zA-Z0-9_.-]/", "", $applicant_department_second);
            
            $pan_number_second = empty($_POST['pan_number_second']) ? "" : $_POST['pan_number_second'];
            $pan_number_second = preg_replace("/[^a-zA-Z0-9_.-]/", "", $pan_number_second);
            
            $gst_number_second = empty($_POST['gst_number_second']) ? "" : $_POST['gst_number_second'];
            $gst_number_second = preg_replace("/[^a-zA-Z0-9_.-]/", "", $gst_number_second);
            
            

            if (!empty($arrival_date)) {
                $arrival_date_time = DATE('Y-m-d H:i:s', strtotime($arrival_date . " " . $arrival_time));
                $arrival_date = DATE('Y-m-d', strtotime($arrival_date));
            }

            $departure_date = empty($_POST['departure_date']) ? "" : $_POST['departure_date'];
            $departure_time = empty($_POST['departure_time']) ? "" : $_POST['departure_time'];

            if (!empty($departure_date)) {
                $departure_date_time = DATE('Y-m-d H:i:s', strtotime($departure_date . " " . $departure_time));
                $departure_date = DATE('Y-m-d', strtotime($departure_date));
            }


            $purpose_visit = empty($_POST['purpose_visit']) ? "" : $_POST['purpose_visit'];
            $purpose_visit = preg_replace("/[^a-zA-Z0-9_.-]/", "", $purpose_visit);

         
            /* Checking room is availble or not */
            $BookedRoomArr = array();
            $room_number_arr = explode(",", $room_number);
           
            if (count($room_number_arr) > 1) {
                foreach ($room_number_arr as $rna) {
                    $roomId = trim($rna);
                    $RoomCheckAvailable = array();
                    $arrival_date_time_db = DATE("Y-m-d", strtotime($arrival_date_time));
                    $departure_date_time_db = DATE("Y-m-d", strtotime($departure_date_time));
                    
                    $RoomCheckAvailable = $db->selectWithCols("rcuesr_room_number_book_tbl", "room_number_pk_id", "1 AND ((DATE(arrival_date_time)>'$arrival_date_time_db' AND DATE(departure_date_time)<'$departure_date_time_db') OR (DATE(arrival_date_time)<'$arrival_date_time_db' AND DATE(departure_date_time)>'$arrival_date_time_db') OR (DATE(arrival_date_time)<'$departure_date_time_db' AND DATE(departure_date_time)>'$departure_date_time_db')) AND FIND_IN_SET('$roomId', room_number) AND book_status='2'");
                    if (count($RoomCheckAvailable) > 0) {
                       
                        $BookedRoomArr[] = $roomId;
                    }
                }
            } else {
                $RoomCheckAvailable = array();
                
                    $arrival_date_time_db = DATE("Y-m-d", strtotime($arrival_date_time));
                    $departure_date_time_db = DATE("Y-m-d", strtotime($departure_date_time));
                
                //echo "1 AND ((DATE(arrival_date_time)>'$arrival_date_time_db' AND DATE(departure_date_time)<'$departure_date_time_db') OR (DATE(arrival_date_time)<'$arrival_date_time_db' AND DATE(departure_date_time)>'$arrival_date_time_db') OR (DATE(arrival_date_time)<'$departure_date_time_db' AND DATE(departure_date_time)>'$departure_date_time_db')) AND FIND_IN_SET('$room_number', room_number) AND book_status='2'";
                
                $RoomCheckAvailable = $db->selectWithCols("rcuesr_room_number_book_tbl", "room_number_pk_id", "1 AND ((DATE(arrival_date_time)>'$arrival_date_time_db' AND DATE(departure_date_time)<'$departure_date_time_db') OR (DATE(arrival_date_time)<'$arrival_date_time_db' AND DATE(departure_date_time)>'$arrival_date_time_db') OR (DATE(arrival_date_time)<'$departure_date_time_db' AND DATE(departure_date_time)>'$departure_date_time_db')) AND FIND_IN_SET('$room_number', room_number) AND book_status='2'");
                 if (count($RoomCheckAvailable) > 0) {
                $BookedRoomArr[] = $room_number;
                 }
            }

            //print_r($BookedRoomArr);

            if (count($BookedRoomArr) == 0) {

                if ($_FILES['upload_id_file']['name']) {
                    $upload_id_file = mt_rand(111, 999) . $upload_id_file;
                    $upload_id_file_arr = explode(".", $upload_id_file);
                    $last_one_value = end($upload_id_file_arr);
                    $last_one_value = strtolower($last_one_value);
                   
                    if($last_one_value == "jpg" || $last_one_value == "png" || $last_one_value == "jpeg" || $last_one_value == "pdf" || $last_one_value == "doc" || $last_one_value == "docx"){
                    if (move_uploaded_file($_FILES['upload_id_file']['tmp_name'], "../updoc/" . $upload_id_file)) {
                        
                    }
                    }else{
                         $arr["res_status"] = "3";
                $arr["res_msg"] = "Supported only File Format i.e. jpg, jpeg, pdf, doc, docx";
                $error_flag = 1;
                    }
                }
                
                if ($_FILES['upload_id_file_second']['name']) {
                    $upload_id_file_second = mt_rand(111, 999) . $upload_id_file_second;
                    $upload_id_file_arr = explode(".", $upload_id_file_second);
                    $last_second_value = end($upload_id_file_arr);
                    $last_second_value = strtolower($last_second_value);
                    if($last_second_value == "jpg" || $last_second_value == "png" || $last_second_value == "jpeg" || $last_second_value == "pdf" || $last_second_value == "doc" || $last_second_value == "docx"){
                    if (move_uploaded_file($_FILES['upload_id_file_second']['tmp_name'], "../updoc/" . $upload_id_file_second)) {
                        
                    }
                    }else{
                        $error_flag = 1;
                         $arr["res_status"] = "3";
                $arr["res_msg"] = "Supported only File Format i.e. jpg, jpeg, pdf, doc, docx";
                    }
                }

                if($error_flag == 2){
                $ins_array = array(
                    "applicant_name" => common::StrToDB($applicant_name),
                    "applicant_post" => common::StrToDB($applicant_post),
                    "department" => common::StrToDB($applicant_department),
                    "mobile_number" => common::StrToDB($mobile_number),
                    "applicant_address" => common::StrToDB($applicant_address),
                    "id_type" => $id_type,
                    "id_number" => $id_number,
                    "upload_file" => $upload_id_file,
                    "event_option" => common::StrToDB($event_option),
                    "total_person" => common::StrToDB($total_person),
                    "total_days" => common::StrToDB($total_days),
                    "total_room" => common::StrToDB($total_room),
                    "room_number" => common::StrToDB($room_number),
                    "purpose_visit" => common::StrToDB($purpose_visit),
                    "arrival_date_time" => common::StrToDB($arrival_date_time),
                    "departure_date_time" => common::StrToDB($departure_date_time),
                    "proposed_departure_date_time" => common::StrToDB($departure_date_time),
                    "purpose_visit" => common::StrToDB($purpose_visit),
                    "room_rate" => common::StrToDB($room_rate),
                    "adl_charges" => common::StrToDB($adl_charges),
                    "tax" => common::StrToDB($room_tax),
                    "proposed_amount" => common::StrToDB($room_amount),
                    "added_date" => "$added_date",
                    "added_by" => "$added_by",
                    "pan_number" => "$pan_number",
                    "gst_number" => "$gst_number",
                    "applicant_name_second" => "$applicant_name_second",
                    "mobile_number_second" => "$mobile_number_second",
                    "id_type_second" => "$id_type_second",
                    "id_number_second" => "$id_number_second",
                    "upload_id_file_second" => "$upload_id_file_second",
                    "applicant_post_second" => "$applicant_post_second",
                    "applicant_department_second" => "$applicant_department_second",
                    "pan_number_second" => "$pan_number_second",
                    "gst_number_second" => "$gst_number_second",
                    "applicant_address_second" => "$applicant_address_second",
                    "sharing_check" => "$sharing_check"
                );
                
                $BookingId = $db->insert($ins_array, "rcuesr_room_booking_tbl");

                foreach ($room_number_arr as $rna) {
                    $roomId = trim($rna);
                    $InsRoom = array(
                        "room_book_pk_id" => "$BookingId",
                        "room_number" => "$roomId",
                        "arrival_date_time" => "$arrival_date_time",
                        "departure_date_time" => "$departure_date_time",
                        "proposed_departure_date_time" => "$departure_date_time"
                    );
                    $RoomNumberBookId = $db->insert($InsRoom, "rcuesr_room_number_book_tbl");
                }

                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
                
                }
                
                
            } else {
                $BookedRoomStr = implode(",", $BookedRoomArr);
                $arr["res_status"] = "2";
                $arr["res_msg"] = $BookedRoomStr . " Rooms booked on selected date";
            }

            break;

        case "FunCheckOut":

            ini_set("display_errors", 0);
            
            $RoomBookId = empty($_POST["RoomBookId"]) ? "" : $_POST["RoomBookId"];
            $RoomBookId = preg_replace("/[^a-zA-Z0-9_-]/", "", $RoomBookId);
            
            $received_amount = empty($_POST["received_amount"]) ? "" : $_POST['received_amount'];
            $received_amount = preg_replace("/[^a-zA-Z0-9_.-]/", "", $received_amount);
            
            /*Checking the RoomBooid exist or not*/
            
            $RoomBookingArr = $db->selectWithCols("rcuesr_room_booking_tbl", "room_book_pk_id", "room_book_pk_id='$RoomBookId'");
            
            if(count($RoomBookingArr)>0){
                
                
            if (!empty($received_amount)) {
                
                if($val->numericdot($received_amount) == true){

                $MonthVal = DATE('n');
                if ($MonthVal <= 3) {
                    $yearPrev = DATE('Y') - 1;
                    $FinancialYear = $yearPrev . "-" . DATE('y');
                    $start_financial_date = $yearPrev . "-04" . "-01";
                    $end_financial_date = DATE('Y') . "-03" . "-31";
                } else {
                    $yearNext = DATE('y') + 1;
                    $FinancialYear = DATE('Y') . "-" . $yearNext;
                    $start_financial_date = DATE('Y') . "-04" . "-01";
                    $nY = DATE('Y') + 1;
                    $end_financial_date = $nY . "-03" . "-31";
                }

                /* Getting Room Booking count according to FY */
                $CountBookingArr = $db->selectWithCols("rcuesr_room_booking_tbl", "COUNT(room_book_pk_id) as RoomBook", "book_status='1' AND (DATE(departure_date_time)>='$start_financial_date' OR DATE(departure_date_time)<='$end_financial_date')");
                $RoomBook = $CountBookingArr['0']['RoomBook'];
                /* Getting Start Bill Number FY */
                $SetFYValArr = $db->selectWithCols("rcuesr_bill_number_settings_tbl", "bill_start_number", "financial_year_set='$FinancialYear'");
                $bill_start_number = $SetFYValArr['0']['bill_start_number'];

                $Final_bill_number = $RoomBook + $bill_start_number;
                $bill_number = "RCUES/" . $FinancialYear . "/" . $Final_bill_number;

                $UpdateArr = array(
                    "paid_amount" => "$received_amount",
                    "departure_date_time" => "$added_date",
                    "book_status" => "1",
                    "bill_number" => "$bill_number"
                );

                $db->update($UpdateArr, "rcuesr_room_booking_tbl", "room_book_pk_id='$RoomBookId'");
                
                /*Room Book Status*/
                $UpdateBookArr = array(
                    "book_status" => "1"
                );
                $db->update($UpdateBookArr, "rcuesr_room_number_book_tbl", "room_book_pk_id='$RoomBookId'");
                
                
                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
                
                }else{
                $arr["res_status"] = "2";
                $arr["res_msg"] = "Received Amount must be in Numbers!";
                }
                
                
            } else {
                $arr["res_status"] = "2";
                $arr["res_msg"] = "Received Amount must have some value!";
            }
            
            
            }else{
                $arr["res_status"] = "2";
                $arr["res_msg"] = "Booking Id Not Available";
            }

            break;
            
            
            case "transfer-guest":

            ini_set("display_errors", 0);
            
            $applicant_name = empty($_POST["applicant_name"]) ? "" : $_POST["applicant_name"];
            $applicant_name = preg_replace("/[^a-zA-Z0-9_-]/", "", $applicant_name);
            
            $applicant_post = empty($_POST["applicant_post"]) ? "" : $_POST["applicant_post"];
            $applicant_post = preg_replace("/[^a-zA-Z0-9_-]/", "", $applicant_post);
            
            $applicant_department = empty($_POST["applicant_department"]) ? "" : $_POST["applicant_department"];
            $applicant_department = preg_replace("/[^a-zA-Z0-9_-]/", "", $applicant_department);
             
             
            $mobile_number = empty($_POST["mobile_number"]) ? "" : $_POST["mobile_number"];
            $mobile_number = preg_replace("/[^a-zA-Z0-9_-]/", "", $mobile_number);
            
            
            $event_option = empty($_POST['event_option']) ? "" : $_POST['event_option'];
            $event_option = preg_replace("/[^a-zA-Z0-9_-]/", "", $event_option);
            
            $total_person = empty($_POST['total_person']) ? "" : $_POST['total_person'];
            $total_person = preg_replace("/[^a-zA-Z0-9_-]/", "", $total_person);
            
            
            $arrival_date = empty($_POST['arrival_date']) ? "" : $_POST['arrival_date'];
            $arrival_date = preg_replace("/[^a-zA-Z0-9_-]/", "", $arrival_date);
            
            
            $arrival_time = empty($_POST['arrival_time']) ? "" : $_POST['arrival_time'];
            $arrival_time = preg_replace("/[^a-zA-Z0-9_-]/", "", $arrival_time);
            
            $purpose_visit = empty($_POST['purpose_visit']) ? "" : $_POST['purpose_visit'];
            $purpose_visit = preg_replace("/[^a-zA-Z0-9_-]/", "", $purpose_visit);
            
            $recommended_place = empty($_POST['recommended_place']) ? "" : $_POST['recommended_place'];
            $recommended_place = preg_replace("/[^a-zA-Z0-9_-]/", "", $recommended_place);
            
            
            if (!empty($arrival_date)) {
                $arrival_date_time = DATE('Y-m-d H:i:s', strtotime($arrival_date . " " . $arrival_time));
                $arrival_date = DATE('Y-m-d', strtotime($arrival_date));
            }
            
            $ins_array = array(
                "applicant_name" => common::StrToDB($applicant_name),
                "applicant_post" => common::StrToDB($applicant_post),
                "department" => common::StrToDB($applicant_department),
                "mobile_number" => common::StrToDB($mobile_number),
                "arrival_date_time" => common::StrToDB($arrival_date_time),
                "purpose_visit" => common::StrToDB($purpose_visit),
                "event_option" => $event_option,
                "total_person" => "$total_person",
                "recommended_place" => common::StrToDB($recommended_place)
                );
                
            $BookingId = $db->insert($ins_array, "rcuesr_transfer_guest_tbl");
                
                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
                
                //print_r($ins_array);
            
            break;
    }

    $RES = json_encode($arr);
    echo $RES;
}
?>