<?php
ob_start();
include_once 'classes/common.php';
include_once 'classes/DB.class.php';
include_once 'session/admin-session.php';

$db = new DB();

$added_by = $_SESSION['rcuesr_room_admin_id'];
$EventID = $_REQUEST['EventID'];
$EventID = preg_replace("/[^a-zA-Z0-9_@-]/", "", $EventID);
$event_list_arr = $db->selectWithCols("rcuesr_event_tbl", "*", "status='1'");

?>
<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12 ">
        <h3>Room Booking</h3>
        <div class="box box-primary">
            <div class="box-body">
                <div class="row" id="result_msg" style="padding-left: 5px;"></div>
                <form action="" method="POST" id="room_book_form_id" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-3 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Guest Name<font color="red">*</font></label>
                                <input type="text" name="applicant_name" id="applicant_name" class="form-control input-lg" required=""/>

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Mobile Number<font color="red">*</font></label>
                                <input type="text" name="mobile_number" id="mobile_number" class="form-control input-lg" required=""/>
                                <i style="font-size: 10px;">(You can enter comma separated Mobile Number)</i>
                            </div>
                        </div>
                            <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>ID Type<font color="red">*</font></label>
                                <input type="text" name="id_type" id="id_type" class="form-control input-lg" required=""/>
                                <i style="font-size: 10px;">(Enter Type Of document Name i.e. Aadhar Card, Pan Card etc.)</i>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>ID Number<font color="red">*</font></label>
                                <input type="text" name="id_number" id="id_number" class="form-control input-lg" required=""/>
                                <i style="font-size: 10px;">(Enter document Number i.e. Aadhar Number, Pan Number etc.)</i>
                            </div>
                        </div>
                    
                        <div class="col-md-3 col-sm-3 col-xs-3">
                            <div class="form-group">
                                <label>Upload File ID</label>
                                <input type="file" name="upload_id_file" id="upload_id_file" class="form-control input-lg"/>
                                <i style="font-size: 10px;">(Upload any identification document in image or, pdf)</i>
                            </div>
                        </div>
                             
                    
                             <div class="clearfix"></div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Post</label>
                                <input type="text" name="applicant_post" id="applicant_post" class="form-control input-lg" />

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Department</label>
                                <input type="text" name="applicant_department" id="applicant_department" class="form-control input-lg" />

                            </div>
                        </div>
                       
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>PAN</label>
                                <input type="text" name="pan_number" id="pan_number" class="form-control input-lg"/>
                            </div>
                        </div>
                         <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>GST</label>
                                <input type="text" name="gst_number" id="gst_number" class="form-control input-lg"/>
                            </div>
                        </div>
                            <div class="col-md-4 col-sm-4 col-xs-4">
                            <div class="form-group">
                                <label>Address</label>
                                <input type="text" name="applicant_address" id="applicant_address" class="form-control input-lg"/>

                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-xs-12"></div>
                        
                        <div class="col-md-12 col-sm-12 col-xs-12" style="float: right;">
                            <input type="checkbox" name="sharing_check" id="sharing_check" value="1" onclick="FunSharingCheck();"/> Sharing Room
                        </div>
                        
                        <div class="clearfix"></div>
                        
                        <div style="border-top: 2px solid grey;border-bottom: 2px solid grey; display: none;" id="guest_second_div">
                              <div class="col-md-12 col-sm-12 col-xs-12"></div>
                         <div class="clearfix"></div>
                         <div class="col-md-3 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Guest Name Second<font color="red">*</font></label>
                                <input type="text" name="applicant_name_second" id="applicant_name_second" class="form-control input-lg"/>

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Mobile Number<font color="red">*</font></label>
                                <input type="text" name="mobile_number_second" id="mobile_number_second" class="form-control input-lg" />
                                <i style="font-size: 10px;">(You can enter comma separated Mobile Number)</i>
                            </div>
                        </div>
                            <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>ID Type<font color="red">*</font></label>
                                <input type="text" name="id_type_second" id="id_type_second" class="form-control input-lg"/>
                                <i style="font-size: 10px;">(Enter Type Of document Name i.e. Aadhar Card, Pan Card etc.)</i>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>ID Number<font color="red">*</font></label>
                                <input type="text" name="id_number_second" id="id_number_second" class="form-control input-lg" />
                                <i style="font-size: 10px;">(Enter document Number i.e. Aadhar Number, Pan Number etc.)</i>
                            </div>
                        </div>
                    
                        <div class="col-md-3 col-sm-3 col-xs-3">
                            <div class="form-group">
                                <label>Upload File ID</label>
                                <input type="file" name="upload_id_file_second" id="upload_id_file_second" class="form-control input-lg"/>
                                <i style="font-size: 10px;">(Upload any identification document in image or, pdf)</i>
                            </div>
                        </div>
                             
                    
                             <div class="clearfix"></div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Post</label>
                                <input type="text" name="applicant_post_second" id="applicant_post_second" class="form-control input-lg" />

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Department</label>
                                <input type="text" name="applicant_department_second" id="applicant_department_second" class="form-control input-lg" />

                            </div>
                        </div>
                       
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>PAN</label>
                                <input type="text" name="pan_number_second" id="pan_number_second" class="form-control input-lg"/>
                            </div>
                        </div>
                         <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>GST</label>
                                <input type="text" name="gst_number_second" id="gst_number_second" class="form-control input-lg"/>
                            </div>
                        </div>
                            <div class="col-md-4 col-sm-4 col-xs-4">
                            <div class="form-group">
                                <label>Address</label>
                                <input type="text" name="applicant_address_second" id="applicant_address_second" class="form-control input-lg"/>

                            </div>
                        </div>
                         <div class="clearfix"></div>
                           <div class="col-md-12 col-sm-12 col-xs-12"></div>
                        </div>
                        
                         <div class="clearfix"></div>
                         
                        <div class="col-md-12 col-sm-12 col-xs-12"></div>
                        <div class="col-md-12 col-sm-12 col-xs-12"></div>
                        
                        <div class="col-md-3 col-sm-3 col-xs-3">
                            <div class="form-group">
                                <label>Choose Event <font color="red">*</font></label>
                                <select name="event_option" id="event_option" class="form-control input-lg" required="">
                                    <option value="">Select</option>
                                    <?php foreach ($event_list_arr as $ela) { 
                                        $SelectedEvent = "";
                                    if($ela['event_pk_id'] == $EventID){
                                         $SelectedEvent = "SELECTED";
                                    }
                                    ?>
                                        <option value="<?php echo $ela['event_pk_id']; ?>" <?php echo $SelectedEvent; ?>><?php echo $ela['event_name']; ?></option>
                                    <?php } ?>
                                </select>

                            </div>
                        </div>

                        <div class="col-md-1 col-sm-1 col-xs-1">
                            <div class="form-group">
                                <label>Persons <font color="red">*</font></label>
                                <input type="number" name="total_person" id="total_person" class="form-control input-lg" required="" min="1" value="1"/>

                            </div>
                        </div>
                        <div class="col-md-1 col-sm-1 col-xs-1">
                            <div class="form-group">
                                <label>Days <font color="red">*</font></label>
                                <input type="number" name="total_days" id="total_days" class="form-control input-lg" required="" min="1" onchange="CalRoomAmount();" value="1"/>

                            </div>
                        </div>           
                        <div class="col-md-1 col-sm-1 col-xs-1">
                            <div class="form-group">
                                <label>Total Room <font color="red">*</font></label>
                                <input type="number" name="total_room" id="total_room" class="form-control input-lg" required="" min="1" onchange="CalRoomAmount();" value="1"/>

                            </div>
                        </div>
                        <div class="col-md-6 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Room Number <font color="red">*</font></label>
                                <input type="text" name="room_number" id="room_number" class="form-control input-lg" required=""/>
                                <i style="font-size: 10px;">(Enter comma separated entry of rooms i.e. GF-101, GF-102, 201, 405. <font color="red">Pattern of entering the room must be same for all entry!</font>)</i>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Arrival Date <font color="red">*</font></label>
                                <input type="date" name="arrival_date" id="arrival_date" class="form-control input-lg" required=""/>

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Time <font color="red">*</font></label>
                                <input type="time" name="arrival_time" id="arrival_time" class="form-control input-lg" required=""/>
                               
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Departure Date <font color="red">*</font></label>
                                <input type="date" name="departure_date" id="departure_date" class="form-control input-lg" required=""/>

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Time <font color="red">*</font></label>
                                <input type="time" name="departure_time" id="departure_time" class="form-control input-lg" required=""/>

                            </div>
                        </div>

                        <div class="col-md-4 col-sm-4 col-xs-4">
                            <div class="form-group">
                                <label>Particulars/Purpose Of Visit <font color="red">*</font></label>
                                <input type="text" name="purpose_visit" id="purpose_visit" class="form-control input-lg" required=""/>

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Rate <font color="red">*</font></label>
                                <input type="decimal" name="room_rate" id="room_rate" class="form-control input-lg" required="" pattern="^\d*(\.\d{0,2})?$" value="0" onchange="CalRoomAmount();"/>
 <i style="font-size: 10px;">(Enter per room rate)</i>
                            </div>
                        </div>

                        <div class="col-md-1 col-sm-1 col-xs-1">
                            <div class="form-group">
                                <label>Charges</label>
                                <input type="decimal" name="adl_charges" id="adl_charges" class="form-control input-lg" pattern="^\d*(\.\d{0,2})?$" value="0" onchange="CalRoomAmount();"/>

                            </div>
                        </div>
                        <div class="col-md-1 col-sm-1 col-xs-1">
                            <div class="form-group">
                                <label>Tax (%)<font color="red">*</font></label>
                                <input type="decimal" name="room_tax" id="room_tax" class="form-control input-lg" required="" pattern="^\d*(\.\d{0,2})?$" value="0" onchange="CalRoomAmount();"/>

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label>Final Amount <font color="red">*</font></label>
                                <input type="decimal" name="room_amount" id="room_amount" class="form-control input-lg" required="" pattern="^\d*(\.\d{0,2})?$" value="0" readonly=""/>

                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label><br/></label>
                                <input type="hidden" name="action" id="action" value="room-book"/>
                                <input type="hidden" name="added_by" id="added_by" value="<?php echo $added_by; ?>"/>
                                <input type="submit" name="room_book_add_btn" id="room_book_add_btn" class="btn btn-warning btn-block text-uppercase" value="Book"/>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>
<div class="clearfix"></div><br/><br/>
<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include 'admin-master.php';
?>
<script type="text/javascript">
    $(function () {
        $("#room_book_form_id").validate({
            rules: {
                applicant_name: {
                    required: true,
                    minlength: 3
                },
                mobile_number: {
                    required: true
                },
                room_number: {
                    required: true
                },
                arrival_date: {
                    required: true
                },
                arrival_time: {
                    required: true
                },
                departure_date: {
                    required: true
                },
                departure_time: {
                    required: true
                },
                event_option: {
                    required: true
                },
                total_person: {
                    required: true
                },
                total_days: {
                    required: true
                },
                room_rate: {
                    required: true
                },
                room_tax: {
                    required: true
                },
                id_type: {
                    required: true
                },
                id_number: {
                    required: true
                },
                purpose_visit: {
                    required: true
                }
            },
            messages: {
                applicant_name: {
                    required: "Please Enter Applicant Name",
                    minlength: "Minimum 3 Numbers"
                },
                mobile_number: {
                    required: "Please Enter Mobile Number"
                },
                room_number: {
                    required: "Please Enter Mobile Number"
                },
                arrival_date: {
                    required: "Please Enter Arrival Date"
                },
                arrival_time: {
                    required: "Please Enter Time"
                },
                departure_date: {
                    required: "Please Enter Departure Date"
                },
                departure_time: {
                    required: "Please Enter Time"
                },
                event_option: {
                    required: "Please select the Event"
                },
                total_person: {
                    required: "Please Enter Number of Person"
                },
                total_days: {
                    required: "Please Enter Total Days"
                },
                room_rate: {
                    required: "Please Enter Room Rate"
                },
                room_tax: {
                    required: "Please Enter Room Tax"
                },
                id_type: {
                    required: "Please Enter ID Type"
                },
                id_number: {
                    required: "Please Enter ID Number"
                },
                purpose_visit: {
                    required: "Please Enter Purpose Visit"
                }
            }
        });
        $("#room_book_add_btn").click(function () {
            $("#result_msg").html("");
            if ($("#room_book_form_id").valid()) {

                var formData = new FormData($('#room_book_form_id')[0]);

                $.ajax({
                    type: "POST",
                    url: "server/action-post.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function (data) {
                      
                        
                        if (data.res_status == 1) {
                            $("#result_msg").html("<span style='color: green;'>Booking is done successfully!</span>");
                            $(".form-control").val('');
                            /*location.reload();*/
                        } else {
                            $("#result_msg").html("<span style='color: red;'>" + data.res_msg + "</span>");

                        }
                    }
                });
            }
            return false;
        });
    });

    function CalRoomAmount() {
        var total_days = $("#total_days").val();
        var total_room = $("#total_room").val();
        var room_rate = $("#room_rate").val();
        var adl_charges = $("#adl_charges").val();
        var room_tax = $("#room_tax").val();


        var CalAmount = parseFloat(total_days) * parseFloat(total_room) * parseFloat(room_rate);
        var CalAmountVal = parseFloat(CalAmount) + parseFloat(adl_charges);
        var TotalAmountVal = parseFloat(CalAmountVal) + ((parseFloat(CalAmountVal) * room_tax) / 100);
        $("#room_amount").val(TotalAmountVal.toFixed(2));
    }
    function FunSharingCheck(){
        if($("#sharing_check").is(':checked')){
            $("#guest_second_div").show();
            $("#total_person").val("2");
        }else{
             $("#guest_second_div").hide();
        }
    }
</script>