<?php
class phptextClass {

    // Generate captcha image
    public function phpcaptcha($textColor, $backgroundColor, $imgWidth, $imgHeight, $noiceLines = 0, $noiceDots = 0, $noiceColor = "#000") {
        session_start();

        // Random number (5 digit)
        $text = rand(10000, 99999);
        $_SESSION['captcha_code'] = $text;

        $font = __DIR__ . '/fonts/monofont.ttf'; // font path
        $textColor = $this->hexToRGB($textColor);
        $fontSize = $imgHeight * 0.75;

        // create image
        $im = imagecreatetruecolor($imgWidth, $imgHeight);
        $textColor = imagecolorallocate($im, $textColor['r'], $textColor['g'], $textColor['b']);

        $backgroundColor = $this->hexToRGB($backgroundColor);
        $backgroundColor = imagecolorallocate($im, $backgroundColor['r'], $backgroundColor['g'], $backgroundColor['b']);
        imagefill($im, 0, 0, $backgroundColor);

        // noise lines
        if ($noiceLines > 0) {
            $noiceColor = $this->hexToRGB($noiceColor);
            $noiceColor = imagecolorallocate($im, $noiceColor['r'], $noiceColor['g'], $noiceColor['b']);
            for ($i = 0; $i < $noiceLines; $i++) {
                imageline($im, mt_rand(0, $imgWidth), mt_rand(0, $imgHeight),
                               mt_rand(0, $imgWidth), mt_rand(0, $imgHeight), $noiceColor);
            }
        }

        // noise dots
        if ($noiceDots > 0) {
            for ($i = 0; $i < $noiceDots; $i++) {
                imagefilledellipse($im, mt_rand(0, $imgWidth), mt_rand(0, $imgHeight), 2, 2, $textColor);
            }
        }

        // text position
        list($x, $y) = $this->ImageTTFCenter($im, $text, $font, $fontSize);
        imagettftext($im, $fontSize, 0, $x, $y, $textColor, $font, $text);

        // output
        header('Content-Type: image/jpeg');
        imagejpeg($im);
        imagedestroy($im);
    }

    // hex to RGB
    protected function hexToRGB($hex) {
        $hex = str_replace("#", "", $hex);
        if (strlen($hex) == 3) {
            $r = hexdec(str_repeat(substr($hex,0,1),2));
            $g = hexdec(str_repeat(substr($hex,1,1),2));
            $b = hexdec(str_repeat(substr($hex,2,1),2));
        } else {
            $r = hexdec(substr($hex,0,2));
            $g = hexdec(substr($hex,2,2));
            $b = hexdec(substr($hex,4,2));
        }
        return ["r"=>$r,"g"=>$g,"b"=>$b];
    }

    // center text
    protected function ImageTTFCenter($image, $text, $font, $size, $angle = 0) {
        $xi = imagesx($image);
        $yi = imagesy($image);
        $box = imagettfbbox($size, $angle, $font, $text);
        $xr = abs(max($box[2], $box[4]));
        $yr = abs(max($box[5], $box[7]));
        $x = intval(($xi - $xr) / 2);
        $y = intval(($yi + $yr) / 2);
        return [$x, $y];
    }
}
?>
