<?php
error_reporting(E_ERROR | E_PARSE);
session_set_cookie_params([
    'lifetime' => 0,       // Session expires when browser closes
    'path' => '/',
    'secure' => false,     // Set true if using HTTPS
    'httponly' => true,
    'SameSite' => 'Strict'
]);

session_start();
session_regenerate_id(true);



$resmsg = "";
$error_flag = 0;

if (isset($_POST['login_btnid'])) {

    include_once './classes/class_student.php';
    include_once './classes/validation.php';
    include_once './classes/common.php';

    $val = new validation();
    $objroot = new class_root();

    // Get and sanitize input
    $roll_email = $val->ValidateString(trim($_POST['roll_email'] ?? ''));
    $password   = $val->ValidateString(trim($_POST['password'] ?? ''));
    $verif_box  = $val->ValidateString(trim($_POST['verif_box'] ?? ''));

    // Check empty fields
    if (empty($roll_email)) {
        $error_flag = 1;
        $resmsg = "Please enter roll number/email id";
    } elseif (empty($password)) {
        $error_flag = 1;
        $resmsg = "Please enter password";
    } elseif (empty($verif_box) || $verif_box != ($_SESSION['captcha_code'] ?? '')) {
  $error_flag = 1;
   $resmsg = "Please enter correct captcha code";
    }

    if ($error_flag == 0) {
        // Assign input to class_root properties
        $objroot->roll_email = $roll_email;
        $objroot->password   = $password;

        // Attempt login
        $result_login = $objroot->CommonLogin(); // Returns array of user if found
      

        if (!empty($result_login['user_type'])) {
           
            // Store session variables
            $_SESSION['user_type']      = $result_login['user_type']; // new, easy access
            $_SESSION['user_sestype']   = $result_login['user_type']; // existing
            $_SESSION['user_sesid']     = $result_login['user_pk_id'];
            $_SESSION['user_sesroll']   = $result_login['user_roll'];
            $_SESSION['user_roll']      = $result_login['user_roll'];
            $_SESSION['user_email']     = $result_login['user_email'];
            $_SESSION['user_sespermission'] = $result_login['user_permission'];
            $_SESSION['captcha_code']   = ''; // Clear captcha

            // Regenerate session ID
            session_regenerate_id(true);

            // Redirect based on user type
            if ($result_login['user_type'] == 'BSMS') {
                header("Location: bsstums/student-dashboard.php");
                exit;
            } elseif ($result_login['user_type'] == 'ADMB') {
                header("Location: adinm/admin-dashboard.php");
                exit;
            } else {
                //header("Location: login.php");
                //exit;
            }

        } else {
            $resmsg = "Invalid roll number/email id or password";
        }
    }

   // echo $resmsg;
}
?>
