<?php

class common {

    public static function StrToDB($str) {
        $str = str_replace("'", "&#39;", $str);
        $str = str_replace('"', "&#34;", $str);
        $str = str_replace("\n", "&#nl", $str);
        $str = str_replace("\r", "&#rl", $str);

        return $str;
    }

    public static function StrFromDb($str) {
        $str = str_replace("&#39;", "'", $str);
        $str = str_replace("&#34;", '"', $str);
        $str = str_replace("&#nl", "\n", $str);
        $str = str_replace("&#rl", "\r", $str);

        return $str;
    }

    public static function AcaStatusText($aca_status) {
        $RES = "";
        switch ($aca_status) {
            case "ONRO":
                $RES = "On Roll";
                break;
            case "YRDR":
                $RES = "Year Drop";
                break;
            case "LEFT":
                $RES = "Left/ Withdrawn";
                break;
            case "TRMI":
                $RES = "Terminated";
                break;
            case "GRAD":
                $RES = "Graduated and left";
                break;
            case "LVDE":
                $RES = "Leave until defence";
                break;
            case "DEL":
                $RES = "Remove from system";
                break;
        }

        return $RES;
    }

    public static function clean($string) {
        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
        $string = str_replace('&', '', $string); // Replaces all spaces with hyphens.
        $string = preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.

        return preg_replace('/-+/', '-', $string); // Replaces multiple hyphens with single one.
    }

    public static function encryptString($StrVal) {
        $qryStr = $StrVal;
        $keySalt = "lulmsWWWSri";  // change it
        //$qryStr = "name1=" . $val1 . "&name2=" . $val2;  //making query string
        $query = base64_encode(urlencode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256, md5($keySalt), $qryStr, MCRYPT_MODE_CBC, md5(md5($keySalt)))));    //this line of code encrypt the query string
        return $query;
    }

    public static function decryptString($StrVal) {
        $keySalt = "lulmsWWWSri";  // change it
        $queryString = rtrim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, md5($keySalt), urldecode(base64_decode($StrVal)), MCRYPT_MODE_CBC, md5(md5($keySalt))), "\0");
        return $queryString;
    }

    public static function encryptLink($arrQuery) {
        $qryStr = "";
        $keySalt = "lulmsWWWSri";  // change it
        //$qryStr = "name1=" . $val1 . "&name2=" . $val2;  //making query string
        $i = 0;
        foreach ($arrQuery as $key => $value) {
            $qryStr .= $i > 0 ? "&" : "";
            $qryStr .= $key . "=" . $value;
            $i++;
        }
        $query = base64_encode(urlencode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256, md5($keySalt), $qryStr, MCRYPT_MODE_CBC, md5(md5($keySalt)))));    //this line of code encrypt the query string
        return $query;
    }

    public static function decryptLink($query) {
        $arrQuery = array();
        $keySalt = "lulmsWWWSri";  // change it
        $queryString = rtrim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, md5($keySalt), urldecode(base64_decode($query)), MCRYPT_MODE_CBC, md5(md5($keySalt))), "\0");
        parse_str($queryString, $arrQuery);
        return $arrQuery;
    }

    public static function WordTruncate($input, $numWords) {
        if (str_word_count($input) > $numWords) {
            $WordKey = str_word_count($input, 1);
            $WordIndex = array_flip(str_word_count($input, 2));
            return substr($input, 0, $WordIndex[$WordKey[$numWords]]);
        } else {
            return $input;
        }
    }

    public function eightcode() {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $data .= "0123456789";
        for ($i = 0; $i < 8; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }

    public function fourcode() {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "0123456789";
        for ($i = 0; $i < 4; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }

    public function uniqueid($ct) {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "AbcDE123IJKLMN67QRSTUVWXYZ";
        $data .= "aBCdefghijklmn123opq45rs67tuv89wxyz";
        $data .= "0FGH45OP89";
        for ($i = 0; $i < $ct; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }

    public function GetID($type, $roll) {
        $ID = "";
        switch ($type) {
            case "leave"://1+14
                $ID = "L" . date("YmdHis") . $roll . $this->uniqueid(10 - strlen($roll));
                break;
            case "officer":
                $ID = "OF" . date("YmdHis") . $this->uniqueid(4);
                break;
            case "faculty":
                $ID = "F" . date("YmdHis") . $this->uniqueid(5);
                break;
            case "student":
                //$ID = "S" . date("YmdHis") . $roll; //$this->uniqueid(5);
                $ID = "S" . $roll; //.$this->uniqueid(4);
                $ulen = strlen($ID);
                $ID .= $this->uniqueid(20 - $ulen);
                break;
            case "course":
                $ID = "COU" . date("YmdHis") . $this->uniqueid(3); //$this->uniqueid(5);
                break;
            case "bulk":
                $ID = "C" . date("YmdHis") . $roll; //.$this->uniqueid(4);
                $ulen = strlen($ID);
                $ID .= $this->uniqueid(20 - $ulen);
                break;
            case "C":
                $ID = "C" . $roll; //.$this->uniqueid(4);
                $ulen = strlen($ID);
                $ID .= $this->uniqueid(20 - $ulen);
                break;
            case "F":
                $ID = "F" . $roll; //.$this->uniqueid(4);
                $ulen = strlen($ID);
                $ID .= $this->uniqueid(20 - $ulen);
                break;
        }
        return $ID;
    }

    public static function PasswordCheckCondition($passwordStr) {

        // Validate password strength
        $uppercase = preg_match('@[A-Z]@', $passwordStr);
        $lowercase = preg_match('@[a-z]@', $passwordStr);
        $number = preg_match('@[0-9]@', $passwordStr);
        $specialChars = preg_match('@[^\w]@', $passwordStr);

        if (!$uppercase || !$lowercase || !$number || !$specialChars || strlen($passwordStr) < 8 || strlen($passwordStr) > 12) {
            //echo 'Please use 8-12 characters. Password should not be the same as your name or email. Use at least 1 number, 1 capital letter, and 1 special character.';

            return "2";
        } else {
            //echo 'Strong password.';

            return "1";
        }
    }

    public function uniqueotpcode($ct) {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "1592634879";
        for ($i = 0; $i < $ct; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }
    
       public function UniqueStringOflength($length = 32) {
         $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }
    return $randomString;
    }
    
      public static function GetAmountInWord($number) {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(0 => '', 1 => 'one', 2 => 'two',
            3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
            7 => 'seven', 8 => 'eight', 9 => 'nine',
            10 => 'ten', 11 => 'eleven', 12 => 'twelve',
            13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
            16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
            19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
            40 => 'forty', 50 => 'fifty', 60 => 'sixty',
            70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
        $digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
        while ($i < $digits_length) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else
                $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal) ? " " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return $Rupees . " " . $paise . " Only";
    }

}

?>
