<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

class Captcha {

    // Generate a random number and store in session
    public static function generate($length = 5) {
        $min = pow(10, $length - 1);  // e.g. 10000
        $max = pow(10, $length) - 1;  // e.g. 99999
        $captcha_code = rand($min, $max);
        $_SESSION['captcha_code'] = $captcha_code;
        return $captcha_code;
    }

    // Validate user input
    public static function validate($input) {
        if (!isset($_SESSION['captcha_code'])) {
            return false;
        }
        return trim($input) === strval($_SESSION['captcha_code']);
    }

    // Clear captcha (optional after success)
    public static function clear() {
        unset($_SESSION['captcha_code']);
    }
}
?>
