<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/common.php';
include_once __DIR__ . '/../classes/validation.php';
include_once __DIR__ . '/../classes/class_db.php';
include_once __DIR__ . '/../classes/class_student.php';
$stu_roll = $_SESSION['user_roll'] ?? '';
$courseObj = new class_student();
$semesters = $courseObj->getSemesterCourses($stu_roll);
ob_start();
?>
<div class="tp-dashboard-course-list">
   <section class="tp-fact-wrapper">
      <div class="row">
         <div class="col-lg-12">
            <div class="tp-dashboard-section">
               <h2 class="tp-dashboard-title">Academic Performance</h2>
            </div>
         </div>
      </div>

      <div class="form-container ScrollStyle ">
         <?php foreach ($semesters as $sem => $data): ?>
            <div class="row">
               <div class="col-lg-12">
                  <div class="header-bar" style="background-color: #d9534f; color: white; font-weight: bold; padding: 10px; font-size: 18px; text-align: left;">
                     Semester : <?= htmlspecialchars($sem) ?>
                     <span style="float: right;"><a href="download-transcript.php?sem=<?= $sem ?>">Download</a></span>
                  </div>
               </div>
            </div>

            <form>
               <div class="table-container">
                  <table>
                     <?php foreach ($data['courses'] as $course): ?>
                        <tr>
                           <td style="color: #14ab69"><a href="#"><?= htmlspecialchars($course['sub_code']) ?></a></td>
                           <td><?= htmlspecialchars($course['sub_title']) ?></td>
                           <td><?= htmlspecialchars($course['credit']) ?></td>
                           <td><?= htmlspecialchars($course['grade']) ?></td>
                        </tr>
                     <?php endforeach; ?>
                  </table>
               </div>

               <div class="tpd-course-area">
                  <div class="tpd-table mb-25">
                     <ul>
                        <li style="padding: 7px 0;">
                           <div class="tpd-table-row">
                              <div class="tpd-quiz-info-sub">
                                 <h4 class="tpd-quiz-title" style="font-size: 15px;">Credit Cleared</h4>
                              </div>
                              <div class="tpd-quiz-ques">
                                 <span class="tpd-common-text"><?= $data['total_credit'] ?></span>
                              </div>
                           </div>
                        </li>
                        <li style="padding: 7px 0;">
                           <div class="tpd-table-row">
                              <div class="tpd-quiz-info-sub">
                                 <h4 class="tpd-quiz-title" style="font-size: 15px;">Credit for GPA Calculation</h4>
                              </div>
                              <div class="tpd-quiz-ques">
                                 <span class="tpd-common-text"><?= $data['gpa_credit'] ?></span>
                              </div>
                           </div>
                        </li>
                        <li style="padding: 7px 0;">
                           <div class="tpd-table-row">
                              <div class="tpd-quiz-info-sub">
                                 <h4 class="tpd-quiz-title" style="font-size: 15px;">GPA</h4>
                              </div>
                              <div class="tpd-quiz-ques">
                                 <span class="tpd-common-text"><?= $data['gpa'] ?></span>
                              </div>
                           </div>
                        </li>
                     </ul>
                  </div>
               </div>
            </form>
         <?php endforeach; ?>
      </div>
   </section>
</div>
<?php
$mainpagecontent = ob_get_clean();
$PAGENAME = 'my_courses';
include("./student-masters.php");
?>