<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/class_student.php';
$stu_roll = $_SESSION['user_roll'] ?? '';
$stu_name = $_SESSION['user_name'] ?? '';
$studentObj = new class_student();
$success_msg = '';
$error_msg   = '';
$selected_sup = '';
if (isset($_POST['Submit'])) {
    $supervisor = $_POST['sup'] ?? '';
    $purpose    = trim($_POST['purpose'] ?? '');
    $datefrom   = $_POST['datefrom'] ?? '';
    $dateupto   = $_POST['dateupto'] ?? '';
    $selected_sup = $supervisor;

    if (!$supervisor || !$purpose || !$datefrom || !$dateupto) {
        $error_msg = "Please fill all fields.";
    } elseif (strtotime($dateupto) < strtotime($datefrom)) {
        $error_msg = "End date cannot be earlier than start date.";
    } else {
        $inserted = $studentObj->InsertSummerStay($stu_roll, $datefrom, $dateupto, $purpose, $supervisor);
        if ($inserted) {
            $success_msg = "Request submitted successfully!";
        } else {
            $error_msg = "Failed to submit request!";
        }
    }
}
$supervisors = $studentObj->FetchSupervisors();
ob_start();
?>
<div class="tp-dashboard-course-list">
<section class="tpd-main pb-75">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="tp-dashboard-section">
                    <h2 class="tp-dashboard-title">Request for Permission to Stay in Campus During Summer Break</h2>
                </div>
            </div>
        </div>

        <?php if ($success_msg): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success_msg); ?></div>
        <?php elseif ($error_msg): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error_msg); ?></div>
        <?php endif; ?>

        <div class="form-container">
            <form method="post" action="">
                <div class="row">

                    <div class="col-lg-12">
                        <label>Roll Number</label>
                        <input type="text" value="<?php echo htmlspecialchars($stu_roll); ?>" disabled>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-lg-12">
                        <label>Supervisor</label>
                        <select name="sup" class="form-control scrollable-select" size="10" required>
                            <option value="" selected>- - - - Select Supervisor - - - -</option>
                            <?php foreach ($supervisors as $sup): ?>
                                <option value="<?php echo $sup['roll']; ?>"
                                    <?php echo ($selected_sup == $sup['roll']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($sup['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>

                    </div>
                </div>
                

                <div class="row mt-3">
                    <div class="col-lg-12">
                        <label>Purpose</label>
                        <input type="text" name="purpose"
                            value="<?php echo htmlspecialchars($_POST['purpose'] ?? 'Summer Project'); ?>"
                            maxlength="250" required>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-lg-6">
                        <label>Date from</label>
                        <input type="date" name="datefrom"
                            value="<?php echo htmlspecialchars($_POST['datefrom'] ?? ''); ?>" required>
                        <small>May 1, 2025 onwards</small>
                    </div>
                    <div class="col-lg-6">
                        <label>Date up to</label>
                        <input type="date" name="dateupto"
                            value="<?php echo htmlspecialchars($_POST['dateupto'] ?? ''); ?>" required>
                        <small>Up to July 31, 2025</small>
                    </div>
                </div>

                <div class="btn-group mt-4">
                    <button type="submit" name="Submit" class="btn btn-success"
                        style="border-radius: 5px;background: #cb4f4e;color:#fff;">
                        Submit
                    </button>
                </div>
            </form>
        </div>
    </div>
</section>
</div>
<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'summer_stay';
include("./student-masters.php");
?>