<?php
// ======================= COMMON INCLUDES =======================
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/common.php';
include_once __DIR__ . '/../classes/validation.php';
include_once __DIR__ . '/../classes/class_db.php';
include_once __DIR__ . '/../classes/class_root.php';
include_once __DIR__ . '/../classes/class_student.php';

// ======================= INIT OBJECTS =========================
$rootObj    = new class_root();
$studentObj = new class_student();
$stu_roll   = $_SESSION['user_roll'] ?? '';

// ======================= FETCH STUDENT DATA ===================
$student_data  = $rootObj->GetStudentData();
$student_name  = $student_data['stu_name'] ?? ($student_data['name'] ?? 'Unknown');
$stu_roll      = $student_data['stu_roll'] ?? $stu_roll;

// ======================= CHECK REGISTRATION ELIGIBILITY ======
try {
    $studentObj->CheckRegistration(); 
    $registration_allowed = true;
} catch (Exception $e) {
    $registration_allowed = false;
    $errorMessage = $e->getMessage();
}

// ======================= CURRENT SEMESTER ====================
$current_sem = $studentObj->GetCurrentSemester($stu_roll);

// ======================= HANDLE ADD / DROP (PRG pattern) =====
if ($registration_allowed && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = trim($_POST['action'] ?? '');
    $code   = trim($_POST['code'] ?? '');

    if ($action === 'add' && !empty($code)) {
        $studentObj->AddCourse($stu_roll, $code, $current_sem);
        $_SESSION['message'] = "Course added successfully.";
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    }

    if ($action === 'drop' && !empty($code)) {
        $studentObj->MoveToDroppedCourses($stu_roll, $code);
        $_SESSION['message'] = "Course dropped successfully.";
        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    }
}

// ======================= FETCH COURSES =======================
$active_courses    = $studentObj->GetStudentCourses($stu_roll, $current_sem, "active") ?? [];
$dropped_courses   = $studentObj->GetStudentCourses($stu_roll, $current_sem, "dropped") ?? [];
$available_courses = $studentObj->GetAvailableCourses($stu_roll, $current_sem) ?? [];

// ======================= CALCULATE TOTAL CREDITS ============
$total_credits = 0;
foreach ($active_courses as $c) {
    $total_credits += intval($c['sub_crdit'] ?? 0);
}

// ======================= PAGE CONTENT =======================
ob_start();
?>

<div class="container" style="max-width:900px;margin:auto;padding:20px;">
    <h1>Student Course Registration</h1>

    <?php if (!$registration_allowed): ?>
        <p style="color:red;font-weight:bold;">
            <?= htmlspecialchars($errorMessage ?? "Registration not allowed at this time.") ?>
        </p>
    <?php else: ?>
        <?php if (!empty($_SESSION['message'])): ?>
            <div style="color:green;font-weight:bold;"><?= htmlspecialchars($_SESSION['message']); unset($_SESSION['message']); ?></div>
        <?php endif; ?>

        <!-- Student Info -->
        <div style="margin-top:15px;">
            <strong>Name:</strong> <?= htmlspecialchars($student_name) ?> |
            <strong>Roll No:</strong> <?= htmlspecialchars($stu_roll) ?> |
            <strong>Semester:</strong> <?= htmlspecialchars($current_sem) ?>
        </div>

        <!-- Registration Status -->
        <div style="margin-top:10px; font-weight:bold; color:<?= $total_credits >= 18 ? 'green' : 'orange' ?>">
            <?= $total_credits >= 18 ? "Registration Complete" : "Registration Pending" ?> 
            (Total Credits: <?= $total_credits ?>)
        </div>

        <!-- Active Courses -->
        <h3 style="margin-top:20px;">Active Courses</h3>
        <?php if (!empty($active_courses)): ?>
            <table border="1" cellpadding="5" cellspacing="0" width="100%">
                <thead>
                    <tr style="background:#f0f0f0;">
                        <th>Code</th>
                        <th>Title</th>
                        <th>Credits</th>
                        <th>Drop</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($active_courses as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['sub_code'] ?? '') ?></td>
                            <td><?= htmlspecialchars($row['sub_title'] ?? '') ?></td>
                            <td><?= htmlspecialchars($row['sub_crdit'] ?? '0') ?></td>
                            <td>
                                <form method="post" style="display:inline;">
                                    <input type="hidden" name="action" value="drop">
                                    <input type="hidden" name="code" value="<?= htmlspecialchars($row['unique_code'] ?? $row['sub_code']) ?>">
                                    <button type="submit" onclick="return confirm('Drop <?= addslashes(htmlspecialchars($row['sub_code'])) ?>?')">Drop</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p style="color:red;">No active courses.</p>
        <?php endif; ?>

        <!-- Available Courses to Add -->
        <h3 style="margin-top:20px;">Available Courses</h3>
        <?php if (!empty($available_courses)): ?>
            <form method="post">
                <select name="code" required style="width:100%; max-height:200px; overflow-y:auto;">
                    <option value="" selected>-- Select a course --</option>
                    <?php foreach ($available_courses as $row): ?>
                        <option value="<?= htmlspecialchars($row['unique_code']) ?>">
                            <?= htmlspecialchars($row['sub_code'] . " - " . $row['sub_title'] . " (" . $row['sub_crdit'] . " cr)") ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <input type="hidden" name="action" value="add">
                <button type="submit" style="margin-top:5px;">Add Course</button>
            </form>
        <?php else: ?>
            <p style="color:red;">No available courses to add.</p>
        <?php endif; ?>

        <!-- Dropped Courses -->
        <?php if (!empty($dropped_courses)): ?>
            <h3 style="margin-top:20px; color:#800000;">Dropped Courses</h3>
            <table border="1" cellpadding="5" cellspacing="0" width="100%">
                <thead>
                    <tr style="background:#f0f0f0;">
                        <th>Code</th>
                        <th>Title</th>
                        <th>Credits</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($dropped_courses as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['sub_code'] ?? '') ?></td>
                            <td><?= htmlspecialchars($row['sub_title'] ?? '') ?></td>
                            <td><?= htmlspecialchars($row['sub_crdit'] ?? '0') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    <?php endif; ?>
</div>

<?php
$mainpagecontent = ob_get_clean();
$PAGENAME = 'student_registration';
include("./student-masters.php");
?>
