<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/class_student.php';
$stu_roll = $_SESSION['user_roll'] ?? '';
$stu_name = $_SESSION['user_name'] ?? '';
if (!$stu_roll) {
    die("Student roll not found. Please login again.");
}
$studentObj = new class_student();
$success_msg = '';
$error_msg   = '';
$swap_students_raw   = $studentObj->getSwapStudents($stu_roll);   // Fetch all other students
$available_rooms_raw = $studentObj->getAvailableRooms();          // Fetch all rooms
$seen_rolls = [];
$swap_students = [];
foreach ($swap_students_raw as $stu) {
    if (!in_array($stu['roll'], $seen_rolls)) {
        $seen_rolls[] = $stu['roll'];
        $swap_students[] = $stu;
    }
}

$available_rooms = array_unique($available_rooms_raw);
sort($available_rooms);

if (isset($_POST['Submit'])) {
    $swap_roll = trim($_POST['swap_roll'] ?? '');
    $swap_room = trim($_POST['swap_room'] ?? '');
    $swap_seat = trim($_POST['swap_seat'] ?? '');
    $reason    = trim($_POST['reason'] ?? '');
    $reason    = str_replace(["'", '"', ";", "<", ">"], "*", $reason);

    if (!$swap_roll || !$swap_room || !$swap_seat || !$reason) {
        $error_msg = "Please fill all fields.";
    } else {
        $currentRoom = $studentObj->getCurrentRoom($stu_roll);
        if (!empty($currentRoom)) {
            $inserted = $studentObj->insertRoomSwapRequest(
                $stu_roll,
                $currentRoom['hostel'],
                $currentRoom['room'],
                $currentRoom['seat'],
                $swap_roll,
                $swap_room,
                $swap_seat,
                $reason
            );
            if ($inserted) {
                $success_msg = "Room swap request submitted successfully!";
            } else {
                $error_msg = "Failed to submit swap request!";
            }
        } else {
            $error_msg = "No current room found!";
        }
    }
}

$currentRoom = $studentObj->getCurrentRoom($stu_roll);
$roommate_name = '';
if (!empty($currentRoom)) {
    $roommate_roll = $studentObj->getRoomMate($currentRoom['hostel'], $currentRoom['room'], $currentRoom['seat']);
    $roommate_name = $roommate_roll ? $studentObj->getStudentName($roommate_roll) : 'No roommate';
}

$requests = $studentObj->getRoomSwapRequests($stu_roll);

ob_start();
?>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<div class="tp-dashboard-course-list">
    <section class="tp-fact-wrapper">
        <h2 class="tp-dashboard-title">Request for Room Swap</h2>

        <?php if ($success_msg): ?>
            <div class="alert alert-success"><?= htmlspecialchars($success_msg) ?></div>
        <?php elseif ($error_msg): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error_msg) ?></div>
        <?php endif; ?>

        <?php if ($currentRoom): ?>
            <table class="table table-condensed " style="    height: 100px;">
                <tr>
                    <td>Hostel</td>
                    <td><?= htmlspecialchars($currentRoom['hostel']) ?></td>
                </tr>
                <tr>
                    <td>Current Room</td>
                    <td><?= htmlspecialchars($currentRoom['room']) ?> (Seat <?= htmlspecialchars($currentRoom['seat']) ?>)</td>
                </tr>
                <tr>
                    <td>Roommate</td>
                    <td><?= htmlspecialchars($roommate_name) ?> (Seat <?= ($currentRoom['seat'] == 'C' ? 'D' : 'C') ?>)</td>
                </tr>
            </table>

            <form method="post" class="form-horizontal">
                <table class="table table-condensed ">
                    <tr>
                        <td>Swap With Roll</td>
                        <td>
                            <select name="swap_roll" id="swap_roll" class="form-control select2" required>
                                <option value="">--Select Roll--</option>
                                <?php foreach ($swap_students as $stu): ?>
                                    <option value="<?= htmlspecialchars($stu['roll']) ?>">
                                        <?= htmlspecialchars($stu['roll'] . ' - ' . $stu['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>

                        </td>
                    </tr>
                    <tr>
                        <td>Swap Room</td>
                        <td>
                            <select name="swap_room" id="swap_room" class="form-control select2" required>
                                <option value="">--Select Room--</option>
                                <?php foreach ($available_rooms as $room): ?>
                                    <option value="<?= htmlspecialchars($room) ?>"><?= htmlspecialchars($room) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Swap Seat</td>
                        <td>
                            <select name="swap_seat" required>
                                <option value="">--Select--</option>
                                <option value="C">C</option>
                                <option value="D">D</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td>Reason</td>
                        <td>
                            <input type="text" name="reason" size="60" maxlength="250" required>
                            <br><span style="color:blue;">(within 10 words)</span>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="center">
                            <input type="submit" class="btn btn-primary" name="Submit" style="background: #cb4f4e;" value="Confirm and Submit">
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="center">
                            <span style="color:red;">Alert: Please ensure both students agree to this swap.</span>
                        </td>
                    </tr>
                </table>
            </form>

           

        <?php endif; ?>

        <?php if (!empty($requests)): ?>
         <h2 class="tp-dashboard-title">Room Swap Request Status</h2>

         
            <table class="">
                <tr>
                    <th>#</th>
                    <th>Swap With Roll</th>
                    <th>Swap Room</th>
                    <th>Swap Seat</th>
                    <th>Reason</th>
                    <th>Date</th>
                    <th>Status</th>
                </tr>
                <?php $i = 1;
                foreach ($requests as $req): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($req['swap_roll']) ?></td>
                        <td><?= htmlspecialchars($req['swap_room']) ?></td>
                        <td><?= htmlspecialchars($req['swap_seat']) ?></td>
                        <td><?= htmlspecialchars($req['reason']) ?></td>
                        <td><?= date("d M Y", strtotime($req['date_req'])) ?></td>
                        <td><?= htmlspecialchars($req['req_status']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
            <p><b>R</b>: Requested | <b>A</b>: Approved | <b>N</b>: Not approved</p>
        <?php endif; ?>

    </section>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'room_swap_request';
include("./student-masters.php");
?>