<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/common.php';
include_once __DIR__ . '/../classes/validation.php';
include_once __DIR__ . '/../classes/class_db.php';
include_once __DIR__ . '/../classes/class_student.php';
$studentObj = new class_student();
$stu_roll   = $_SESSION['user_roll'] ?? '';
if (empty($stu_roll)) {
    die("Student roll not found. Please login again.");
}
$student_data = $studentObj->GetStudentData($stu_roll);
$student_name = $student_data['stu_name'] ?? ($student_data['name'] ?? 'Unknown');
$stu_roll     = $student_data['stu_roll'] ?? $stu_roll;
$current_sem = $studentObj->GetCurrentSemester($stu_roll); 
$next_sem    = $current_sem + 1;
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = trim($_POST['action'] ?? '');
    $course_code = trim($_POST['add_code'] ?? $_POST['drop_code'] ?? '');

    if ($action === 'add' && $course_code) {
        $result = $studentObj->AddCourse($stu_roll, $course_code, $next_sem);
        $msg = $result 
            ? "<div class='alert alert-success'> Course added successfully.</div>"
            : "<div class='alert alert-warning'> Course cannot be added or already registered.</div>";
    }

    if ($action === 'drop' && $course_code) {
        $result = $studentObj->MoveToDroppedCourses($stu_roll, $course_code);
        $msg = $result 
            ? "<div class='alert alert-success'> Course dropped successfully.</div>"
            : "<div class='alert alert-danger'> Unable to drop course.</div>";
    }
}
$reg_courses       = $studentObj->GetStudentCourses($stu_roll, $next_sem, 'active');
$available_courses = $studentObj->GetAvailableCourses($stu_roll, $next_sem);
$total_credit = 0;
$slot_list = [];

foreach ($reg_courses as $row) {
    $total_credit += $row['sub_crdit'];
    $slot_list[] = $row['slot'] ?? '';
}

$slot_count = array_count_values($slot_list);

$error = 0;
$error_message = '';
foreach ($slot_count as $slot => $count) {
    if ($count > 1) {
        $error = 1;
        $error_message .= "$count Courses in Group $slot<br>";
    }
}

// Minimum & maximum credit rules
$min_credit = 20;
$max_credit = 24;
if ($total_credit > $max_credit) $error_message .= "Total Credits > $max_credit. Drop some courses.<br>";
if ($total_credit < $min_credit) $error_message .= "Total Credits < $min_credit. Add more courses.<br>";
if ($total_credit > $max_credit || $total_credit < $min_credit || !empty($slot_count)) $error = 1;

// ======================= PAGE CONTENT =========================
ob_start();
?>

<div class="tp-dashboard-course-list" style="height:500px;">
    <section class="tp-fact-wrapper">
        <div class="tp-dashboard-section">
            <h2 class="tp-dashboard-title">Course Registration</h2>
            <p>Registering for Semester: <?= $next_sem ?></p>
        </div>

        <?php if (!empty($msg)) echo "<div style='margin:10px 0;'>$msg</div>"; ?>
        <?php if ($error) echo "<div style='color:red;margin:10px 0;'>$error_message</div>"; ?>

        <!-- REGISTERED COURSES -->
        <?php if ($reg_courses): ?>
            <h4>Registered Courses</h4>
            <table class='table table-striped table-bordered'>
                <tr><th>Sr.</th><th>Course No</th><th>Title</th><th>Credits</th><th>Group</th><th>Action</th></tr>
                <?php foreach ($reg_courses as $i => $row): ?>
                    <tr>
                        <td><?= $i + 1 ?></td>
                        <td><?= htmlspecialchars($row['sub_code']) ?></td>
                        <td><?= htmlspecialchars($row['sub_title']) ?></td>
                        <td><?= $row['sub_crdit'] ?></td>
                        <td><?= htmlspecialchars($row['slot'] ?? '') ?></td>
                        <td>
                            <?php if (empty($row['grade'])): ?>
                                <form method="post">
                                    <input type="hidden" name="action" value="drop">
                                    <input type="hidden" name="drop_code" value="<?= htmlspecialchars($row['unique_code']) ?>">
                                    <button type="submit" class="btn btn-danger btn-xs" onclick="return confirm('Drop <?= $row['sub_code'] ?>?')">Drop</button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <tr><td colspan="3">Total Credits</td><td colspan="3"><?= $total_credit ?></td></tr>
            </table>
        <?php endif; ?>

        <!-- ADD COURSE -->
        <?php if ($available_courses): ?>
            <h4>Add Course</h4>
            <form method="post">
                <div class="row mb-3">
                    <div class="col-lg-8">
                        <select name="add_code" required class="form-select js-course-select">
                            <option value="">-- Select Course --</option>
                            <?php foreach ($available_courses as $row): ?>
                                <option value="<?= htmlspecialchars($row['unique_code']) ?>">
                                    <?= htmlspecialchars($row['sub_code'] . " - " . $row['sub_title'] . " (" . $row['sub_crdit'] . " cr)") ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-lg-4">
                        <input type="hidden" name="action" value="add">
                        <button type="submit" class="btn btn-primary">Add</button>
                    </div>
                </div>
            </form>
        <?php else: ?>
            <div style="color:red;">No courses available for registration.</div>
        <?php endif; ?>
    </section>
</div>

<!-- SELECT2 JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.js-course-select').select2({
            placeholder: "-- Select Course --",
            allowClear: true,
            width: '100%'
        });
    });
</script>

<?php
$mainpagecontent = ob_get_clean();
$PAGENAME = 'student_registration';
include("./student-masters.php");
?>
