<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/class_student.php';
include_once __DIR__ . '/../classes/validation.php';
$rootObj = new class_root();
$msg = '';
$show_msg = false; 
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['section'])) {
   $section = $_POST['section'];
   $updated = false;
   if ($section === 'personal') {
      $updated = $rootObj->UpdateMyProfile($_POST);
   } elseif ($section === 'school') {
      $updated = $rootObj->UpdateSchoolSection($_POST);
   } elseif ($section === 'home') {
      $updated = $rootObj->UpdateHomeSection($_POST);
   } elseif ($section === 'bank') {
      $updated = $rootObj->UpdateBankSection($_POST);
   }
   // Store message in session
   $_SESSION['profile_msg'] = $updated ? " Section updated successfully!" : " Failed to update section!";
   // Refresh student data
   $student = $rootObj->GetStudentData();
   // Redirect to same page to avoid message on refresh
   header("Location: " . $_SERVER['PHP_SELF']);
   exit;
}
// After redirect, show message if exists
if (isset($_SESSION['profile_msg'])) {
   $msg = $_SESSION['profile_msg'];
   $show_msg = true;
   unset($_SESSION['profile_msg']);
}

$student = $rootObj->GetStudentData();
ob_start();
?>
<div class="tp-dashboard-course-list">
   <section class="tp-fact-wrapper">
      <div class="row">
         <div class="col-lg-12">
            <div class="tp-dashboard-section">
               <h2 class="tp-dashboard-title">My Profile</h2>
            </div>
         </div>

      </div>
      <!-- dashboard-content-area-start -->
      <div class="tab-content" id="myTabContent">
         <div class="tab-pane fade show active" id="home" role="tabpanel"
            aria-labelledby="home-tab">

            <div class="tp-course-grid-box p-relative tp-tab">
               <div class="row">
                  <div class="col-lg-12">
                     <ul class="nav nav-tabs" id="filtertab-1" role="tablist">
                        <li class="nav-item" role="presentation">
                           <button class="nav-link active" id="finance-tab" data-bs-toggle="tab"
                              data-bs-target="#finance" type="button" role="tab"
                              aria-controls="finance" aria-selected="true">
                              Basic Information
                           </button>
                        </li>
                        <li class="nav-item" role="presentation">
                           <button class="nav-link" id="art-tab" data-bs-toggle="tab"
                              data-bs-target="#art" type="button" role="tab" aria-controls="art"
                              aria-selected="false" tabindex="-1">
                              Last School / College
                           </button>
                        </li>
                        <li class="nav-item" role="presentation">
                           <button class="nav-link" id="business-tab" data-bs-toggle="tab"
                              data-bs-target="#business" type="button" role="tab"
                              aria-controls="business" aria-selected="false" tabindex="-1">
                              Home Address
                           </button>
                        </li>
                        <li class="nav-item" role="presentation">
                           <button class="nav-link" id="data-tab" data-bs-toggle="tab"
                              data-bs-target="#data" type="button" role="tab" aria-controls="data"
                              aria-selected="false" tabindex="-1">
                              Saving Bank
                           </button>
                        </li>

                     </ul>
                  </div>

               </div>

            </div>
            <?php if ($show_msg): ?>
               <div class="msg" style="color: green;"><?php echo $msg; ?></div>
            <?php endif; ?>
            <div class="tab-content" id="TabContent">
               <div class="tab-pane fade" id="art" role="tabpanel" aria-labelledby="art-tab">
                  <div class="row">
                     <div class="form-container">
                        <!-- School Section -->
                        <form method="post" action="">
                           <input type="hidden" name="section" value="school">
                           <div class="row">
                              <div class="col-lg-6">
                                 <label>Last School Name</label>
                                 <input type="text" name="last_schoolname" value="<?php echo htmlspecialchars($student['last_schoolname'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-6">
                                 <label>City/Town</label>
                                 <input type="text" name="school_city" value="<?php echo htmlspecialchars($student['school_city'] ?? ''); ?>">
                              </div>
                           </div>

                           <div class="row">
                              <div class="col-lg-6">
                                 <label>Pincode</label>
                                 <input type="number" name="school_pincode" value="<?php echo htmlspecialchars($student['school_pincode'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-6">
                                 <label>State</label>
                                 <input type="text" name="school_state" value="<?php echo htmlspecialchars($student['school_state'] ?? ''); ?>">
                              </div>
                           </div>

                           <div class="row">
                              <div class="col-lg-6">
                                 <label>Board</label>
                                 <input type="text" name="school_board" value="<?php echo htmlspecialchars($student['school_board'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-6">
                                 <label>Percentage in 12th Std</label>
                                 <input type="text" name="percentagein_twelve" value="<?php echo htmlspecialchars($student['percentagein_twelve'] ?? ''); ?>">
                              </div>
                           </div>

                           <div class="btn-group">
                              <button type="submit" class="btn" style="border-radius: 5px; background: #d9534f;">Update School</button>
                           </div>
                        </form>

                     </div>

                  </div>

               </div>
               <div class="tab-pane fade" id="business" role="tabpanel"
                  aria-labelledby="business-tab">
                  <div class="row">
                     <div class="form-container">
                        <!-- Home Section -->
                        <form method="post">
                           <input type="hidden" name="section" value="home">

                           <div class="row">
                              <div class="col-lg-4">
                                 <label>House No. & Society</label>
                                 <input type="text" name="house_number" value="<?php echo htmlspecialchars($student['house_number'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Landmark</label>
                                 <input type="text" name="home_landmark" value="<?php echo htmlspecialchars($student['home_landmark'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Area</label>
                                 <input type="text" name="home_area" value="<?php echo htmlspecialchars($student['home_area'] ?? ''); ?>">
                              </div>
                           </div>

                           <div class="row">
                              <div class="col-lg-4">
                                 <label>City</label>
                                 <input type="text" name="home_city" value="<?php echo htmlspecialchars($student['home_city'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Pincode</label>
                                 <input type="number" name="home_pincode" value="<?php echo htmlspecialchars($student['home_pincode'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>State</label>
                                 <input type="text" name="home_state" value="<?php echo htmlspecialchars($student['home_state'] ?? 'India'); ?>">
                              </div>
                             
                           </div>

                           <!-- Father Details -->
                           <div class="row">
                                <div class="col-lg-4">
                                 <label>Country</label>
                                 <input type="text" name="home_country" value="<?php echo htmlspecialchars($student['home_country'] ?? 'India'); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Father's Name</label>
                                 <input type="text" name="father_name" value="<?php echo htmlspecialchars($student['father_name'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Occupation Classification</label>
                                 <input type="text" name="father_occupation" value="<?php echo htmlspecialchars($student['father_occupation'] ?? ''); ?>">
                              </div>
                             
                           </div>

                           <div class="row">
                                <div class="col-lg-4">
                                 <label>Company Name</label>
                                 <input type="text" name="father_companyname" value="<?php echo htmlspecialchars($student['father_companyname'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Father's Designation</label>
                                 <input type="text" name="father_designation" value="<?php echo htmlspecialchars($student['father_designation'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Father's Contact Number</label>
                                 <input type="number" name="father_contactnumber" value="<?php echo htmlspecialchars($student['father_contactnumber'] ?? ''); ?>">
                              </div>
                              
                           </div>

                           <!-- Mother Details -->
                           <div class="row">
                               <div class="col-lg-4">
                                 <label>Father's Email Id</label>
                                 <input type="email" name="father_emailid" value="<?php echo htmlspecialchars($student['father_emailid'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Mother's Name</label>
                                 <input type="text" name="mother_name" value="<?php echo htmlspecialchars($student['mother_name'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Occupation Classification</label>
                                 <input type="text" name="mother_occupation" value="<?php echo htmlspecialchars($student['mother_occupation'] ?? ''); ?>">
                              </div>
                              
                           </div>

                           <div class="row">
                               <div class="col-lg-4">
                                 <label>Company Name</label>
                                 <input type="text" name="mother_companyname" value="<?php echo htmlspecialchars($student['mother_companyname'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Mother's Designation</label>
                                 <input type="text" name="mother_designation" value="<?php echo htmlspecialchars($student['mother_designation'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Mother's Contact Number</label>
                                 <input type="number" name="mother_contactnumber" value="<?php echo htmlspecialchars($student['mother_contactnumber'] ?? ''); ?>">
                              </div>
                             
                           </div>

                           <div class="row">
                                <div class="col-lg-4">
                                 <label>Mother's Email Id</label>
                                 <input type="email" name="mother_emailid" value="<?php echo htmlspecialchars($student['mother_emailid'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Total Annual Family Income in Lakhs</label>
                                 <input type="text" name="annual_familyincome" value="<?php echo htmlspecialchars($student['annual_familyincome'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-4">
                                 <label>Emergency Contact Number</label>
                                 <input type="number" name="emergency_phonenumber" value="<?php echo htmlspecialchars($student['emergency_phonenumber'] ?? ''); ?>">
                              </div>
                           </div>

                           <div class="btn-group">
                              <button type="submit" class="btn" style="border-radius: 5px;background: #d9534f;">Update Home</button>
                           </div>
                        </form>

                     </div>



                  </div>
               </div>
               <div class="tab-pane fade" id="data" role="tabpanel" aria-labelledby="data-tab">
                  <div class="row">
                     <div class="form-container">
                        <!-- Bank Section -->
                        <form method="post">
                           <input type="hidden" name="section" value="bank">

                           <div class="row">
                              <div class="col-lg-6">
                                 <label>Name of the Bank</label>
                                 <input type="text" name="bank_name" value="<?php echo htmlspecialchars($student['bank_name'] ?? ''); ?>">
                              </div>
                              <div class="col-lg-6">
                                 <label>IFSC</label>
                                 <input type="text" name="bank_ifsc" value="<?php echo htmlspecialchars($student['bank_ifsc'] ?? ''); ?>">
                              </div>
                           </div>

                           <div class="row">
                              <div class="col-lg-6">
                                 <label>Account Number</label>
                                 <input type="text" name="bank_accountnumber" value="<?php echo htmlspecialchars($student['bank_accountnumber'] ?? ''); ?>">
                              </div>
                           </div>

                           <div class="btn-group">
                              <button type="submit" class="btn" style="border-radius: 5px; background: #d9534f;">Update Bank</button>
                           </div>
                        </form>


                     </div>

                  </div>
               </div>
               <div class="tab-pane fade active show" id="finance" role="tabpanel"
                  aria-labelledby="finance-tab">
                  <div class="row">
                     <div class="form-container">
                        <!-- Personal Section -->
                        <form method="post">
                           <div class="form-section">
                              <h2>Personal Details</h2>
                              <input type="hidden" name="section" value="personal">

                              <div class="row">
                                 <div class="col-lg-6">
                                    <label>Name</label>
                                    <input type="text" name="stu_name" value="<?php echo htmlspecialchars($student['stu_name'] ?? ''); ?>" required>
                                 </div>
                                 <div class="col-lg-6">
                                    <label>Hindi Name</label>
                                    <input type="text" name="stu_hindiname" value="">
                                 </div>
                              </div>

                              <div class="row">
                                 <div class="col-lg-6">
                                    <label>Gender</label>
                                    <div class="radio-group">
                                       <label><input type="radio" name="stu_gender" value="Male"
                                             <?php echo (($student['stu_gender'] ?? '') === 'Male') ? 'checked' : ''; ?> required> Male</label>
                                       <label><input type="radio" name="stu_gender" value="Female"
                                             <?php echo (($student['stu_gender'] ?? '') === 'Female') ? 'checked' : ''; ?> required> Female</label>
                                    </div>
                                 </div>

                                 <div class="col-lg-6">
                                    <label>Nationality</label>
                                    <div class="radio-group">
                                       <label><input type="radio" name="nationality" value="Indian"
                                             <?php echo (($student['nationality'] ?? '') === 'Indian') ? 'checked' : ''; ?>> Indian</label>
                                       <label><input type="radio" name="nationality" value="OCI"
                                             <?php echo (($student['nationality'] ?? '') === 'OCI') ? 'checked' : ''; ?>> OCI Card Holder</label>
                                       <label><input type="radio" name="nationality" value="PIO"
                                             <?php echo (($student['nationality'] ?? '') === 'PIO') ? 'checked' : ''; ?>> PIO Card Holder</label>
                                    </div>
                                 </div>
                              </div>

                              <div class="row">
                                 <div class="col-lg-6">
                                    <label>Personal Contact Number</label>
                                    <input type="number" name="personal_contactnumber" value="<?php echo htmlspecialchars($student['personal_contactnumber'] ?? ''); ?>" >
                                 </div>
                                 <div class="col-lg-6">
                                    <label>Email</label>
                                    <input type="email" name="email" value="<?php echo htmlspecialchars($_SESSION['user_email'] ?? ''); ?>">
                                 </div>
                              </div>

                              <div class="row">
                                 <div class="col-lg-6">
                                    <label>Date of Birth (As per 12th Std Marksheet)</label>
                                    <input type="date" name="date_birth" value="<?php echo htmlspecialchars($student['date_birth'] ?? ''); ?>">
                                 </div>
                                 <div class="col-lg-6">
                                    <label>Blood Group</label>
                                    <input type="text" name="blood_group" value="<?php echo htmlspecialchars($student['blood_group'] ?? ''); ?>">
                                 </div>
                              </div>

                              <div class="row">
                                 <div class="col-lg-6">
                                    <label>Aadhaar Card Number</label>
                                    <input type="number" name="aadhaar_card" value="<?php echo htmlspecialchars($student['aadhaar_card'] ?? ''); ?>">
                                 </div>
                                 <div class="col-lg-6">
                                    <label>JAC Registration Number</label>
                                    <input type="text" name="jac_registration_number" value="<?php echo htmlspecialchars($student['jac_registration_number'] ?? ''); ?>">
                                 </div>
                              </div>

                              <div class="row">
                                 <div class="col-lg-4">
                                    <label>Channel of Admission</label>
                                    <div class="radio-group">
                                       <label><input type="radio" name="channel_admission" value="KVPY"
                                             <?php echo (($student['channel_admission'] ?? '') === 'KVPY') ? 'checked' : ''; ?>> KVPY</label>
                                       <label><input type="radio" name="channel_admission" value="JEE"
                                             <?php echo (($student['channel_admission'] ?? '') === 'JEE') ? 'checked' : ''; ?>> JEE</label>
                                       <label><input type="radio" name="channel_admission" value="SCB"
                                             <?php echo (($student['channel_admission'] ?? '') === 'SCB') ? 'checked' : ''; ?>> SCB</label>
                                    </div>
                                 </div>

                                 <div class="col-lg-4">
                                    <label>Category</label>
                                    <div class="radio-group">
                                       <?php
                                       $categories = ['GEN', 'OBC', 'SC', 'ST', 'PD', 'KM'];
                                       foreach ($categories as $cat) {
                                          $checked = (($student['category'] ?? '') === $cat) ? 'checked' : '';
                                          echo "<label><input type='radio' name='category' value='$cat' $checked> $cat</label>";
                                       }
                                       ?>
                                    </div>
                                 </div>

                                 <div class="col-lg-4">
                                    <label>Religion</label>
                                    <select name="religion">
                                       <?php
                                       $religions = ['Hindu', 'Muslim', 'Christian', 'Sikh', 'Other'];
                                       foreach ($religions as $rel) {
                                          $selected = (($student['religion'] ?? '') === $rel) ? 'selected' : '';
                                          echo "<option value='$rel' $selected>$rel</option>";
                                       }
                                       ?>
                                    </select>
                                 </div>
                              </div>
                              <div class="btn-group">
                                 <button type="submit" class="btn" style="border-radius: 5px;background: #d9534f;">Save</button>
                              </div>
                           </div>
                        </form>


                     </div>
                  </div>

               </div>
               <div class="tab-pane fade" id="style" role="tabpanel" aria-labelledby="style-tab">
                  <div class="row">
                     <div class="col-lg-4 col-md-6">
                        <div class="tp-course-item p-relative fix mb-30">
                           <div class="tp-course-teacher mb-15">
                              <span><img src="assets/img/teacher/teacher-3.png" alt="">Gustav
                                 Purpleson</span>
                           </div>
                           <div class="tp-course-thumb">
                              <a href="course-details-2.html"><img class="course-sky"
                                    src="assets/img/course/course-list/course-thumb-3.jpg"
                                    alt=""></a>
                           </div>
                           <div class="tp-course-content">
                              <div class="tp-course-tag mb-10">
                                 <span>Art &amp; Design</span>
                              </div>
                              <div class="tp-course-meta">
                                 <span>
                                    <span>
                                       <svg width="15" height="14" viewBox="0 0 15 14" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                          <path d="M7.46118 2.81787V12.4506" stroke="#94928E"
                                             stroke-width="1.2" stroke-linecap="round"
                                             stroke-linejoin="round"></path>
                                       </svg>
                                    </span>
                                    12 Lessons
                                 </span>
                                 <span>
                                    <span>
                                       <svg width="13" height="15" viewBox="0 0 13 15" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                          <path
                                             d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                       </svg>
                                    </span>
                                    45 Student
                                 </span>
                              </div>
                              <h4 class="tp-course-title">
                                 <a href="course-details-2.html">Grow personal financial security
                                    <br> thinking &amp; principles</a>
                              </h4>
                              <div
                                 class="tp-course-rating d-flex align-items-end justify-content-between">
                                 <div class="tp-course-rating-star">
                                    <p>5.0<span> /5</span></p>
                                    <div class="tp-course-rating-icon">
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                    </div>
                                 </div>
                                 <div class="tp-course-pricing">
                                    <span>$86.00</span>
                                 </div>
                              </div>
                           </div>
                           <div class="tp-course-btn">
                              <a href="course-details-2.html">Preview this Course</a>
                           </div>
                        </div>
                     </div>
                     <div class="col-lg-4 col-md-6">
                        <div class="tp-course-item p-relative fix mb-30">
                           <div class="tp-course-teacher mb-15">
                              <span><img src="assets/img/teacher/teacher-5.png" alt="">Benjamin
                                 Evalent</span>
                              <span class="discount">-25%</span>
                           </div>
                           <div class="tp-course-thumb">
                              <a href="course-details-2.html"><img class="course-pink"
                                    src="assets/img/course/course-thumb-5.jpg" alt=""></a>
                           </div>
                           <div class="tp-course-content">
                              <div class="tp-course-tag mb-10">
                                 <span>Art &amp; Design</span>
                              </div>
                              <div class="tp-course-meta">
                                 <span>
                                    <span>
                                       <svg width="15" height="14" viewBox="0 0 15 14" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                          <path d="M7.46118 2.81787V12.4506" stroke="#94928E"
                                             stroke-width="1.2" stroke-linecap="round"
                                             stroke-linejoin="round"></path>
                                       </svg>
                                    </span>
                                    12 Lessons
                                 </span>
                                 <span>
                                    <span>
                                       <svg width="13" height="15" viewBox="0 0 13 15" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                          <path
                                             d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                       </svg>
                                    </span>
                                    45 Student
                                 </span>
                              </div>
                              <h4 class="tp-course-title">
                                 <a href="course-details-2.html">The complete guide to build <br>
                                    restful API application</a>
                              </h4>
                              <div
                                 class="tp-course-rating d-flex align-items-end justify-content-between">
                                 <div class="tp-course-rating-star">
                                    <p>5.0<span> /5</span></p>
                                    <div class="tp-course-rating-icon">
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                    </div>
                                 </div>
                                 <div class="tp-course-pricing">
                                    <span>Free</span>
                                 </div>
                              </div>
                           </div>
                           <div class="tp-course-btn">
                              <a href="course-details-2.html">Preview this Course</a>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="tab-pane fade" id="m" role="tabpanel" aria-labelledby="m-tab">
                  <div class="row">
                     <div class="col-lg-4 col-md-6">
                        <div class="tp-course-item p-relative fix mb-30">
                           <div class="tp-course-teacher mb-15">
                              <span><img src="assets/img/teacher/teacher-4.png" alt="">Indigo
                                 Violet</span>
                              <span class="discount">-25%</span>
                           </div>
                           <div class="tp-course-thumb">
                              <a href="course-details-2.html"><img class="course-sky"
                                    src="assets/img/course/course-thumb-4.jpg" alt=""></a>
                           </div>
                           <div class="tp-course-content">
                              <div class="tp-course-tag mb-10">
                                 <span>Art &amp; Design</span>
                              </div>
                              <div class="tp-course-meta">
                                 <span>
                                    <span>
                                       <svg width="15" height="14" viewBox="0 0 15 14" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                          <path d="M7.46118 2.81787V12.4506" stroke="#94928E"
                                             stroke-width="1.2" stroke-linecap="round"
                                             stroke-linejoin="round"></path>
                                       </svg>
                                    </span>
                                    12 Lessons
                                 </span>
                                 <span>
                                    <span>
                                       <svg width="13" height="15" viewBox="0 0 13 15" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                          <path
                                             d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                       </svg>
                                    </span>
                                    45 Student
                                 </span>
                              </div>
                              <h4 class="tp-course-title">
                                 <a href="course-details-2.html">Computer science: mathematical and
                                    analytical</a>
                              </h4>
                              <div
                                 class="tp-course-rating d-flex align-items-end justify-content-between">
                                 <div class="tp-course-rating-star">
                                    <p>5.0<span> /5</span></p>
                                    <div class="tp-course-rating-icon">
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                    </div>
                                 </div>
                                 <div class="tp-course-pricing">
                                    <del>$26.00</del>
                                    <span>$54.00</span>
                                 </div>
                              </div>
                           </div>
                           <div class="tp-course-btn">
                              <a href="course-details-2.html">Preview this Course</a>
                           </div>
                        </div>
                     </div>
                     <div class="col-lg-4 col-md-6">
                        <div class="tp-course-item p-relative fix mb-30">
                           <div class="tp-course-teacher mb-15">
                              <span><img src="assets/img/teacher/teacher-6.png" alt="">Hanson
                                 Deck</span>
                              <span class="discount">-25%</span>
                           </div>
                           <div class="tp-course-thumb">
                              <a href="course-details-2.html"><img class="course-lightblue"
                                    src="assets/img/course/course-thumb-6.jpg" alt=""></a>
                           </div>
                           <div class="tp-course-content">
                              <div class="tp-course-tag mb-10">
                                 <span>Art &amp; Design</span>
                              </div>
                              <div class="tp-course-meta">
                                 <span>
                                    <span>
                                       <svg width="15" height="14" viewBox="0 0 15 14" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                          <path d="M7.46118 2.81787V12.4506" stroke="#94928E"
                                             stroke-width="1.2" stroke-linecap="round"
                                             stroke-linejoin="round"></path>
                                       </svg>
                                    </span>
                                    12 Lessons
                                 </span>
                                 <span>
                                    <span>
                                       <svg width="13" height="15" viewBox="0 0 13 15" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                          <path
                                             d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                                             stroke="#94928E" stroke-width="1.2"
                                             stroke-linecap="round" stroke-linejoin="round"></path>
                                       </svg>
                                    </span>
                                    45 Student
                                 </span>
                              </div>
                              <h4 class="tp-course-title">
                                 <a href="course-details-2.html">Machine learning A-Z: <br>
                                    hands-on python and java</a>
                              </h4>
                              <div
                                 class="tp-course-rating d-flex align-items-end justify-content-between">
                                 <div class="tp-course-rating-star">
                                    <p>5.0<span> /5</span></p>
                                    <div class="tp-course-rating-icon">
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                       <i class="fa-solid fa-star"></i>
                                    </div>
                                 </div>
                                 <div class="tp-course-pricing">
                                    <del>$26.00</del>
                                    <span>$84.00</span>
                                 </div>
                              </div>
                           </div>
                           <div class="tp-course-btn">
                              <a href="course-details-2.html">Preview this Course</a>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>


      </div><!-- dashboard-content-area-end -->

</div>
<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'student_list';
include("./student-masters.php");
?>