<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/common.php';
include_once __DIR__ . '/../classes/validation.php';
include_once __DIR__ . '/../classes/class_db.php';
include_once __DIR__ . '/../classes/class_student.php';
$studentObj = new class_student();
$stu_roll   = $_SESSION['user_roll'] ?? '';

if (empty($stu_roll)) {
    die("Student roll not found. Please login again.");
}
$student_data = $studentObj->GetStudentData($stu_roll);
$semesters = $studentObj->GetAllSemestersWithCourses($stu_roll);
ob_start();
?>
<div class="tp-dashboard-course-list">
    <section class="tp-fact-wrapper">
        <div class="row">
            <div class="col-lg-12">
                <div class="tp-dashboard-section">
                    <h2 class="tp-dashboard-title">My Course Registration</h2>
                   
                </div>
            </div>
        </div>

        <div class="container ScrollStyle tp-user-wrap" style="    height: 2450px;">
            <form>
                <div class="table-container">

                    <?php foreach ($semesters as $sem_info): 
                        $sem_no = $sem_info['sem'];
                        $total_credit = $sem_info['total_credit'];
                        $reg_courses = $sem_info['courses'];
                    ?>
                    <!-- Semester Header -->
                    <div class="row mb-3">
                        <div class="col-lg-12">
                            <div class="header-bar" style="background-color: #d9534f; color: white; font-weight: bold; padding: 5px; text-align: left; margin-top: 18px;">
                                Semester : <?= $sem_no ?>
                            </div>
                        </div>
                    </div>

                    <!-- Courses Table -->
                    <table class="course-table" style="width:100%; border-collapse: collapse;">
                        <tr>
                            <th style="border:1px solid #ccc; padding:5px;">Sr.</th>
                            <th style="border:1px solid #ccc; padding:5px;">Course Code & Title</th>
                            <th style="border:1px solid #ccc; padding:5px;text-align: center;">Credits</th>
                        </tr>

                        <?php foreach ($reg_courses as $i => $row): ?>
                            <tr>
                                <td style="border:1px solid #ccc; padding:5px; text-align:center;"><?= $i + 1 ?></td>
                                <td style="border:1px solid #ccc; padding:5px;"><?= htmlspecialchars($row['sub_code'] . '  ' . $row['sub_title']) ?></td>
                                <td style="border:1px solid #ccc; padding:5px; text-align:center;"><?= $row['sub_crdit'] ?></td>
                            </tr>
                        <?php endforeach; ?>

                        <!-- Total Credits per Semester -->
                        <tr>
                            <td colspan="2" style="border:1px solid #ccc; padding:5px; text-align:right;"><b>Total Credits</b></td>
                            <td style="border:1px solid #ccc; padding:5px; text-align:center;"><b><?= $total_credit ?></b></td>
                        </tr>
                    </table>
                    <br>
                    <?php endforeach; ?>

                </div>
            </form>
        </div>
    </section>
</div>

<?php
$mainpagecontent = ob_get_clean();
$PAGENAME = 'my_courses';
include("./student-masters.php");
?>
