<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/common.php';
include_once __DIR__ . '/../classes/validation.php';
include_once __DIR__ . '/../classes/class_db.php';
include_once __DIR__ . '/../classes/class_student.php';
$feedbackObj = new class_feedback();
$validator   = new validation();
$stu_roll = $_SESSION['user_roll'] ?? '';
$sem_now  = $_SESSION['user_sem'] ?? $feedbackObj->GetCurrentSemester($stu_roll);
$courses = $feedbackObj->GetStudentCourses($stu_roll, $sem_now);
ob_start();
?>
<!-- dashboad-content-box-area-start -->
<div class="tp-dashboard-course-list">
   <section class="tp-fact-wrapper">
      <div class="row">
         <div class="col-lg-12">
            <div class="tp-dashboard-section">
               <h2 class="tp-dashboard-title">Mid Semester Feedback</h2>
            </div>
         </div>
      </div>

 <div class="container mt-4">
   <div class="table mt-3">
      <table class="table table-bordered align-middle">
         <thead>
            <tr style="background: #f3e4c1;">
               <th colspan="5" class="text-brown">
                  Semester : <?php echo htmlspecialchars($sem_now); ?>
               </th>
            </tr>
            <tr>
               <th>#</th>
               <th>Subject Code</th>
               <th>Subject Title</th>
               <th>Credits</th>
               <th style="    text-align: end;">Feedback</th>
            </tr>
         </thead>
         <tbody>
            <?php if (!empty($courses)) : ?>
               <?php $i = 1; foreach ($courses as $course): ?>
                  <tr>
                     <td><?php echo $i++; ?></td>
                     <td><?php echo htmlspecialchars($course['sub_code']); ?></td>
                     <td><?php echo htmlspecialchars($course['sub_title']); ?></td>
                     <td><?php echo htmlspecialchars($course['sub_crdit']); ?></td>
                     <td class="text-center">
                        <a href="feedback-select.php?code=<?php echo urlencode($course['unique_code']); ?>" 
                           style="color: #d9534f; float: right;">
                           Give Feedback
                        </a>
                     </td>
                  </tr>
               <?php endforeach; ?>
            <?php else: ?>
               <tr>
                  <td colspan="5" class="text-center text-danger">
                     No courses found for this semester.
                  </td>
               </tr>
            <?php endif; ?>
         </tbody>
      </table>
   </div>
</div>

   </section>
</div>
<!-- dashboad-content-box-area-end -->

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'mid_sem_feedback';
include("./student-masters.php");
?>
