<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/class_student.php';

$studentObj = new class_student();
$curr_sem_no = $studentObj->GetCurrentSemester($stu_roll);
$semester_name = "Semester $curr_sem_no";

// Fetch all courses for current semester
$courses = $studentObj->GetStudentCourses($stu_roll, $curr_sem_no);

ob_start();
?>
<div class="tp-dashboard-course-list">
    <section class="tp-fact-wrapper">
        <div class="row">
            <div class="col-lg-12">
                <div class="tp-dashboard-section">
                    <h2 class="tp-dashboard-title">Class Attendance : <?= htmlspecialchars($semester_name) ?></h2>
                </div>
            </div>
        </div>
        <?php if (!empty($courses)): ?>
            <div class="form-container" style="    height: 700px;">
                <div class="table-container">
                    <table class="table " style="vertical-align: middle;">
                        <thead style="background:#f3e4c1;">
                            <tr>
                                <th>Course Title</th>
                                <th>Course Code</th>
                                <th>View Attendance</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($courses as $course): ?>
                                <tr>
                                    <td><?= htmlspecialchars($course['sub_title']) ?></td>
                                    <td style="color:#14ab69"><?= htmlspecialchars($course['sub_code']) ?></td>
                                    <td>
                                        <a href="class-attendance-view.php?unique_code=<?= urlencode($course['unique_code']) ?>" class="btn btn-sm btn-primary" style="background: #cb4f4e;">
                                            View
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php else: ?>
            <div class="alert alert-warning">No courses found for this semester.</div>
        <?php endif; ?>
    </section>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'class_attendance';
include("./student-masters.php");
?>
