<?php
include_once '../session/admin-session.php';
include_once '../classes/class_admin.php';
include_once '../classes/validation.php';
include_once '../classes/common.php';
include_once 'read-configration.php';
ob_start();

$log = new common();
$objadm = new class_admin();
$val = new validation();

$objadm->res_sem = preg_replace('/[^0-9]/', '', $working_curriculum);
$RegCourseLisr = $objadm->GetRegistrationCourseList();

if ($_POST['reg_course_btn']) {
    $course_code_str = $val->ValidateString($_REQUEST['course_code']);
    $course_code_arr = explode("_", $course_code_str);
    $objadm->course_code = $course_code_arr['1'];
    $objadm->res_sem = preg_replace('/[^0-9]/', '', $working_curriculum);

    $RegCourseStudentArr = $objadm->GetRegistrationCourseStudentList();
}
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-xl-12 col-xxl-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Subject Registration Student List</h5>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">                        
                            <form action="" method="POST">
                                <div class="mb-3" style="padding-left: 0px;">
                                    <select class="form-select" id="course_code" name="course_code" required>
                                        <option value="">--- Select Subject ---</option>

                                        <?php
                                        while ($row = mysqli_fetch_array($RegCourseLisr)) {

                                            $sub_list = $row["sub_list"];
                                            $sub_code = $row["sub_code"];
                                            $sub_title = $row["sub_title"];
                                            
                                            $selected_val = "";
                                            if($course_code_str == $sub_list . '_' . $sub_code . '_' . $sub_title){
                                                $selected_val = "SELECTED";
                                            }
                                            ?>

                                            <option value="<?php echo $sub_list . '_' . $sub_code . '_' . $sub_title; ?>" <?php echo $selected_val; ?>><?php echo $sub_code . '-' . $sub_title; ?></option>

                                        <?php } ?>

                                    </select>

                                </div>

                                <input type="submit" class="btn btn-danger" style="background: #a9181b;
                                       border: #a9181b; text-align: center;" value="Submit" name="reg_course_btn"/>

                            </form>

                        </div>
                        <div class="col-lg-2"></div><br/><br/>
                    </div>

                    <div class="row">
                        <br/>
                        <div class="table-responsive">
                            <table class="table table-bordered align-middle" id="Subject_Student_List">
                                <thead class="table" style="background: #f3e4c1;" >
                                    <tr>
                                        <th>#</th>
                                        <th>Batch</th>
                                        <th>Roll No</th>
                                        <th>Student Name</th>
                                        <th>Credit</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $cn = 1;
                                    foreach ($RegCourseStudentArr as $rv) {
                                        if (!empty($rv['stu_roll'])) {
                                            ?>
                                            <tr>
                                                <td><?php echo $cn; ?></td>
                                                <td><?php echo $rv['batch_name']; ?></td>
                                                <td><?php echo $rv['stu_roll']; ?></td>
                                                <td><?php echo $rv['stu_name']; ?></td>
                                                <td><?php echo $rv['grade']; ?></td>
                                            </tr>

                                            <?php
                                            $cn = $cn + 1;
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
</div>
<?php
$pagemaincontent = ob_get_contents();
ob_clean();
$PAGENAME = 'registration-course-student';
$HTMLTITLE = '';
$HTMLDESCRIPTION = '';
$HTMLKEYWORDS = '';
include("admin-master.php");
?>
<script type="text/javascript">
    $("#Subject_Student_List").DataTable({
        dom: '<"top"lBf>rt<"bottom"ip><"clear">',
        buttons: [
            {
                extend: 'excelHtml5',
                text: 'Download Excel',
                title: 'Data Export',
                className: 'btn btn-success'
            }
        ]
    });
</script>