<?php
ob_start();
include_once 'classes/common.php';
include_once 'classes/DB.class.php';
include_once 'session/vendor-session.php';
ini_set("display_errors", 0);
$db = new DB();

$added_by = $_SESSION['gftgn_vendor_id'];
$dy = "";
$Occasion_list_arr = $db->selectWithCols("gftgn_occasions_tbl", "occasion_pk_id, occasion_name", "status='1' ORDER BY occasion_name ASC");
$Category_list_arr = $db->selectWithCols("gftgn_category_tbl", "category_pk_id, category_name", "status='1' ORDER BY category_name ASC");

$OccasionArr = array();
foreach ($Occasion_list_arr as $ola) {
    $OccasionArr[$ola['occasion_pk_id']] = $ola['occasion_name'];
}
$CategoryArr = array();
foreach ($Category_list_arr as $cla) {
    $CategoryArr[$cla['category_pk_id']] = $cla['category_name'];
}

/* Getting the already alloted product id */

$vnd_product_id_arr = $db->selectWithCols("gftgn_product_vendor_tbl", "GROUP_CONCAT(product_pk_id) as ProductPkIdStr", "1 AND status='1' AND vendor_pk_id='$added_by'");
$ProductPkIdStr = $vnd_product_id_arr['0']['ProductPkIdStr'];

if (!empty($ProductPkIdStr)) {
    $dy .= " AND product_pk_id NOT IN($ProductPkIdStr)";
}


$gft_occasion_pk_id_arr = array();
$gft_category_pk_id_arr = array();

if ($_POST['product_search_btn']) {
    $gft_search_text = $_REQUEST['gft_search_text'];

    if (!empty($_REQUEST['gft_occasion_pk_id'])) {
        $gft_occasion_pk_id_arr = $_REQUEST['gft_occasion_pk_id'];
    }

    if (!empty($_REQUEST['gft_category_pk_id'])) {
        $gft_category_pk_id_arr = $_REQUEST['gft_category_pk_id'];
    }

    $ViewOccCol = "";
    if (count($gft_occasion_pk_id_arr) > 0) {
        foreach ($gft_occasion_pk_id_arr as $goA) {
            $ViewOccCol .= "(FIND_IN_SET($goA, occasion_pk_id)) OR";
        }

        $ViewOccCol = substr($ViewOccCol, 0, - 2);
        $ViewOccCol = "(" . $ViewOccCol . ")";
        $dy .= " AND " . $ViewOccCol;
    }

    $ViewCatCol = "";
    if (count($gft_category_pk_id_arr) > 0) {
        foreach ($gft_category_pk_id_arr as $gcatA) {
            $ViewCatCol .= " (FIND_IN_SET($gcatA, category_pk_id)) OR";
        }
        $ViewCatCol = substr($ViewCatCol, 0, - 2);
        $ViewCatCol = "(" . $ViewCatCol . ")";
        $dy .= " AND " . $ViewCatCol;
    }


    if (!empty($gft_search_text)) {
        $gft_search_text_str = common::StrFromDb($gft_search_text);
        $dy .= " AND (product_name LIKE '%$gft_search_text_str%' OR product_description_text LIKE '%$gft_search_text_str%')";
    }
}


// Getting the List Of Compnay
$product_list_arr = $db->selectWithCols("gftgn_product_tbl", "*", "1 AND status='1' $dy ORDER BY product_pk_id DESC");
?>
<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12 ">
        <h3>Product Search List</h3>
        <div class="box box-primary">
            <div class="box-body">
                <form action="" method="POST" id="search_product_form_id">
                    <div class="row">
                        <div class="col-md-4 col-sm-4 col-xs-4">
                            <div class="form-group">
                                <label>Search Box</label>
                                <input type="text" name="gft_search_text" id="gft_search_text" class="form-control input-lg" value="<?php echo common::StrFromDb($gft_search_text); ?>" placeholder="Enter Product Name or, Description"/>

                            </div>
                        </div>
                        <div class="col-md-3 col-sm-3 col-xs-3">
                            <div class="form-group">
                                <label>Occasions</label>
                                <select name="gft_occasion_pk_id[]" id="gft_occasion_pk_id" class="form-control input-lg" multiple="">
                                    <?php foreach ($Occasion_list_arr as $ola) { ?>
                                        <option value="<?php echo $ola['occasion_pk_id']; ?>" <?php if (in_array($ola['occasion_pk_id'], $gft_occasion_pk_id_arr)) {
                                        echo "SELECTED";
                                    } ?>><?php echo $ola['occasion_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-3 col-xs-3">
                            <div class="form-group">
                                <label>Category</label>
                                <select name="gft_category_pk_id[]" id="gft_category_pk_id" class="form-control input-lg" multiple="">
                                    <?php foreach ($Category_list_arr as $cla) { ?>
                                        <option value="<?php echo $cla['category_pk_id']; ?>" <?php if (in_array($cla['category_pk_id'], $gft_category_pk_id_arr)) {
                                        echo "SELECTED";
                                    } ?>><?php echo $cla['category_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <br/><br/><br/>
                                <input type="submit" name="product_search_btn" id="product_search_btn" class="btn btn-warning btn-block text-uppercase" value="SEARCH"/>
                            </div>
                        </div>
                    </div>
                </form>


                <div class="clearfix"></div><br/>
                <div class="table-responsive ">
                    <table class="table table-striped table-hover table-bordered table-condensed" id="product_list_id">
                        <thead>
                            <tr>
                                <th width="5%">
                                    #
                                </th>
                                <th width="30%">
                                    Product Name
                                </th>
                                <th width="15%">
                                    Product Title
                                </th>
                                <th width="15%">
                                    Occasions
                                </th>
                                <th width="15%">
                                    Categories
                                </th>
                                <th>
                                    Action
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $c = 1;
                            foreach ($product_list_arr as $pla) {

                                $product_pk_id = $pla['product_pk_id'];
                                ?>
                                <tr id="Row_<?php echo $product_pk_id; ?>">
                                    <td><?php echo $c; ?></td>
                                    <td><?php echo common::StrFromDb($pla['product_name']); ?></td>
                                    <td><?php echo common::StrFromDb($pla['product_price']); ?></td>
                                    <td>
                                        <?php
                                        $OccaisionStr = "";
                                        $occasion_pk_id = common::StrFromDb($pla['occasion_pk_id']);
                                        $occasionIdArr = explode(",", $occasion_pk_id);
                                        if (count($occasionIdArr) > 0) {
                                            foreach ($occasionIdArr as $OIA) {
                                                $OccaisionStr .= $OccasionArr[$OIA] . ",";
                                            }
                                        } else {
                                            $OccaisionStr .= $OccasionArr[$occasion_pk_id] . ",";
                                        }

                                        if (!empty($OccaisionStr)) {
                                            echo $OccaisionStr;
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $CategoryIdStr = "";
                                        $category_pk_id = common::StrFromDb($pla['category_pk_id']);
                                        $categoryIdarr = explode(",", $category_pk_id);

                                        if (count($categoryIdarr) > 0) {

                                            foreach ($categoryIdarr as $OIA) {

                                                $CategoryIdStr .= $CategoryArr[$OIA] . ",";
                                            }
                                        } else {

                                            $CategoryIdStr .= $CategoryArr[$category_pk_id] . ",";
                                        }

                                        if (!empty($CategoryIdStr)) {
                                            echo $CategoryIdStr;
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <input type="number" name="allot_number_item_<?php echo $product_pk_id; ?>" id="allot_number_item_<?php echo $product_pk_id; ?>" class="form-control" style="width: 100px;" placeholder="Quantity"/>
                                        <a href="javascript:void(0);" class="btn btn-warning" onclick="AllotProduct('<?php echo $product_pk_id; ?>', '<?php echo $added_by; ?>')">Allot</a>
                                    </td>
                                </tr>
                                <?php
                                $c = $c + 1;
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
</div>
<div class="clearfix"></div><br/><br/>
<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include 'vendor-master.php';
?>

<script type="text/javascript">
    $(function () {
        $("#category_pk_id").change(function () {
            var category_id_str = $(this).val();
            $.ajax({
                type: "POST",
                url: "server/action-post.php",
                data: "category_id_str=" + category_id_str + "&action=GetSubCategory",
                success: function (data) {
                    $("#sub_category_pk_id").html(data.data);
                }
            });
        });
    });

    function AllotProduct(ProductId, AddedBy) {
        if (confirm("Are You Sure To Allot Product?")) {
            var allot_number_item = $("#allot_number_item_" + ProductId).val();
            if (allot_number_item != "") {
                $.ajax({
                    type: "POST",
                    url: "server/action-post.php",
                    data: "ProductId=" + ProductId + "&AddedBy=" + AddedBy + "&NumberItem=" + allot_number_item + "&action=AllotProduct",
                    success: function (data) {
                        alert("Alloted");
                        $("#Row_"+ProductId).hide();
                    }
                });
            }else{
                alert("Enter Item Quantity!");
            }
        }
    }
</script>