<?php

header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT, GET, POST");
include_once '../classes/DB.class.php';
include_once '../classes/common.php';
include_once '../classes/validation.php';
require_once('../tcpdf/tcpdf.php');

class MYPDF extends TCPDF {

    public function Header() {
        $this->SetFont('helvetica', 'B', 8);
        $view_tbl .= '';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    public function Footer() {

        $this->SetY(-50);

        $this->SetFont('helvetica', 'I', 8);

        $view_tbl .= '';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

ini_set("display_errors", 0);

$db = new DB();
$val = new validation();
$com = new common();

$action = empty($_POST["action"]) ? "" : $_POST["action"];
$added_by = empty($_POST["added_by"]) ? "" : $_POST["added_by"];

$added_date = DATE('Y-m-d H:i:s');
if ($action == "") {
    $arr["res_status"] = "2";
    $arr["res_msg"] = "Source Not Found!";
} else {

    switch ($action) {

        case "GetSubCategory" :

            $category_id_str = $_REQUEST['category_id_str'];
            // Getting the List Of Sub Category
            $SubCateListArr = $db->selectWithCols("gftgn_sub_category_tbl", "sub_category_pk_id, sub_category_name", "1 AND status='1' AND category_pk_id IN ($category_id_str)");
            foreach ($SubCateListArr as $SLA) {
                $OptionVal .= "<option value='" . $SLA['sub_category_pk_id'] . "'>" . $SLA['sub_category_name'] . "</option>";
            }

            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $OptionVal;
            break;

        case "ChangeOrderStatus" :

            $OrderPkId = $_REQUEST['OrderPkId'];
            $StatusVal = $_REQUEST['StatusVal'];

            $UpdateArr = array(
                "order_status" => "$StatusVal"
            );

            $db->update($UpdateArr, "gftgn_order_tbl", "order_pk_id='$OrderPkId'");

            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            break;

        case "AllotProduct" :
            $ProductId = $_REQUEST['ProductId'];
            $AddedBy = $_REQUEST['AddedBy'];
            $NumberItem = $_REQUEST['NumberItem'];
            
            $added_date = DATE('Y-m-d H:i:s');
            
            $InsertArr = array(
                "product_pk_id" => "$ProductId",
                "vendor_pk_id" => "$AddedBy",
                "added_date" => "$added_date",
                "item_number" => "$NumberItem",
                "remaining_item_number" => "$NumberItem"
            );

            $db->insert($InsertArr, "gftgn_product_vendor_tbl");
            
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            break;
        
            case "UnAllotProduct" :
            $ProductId = $_REQUEST['ProductId'];
            $AddedBy = $_REQUEST['AddedBy'];
            
            $added_date = DATE('Y-m-d H:i:s');
            
            $UpdateArr = array(
                "status" => "2"
            );

            $db->update($UpdateArr, "gftgn_product_vendor_tbl", "vendor_pk_id='$AddedBy' AND product_pk_id='$ProductId'");
            
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            break;
        
           case "UpdateProductQty" :
            $ProductId = $_REQUEST['ProductId'];
            $RemNumber = $_REQUEST['RemNumber'];
            
            $UpdateArr = array(
                "remaining_item_number" => "$RemNumber"
            );

            $db->update($UpdateArr, "gftgn_product_vendor_tbl", "product_pk_id='$ProductId'");
            
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            break;
        
    }

    $RES = json_encode($arr);
    echo $RES;
}
?>