<?php

header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT, GET, POST");
include_once '../classes/DB.class.php';
include_once '../classes/common.php';
include_once '../classes/validation.php';

$db = new DB();
$val = new validation();
$com = new common();

$action = empty($_POST["action"]) ? "" : $_POST["action"];
$added_by = empty($_POST["added_by"]) ? "" : $_POST["added_by"];

$added_date = DATE('Y-m-d H:i:s');

if ($action == "") {
    $arr["res_status"] = "2";
    $arr["res_msg"] = "Source Not Found!";
} else {
    $OccasionIdArr = array();
    switch ($action) {
        case "getOccasion":
            $getOccasionArr = $db->selectWithCols("gftgn_occasions_tbl", "*", "1 AND status='1' ORDER BY occasion_name ASC");
            foreach ($getOccasionArr as $goA) {
                $OccasionIdArr[$goA['occasion_pk_id']] = $goA['occasion_name'];
            }
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $OccasionIdArr;
            break;

        case "getCategory":
            $getCategoryArr = $db->selectWithCols("gftgn_category_tbl", "*", "1 AND status='1' ORDER BY category_name ASC");
            foreach ($getCategoryArr as $gcA) {
                $CategoryIdArr[$gcA['category_pk_id']] = $gcA['category_name'];
            }
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $CategoryIdArr;
            break;

        case "getSubCategory":
            $category_pk_id = $_POST['category_pk_id'];
            $getSubCategoryArr = $db->selectWithCols("gftgn_sub_category_tbl", "*", "1 AND status='1' AND category_pk_id = '$category_pk_id' ORDER BY sub_category_name ASC");
            foreach ($getSubCategoryArr as $gscA) {
                $SubCategoryIdArr[$gscA['category_pk_id']] = $gscA['category_name'];
            }
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $SubCategoryIdArr;
            break;

        case "getCategoryForOccasion":
            $ProductCountArray = array();
            $occasion_pk_id = $_POST['occasion_pk_id'];
            $getProductArr = $db->selectWithCols("gftgn_product_tbl", "category_pk_id, COUNT(*) AS category_count", "1 AND status='1' AND occasion_pk_id = '$occasion_pk_id' GROUP BY category_pk_id HAVING COUNT(*) > 2 ORDER BY category_count DESC");
            foreach ($getProductArr as $gpA) {
                $ProductCountArray[$gpA['category_pk_id']] = $gpA['category_count'];
            }
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $ProductCountArray;
            break;

        case "getTrendingItem":
            $ProductListArray = array();
            /*
              $getOrderArr = $db->selectWithCols("gftgn_order_product_tbl", "product_pk_id, COUNT(*) AS product_id_count", "1 AND status='1' GROUP BY product_pk_id HAVING COUNT(*) > 2 ORDER BY product_id_count DESC");
              foreach ($getOrderArr as $goA) {
              $ProductCountArray[$goA['product_pk_id']] = $goA['product_id_count'];
              }
             */

            $view_product_div = "";
            $getProductArr = $db->selectWithCols("gftgn_product_tbl", "product_pk_id, product_name, product_offer_price, product_image_file", "1 ORDER BY product_pk_id DESC");
            foreach ($getProductArr as $gPA) {
                $ProductListArray[$gPA['product_pk_id']]['product_name'] = common::StrFromDb($gPA['product_name']);
                $ProductListArray[$gPA['product_pk_id']]['product_offer_price'] = common::StrFromDb($gPA['product_offer_price']);
                $product_image_file_str = $gpA['product_image_file'];
                $product_image_file_arr = explode(",", $product_image_file_str);
                $ProductListArray[$gPA['product_pk_id']]['product_image_file'] = $product_image_file_arr['0'];

                $view_product_div .= '<div class="product-item">
                    <div class="">
                        <a href="product-detail.html"><img src="assets/img/trending/caramel-crown-cake-half-kg_1.webp" alt="" style="width: 100px;"></a>
                        <div class="product-action-wrap">
                            <div class="product-action">        
                            </div>
                        </div>
                    </div>
                    <div class="product-content">
                        <div class="product-info">
                            <h3 class="product-title"><a href="shop-single.html">' . common::StrFromDb($gPA['product_name']) . '</a></h3>
                            <div class="product-price">
                                <span>₹' . $gPA['product_offer_price'] . '</span>
                            </div>
                        </div>
                    </div>
                </div>';
            }


            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $view_product_div;
            break;

        case "getCakeSubCategory":
            $CakeSubArray = array();
            $category_pk_id = $_POST['category_pk_id'];
            $getCakeSubArr = $db->selectWithCols("gftgn_sub_category_tbl", "sub_category_pk_id, sub_category_name", "1 AND status='1' AND category_pk_id='$category_pk_id' ORDER BY sub_category_name ASC");
            foreach ($getCakeSubArr as $gcA) {
                $CakeSubArray[$gcA['sub_category_pk_id']] = $gcA['sub_category_name'];
            }
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $CakeSubArray;
            break;

        case "getPlantSubCategory":
            $PlantSubArray = array();
            $category_pk_id = $_POST['category_pk_id'];
            $getPlantSubArr = $db->selectWithCols("gftgn_sub_category_tbl", "sub_category_pk_id, sub_category_name", "1 AND status='1' AND category_pk_id='$category_pk_id' ORDER BY sub_category_name ASC");
            foreach ($getPlantSubArr as $gPSA) {
                $PlantSubArray[$gcA['sub_category_pk_id']] = $gPSA['sub_category_name'];
            }
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $PlantSubArray;
            break;

        case "getBestSeller":
            $BestSellerArray = array();
            $getSellerArr = $db->selectWithCols("gftgn_order_product_tbl", "category_pk_id, COUNT(*) AS category_id_count", "1 AND status='1' GROUP BY category_pk_id HAVING COUNT(*) > 2 ORDER BY category_id_count DESC");
            foreach ($getOrderArr as $goA) {
                $BestSellerArray[$goA['category_pk_id']] = $goA['category_id_count'];
            }
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $BestSellerArray;
            break;

        case "CartTransferOrderTbl":

            $AddedDateTime = DATE('Y-m-d H:i:s');

            $vendorId = empty($_POST["vendor_pk_id"]) ? "" : common::StrToDB($_POST["vendor_pk_id"]);
            $OrderShowId = "ORD" . DATE('dmy') . "-" . $vendorId . "-" . mt_rand("1111", "9999");
            $userId = empty($_POST["user_pk_id"]) ? "" : common::StrToDB($_POST["user_pk_id"]);

            $orderInsArr = array(
                "order_show_id" => "$OrderShowId",
                "user_pk_id" => "$userId",
                "added_date" => "$AddedDateTime",
                "vendor_pk_id" => "$vendorId"
            );

            $orderPkId = $db->insert($orderInsArr, "gftgn_order_tbl");

            /* Transfer data Cart To product Order Table */

            $ProductCartArr = $db->selectWithCols("gftgn_product_cart_tbl", "*", "user_id='$userId' ORDER BY prod_cart_pk_id ASC");
            foreach ($ProductCartArr as $PCA) {

                $productId = $PCA['product_pk_id'];

                $OrderProductArr = array(
                    "order_pk_id" => "$orderPkId",
                    "product_pk_id" => "$productId",
                    "added_date" => "$AddedDateTime",
                    "user_pk_id" => "$userId"
                );

                $db->insert($OrderProductArr, "gftgn_product_cart_tbl");
            }

            break;

        case "AddToCart":
            $ProductId = $_REQUEST['ProductId'];
            $CartUserID = $_REQUEST['CartUserID'];

            $AddedDateTime = DATE('Y-m-d H:i:s');

            $InsArr = array(
                "product_pk_id" => "$ProductId",
                "user_id" => $CartUserID,
                "number_item" => "1",
                "added_date" => "$AddedDateTime"
            );

            $db->insert($InsArr, "gftgn_product_cart_tbl");

            break;

        case "FunCartOpen":

            $CartUserID = $_REQUEST['CartUserID'];

            $CartProductArr = $db->selectWithCols("gftgn_product_cart_tbl", "*", "user_id='$CartUserID'");
            
            $ViewCartItem = '<div class="dropdown-cart-header">
                                                    <span>01 Items</span>
                                                    <a href="shop-cart.html">View Cart</a>
                                                </div> <ul class="dropdown-cart-list">';
            $ViewCartItem = "";
            $TotalPrice = 0;
            foreach ($CartProductArr as $CPA) {
                
                $productId = $CPA['product_pk_id'];
                $ProductDetailsArr = $db->selectWithCols("gftgn_product_tbl", "*", "product_pk_id='$productId'");
foreach ($ProductDetailsArr as $PDA) {
    $ProductName = $PDA['product_name'];
    $product_offer_price = $PDA['product_offer_price'];
    $product_price = $PDA['product_price'];
    $product_image_file_str = $PDA['product_image_file'];
    $product_image_file_arr = explode(",", $product_image_file_str);
    $prodImage = $product_image_file_arr['0'];
}                
$TotalPrice = $TotalPrice + $product_offer_price;

                
                    $ViewCartItem .='<li>
                                                        <div class="dropdown-cart-item">
                                                            <div class="cart-img">
                                                                <a href="#"><img src="guplod/prodimg/'.$prodImage.'"
                                                                                 alt="#"></a>
                                                            </div>
                                                            <div class="cart-info">
                                                                <h4><a href="#">'.$ProductName.'</a></h4>
                                                                <p class="cart-qty">1x - <span
                                                                        class="cart-amount">₹'.$product_offer_price.'</span></p>
                                                            </div>
                                                            <a href="#" class="cart-remove" title="Remove this item" style="display:none;"><i
                                                                    class="far fa-times-circle"></i></a>
                                                        </div>
                                                    </li>';
            }
            
            if(!empty($CartUserID)){
            
            $ViewCartItem .= '</ul>
                                                <div class="dropdown-cart-bottom">
                                                    <div class="dropdown-cart-total">
                                                        <span>Total</span>
                                                        <span class="total-amount">₹'.$TotalPrice.'</span>
                                                    </div>
                                                    <a href="#" class="theme-btn" style="background: #31b197;
                                                       color: #ffffff;">Checkout</a>
                                                </div>';
            }else{
                
                         $ViewCartItem .= '</ul>
                                                <div class="dropdown-cart-bottom">
                                                   
                                                    <a href="login.php" class="theme-btn" style="background: #31b197;
                                                       color: #ffffff;">Login</a>
                                                </div>';
                
            }
            
            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $ViewCartItem;

            break;
    }

    $RES = json_encode($arr);
    echo $RES;
}
?>