<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta charset="utf-8"/>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <meta name="viewport" content="width=device-width, initial-scale=1"/>
        <title>Admin @ GiftGenie</title>
        <!-- CSS -->
        <link href="css/bootstrap.min.css" rel="stylesheet"/>
        <link href="css/bootstrap-datetimepicker.css" rel="stylesheet"/>
        <link href="fonts/css/font-awesome.min.css" rel="stylesheet"/>
        <link href="css/animate.min.css" rel="stylesheet"/>
        <link href="css/custom.css" rel="stylesheet"/>
        <link href="css/style.css" rel="stylesheet"/>

    </head>

    <style type="text/css">
        /* Remove bullets from <ul> and <li> */
        .side-menu ul {
            list-style-type: none; /* Removes the default bullet points */
            padding-left: 0; /* Remove left padding to align items correctly */
            margin: 0; /* Remove any default margin */
        }

        /* Optional: Remove bullets specifically from submenu */
        .side-menu .submenu {
            list-style-type: none; /* Removes bullets from the submenu */
            padding-left: 20px;
        }
        .side-menu {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .side-menu > li {
            position: relative;
        }

        .submenu {
            display: none; /* Hide sub-menu by default */
            list-style: none;
            padding-left: 20px;
            margin-top: 5px;
        }

        .has-submenu:hover .submenu {
            display: block; /* Show sub-menu on hover */
        }

        .side-menu a {
            text-decoration: none;
            color: #333;
            padding: 10px;
            display: block;
        }

        .side-menu li a:hover {
            background-color: #a1e6e74f;
        }


        .dashboard-widget.color-1 {
            background: rgb(168 85 247 / 32%);
            color: #A855F7;
        }

        .dashboard-widget.color-2 {
            background: rgb(17 183 107 / 18%);
            color: #11B76B;
        }

        .dashboard-widget.color-3 {
            background: rgba(240, 84, 84, .08);
            color: #F05454;
        }
        .dashboard-widget.color-4 {
            background: rgb(229 150 22 / 39%);
            color: #a56b0f;
        }

        .user-card {
            background: var(--color-white);
            /*    padding: 0px 20px 20px 20px;*/
            border-radius: 10px;
            margin-bottom: 10px;
            box-shadow: var(--box-shadow);
        }

        .user-card-header {
            display: flex
                ;
            align-items: center;
            justify-content: space-between;
            /*    padding-bottom: 15px;*/
            margin-bottom: 15px;
            border-bottom: 1px solid var(--border-info-color);
        }

        .user-card-header .user-card-title {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        .user-card-title {
            color: var(--color-dark);
            font-size: 20px;
            padding-bottom: 15px;
            margin-bottom: 15px;
            border-bottom: 1px solid var(--border-info-color);
        }

        .user-card-header .theme-btn {
            padding: 8px 15px;
        }
        .theme-btn {
            position: relative;
            font-size: 16px;
            background: #008dd2;
            color: white;
            padding: 10px 20px;
            display: inline-block;
            vertical-align: middle;
            text-transform: capitalize;
            border-radius: 10px;
            font-weight: 500;
            cursor: pointer;
            text-align: center;
            overflow: hidden;
            border: none;
            box-shadow: var(--box-shadow);
            transition: var(--transition);
            z-index: 1;
        }


        .user-area .table {
            border-collapse: separate;
            border-spacing: 0 10px;
            margin-bottom: 0;
        }
        .text-nowrap {
            white-space: nowrap !important;
        }


        .user-area .table tbody tr {
            background: #F8F8F8;
            margin-bottom: 10px;
        }

        * {
            border: 0;
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }


        strong {
            font-weight: 500;
        }
        .db {
            display: grid;
            grid-gap: 1.5em;
            padding: 1.5em;
            width: 100%;
        }
        .db__bars {
            display: grid;
            grid-template-columns: 2.5em repeat(7,1fr);
            grid-template-rows: repeat(5,1fr) 2.5em;
            align-items: center;
            justify-items: center;
            position: relative;
        }
        .db__bars-cell {
            text-align: center;
            width: 100%;
        }
        .db__bars-cell-bar {
            background-image: linear-gradient(var(--primary),var(--secondary),var(--tertiary));
            border-radius: 0.25em;
            margin: auto;
            overflow: hidden;
            position: relative;
            height: 15em;
            width: 50%;
            max-width: 3em;
        }
        .db__bars-cell-bar-fill {
            background-color: var(--gray2);
            position: absolute;
            top: 0;
            right: -1px;
            left: -1px;
            height: 100%;
            transition:
                background-color var(--trans-dur),
                transform var(--trans-dur) ease-in-out;
        }
        .db__bars-cell:nth-child(1) {
            grid-column: 2;
        }
        .db__bars-cell:nth-child(2) {
            grid-column: 3;
        }
        .db__bars-cell:nth-child(3) {
            grid-column: 4;
        }
        .db__bars-cell:nth-child(4) {
            grid-column: 5;
        }
        .db__bars-cell:nth-child(5) {
            grid-column: 6;
        }
        .db__bars-cell:nth-child(6) {
            grid-column: 7;
        }
        .db__bars-cell:nth-child(7) {
            grid-column: 8;
        }
        .db__bars-cell:nth-child(-n + 7) {
            grid-row: 1 / 6;
        }
        .db__bars-cell:nth-child(n + 8):nth-child(-n + 13) {
            align-self: start;
            text-align: right;
        }
        .db__bars-cell:nth-child(n + 14) {
            align-self: end;
        }
        .db__bubble {
            background-color: var(--primary);
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            position: absolute;
            top: 50%;
            left: 50%;
            width: 12em;
            height: 12em;
            transform: translate(-50%,-50%) translate(-3em,-2em);
        }
        .db__bubble:nth-child(2) {
            background-color: var(--secondary);
            font-size: 0.9em;
            width: 9rem;
            height: 9rem;
            transform: translate(-50%,-50%) translate(5rem,-1rem);
        }
        .db__bubble:nth-child(3) {
            background-color: var(--tertiary);
            font-size: 0.8em;
            width: 7rem;
            height: 7rem;
            transform: translate(-50%,-50%) translate(1rem,4.5rem);
        }
        .db__bubble-text {
            color: hsl(0,0%,100%);
            text-align: center;
        }
        .db__bubble-value {
            font-size: 2.25em;
        }
        .db__bubbles {
            position: relative;
            height: 17em;
        }
        .db__cell,
        .db__select {
            background-color: hsla(0,0%,100%,0.5);
            backdrop-filter: blur(20px);
            box-shadow:
                0 0 0 1px hsla(0,0%,100%,0.5) inset,
                0 0 0 2px hsla(0,0%,100%,0) inset,
                0 0 0.75em hsl(0,0%,0%,0.3);
            -webkit-backdrop-filter: blur(20px);
        }
        .db__cell {
            border-radius: 0.5em;
            padding: 1.5em 1.25em;
            display: flex;
            flex-direction: column;
            transition:
                background-color var(--trans-dur),
                box-shadow var(--trans-dur);
        }
        .db__counter {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
            flex-grow: 1;
        }
        .db__counter-value,
        .db__heading,
        .db__subheading {
            font-weight: 500;
        }
        .db__counter-label {
            line-height: 1;
            margin-left: 0.75em;
            text-align: right;
        }
        .db__counter-value {
            font-size: 2em;
            line-height: 1;
        }
        .db__heading {
            font-size: 2em;
        }
        .db__order {
            display: flex;
            padding: 1em 0;
        }
        .db__order:not(:last-child) {
            box-shadow: 0 1px 0 hsla(0,0%,50%,0.3);
        }
        .db__order-cat,
        .db__order-name {
            margin-right: 1em;
        }
        .db__order-cat {
            background-color: hsla(var(--hue),90%,55%,0.2);
            border-radius: 50%;
            display: grid;
            place-items: center;
            align-self: center;
            width: 2.75em;
            height: 2.75em;
            transition: background-color var(--trans-dur);
        }
        .db__order-cat-icon {
            color: var(--primary);
            width: 1.5em;
            height: 1.5em;
            transition: color var(--trans-dur);
        }
        .db__order-name {
            flex-grow: 1;
        }
        .db__product {
            display: flex;
            justify-content: space-between;
        }
        .db__product-details {
            width: 33%;
        }
        .db__product-details + .db__product-details {
            text-align: right;
            width: 67%;
        }
        .db__product-detail-line {
            min-width: 0;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        .db__product-table {
            border-collapse: collapse;
            text-align: left;
            width: 100%;
        }
        .db__product-table th,
        .db__product-table td {
            padding: 1em 0.5em 1em 0;
        }
        .db__product-table th {
            font-weight: 400;
        }
        .db__product-table th:nth-child(odd) {
            width: 30%;
        }
        .db__product-table th:nth-child(even) {
            width: 20%;
        }
        .db__product-table td {
            max-width: 1px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        .db__product-table th,
        .db__product-table tr:not(:last-child) td {
            box-shadow: 0 -1px 0 hsla(0,0%,50%,0.3) inset;
        }
        .db__product-table thead,
        .db__product-table td + td {
            display: none;
        }
        .db__progress {
            background-image: linear-gradient(90deg,var(--primary),var(--secondary),var(--tertiary));
            height: 0.25em;
            margin-bottom: 1.25em;
            overflow: hidden;
            position: relative;
        }
        .db__progress-fill {
            background-color: var(--gray2);
            position: absolute;
            top: -1px;
            right: 0;
            bottom: -1px;
            left: 0;
            transition:
                background-color var(--trans-dur),
                transform var(--trans-dur) ease-in-out;
        }
        .db__select {
            border-radius: 0.2em;
            display: inline-flex;
            align-items: center;
            margin-right: 1em;
            padding: 0.75em 1.5em;
            transition:
                background-color var(--trans-dur),
                box-shadow var(--trans-dur),
                color var(--trans-dur);
        }
        .db__select:focus {
            outline: transparent;
        }
        .db__select:focus,
        .db__select:hover {
            background-color: hsla(0,0%,100%,0.7);
        }
        .db__select:last-child {
            margin-right: 0;
        }
        .db__select::after {
            box-shadow: -0.125em -0.125em 0 0 currentColor inset;
            content: "";
            display: inline-block;
            margin-left: 1.25em;
            width: 0.5em;
            height: 0.5em;
            transform: translateY(-0.125em) rotate(45deg);
        }
        .db__select-icon {
            margin-right: 0.75em;
            width: 1.5em;
            height: 1.5em;
        }
        .db__status {
            transition: color var(--trans-dur);
        }
        .db__status::before {
            background-color: currentColor;
            border-radius: 50%;
            content: "";
            display: inline-block;
            margin-right: 0.5em;
            width: 0.5em;
            height: 0.5em;
            vertical-align: 0.1em;
        }
        .db__status--green {
            color: hsl(123,90%,25%);
        }
        .db__status--orange {
            color: hsl(33,90%,35%);
        }
        .db__status--red {
            color: hsl(3,90%,35%);
        }
        .db__subheading {
            font-size: 1.5em;
            line-height: 1;
            margin-bottom: 1.5rem;
        }
        .db__toolbar {
            color: var(--gray1);
            min-height: 3em;
        }
        .db__toolbar-btns {
            margin-top: 1em;
        }
        .db__top-stat {
            font-size: 1em;
            font-weight: normal;
            margin-bottom: 1em;
        }
        small,
        time,
        .db__bars-cell,
        .db__product-table th,
        .db__top-stat {
            color: var(--gray7);
            transition:
                background-color var(--trans-dur),
                color var(--trans-dur);
        }

        /* `:focus-visible` support */
        @supports selector(:focus-visible) {
            .db__select:focus {
                background-color: hsla(0,0%,100%,0.5);
            }
            .db__select:focus-visible,
                .db__select:hover {
                background-color: hsla(0,0%,100%,0.7);
            }
        }

        /* Dark theme */
        @media (prefers-color-scheme: dark) {
            body,
            button {
                color: var(--gray1);
            }
            .db__bars-cell-bar-fill,
            .db__progress-fill {
                background-color: var(--gray9);
            }
            .db__order-cat {
                background-color: hsla(var(--hue),90%,65%,0.2);
            }
            .db__order-cat-icon {
                color: hsl(var(--hue),90%,65%);
            }
            .db__cell,
            .db__select {
                background-color: hsla(var(--hue),10%,10%,0.7);
                box-shadow:
                    0 0 0 1px hsla(var(--hue),10%,10%,0.7) inset,
                    0 0 0 2px hsla(0,0%,100%,0.2) inset,
                    0 0 0.75em hsl(var(--hue),10%,10%,0.3);
            }
            .db__select:focus,
            .db__select:hover {
                background-color: hsla(var(--hue),10%,25%,0.7);
            }
            .db__status--green {
                color: hsl(123,90%,40%);
            }
            .db__status--orange {
                color: hsl(33,90%,70%);
            }
            .db__status--red {
                color: hsl(3,90%,70%);
            }
            small,
            time,
            .db__bars-cell,
            .db__product-table th,
            .db__top-stat {
                color: var(--gray3);
            }

            /* `:focus-visible` support */
            @supports selector(:focus-visible) {
                .db__select:focus {
                    background-color: hsla(var(--hue),10%,10%,0.7);
                }
                .db__select:focus-visible,
                    .db__select:hover {
                    background-color: hsla(var(--hue),10%,25%,0.7);
                }
            }
        }

        /* Tablet */
        @media (min-width: 768px) {
            .db {
                grid-template-columns: 1fr 1fr 2fr;
                grid-template-areas:
                    "a a g"
                    "b b g"
                    "c d g"
                    "e e h"
                    "e e h"
                    "f f h";
            }
            .db__bubble {
                width: 16em;
                height: 16em;
                transform: translate(-50%,-50%) translate(-4em,-2em);
            }
            .db__bubble:nth-child(2) {
                width: 12rem;
                height: 12rem;
                transform: translate(-50%,-50%) translate(6rem,-1rem);
            }
            .db__bubble:nth-child(3) {
                width: 8rem;
                height: 8rem;
                transform: translate(-50%,-50%) translate(1rem,6rem);
            }
            .db__bubbles {
                height: 20em;
            }
            .db__cell:nth-child(2) {
                grid-area: b;
            }
            .db__cell:nth-child(3) {
                grid-area: c;
            }
            .db__cell:nth-child(4) {
                grid-area: d;
            }
            .db__cell:nth-child(5) {
                grid-area: e;
            }
            .db__cell:nth-child(6) {
                grid-area: f;
            }
            .db__cell:nth-child(7) {
                grid-area: g;
            }
            .db__cell:nth-child(8) {
                grid-area: h;
            }
            .db__product-table thead {
                display: table-header-group;
            }
            .db__product-table td {
                display: none;
            }
            .db__product-table td + td {
                display: table-cell;
            }
            .db__toolbar {
                grid-area: a;
            }
        }

        /* Desktop */
        @media (min-width: 1024px) {
            .db__toolbar {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
            .db__toolbar-btns {
                margin-top: 0;
            }
        }
        @media (min-width: 1280px) {
            .db {
                grid-template-columns: 1fr 1fr 1fr 2fr;
                grid-template-areas:
                    "a a a g"
                    "b c d g"
                    "e e e g"
                    "e e e h"
                    "f f f h"
                    "f f f h";
            }
        }
        .dashboard-widget.color-1 .dashboard-widget-icon {
            background: #A855F7;
            color: #fff;
        }
        .dashboard-widget-icon {
            width: 50px;
            height: 50px;
            display: flex
                ;
            align-items: center;
            justify-content: center;
            font-size: 32px;
            border-radius: 50px;
        }

        .btn-outline-secondary {
            background: #e2ebdd;


        }


        img {
            max-width: 100%;
        }

        .preview {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-orient: vertical;
            -webkit-box-direction: normal;
            -webkit-flex-direction: column;
            -ms-flex-direction: column;
            flex-direction: column;
        }
        @media screen and (max-width: 996px) {
            .preview {
                margin-bottom: 20px;
            }
        }

        .preview-pic {
            -webkit-box-flex: 1;
            -webkit-flex-grow: 1;
            -ms-flex-positive: 1;
            flex-grow: 1;
        }

        .preview-thumbnail.nav-tabs {
            border: none;
            margin-top: 15px;
        }
        .preview-thumbnail.nav-tabs li {
            width: 18%;
            margin-right: 2.5%;
        }
        .preview-thumbnail.nav-tabs li img {
            max-width: 100%;
            display: block;
        }
        .preview-thumbnail.nav-tabs li a {
            padding: 0;
            margin: 0;
        }
        .preview-thumbnail.nav-tabs li:last-of-type {
            margin-right: 0;
        }

        .tab-content {
            overflow: hidden;
        }
        .tab-content img {
            width: 100%;
            -webkit-animation-name: opacity;
            animation-name: opacity;
            -webkit-animation-duration: .3s;
            animation-duration: .3s;
        }

        .card {

            background: #fff;
            padding: 3em;
            line-height: 1.5em;
        }

        @media screen and (min-width: 997px) {
            .wrapper {
                display: -webkit-box;
                display: -webkit-flex;
                display: -ms-flexbox;
                display: flex;
            }
        }

        .details {
            display: -webkit-box;
            display: -webkit-flex;
            display: -ms-flexbox;
            display: flex;
            -webkit-box-orient: vertical;
            -webkit-box-direction: normal;
            -webkit-flex-direction: column;
            -ms-flex-direction: column;
            flex-direction: column;
        }

        .colors {
            -webkit-box-flex: 1;
            -webkit-flex-grow: 1;
            -ms-flex-positive: 1;
            flex-grow: 1;
        }

        .product-title, .price, .sizes, .colors {
            text-transform: UPPERCASE;
            font-weight: bold;
        }

        .checked, .price span {
            color: #ff9f1a;
        }

        .product-title, .rating, .product-description, .price, .vote, .sizes {
            margin-bottom: 15px;
        }

        .product-title {
            margin-top: 0;
        }

        .not-available {
            text-align: center;
            line-height: 2em;
        }
        .not-available:before {
            font-family: fontawesome;
            content: "\f00d";
            color: #fff;
        }


        @-webkit-keyframes opacity {
            0% {
                opacity: 0;
                -webkit-transform: scale(3);
                transform: scale(3);
            }
            100% {
                opacity: 1;
                -webkit-transform: scale(1);
                transform: scale(1);
            }
        }

        @keyframes opacity {
            0% {
                opacity: 0;
                -webkit-transform: scale(3);
                transform: scale(3);
            }
            100% {
                opacity: 1;
                -webkit-transform: scale(1);
                transform: scale(1);
            }
        }

        /*# sourceMappingURL=style.css.map */

    </style>
    <style>



        .slider {
            display: flex;
            flex-direction: column;
            gap: 10px;
            width: 120px; /* Width for vertical thumbnails */
        }

        .slider img {
            width: 100%;
            border: 1px solid #ddd;
            border-radius: 5px;
            cursor: pointer;
        }

        .main-image {
            flex: 1;
            text-align: center;
        }

        .main-image img {
            max-width: 100%;
            max-height: 500px;
            border: 1px solid #ddd;
            border-radius: 8px;
        }

        @media only screen and (min-width: 1200px) {
            .change {

                display: none;
            }
        }
        @media only screen and (max-width: 768px) {
            .exchange {

                display: none;
            }
        }
        @media only screen and (max-width: 768px) {
            .ange {

                width: 100%;
            }
        }


    </style>
    <body class="nav-md">
        <div class="container body">
            <div class="main_container">
                <div class="col-md-3 left_col">
                    <div class="left_col scroll-view">
                        <div class="navbar nav_title" style="border: 0;">
                            <a href="min-dashboard.php" class="site_title"><img src="logo/genie-logo.png" alt="alt" width="50" height="50"/>&nbsp;<span style="margin-left: 29px;
                                                                                                                                                        font-size: 27px;">Admin</span></a>
                        </div>
                        <div class="clearfix"></div>

                        <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
                            <div class="menu_section">
                                <nav class="side-menu">
                                    <ul>
                                        <!-- Main Menu Item 1 -->
                                        <li class="has-submenu">
                                            <a href="#"><i class="fa fa-shopping-cart" style="    color: #fcc309;"></i><span><p style="padding-left: 30px;
                                                                                                                                margin-top: -20px;">Product Management</p></span></a>
                                            <ul class="submenu">
                                                <li><a href="gft-product-entry.php"><i class="fa fa-plus"></i><p style="padding-left: 30px;
                                                                                                                 margin-top: -20px;">Product Entry</p></a></li>
                                                <li><a href="gft-product-list.php"><i class="fa fa-list-ol"></i><p style="padding-left: 30px;
                                                                                                                   margin-top: -20px;">Product List</p></a></li>
                                            </ul>
                                        </li>

                                        <!-- Main Menu Item 2 with Sub-menu -->
                                        <li class="has-submenu">
                                            <a href="#"><i class="fa fa-gift" style="color: #e02c62;"></i><p style="padding-left: 30px;
                                                                                                             margin-top: -20px;">Vendor Management</p></a>
                                            <ul class="submenu">
                                                <li><a href="gft-vendor.php"><i class="fa fa-plus"></i><p style="padding-left: 30px;
                                                                                                          margin-top: -20px;">Vendor Entry</p></a></li>
                                                <li><a href="gft-vendor-list.php"><i class="fa fa-list-ol"></i><p style="padding-left: 30px;
                                                                                                                  margin-top: -20px;">Vendor List</p></a></li>
                                                <li><a href="gft-vendor-enquiry-list.php"><i class="fa fa-list"></i><p style="padding-left: 30px;
                                                                                                                       margin-top: -20px;">Vendor Enquiry</p></a></li>
                                            </ul>
                                        </li>

                                        <!-- Main Menu Item 3 -->
                                        <li>
                                            <a href="gft-order-list.php"><i class="fa fa-outdent" style="color: #d74dc6;"></i><p style="padding-left: 30px;
                                                                                                                                 margin-top: -20px;">Order Management</p></a>
                                        </li>

                                        <li class="has-submenu">
                                            <a href="#"><i class="fa fa-bookmark-o" style="color: yellowgreen;"></i><p style="padding-left: 30px;
                                                                                                                       margin-top: -20px;">Coupon Management</p></a>
                                            <ul class="submenu">
                                                <li><a href="gft-coupon-create.php"><i class="fa fa-plus"></i><p style="padding-left: 30px;
                                                                                                                 margin-top: -20px;">Create Coupon</p></a></li>
                                                <li><a href="gft-coupon-list.php"><i class="fa fa-list-ol"></i><p style="padding-left: 30px;
                                                                                                                  margin-top: -20px;">Coupon List</p></a></li>
                                            </ul>
                                        </li>

                                        <!-- Main Menu Item 4 with Sub-menu -->
                                        <li class="has-submenu">
                                            <a href="#"><i class="fa fa-cog"></i><p style="padding-left: 30px;
                                                                                    margin-top: -20px;">Settings</p></a>
                                            <ul class="submenu">
                                                <li><a href="gft-banner.php"><i class="fa fa-image"></i><p style="padding-left: 30px;
                                                                                                           margin-top: -20px;">Banner</p></a></li>
                                                <li><a href="gft-occasions.php"><i class="fa fa-shopping-cart"></i><p style="padding-left: 30px;
                                                                                                                      margin-top: -20px;">Occasions</p></a></li>
                                                <li><a href="gft-categories.php"><i class="fa fa-list"></i><p style="padding-left: 30px;
                                                                                                              margin-top: -20px;">Categories</p></a></li>
                                                <li><a href="gft-sub-categories.php"><i class="fa fa-outdent"></i><p style="padding-left: 30px;
                                                                                                                     margin-top: -20px;">Sub-Categories</p></a></li>
                                                <li><a href="gft-delivery-settings.php"><i class="fa fa-image"></i><p style="padding-left: 30px;
                                                                                                           margin-top: -20px;">Delivery Settings</p></a></li>

                                            </ul>
                                        </li>
                                    </ul>
                                </nav>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="top_nav">

                    <div class="nav_menu">
                        <nav class="" role="navigation">
                            <div class="nav toggle">
                                <button style="    background: #008dd2;">  <a id="menu_toggle" style="color: #fff;"><i class="fa fa-bars"></i></a></button>

                            </div>

                            <ul class="nav navbar-nav navbar-right">
                                <li>
                                    <a href="logout.php" style="color: #fff;border-top: 1px #00aaa9 solid;"><i class="fa fa-sign-out"></i> Log Out</a>
                                </li>

                                <li><a style="color: #fff;border-top: 1px #00aaa9 solid;"><i class="fa fa-user" style="padding-right: 8px;
                                                                                             color: yellow;"></i>Welcome, <?php echo $_SESSION['gftgn_admin_name']; ?></a></li>
                            </ul>
                        </nav>
                    </div>

                </div>
                <!-- /top navigation -->

                <!-- page content -->
                <div class="right_col">
                    <?php echo $mainpagecontent; ?>
                    <footer>
                        <div style="padding-top: 10px;">
                            <p class="" style="text-align:center;">Copyright &copy; 2024 Admin @ GiftGenie</p>
                        </div>
                        <div class="clearfix"></div>
                    </footer>
                    <!-- /footer content -->
                </div>
            </div>

        </div>
    </body>
</html>





<!-- Javascripts -->
<script type="text/javascript" src="js/jquery-1.11.1.min.js"></script>
<script type="text/javascript" src="js/jquery.validate.min.js"></script>
<script src="js/jquery-validate.bootstrap-tooltip.min.js"></script>
<script type="text/javascript" src="js/bootstrap.min.js"></script>
<script type="text/javascript" src="js/custom.js"></script>
<!--<script type="text/javascript" src="../js/custom.js"></script>-->


<script type="text/javascript" src="js/bootstrap-datepicker.min.js"></script>
<script type="text/javascript" src="js/moment-with-locales.js"></script>
<script type="text/javascript" src="js/bootstrap-datetimepicker.min.js"></script>

<script type="text/javascript" src="js/loader.js"></script>

<script type="text/javascript">
    document.querySelectorAll('.has-submenu > a').forEach(item => {
        item.addEventListener('click', function (event) {
            const submenu = this.nextElementSibling; // Get the submenu
            submenu.style.display = submenu.style.display === 'block' ? 'none' : 'block';
            event.preventDefault(); // Prevent default link behavior
        });
    });
</script>


<script>
    // Function to change the main image when a thumbnail is clicked
    function changeImage(element) {
        const mainImage = document.getElementById("mainImage");
        mainImage.src = element.src;
    }
</script>

<!--<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>-->
<script>
    $(document).ready(function () {
        $("button").click(function () {
            $("p").toggle();
        });
    });
</script>





<style type="text/css">
    .ajax_loader {
        background: url("../images/loader.gif") no-repeat center center transparent;
        /*                    width: 120%;*/
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: 1000;
    }

</style>