<?php

include_once './classes/DB.class.pg.php';

$db = new DB();

$ProgramId = $_REQUEST['ProgramId'];

$CollegeListArr = $db->selectWithCols("itdc_college_list_tbl", "cid, college_name, program_type, male_female", "program_id='$ProgramId'");
$ProgramTypeArr = array();
$College_Name_Arr = array();
$Gender_Arr = array();

foreach ($CollegeListArr as $CLA) {
    $ProgramTypeArr[$CLA['cid']] = $CLA['program_type'];
    $College_Name_Arr[$CLA['cid']] = $CLA['college_name'];

    if ($CLA['male_female'] == "20") {
        $male_female = "Female";
    } else {
        $male_female = "Both";
    }

    $Gender_Arr[$CLA['cid']] = $male_female;
}


$Student_Arr = $db->selectWithCols("itdc_result_tbl", "result_id,registration_number, login_id, category, subcategory,category_verify, "
        . "general_rank, category_rank, gender", "present_status='P' AND program_id='$ProgramId' AND seat_allotment_status='20' AND employee_ward_quota='20' AND choice_lock_status='10' ORDER BY general_rank ASC");

foreach ($Student_Arr as $SA) {
    $seat_alloted_flag = "2";
    $LoginId = $SA['login_id'];
    $category = $SA['category'];
    $subcategory = $SA['subcategory'];
    $gender = $SA['gender'];
    /*
      Specially Abled (Divyang),
      Ex-Servicemen and martyrs of war, security personnel handicapped in war or their dependents
      Dependants of freedom fighters (Son/daughter/grandson/granddaughter/great-granddaughter/great-grandson)
      Armed Forces Personnel and their dependents (Husband/wife/son/daughter)
      Dependents of kargil martyrs
     */

    $cat_col = "";
    /* Getting the choices */
    $Choice_List_Arr = $db->selectWithCols("itdc_student_choice_tbl", "cid, college_id, subject_one, subject_two, subject_three, choice_series", "status='10' AND student_id='$LoginId' AND program_id='$ProgramId' ORDER BY choice_series ASC");
    foreach ($Choice_List_Arr as $CLA) {

        $under_category_allotment = "";
        $choice_alloted_series = "";

        $program_type = $ProgramTypeArr[$CLA['college_id']];

        $subject_one = $CLA['subject_one'];
        $subject_two = $CLA['subject_two'];
        $subject_three = $CLA['subject_three'];
        $choice_series = $CLA['choice_series'];

        $choice_pk_id = $CLA['cid'];
        $college_id = $CLA['college_id'];
        $college_gender = $Gender_Arr[$CLA['college_id']];

        $seat_alloted_flag = "2";
        $allow_gender_flag = "1";

        if ($college_gender == "Female" && $gender == "Male") {
            /* Here , Gender male is not alloed in female college */
            $allow_gender_flag = "2";
        }

        if ($allow_gender_flag == "1") {
            /* Seat Allotment for UR/Genreral count */
            $cat_col = "GC";

            $SeatAllotmentRes = FunSubjectChoiceProcess($db, $college_id, $choice_pk_id, $choice_series, $cat_col, $program_type, $subject_one, $subject_two, $subject_three);

            if ($SeatAllotmentRes == "ALLOTED") {
                $seat_alloted_flag = "1";
                $under_category_allotment = $cat_col . "-" . "OP";
                $choice_alloted_series = $choice_series;
                /* Seat is alloted no need to read other choices */
                break;
            }

            /* Particular preference not found in General Cateogry. If candidte belongs to General and EWS go for its sub category */
            if ($seat_alloted_flag == "2") {

                if (!empty($subcategory) && ($category == "General" || $category == "General (EWS)")) {
                    $sub_cat_col = "";
                        $cat_col = "GC";
                        if ($subcategory == "Specially Abled (Divyang)") {
                            $sub_cat_col = "GP";
                        } else if ($subcategory == "Ex-Servicemen and martyrs of war, security personnel handicapped in war or their dependents") {
                            $sub_cat_col = "GEX";
                        } else if ($subcategory == "Dependants of freedom fighters (Son/daughter/grandson/granddaughter/great-granddaughter/great-grandson)") {
                            $sub_cat_col = "GF";
                        } else if ($subcategory == "Armed Forces Personnel and their dependents (Husband/wife/son/daughter)") {
                            $sub_cat_col = "GS";
                        } else if ($subcategory == "Displaced Kashmiri Pandits/Kashmiri Pandits residing in the Kashmir Valley/dependents of Kashmiri hindu families") {
                            $sub_cat_col = "GKM";
                        } else if ($subcategory == "Dependents of kargil martyrs") {
                            $sub_cat_col = "GKG";
                        }

                    $SeatAllotmentRes = "";

                    $SeatAllotmentRes = FunSubjectChoiceProcess($db, $college_id, $choice_pk_id, $choice_series, $sub_cat_col, $program_type, $subject_one, $subject_two, $subject_three);

                    if ($SeatAllotmentRes == "ALLOTED") {
                        $seat_alloted_flag = "1";
                        $under_category_allotment = $cat_col . "-" . $sub_cat_col;
                        $choice_alloted_series = $choice_series;

                        /* Seat is alloted no need to read other choices */
                        break;
                    }
                }
            }

            /* Particular preference not found in General; then Go For category if */

            if ($seat_alloted_flag == "2") {
                $cat_col = "";
                if ($category == "OBC") {
                    $cat_col = "BC";
                } else if ($category == "SC") {
                    $cat_col = "SC";
                } else if ($category == "ST") {
                    $cat_col = "ST";
                } else if ($category == "General (EWS)") {
                    $cat_col = "EWS";
                }

                $SeatAllotmentRes = "";
                if ($cat_col == "BC" || $cat_col == "SC" || $cat_col == "ST" || $cat_col == "EWS") {

                    $SeatAllotmentRes = FunSubjectChoiceProcess($db, $college_id, $choice_pk_id, $choice_series, $cat_col, $program_type, $subject_one, $subject_two, $subject_three);

                    if ($SeatAllotmentRes == "ALLOTED") {
                        $seat_alloted_flag = "1";
                        $under_category_allotment = $cat_col . "-" . "OP";
                        $choice_alloted_series = $choice_series;

                        /* Seat is alloted no need to read other choices */
                        break;
                    }
                }
            }
        }
    }

    $AddedDateTime = DATE('Y-m-d H:i:s');

    if ($seat_alloted_flag == "1") {
        /* Alloted */

        $UpdateResult = array(
            "seat_allotment_status" => "10",
            "allotment_under_category" => "$under_category_allotment",
            "choice_series" => "$choice_series",
            "choice_pk_id" => "$choice_pk_id"
        );

        $db->update($UpdateResult, "itdc_result_tbl", "login_id='$LoginId' AND program_id='$ProgramId'");

        $SelProgram = array(
            "seat_allotment_status" => "10",
            "allotment_date" => "$AddedDateTime",
            "allotment_under_category" => "$under_category_allotment",
            "choice_series" => "$choice_series",
            "choice_pk_id" => "$choice_pk_id"
        );

        $db->update($SelProgram, "itdc_selected_program_tbl", "login_id='$LoginId' AND program_id='$ProgramId'");

        $SelectChoice = array(
            "seat_allotment_status" => "10"
        );

        $db->update($SelectChoice, "itdc_student_choice_tbl", "cid='$choice_pk_id' AND student_id='$LoginId' AND program_id='$ProgramId'");
    } else if ($seat_alloted_flag == "2") {
        /* Not Alloted */

        if (!empty($subcategory)) {
            /* One More chance to allot at Sub Category Side */
        } else {
            $SelProgram = array(
                "seat_allotment_status" => "30"
            );

            $db->update($SelProgram, "itdc_selected_program_tbl", "login_id='$LoginId' AND program_id='$ProgramId'");

            $db->update($SelProgram, "itdc_result_tbl", "login_id='$LoginId' AND program_id='$ProgramId'");
        }
    }
}

function FunSubjectChoiceProcess($db, $college_id, $choice_pk_id, $choice_series, $cat_type_col, $program_type, $subject_one, $subject_two = "", $subject_three = "") {
    $Choice_One_status = "";
    $Choice_Two_status = "";
    $Choice_Three_status = "";

    if ($program_type == "three_subject") {

        $Choice_One_status = FunGettingSeat($db, $cat_type_col, $program_type, $subject_one);

        if ($Choice_One_status > 0) {
            $Choice_Two_status = FunGettingSeat($db, $cat_type_col, $program_type, $subject_two);

            if ($Choice_Two_status > 0) {
                $Choice_Three_status = FunGettingSeat($db, $cat_type_col, $program_type, $subject_three);
            }
        }
    } else if ($program_type == "one_group") {

        $Choice_One_status = FunGettingSeat($db, $cat_type_col, $program_type, $subject_one);
        $Choice_Two_status = 1;
        $Choice_Three_status = 1;
    } else if ($program_type == "only_college") {

        $Choice_One_status = FunGettingSeat($db, $cat_type_col, $program_type, $college_id);
        $Choice_Two_status = 1;
        $Choice_Three_status = 1;
    }


    if ($Choice_One_status > 0 && $Choice_Two_status > 0 && $Choice_Three_status > 0) {
        $Seat_alloted_cat = $cat_type_col;
        $Choice_Prefer_order = $choice_series;

        if ($program_type == "three_subject") {

            /* One Seat is reduced for each subject */
            $res_Choice_One_status = $Choice_One_status - 1;
            UpdateSeat($db, $res_Choice_One_status, $cat_type_col, $program_type, $subject_one);

            $res_Choice_Two_status = $Choice_Two_status - 1;
            UpdateSeat($db, $res_Choice_Two_status, $cat_type_col, $program_type, $subject_two);

            $res_Choice_Three_status = $Choice_Three_status - 1;
            UpdateSeat($db, $res_Choice_Two_status, $cat_type_col, $program_type, $subject_three);
        } else if ($program_type == "one_group") {
            /* One Seat is reduced for  group */
            $res_Choice_One_status = $Choice_One_status - 1;
            UpdateSeat($db, $res_Choice_One_status, $cat_type_col, $program_type, $subject_one);
        } else if ($program_type == "only_college") {

            $res_Choice_One_status = $Choice_One_status - 1;
            UpdateSeat($db, $res_Choice_One_status, $cat_type_col, $program_type, $college_id);
        }

        return "ALLOTED";
        /* Seat Alloted */
    } else {
        return "NOTALLOTED";
    }
}

function FunGettingSeat($db, $final_cat_col, $program_type, $RefId) {
    if ($program_type == "three_subject" || $program_type == "one_group") {
        $Seat_Avail_Arr = $db->selectWithCols("itdc_college_subject_c1_tbl", "$final_cat_col", "sid='$RefId'");
        $get_seat_val = $Seat_Avail_Arr['0'][$final_cat_col];
    } else if ($program_type == "only_college") {
        $Seat_Avail_Arr = $db->selectWithCols("itdc_college_list_c1_tbl", "$final_cat_col", "cid='$RefId'");

        $get_seat_val = $Seat_Avail_Arr['0'][$final_cat_col];
    }

    if (empty($get_seat_val) || $get_seat_val == NULL) {
        $get_seat_val = 0;
    }

    return $get_seat_val;
}

function UpdateSeat($db, $rem_seat_val, $final_cat_col, $program_type, $RefId) {

    if ($program_type == "three_subject" || $program_type == "one_group") {

        $data_arr = array("$final_cat_col" => "$rem_seat_val");
        $db->update($data_arr, "itdc_college_subject_c1_tbl", "sid='$RefId'");
    } else {
        $data_arr = array("$final_cat_col" => "$rem_seat_val");

        $db->update($data_arr, "itdc_college_list_c1_tbl", "cid='$RefId'");
    }
}

?>