<?php
ob_start();
include_once './qualifying-degree.inc.php';

date_default_timezone_set("Asia/Kolkata");
$portal_closed = "10";
$today_portalclosedate = date('Y-m-d');
$expiry_portalclosedate = "2025-07-31";
if (strtotime($today_portalclosedate) > strtotime($expiry_portalclosedate)) {
    $portal_closed = 10;
} else {
    $portal_closed = 20;
}
if (($row_studentdetails['registration_fee_status'] == "10") && ($row_studentdetails['final_submit'] == "20")) {
    $portal_closed = 20;
}
if ($row_studentdetails['registration_fee_status'] == "10") {
    if ($_SESSION['action_performsession'] == "STLKO") {
        $portal_closed = 20;
    }
}

if ($portal_closed == "10") {
    header('location:index.php');
}
//Eligibility
?>
<div class="boxed-area-white">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <fieldset>
                    <legend class="text-uppercase text-warning">Qualifying Examination</legend>
                    <form method="post" id="qualifying_examination_formid" enctype="multipart/form-data" class="form-horizontal">
                        <div class="col-md-9">
                            <div id="form_successmsgid"></div>
                            <div class="">                           
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Name of Qualifying Examination <span class="text-danger">*</span></label>
                                    <div class="col-sm-8"> 
                                        <select class="form-control" readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)" name="qualifying_examination" id="qualifying_examination">
                                                    <?php
                                                    if (mysqli_num_rows($result_ugprogramlist) > 0) {
                                                        while ($row_ugprogramlist = mysqli_fetch_array($result_ugprogramlist)) {
                                                            ?>
                                                    <option value="<?php echo $row_ugprogramlist['id']; ?>" <?php if ($row_studentdetails['qualifying_examination'] == $row_ugprogramlist['id']) { ?> selected="" <?php } ?>><?php echo common::StrFromDb($row_ugprogramlist['program_name']); ?></option>
                                                    <?php
                                                }
                                            }
                                            ?>
                                        </select>
                                        <span class="text-danger"><small><?php echo $error_msg['examination_name']; ?></small></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Year <span class="text-danger">*</span></label>
                                    <div class="col-sm-8">   
                                        <select name="passing_year" id="passing_year" class="form-control">
                                            <option value="">--Select Year--</option>
                                            <?php
                                            $fyears_array = range(date('Y'), date('Y') - 60);
                                            foreach ((array) $fyears_array as $fyears_key) {
                                                ?>
                                                <option value="<?php echo $fyears_key; ?>" <?php if ($fyears_key == $row_studentdetails['passing_year']) { ?> selected="" <?php } ?>><?php echo $fyears_key; ?></option>
                                            <?php } ?>
                                        </select>
                                        <span class="text-danger"><small><?php echo $error_msg['passing_year']; ?></small></span>
                                    </div>
                                </div>  
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Institution/University <span class="text-danger">*</span></label>
                                    <div class="col-sm-8"> 
                                        <input type="text" onpaste="return false;" onCopy="return false" onCut="return false" name="board_university" id="board_university" class="form-control" placeholder="Enter Institution" value="<?php echo common::StrFromDb($row_studentdetails['board_university']); ?>"/>
                                        <span class="text-danger"><small><?php echo $error_msg['board_university']; ?></small></span>
                                    </div>
                                </div>
                                <?php 
                                /*SK For JEE 12th Subject is addede*/
                                if($row_studentdetails['qualifying_examination'] == "4"){ ?>
                                        <div class="form-group">
                                    <label class="col-sm-4 control-label">Intermediate Subject <span class="text-danger">*</span></label>
                                    <div class="col-sm-8"> 
                                        <input type="text" onpaste="return false;" onCopy="return false" onCut="return false" name="qualifying_subject_intm" id="qualifying_subject_intm" class="form-control" placeholder="Enter comma separated subjects of Intermediate" value="<?php echo common::StrFromDb($row_studentdetails['qualifying_subject_intm']); ?>"/>
                                        <span class="text-danger"><small><?php echo $error_msg['subject']; ?></small></span>
                                    </div>
                                </div>
                                <?php } ?>
                                <?php if($row_studentdetails['polytechnic_branch']!="") { ?>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Polytechnic Branch <span class="text-danger">*</span><div class="clearfix"></div></label>
                                    <div class="col-sm-8">                                
                                        <input type="text" readonly="" onmousedown="(function (e) {
                                                    e.preventDefault();
                                                })(event, this)" onpaste="return false;" onCopy="return false" onCut="return false" name="polytechnic_branch" id="polytechnic_branch" class="form-control" placeholder="Polytechnic Branch" value="<?php echo common::StrFromDb($row_studentdetails['polytechnic_branch']); ?>"/>
                                    </div>
                                </div>
                                <?php } ?>
                                <?php if ($row_studentdetails['qualifying_examination'] != "35-20") { ?>
                                    <div class="form-group">
                                        <label class="col-sm-4 control-label">Status <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">                                
                                            <label class="radio-inline">
                                                <input type="radio" onchange="QualiStatusFun(this.value);" name="status_aboveprogram" <?php if ($row_studentdetails['status_aboveprogram'] == "10") { ?> checked="" <?php } ?> value="10"  style="margin-top: 2px;">Passed
                                            </label>
                                            <label class="radio-inline">
                                                <input type="radio" onclick="(function (e) {
                                                                e.preventDefault();
                                                            })(event, this)" readonly="" name="status_aboveprogram" <?php if ($row_studentdetails['status_aboveprogram'] == "20") { ?> checked="" <?php } ?> value="20"  style="margin-top: 2px;">Appearing
                                            </label>
                                            <div class="clearfix"></div>
                                            <small><span class="text-danger"></span></small>
                                        </div>
                                    </div>
                                    <div class="form-group" id="marksdivid_pg" style=" <?php if ($row_studentdetails['status_aboveprogram'] == "20") { ?> display:none; <?php } ?> ">
                                        <label class="col-sm-4 control-label">Marks <span class="text-danger">*</span>
                                            <!--<div class="clearfix"></div><small>(Total marks of all the subjects shown on your class 12 marksheet)</small>--> 
                                        </label>
                                        <div class="col-sm-2">                              
                                            <input type="text" <?php if ($total_max_marks > 0) { ?> readonly="" <?php } ?> onpaste="return false;" onblur="CalculateStudentMarks();" onCopy="return false" onCut="return false" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" id="total_max_marks" name="total_max_marks" class="form-control" placeholder="Total Marks" value="<?php echo $total_max_marks; ?>">
                                            <span class="text-danger"><small><?php echo $error_msg['total_max_marks']; ?></small></span>
                                        </div>
                                        <div class="col-sm-2" style="padding-left: 5px;padding-right: 10px;">                              
                                            <input type="text" <?php if ($total_obtained_marks > 0) { ?> readonly="" <?php } ?> onpaste="return false;" onblur="CalculateStudentMarks();" onCopy="return false" onCut="return false" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" id="total_obtained_marks" name="total_obtained_marks" class="form-control" placeholder="Obtained Marks" value="<?php echo $total_obtained_marks; ?>">
                                            <span class="text-danger"><small><?php echo $error_msg['total_obtained_marks']; ?></small></span>
                                        </div>
                                        <div class="col-sm-1"><strong>OR</strong></div>
                                        <div class="col-sm-3" style="padding-left: 0px;padding-right: 0px;">                              
                                            <input type="text" <?php if ($enter_cgpa > 0) { ?> readonly="" <?php } ?> max="10" onpaste="return false;" onCopy="return false" onCut="return false" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" id="enter_cgpa" name="enter_cgpa" class="form-control" placeholder="CGPA" value="<?php echo $enter_cgpa; ?>">
                                            <span class="text-danger"><small><?php echo $error_msg['enter_cgpa']; ?></small></span>
                                        </div>
                                    </div>
                                    <div class="form-group" style="display: none;">
                                        <label class="col-sm-4 control-label">Percentage <span class="text-danger">*</span></label>
                                        <div class="col-sm-8">
                                            <div class="input-group input-group-sm">
                                                <input type="text" id="total_percentage" name="total_percentage" readonly="" class="form-control" placeholder="Percentage" value="<?php echo $row_qualifyingdetails['total_percentage']; ?>">
                                                <span class="input-group-addon" style="line-height: 15px;padding: 4px 10px;">% </span>                               
                                            </div>
                                            <span class="text-danger"><small><?php echo $error_msg['total_percentage']; ?></small></span>
                                        </div>
                                    </div>
                                <?php } ?>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label"></label>
                                    <div class="col-sm-7">   <br/>                        
                                        <input type="submit" name="education_basic_submit" id="education_basic_submit" value="Submit" class="btn btn-primary btn-sm"/>
                                        <a id="processing_divid" class="btn btn-primary btn-sm" style="display: none;">Processing...</a>
                                    </div>
                                </div>  
                            </div>
                        </div> 
                    </form>
                </fieldset> 
            </div>
        </div>
    </div>
</div>
<div class="clearfix"></div><br/><br/>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'qualifying_examination';
$HTMLTITLE = '';
$HTMLDESCRIPTION = '';
$HTMLKEYWORDS = '';
include("./masters/user-master.php");
?>
<script type="text/javascript">

    function ChangeQualifyingExamination(examination_name) {
        if (examination_name === 'Intermediate') {
            $('#enter_examination_divid').hide();
        } else if (examination_name === 'Others') {
            $('#enter_examination_divid').show();
        }
    }

    function CalculateStudentMarks() {
        var total_max_marks = $('#total_max_marks').val();
        var total_obtained_marks = $('#total_obtained_marks').val();
        var marks_percentage = 0;
        var max_marks = 0;
        var obtained_marks = 0;
        var tt = $.isNumeric(total_max_marks);
        if ((total_max_marks != "") && ($.isNumeric(total_max_marks) === true)) {
            max_marks = Number(total_max_marks);
        }
        if ((total_obtained_marks != "") && ($.isNumeric(total_obtained_marks) === true)) {
            obtained_marks = Number(total_obtained_marks);
        }
        if (Number(max_marks) >= Number(obtained_marks)) {
            marks_percentage = Number(obtained_marks) * 100 / Number(max_marks);
            if ((marks_percentage != "") && ($.isNumeric(marks_percentage) === true)) {
                $('#total_percentage').val(marks_percentage.toFixed(2));
            }
        } else {
            $('#total_max_marks').val('');
            $('#total_obtained_marks').val('');
            $('#total_percentage').val('');
            alert('Please enter valid marks. The marks obtained cannot exceed the total marks.');
        }
    }

    function QualiStatusFun(qustatus) {
        if (qustatus == '10') {
            $('#marksdivid_pg').show();
        } else {
            $('#marksdivid_pg').hide();
        }
    }

    $(function () {
        $('#enter_cgpa').on('input', function () {
            match = (/(\d{0,2})[^.]*((?:\.\d{0,2})?)/g).exec(this.value.replace(/[^\d.]/g, ''));
            this.value = match[1] + match[2];
        });
        $('#total_max_marks').on('input', function () {
            match = (/(\d{0,4})[^.]*((?:\.\d{0,2})?)/g).exec(this.value.replace(/[^\d.]/g, ''));
            this.value = match[1] + match[2];
        });
        $('#total_obtained_marks').on('input', function () {
            match = (/(\d{0,4})[^.]*((?:\.\d{0,2})?)/g).exec(this.value.replace(/[^\d.]/g, ''));
            this.value = match[1] + match[2];
        });
    });
</script>