<?php

error_reporting(E_ERROR | E_PARSE);
include_once './preview.inc.php';
require_once('../tcpdf/tcpdf.php');

class MYPDF extends TCPDF {

    public function Header() {
        $objectnew = new class_student();
        $student_id = $objectnew->student_id = $_SESSION['student_sessionid'];
        $result_studentdetails = $objectnew->GetStudentDetails();
        if (mysqli_num_rows($result_studentdetails) > 0) {
            $row_studentdetails = mysqli_fetch_assoc($result_studentdetails);
        }
        $this->SetFont('helvetica', 'B', 8);
        $view_tbl .= '<br/>
<table width="100%" cellpadding="0" cellspacing="0" style="font-size: 18px;">
<tr>
<td colspan="2" width="100%" style="line-height: 24px;text-align:center;">
<br/><b style="font-size: 14px;">Isabella Thoburn College, Lucknow</b>
<br/><b style="font-size: 12px;">PROVISIONAL ADMISSION COUNSELLING APPLICATION FORM FOR ' . $row_studentdetails[course] . '</b>
<br/><b style="font-size: 12px;">SESSION - 2022-2023</b>
</td>
</tr>
</table>';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    public function Footer() {
        $this->SetY(-25);

        $this->SetFont('helvetica', 'I', 8);
        $view_tbl .= '';

//        $view_tbl .= '';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }

}

$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Isabella Thoburn College, Lucknow');
$pdf->SetTitle('Isabella Thoburn College, Lucknow');
$pdf->SetSubject('Isabella Thoburn College, Lucknow');
$pdf->SetKeywords('Isabella Thoburn College, Lucknow');
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
$pdf->AddPage('A4');
$today_date = date("Y-m-d");
$display_date = date("d-m-Y");
$today_date = date("d-M, Y", strtotime($today_date));

$file_name = "Student-" . $row_studentdetails['registration_number'] . ".pdf";
$date_birth = "";
if ($row_studentdetails['date_birth'] != "0000-00-00") {
    $date_birth = common::StrFromDb($row_studentdetails['date_birth']);
}

$view_tbl .= '<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8"/>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
        <meta name="description" content=""/>
        <meta name="author" content=""/>
        <title>Isabella Thoburn College, Lucknow</title>
        <style type="text/css">
            body, html{
                font-family: arial;
                font-size: 12px;
            }
            td{
                padding: 5px;
            }
        </style>
    </head>
    <body>
<table border="0" cellspacing="0" width="100%">
<tr>
            <td valign="top" width="75%">
                <table cellspacing="0" cellpadding="2" border="0" class="this"  width="100%">
                    <tr>
                        <td class="this" width="45%">Roll No.</td>
                        <td class="this" class="this" width="55%">' . common::StrFromDb($row_studentdetails[test_roll_number]) . '</td>
                    </tr>
                    <tr>
                        <td class="this">College Roll No.</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['college_rollnumber']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Full Name of Candidate</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['student_name']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Full Name of Father</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['father_name']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Full Name of Mother</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['mother_name']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Fathers/Guardians Designation</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['father_designation']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Guardians Mobile Number</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['father_mobile']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Date of Birth (YYYY-MM-DD)</td>
                        <td class="this">' . $date_birth . '</td>
                    </tr>
                    <tr>
                        <td class="this">Mobile Number</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['mobile_number']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Aadhaar Card No.</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['aadhar_number']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Email Id</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['email_id']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Gender</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['gender']) . '</td>
                     </tr>
                    <tr>
                        <td class="this">Course</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['course']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Nationality</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['nationality']);
if ($row_studentdetails['nationality'] == "Others") {
    if ($row_studentdetails['enter_nationality'] != "") {
        $view_tbl .= '(' . common::StrFromDb($row_studentdetails['enter_nationality']) . ')';
    }
}
$view_tbl .= '</td></tr>
                    <tr>
                        <td class="this">Candidate Belonging to State</td>
                        <td class="this">';

if ($row_studentdetails['state'] == "Others") {
    if ($row_studentdetails['enter_state'] != "") {
        $view_tbl .= common::StrFromDb($row_studentdetails['state']) . ' (' . common::StrFromDb($row_studentdetails['enter_state']) . ')';
    }
} else {
    if (mysqli_num_rows($result_masterstate) > 0) {
        while ($row_masterstate = mysqli_fetch_array($result_masterstate)) {
            if ($row_masterstate['state_id'] == $row_studentdetails['state']) {
                $view_tbl .= common::StrFromDb($row_masterstate['state_name']);
            }
        }
    }
}
$view_tbl .= '</td></tr>
                    <tr>
                        <td class="this">Candidate Belonging to Religion</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['religion']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Category</td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['category']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Candidate Privilege Category </td>
                        <td class="this">';

if ($row_studentdetails['privilege_category'] == '10') {
    $view_tbl .= 'Christian';
}
if ($row_studentdetails['privilege_category'] == '20') {
    $view_tbl .= 'Student Passout from IT College Intermediate of 2022';
}
if ($row_studentdetails['privilege_category'] == '30') {
    $view_tbl .= 'LUAC Candidate (Lucknow University Associated College Candidates)';
}
if ($row_studentdetails['privilege_category'] == '40') {
    $view_tbl .= 'Daughter of IT College Faculty & Staff';
}

$view_tbl .= '</td></tr>
                    <tr>
                        <td class="this">Divyangian </td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['divyangjan']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Full Present Address </td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['present_address']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Pincode </td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['pincode']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">City Name </td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['city_name']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Office Address </td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['office_address']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Max Marks </td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['max_marks']) . '</td>
                    </tr>
                    <tr>
                        <td class="this">Obtained Marks </td>
                        <td class="this">' . common::StrFromDb($row_studentdetails['obtained_marks']) . '</td>
                    </tr>';
$view_tbl .= '</table>
</td>
<td valign="top" width="25%" style="text-align:center;">';
if ($passport_photograph != "") {
    $view_tbl .= '<img src="upload_docs/' . $passport_photograph . '" style="height: 130px;"/>';
}
$view_tbl .= '</td></tr></table>';
if ($row_studentdetails['first_subject'] != "") {
    $objectnew = new class_student();
    $result_selectedcourse = $objectnew->GetSelectedSubjectList($row_studentdetails['first_subject'], $row_studentdetails['second_subject'], $row_studentdetails['third_subject'], $row_studentdetails['four_subject']);
    $view_tbl .= '<br/>&nbsp;<br/>&nbsp;<strong>Selected Subjects</strong><br/>
        <table border="0" cellspacing="0" width="100%">
          <tr>
            <td valign="top" width="100%">
                <table cellspacing="0" cellpadding="2" border="0" class="this" width="95%">';
    if (mysqli_num_rows($result_selectedcourse) > 0) {
        $s = 1;
        while ($row_selectedcourse = mysqli_fetch_array($result_selectedcourse)) {
            $subject_label = "";
            if ($s == "1") {
                $subject_label = "Major 1";
            } elseif ($s == "2") {
                $subject_label = "Major 2";
            } elseif ($s == "3") {
                $subject_label = "Minor 1";
            } elseif ($s == "4") {
                $subject_label = "Co-curricular Activities Subject";
            }
            $view_tbl .= '<tr>
                        <td class="this">' . $subject_label . ' </td>
                        <td class="this">' . common::StrFromDb($row_selectedcourse['subject_name']) . '</td>
                    </tr>';
            $s++;
        }
    }
    $view_tbl .= '</table></td></tr></table>';
}
if (mysqli_num_rows($result_uploadeddocument) > 0) {
    $view_tbl .= '<br/>&nbsp;<br/>&nbsp;<strong>Uploaded Files</strong><br/>
                    <table border="0" cellspacing="0" width="100%">
<tr>
            <td valign="top" width="100%">
        <table cellspacing="0" cellpadding="2" border="0" class="this">
                                            <tr style="color: #00618a;">
                                                <th width="100%" class="this">File Type</th>
                                            </tr><tr><td class="this">';
    $i = 1;
    foreach ((array) $row_uploadeddocument_array as $row_uploadeddocument_key) {
        $view_tbl .= '(' . $i . ') ' . $row_uploadeddocument_key['document_name'] . '&nbsp;&nbsp;';
        $i++;
    }
    $view_tbl .= '</td></tr></table></td></tr></table>';
}
$view_tbl .= '<br/>&nbsp;<br/>&nbsp;<strong>Declaration</strong><br/>
    <table cellspacing="0" cellpadding="2" border="0" width="100%">
        <tr>
            <td>I declare that the information given in the form is true and correct. I have read the college prospectus and information brochure and application form thoroughly. I promise to abide by the rules and regulations. I agree to pay the prescribed fees on time. My admission will stand automatically cancelled if the University does not approve it. I understand that falsification of any of the above entries made in the form or certificates, mark sheets, submitted by me or use of any unfair means shall lead to the cancellation of my admission granted, at any time. I hereby agree to participate in all the college activities assigned to me and have no objection to my inclusion in any of the college programs.
<br/>&nbsp;<br/></td>
        </tr>
        <tr>
            <td width="40%"><br/>
                <strong>Date : </strong>' . $display_date . '
             </td>
             <td width="60%" align="right">';
if ($signature_photograph != "") {
    $view_tbl .= '<img src="upload_docs/' . $signature_photograph . '" style="height: 50px;"/><br/>';
}
$view_tbl .= '<strong>Signature of the Applicant </strong>';

$view_tbl .= '</td>
    </tr>';

$view_tbl .= '</table></body></html>';
$html = <<<EOF
<!-- EXAMPLE OF CSS STYLE -->
<style>
body {font-family:arial; font-size:10px;}
td {font-family:arial; font-size:10px;}
td.this {border-left:1px solid steelblue; border-top:1px solid steelblue;}
td.this2 {border:1px solid steelblue; border-top:1px solid steelblue;}

th.this {border-left:1px solid steelblue; border-top:1px solid steelblue;}
table.this {border-right:1px solid steelblue; border-bottom:1px solid steelblue;}

</style>

 $view_tbl
EOF;
//echo $html;
$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output($file_name, 'D');
?>
