<?php

include_once 'class_db.php';
include_once 'common.php';

class class_student {

    public function GetStudentDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT a.registration_fee_status, a.test_roll_number, a.final_submit, a.first_final_submit, a.application_status, a.admission_date, a.last_date, a.payment_last_date, a.counseling_formsubmit, a.meritlist_number, a.merit_number, a.admission_fee_status, a.employee_ward_kota, b.*, c.program_name, d.seat_allotment_status, d.alloted_subject, d.seat_payment_status, d.program_id FROM itdc_login_tbl a, itdc_student_details_tbl b, itdc_program_list_tbl c, itdc_selected_program_tbl d WHERE a.login_id=b.login_id AND a.login_id=d.login_id AND b.course=c.program_id AND a.login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetFinalDate() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_settings_tbl";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetQualifyingExamName() {
        $RES = "invalid";
        $program_name = "";
        $qualifying_examination_id = common::StrToDB($this->qualifying_examination_id);
        $query = "SELECT program_name FROM itdc_master_ugprogram_tbl WHERE id='$qualifying_examination_id' AND status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        if (mysqli_num_rows($RES) > 0) {
            list($program_name) = mysqli_fetch_row($RES);
        }
        return $program_name;
    }

    public function GetSubjectName() {
        $RES = "invalid";
        $subject_name = "";
        $allsub_name = $this->allsub_name;
        $query = "SELECT GROUP_CONCAT(subject_name) AS subject_name FROM itdc_mastersubject_tbl WHERE id IN ('$allsub_name') AND status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        if (mysqli_num_rows($RES) > 0) {
            list($subject_name) = mysqli_fetch_row($RES);
        }
        return $subject_name;
    }

    public function GetProgramData() {
        $RES = "invalid";
        $course = common::StrToDB($this->course);
              if(!empty($course)){
            
        $query = "SELECT * FROM itdc_program_list_tbl WHERE program_id='$course' AND status='10'";
        }else{
        $query = "SELECT * FROM itdc_program_list_tbl WHERE  status='10'";
        }
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function InsertAdmissionOtherProgramPaymentDetail() {
        $log = new common();
        $ObjDB = new class_db();
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $course = common::StrToDB($this->course);
        $student_rollnumber = common::StrToDB($this->student_rollnumber);
        $pay_amount = common::StrToDB($this->pay_amount);

        $query_check = "SELECT * FROM itdc_selected_program_tbl WHERE program_id='$course' AND login_id='$student_id'";
        $ObjDB->sproc_name = $query_check;
        $RESCHECK = $ObjDB->SelectQuery();
        if (mysqli_num_rows($RESCHECK) == 0) {
            $registration_number = $log->uniqueregistrationid($course);

            $query_3 = "INSERT INTO itdc_selected_program_tbl(login_id, unique_id, program_id, add_date) VALUES('$student_id','$registration_number','$course','$add_date')";
            $ObjDB->sproc_name = $query_3;
            $RESYEARLYFINAL = $ObjDB->ExecuteQuery();
        }

        $payment_uniqueid = "DDUAD" . date("ymdHis") . mt_rand(11, 99) . $student_id;
        $query = "INSERT INTO itdc_registration_payment_tbl SET order_id='$payment_uniqueid', program_id='$course', student_loginid='$student_id', registration_fees='$pay_amount', payable_fees='$pay_amount',payment_date='$add_date'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Initiate registration Payment, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $payment_uniqueid;
    }

    public function InsertAdmissionPaymentDetail() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $course = common::StrToDB($this->course);
        $student_rollnumber = common::StrToDB($this->student_rollnumber);
        $pay_amount = common::StrToDB($this->pay_amount);
        $payment_uniqueid = "DDUAD" . date("ymdHis") . mt_rand(11, 99) . $student_id;
        $query = "INSERT INTO itdc_registration_payment_tbl SET order_id='$payment_uniqueid', program_id='$course', student_loginid='$student_id', registration_fees='$pay_amount', payable_fees='$pay_amount',payment_date='$add_date'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Initiate registration Payment, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $payment_uniqueid;
    }

    public function UpdatePaymentSuccess() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->order_id);
        $course = common::StrToDB($this->course);
        $payment_notes = common::StrToDB($this->payment_notes);
        $razorpay_signature = common::StrToDB($this->razorpay_signature);
        $razorpay_payment_id = common::StrToDB($this->razorpay_payment_id);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_registration_payment_tbl SET payment_status='10', razorpay_payment_id='$razorpay_payment_id', razorpay_signature='$razorpay_signature', payment_notes='$payment_notes', payment_date='$add_date' WHERE razorpay_order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_update = "UPDATE itdc_login_tbl SET registration_fee_status='10' WHERE login_id='$student_id'";
        $ObjDB->sproc_name = $query_update;
        $RESUPDATE = $ObjDB->ExecuteQuery();

        $query_update = "UPDATE itdc_selected_program_tbl SET payment_status='10', payment_notes='$payment_notes' WHERE login_id='$student_id' AND program_id='$course'";
        $ObjDB->sproc_name = $query_update;
        $RESUPDATE = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Admission Payment Success, razorpay_order_id - " . $order_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RESUPDATE;
    }

    public function UpdatePaymentFailure() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $order_id = common::StrToDB($this->order_id);
        $payment_notes = common::StrToDB($this->payment_notes);
        $razorpay_payment_id = common::StrToDB($this->razorpay_payment_id);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_registration_payment_tbl SET payment_status='30', razorpay_payment_id='$razorpay_payment_id', payment_notes='$payment_notes' WHERE razorpay_order_id='$order_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Admission Payment Failure, razorpay_order_id - " . $order_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function GetMasterStateList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_state_tbl WHERE status='1' ORDER BY state_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function UpdateApplicantBasicDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $father_name = common::StrToDB($this->father_name);
        $subcategory = common::StrToDB($this->subcategory);
        $mother_name = common::StrToDB($this->mother_name);
        $father_designation = common::StrToDB($this->father_designation);
        $father_mobile = common::StrToDB($this->father_mobile);
        $date_birth = common::StrToDB($this->date_birth);
        if ($date_birth == "") {
            $date_birth = "0000-00-00";
        }
        $email_id = common::StrToDB($this->email_id);
        $aadhar_number = common::StrToDB($this->aadhar_number);
        $gender = common::StrToDB($this->gender);
        $nationality = common::StrToDB($this->nationality);
        $enter_nationality = common::StrToDB($this->enter_nationality);
        $state = common::StrToDB($this->state);
        $enter_state = common::StrToDB($this->enter_state);
        $religion = common::StrToDB($this->religion);
        $category = common::StrToDB($this->category);
        $privilege_category = common::StrToDB($this->privilege_category);
        $divyangjan = common::StrToDB($this->divyangjan);
        $present_address = common::StrToDB($this->present_address);
        $city_name = common::StrToDB($this->city_name);
        $pincode = common::StrToDB($this->pincode);
        $applied_anyother = common::StrToDB($this->applied_anyother);
        $applied_othercourse = common::StrToDB($this->applied_othercourse);
        $weightage = common::StrToDB($this->weightage);
        $category_certificate_date = common::StrToDB($this->category_certificate_date);
        $domicile_up = common::StrToDB($this->domicile_up);
        $preference_one = common::StrToDB($this->preference_one);
        $preference_two = common::StrToDB($this->preference_two);
        $preference_three = common::StrToDB($this->preference_three);
        $preference_four = common::StrToDB($this->preference_four);
        
        /*SK JEE Score and Jee Percentile*/
        $preference_five = common::StrToDB($this->preference_five);
        
        $jee_score = common::StrToDB($this->jee_score);
        $jee_percentile = common::StrToDB($this->jee_percentile);
        
        
        if ($domicile_up == "Yes") {
            $state = "33";
        }
        
         /*SK JEE Score and Jee Percentile Update*/
        $query = "UPDATE itdc_student_details_tbl SET basic_submit='10', preference_one='$preference_one', preference_two='$preference_two', preference_three='$preference_three', preference_four='$preference_four', preference_five='$preference_five', category_certificate_date='$category_certificate_date', father_name='$father_name', mother_name='$mother_name', date_birth='$date_birth', city_name='$city_name', subcategory='$subcategory', applied_anyother='$applied_anyother', applied_othercourse='$applied_othercourse', enter_state='$enter_state',father_designation='$father_designation',father_mobile='$father_mobile',aadhar_number='$aadhar_number',gender='$gender',nationality='$nationality',enter_nationality='$enter_nationality',state='$state',religion='$religion',privilege_category='$privilege_category',divyangjan='$divyangjan',present_address='$present_address',pincode='$pincode',weightage='$weightage', jee_score='$jee_score', jee_percentile='$jee_percentile' WHERE login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_updateform = "UPDATE itdc_login_tbl SET counseling_formsubmit='20', final_submit='20' WHERE login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query_updateform;
        $result_updateform = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Update Basic Details, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function InsertUpdateQualifyingExamination() {
        $RES = "invalid";
        $ObjDB = new class_db();
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $passing_year = common::StrToDB($this->passing_year);
        $board_university = common::StrToDB($this->board_university);

        $degree_status = common::StrToDB($this->status_aboveprogram);
        $total_max_marks = common::StrToDB($this->total_max_marks);
        $total_obtained_marks = common::StrToDB($this->total_obtained_marks);
        $total_percentage = common::StrToDB($this->total_percentage);
        $enter_cgpa = common::StrToDB($this->enter_cgpa);
        $category = common::StrToDB($this->category);
        $subject_name = common::StrToDB($this->subject_name);
        
        /*SK qualifying subject for intermediate*/
        $qualifying_subject_intm = common::StrToDB($this->qualifying_subject_intm);

        if (($total_max_marks > 0) && ($total_obtained_marks > 0)) {
            $marks_percentage = $total_obtained_marks * 100 / $total_max_marks;
            $marks_percentage = number_format($marks_percentage, 1);
        } elseif ($enter_cgpa > 0) {
            $marks_percentage = $enter_cgpa * 100 / 10;
            $marks_percentage = number_format($marks_percentage, 1);
        }
        /*SK update qualifying subject of intermediate to student details*/
        $query = "UPDATE itdc_student_details_tbl SET passing_year='$passing_year',board_university='$board_university',status_aboveprogram='$degree_status',total_max_marks='$total_max_marks', total_obtained_marks='$total_obtained_marks', enter_cgpa='$enter_cgpa', qualifying_subject_intm='$qualifying_subject_intm' WHERE login_id='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_updateform = "UPDATE itdc_login_tbl SET counseling_formsubmit='20', final_submit='20' WHERE login_id='$student_id'";
        $ObjDB->sproc_name = $query_updateform;
        $result_updateform = $ObjDB->ExecuteQuery();

        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Update Qualifying Details, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();

        return $RES;
    }

    public function GetQualifyingExaminationDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_qualifying_examination_tbl WHERE login_id='$student_id' AND status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetQualifyingMoreDetails($qid) {
        $RES = "invalid";
        $qid = common::StrToDB($qid);
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_qualifying_examination_subject_tbl WHERE login_id='$student_id' AND qualifying_examination_id='$qid' AND status='10' ORDER BY sid ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetMasterDocumentList() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_master_uploads_tbl WHERE status='10' ORDER BY did ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetMasterDocumentListForUploading() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT a.* FROM itdc_master_uploads_tbl a WHERE a.status='10' AND  NOT EXISTS (SELECT document_type FROM itdc_upload_document_tbl WHERE document_type=a.did AND student_id='$student_id') ORDER BY a.did ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetMasterDocForUploading() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT a.* FROM itdc_master_uploads_tbl a WHERE a.status='10' ORDER BY a.did ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetSelectFileDetails($did) {
        $did = common::StrToDB($did);
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_uploads_tbl WHERE did='$did' AND status='10' ORDER BY document_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function CheckDocumentUploadOrNot() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $document_type = common::StrToDB($this->document_type);
        $query = "SELECT * FROM itdc_upload_document_tbl WHERE student_id='$student_id' AND status='10' AND document_type='$document_type'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function UploadStudentDocument() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $document_type = common::StrToDB($this->document_type);
        $upload_document = common::StrToDB($this->upload_document);
        $RES = "";
        $ObjDB = new class_db();
        $query_check = "SELECT * FROM itdc_upload_document_tbl WHERE student_id='$student_id' AND status='10' AND document_type='$document_type'";
        $ObjDB->sproc_name = $query_check;
        $RESCHECK = $ObjDB->SelectQuery();
        if (mysqli_num_rows($RESCHECK) == 0) {
            $query = "INSERT INTO itdc_upload_document_tbl SET student_id='$student_id', document_type='$document_type', upload_document='$upload_document', add_date='$add_date'";
            $ObjDB->sproc_name = $query;
            $RES = $ObjDB->ExecuteQuery();
        }

        $query_updateform = "UPDATE itdc_login_tbl SET counseling_formsubmit='20' WHERE login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query_updateform;
        $result_updateform = $ObjDB->ExecuteQuery();

        return $RES;
    }

    public function GetUploadedDocumentList() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT a.*, b.document_name FROM itdc_upload_document_tbl a, itdc_master_uploads_tbl b WHERE a.document_type=b.did AND a.student_id='$student_id' AND a.status='10' ORDER BY a.document_type ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function DeleteUploadedDocument() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $document_id = common::StrToDB($this->document_id);
        $query = "DELETE FROM itdc_upload_document_tbl WHERE uid='$document_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_updateform = "UPDATE itdc_login_tbl SET counseling_formsubmit='20', final_submit='20' WHERE login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query_updateform;
        $result_updateform = $ObjDB->ExecuteQuery();

        return $RES;
    }

    public function GetMasterBoardList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_board_tbl WHERE status='10' ORDER BY FIELD(bid, '27', '29', '30', '3', '2', '21', '1', '4', '16', '22', '17', '5', '6', '7', '8', '10', '9', '12', '13', '11', '18', '19', '15', '14', '20', '31', '23', '24', '26', '25', '28')";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetCheckListUploaded($did, $student_id) {
        $RES = "invalid";
        $did = common::StrToDB($did);
        $student_id = common::StrToDB($student_id);
        $query = "SELECT uid FROM itdc_upload_document_tbl WHERE document_type='$did' AND student_id='$student_id' AND status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $result = $ObjDB->SelectQuery();
        $count = mysqli_num_rows($result);
        return $count;
    }

    public function UpdateApplicationFinalSubmit() {
        $RES = "invalid";
        $add_date = date('Y-m-d');
        $student_id = common::StrToDB($this->student_id);
        $query = "UPDATE itdc_login_tbl SET final_submit='10', first_final_submit='10', finalsubmit_date='$add_date' WHERE login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        return $RES;
    }

    public function GetPaymentForReceiptDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_registration_payment_tbl WHERE student_loginid='$student_id' AND payment_status='10' ORDER BY id DESC LIMIT 1";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetandCheckPaymentOrderId() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $order_id = common::StrToDB($this->order_id);
        $ObjDB = new class_db();
        $query = "SELECT a.*, b.category FROM itdc_registration_payment_tbl a, itdc_student_details_tbl b WHERE a.student_loginid=b.login_id AND a.razorpay_order_id='$order_id' AND a.payment_status='20' LIMIT 1";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function UpdatePaymentPending() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->order_id);
        $payment_notes = common::StrToDB($this->payment_notes);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_registration_payment_tbl SET payment_status='50', payment_notes='$payment_notes' WHERE order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Admission Payment Pending, Student Id - " . $student_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function GetPaymentPendingDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_registration_payment_tbl WHERE student_loginid='$student_id' AND payment_status='50'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetPaymentInitiateDetails() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $before_date = date('Y-m-d H:i:s', strtotime($add_date . ' -1 hour'));
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_registration_payment_tbl WHERE student_loginid='$student_id' AND payment_status='20' AND payment_date>='$before_date'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetSubjectOneMasterList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_subject_tbl WHERE status='10' AND (find_in_set('1', subject_number) <> 0) ORDER BY subject_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetSubjectTwoMasterList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_subject_tbl WHERE status='10' AND (find_in_set('2', subject_number) <> 0) ORDER BY subject_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetSubjectThreeMasterList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_subject_tbl WHERE status='10' AND (find_in_set('3', subject_number) <> 0) ORDER BY subject_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetSubjectCommonMasterList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_subject_tbl WHERE status='10' AND (find_in_set('4', subject_number) <> 0)";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function UpdateStudentSubjectChoice() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $first_subject = common::StrToDB($this->first_subject);
        $second_subject = common::StrToDB($this->second_subject);
        $third_subject = common::StrToDB($this->third_subject);
        $four_subject = common::StrToDB($this->four_subject);
        $query = "UPDATE itdc_student_details_tbl SET first_subject='$first_subject', second_subject='$second_subject', third_subject='$third_subject', four_subject='$four_subject' WHERE login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_updateform = "UPDATE itdc_login_tbl SET counseling_formsubmit='20' WHERE login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query_updateform;
        $result_updateform = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Update Basic Details, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function CheckSubjectSeat($subject_id, $student_type) {
        $student_id = common::StrToDB($this->student_id);
        $subject_id = common::StrToDB($subject_id);
        $student_type = common::StrToDB($student_type);
        $available_seat = 0;
        $RES = "invalid";
        $ObjDB = new class_db();
        if ($student_type == 10) {
            $query_allseat = "SELECT subject_seat FROM itdc_master_subject_tbl WHERE sid='$subject_id'";
        } else {
            $query_allseat = "SELECT selffinance_subject_seat AS subject_seat FROM itdc_master_subject_tbl WHERE sid='$subject_id'";
        }
        $ObjDB->sproc_name = $query_allseat;
        $RESSEAT = $ObjDB->SelectQuery();
        if (mysqli_num_rows($RESSEAT) > 0) {
            list($subject_seat) = mysqli_fetch_row($RESSEAT);
            $query = "SELECT * FROM itdc_student_details_tbl WHERE login_id!='$student_id' AND student_type='$student_type' AND (first_subject='$subject_id' OR second_subject='$subject_id' OR third_subject='$subject_id')";
            $ObjDB->sproc_name = $query;
            $RES = $ObjDB->SelectQuery();
            $count = mysqli_num_rows($RES);
            $available_seat = $subject_seat - $count;
            if ($available_seat < 0) {
                $available_seat = 0;
            }
        }
        return $available_seat;
    }

    public function CheckSubjectMajorMinor($first_id, $second_id, $third_id) {
        $student_id = common::StrToDB($this->student_id);
        $first_id = common::StrToDB($first_id);
        $second_id = common::StrToDB($second_id);
        $third_id = common::StrToDB($third_id);
        $RES = "invalid";
        $ObjDB = new class_db();
        $query_allseat = "SELECT sid FROM itdc_master_subject_tbl WHERE sid IN ('$first_id', '$second_id', '$third_id') AND major_minor='10'";
        $ObjDB->sproc_name = $query_allseat;
        $RESSEAT = $ObjDB->SelectQuery();
        $count = mysqli_num_rows($RESSEAT);
        return $count;
    }

    public function UpdateApplicantCounsellingDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $father_name = common::StrToDB($this->father_name);
        $mother_name = common::StrToDB($this->mother_name);
        $father_designation = common::StrToDB($this->father_designation);
        $father_mobile = common::StrToDB($this->father_mobile);
        $date_birth = common::StrToDB($this->date_birth);
        if ($date_birth == "") {
            $date_birth = "0000-00-00";
        }
        $email_id = common::StrToDB($this->email_id);
        $aadhar_number = common::StrToDB($this->aadhar_number);
        $gender = common::StrToDB($this->gender);
        $nationality = common::StrToDB($this->nationality);
        $enter_nationality = common::StrToDB($this->enter_nationality);
        $state = common::StrToDB($this->state);
        $enter_state = common::StrToDB($this->enter_state);
        $religion = common::StrToDB($this->religion);
        $category = common::StrToDB($this->category);
        $privilege_category = common::StrToDB($this->privilege_category);
        $divyangjan = common::StrToDB($this->divyangjan);
        $present_address = common::StrToDB($this->present_address);
        $city_name = common::StrToDB($this->city_name);
        $pincode = common::StrToDB($this->pincode);
        $office_address = common::StrToDB($this->office_address);
        $max_marks = common::StrToDB($this->max_marks);
        $obtained_marks = common::StrToDB($this->obtained_marks);
        $first_subject = common::StrToDB($this->first_subject);
        $second_subject = common::StrToDB($this->second_subject);
        $third_subject = common::StrToDB($this->third_subject);

        $query = "UPDATE itdc_student_details_tbl SET city_name='$city_name', enter_state='$enter_state', mother_name='$mother_name',father_designation='$father_designation',father_mobile='$father_mobile',date_birth='$date_birth',email_id='$email_id',aadhar_number='$aadhar_number',gender='$gender',nationality='$nationality',enter_nationality='$enter_nationality',state='$state',religion='$religion',category='$category',privilege_category='$privilege_category',divyangjan='$divyangjan',present_address='$present_address',pincode='$pincode', office_address='$office_address',max_marks='$max_marks', obtained_marks='$obtained_marks', first_subject='$first_subject', second_subject='$second_subject', third_subject='$third_subject', subject_number='10' WHERE login_id='$this->student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_updateform = "UPDATE itdc_login_tbl SET counseling_formsubmit='20' WHERE login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query_updateform;
        $result_updateform = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Update Counselling Details, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function UpdateCounselingFinalSubmit() {
        $RES = "invalid";
        $add_date = date('Y-m-d');
        $student_id = common::StrToDB($this->student_id);
        $query = "UPDATE itdc_login_tbl SET counseling_formsubmit='10', counseling_submitdate='$add_date' WHERE login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        return $RES;
    }

    public function GetStudentAdmissionFees() {
        $RES = "invalid";
        $first_subject = common::StrToDB($this->first_subject);
        $second_subject = common::StrToDB($this->second_subject);
        $third_subject = common::StrToDB($this->third_subject);
        $student_type = common::StrToDB($this->student_type);
        if ($student_type == "10") {
            $query = "SELECT SUM(subject_fees) AS subject_fees FROM itdc_master_subject_tbl WHERE status='10' AND sid IN ('$first_subject','$second_subject','$third_subject')";
        } else {
            $query = "SELECT SUM(selffinance_subject_fees) AS subject_fees FROM itdc_master_subject_tbl WHERE status='10' AND sid IN ('$first_subject','$second_subject','$third_subject')";
        }
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        list($subject_fees) = mysqli_fetch_row($RES);
        if ($subject_fees == "") {
            $subject_fees = 0;
        }
        return $subject_fees;
    }

    public function GetStudentVocationalFees() {
        $RES = "invalid";
        $first_subject = common::StrToDB($this->first_subject);
        $second_subject = common::StrToDB($this->second_subject);
        $third_subject = common::StrToDB($this->third_subject);
        $student_type = common::StrToDB($this->student_type);
        if ($student_type == "10") {
            $query = "SELECT SUM(vocational_fee) AS vocational_fee FROM itdc_master_subject_tbl WHERE status='10' AND sid IN ('$first_subject','$second_subject','$third_subject')";
        } else {
            $query = "SELECT SUM(sf_vocational_fee) AS vocational_fee FROM itdc_master_subject_tbl WHERE status='10' AND sid IN ('$first_subject','$second_subject','$third_subject')";
        }
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        list($subject_fees) = mysqli_fetch_row($RES);
        if ($subject_fees == "") {
            $subject_fees = 0;
        }
        return $subject_fees;
    }

    public function GetStudentOverAllFees() {
        $RES = "invalid";
        $student_type = common::StrToDB($this->student_type);
        $religion = common::StrToDB($this->religion);
        if ($student_type == "10") {
            if ($religion == "Christianity") {
                $query = "SELECT SUM(course_fee+annual_fee+security_money+sga_fee+christian_fee) AS overall_fees, course_fee, annual_fee, security_money, sga_fee, christian_fee FROM itdc_settings_tbl GROUP BY id";
            } else {
                $query = "SELECT SUM(course_fee+annual_fee+security_money+sga_fee) AS overall_fees, course_fee, annual_fee, security_money, sga_fee, christian_fee FROM itdc_settings_tbl GROUP BY id";
            }
        } else {
            if ($religion == "Christianity") {
                $query = "SELECT SUM(sf_course_fee+sf_annual_fee+sf_security_money+sf_sga_fee+sf_christian_fee) AS overall_fees, sf_course_fee AS course_fee, sf_annual_fee AS annual_fee, sf_security_money AS security_money, sf_sga_fee AS sga_fee, sf_christian_fee AS christian_fee FROM itdc_settings_tbl GROUP BY id";
            } else {
                $query = "SELECT SUM(sf_course_fee+sf_annual_fee+sf_security_money+sf_sga_fee) AS overall_fees, sf_course_fee AS course_fee, sf_annual_fee AS annual_fee, sf_security_money AS security_money, sf_sga_fee AS sga_fee, sf_christian_fee AS christian_fee FROM itdc_settings_tbl GROUP BY id";
            }
        }
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function InsertFinalAdmissionPayment() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $pay_amount = common::StrToDB($this->pay_amount);
        $payment_uniqueid = "ITA" . date("ymdHis") . mt_rand(11, 99) . $student_id;
        $query = "INSERT INTO itdc_admission_payment_tbl SET order_id='$payment_uniqueid', student_loginid='$student_id', course_fee='$this->course_fee', annual_fee='$this->annual_fee', security_money='$this->security_money', sga_fee='$this->sga_fee', christian_fee='$this->christian_fee', practical_fee='$this->practical_fee', vocational_fee='$this->vocational_fee', total_fee='$pay_amount', payable_fees='$pay_amount',payment_date='$add_date'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Initiate admission Payment, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $payment_uniqueid;
    }

    public function GetandCheckAdmissionPaymentOrderId() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->order_id);
        $ObjDB = new class_db();
        $query = "SELECT * FROM itdc_admission_payment_tbl WHERE order_id='$order_id' AND student_loginid='$student_id' AND payment_status='20' LIMIT 1";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function UpdateAdmissionPaymentSuccess() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->order_id);
        $payment_notes = common::StrToDB($this->payment_notes);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_admission_payment_tbl SET payment_status='10', payment_notes='$payment_notes', payment_date='$add_date' WHERE order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_update = "UPDATE itdc_login_tbl SET admission_fee_status='10' WHERE login_id='$student_id'";
        $ObjDB->sproc_name = $query_update;
        $RESUPDATE = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Final Admission Payment Success, Student Id - " . $student_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RESUPDATE;
    }

    public function UpdateAdmissionPaymentFailure() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
//        $student_rollnumber = common::StrToDB($this->student_rollnumber);
        $order_id = common::StrToDB($this->order_id);
        $payment_notes = common::StrToDB($this->payment_notes);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_admission_payment_tbl SET payment_status='30', payment_notes='$payment_notes' WHERE order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Final Admission Payment Failure, Student Id - " . $student_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function UpdateAdmissionPaymentPending() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->order_id);
        $payment_notes = common::StrToDB($this->payment_notes);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_admission_payment_tbl SET payment_status='50', payment_notes='$payment_notes' WHERE order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Final Admission Payment Pending, Student Id - " . $student_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function GetAdmissionPendingDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_admission_payment_tbl WHERE student_loginid='$student_id' AND payment_status='50'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetAdmissionInitiateDetails() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $before_date = date('Y-m-d H:i:s', strtotime($add_date . ' -1 hour'));
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_admission_payment_tbl WHERE student_loginid='$student_id' AND payment_status='20' AND payment_date>='$before_date'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetAdmissionForReceiptDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_admission_payment_tbl WHERE student_loginid='$student_id' AND payment_status='10' ORDER BY id DESC LIMIT 1";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetSelectedSubjectList($first_subject, $second_subject, $third_subject, $four_subject) {
        $result = "invalid";
        $first_subject = common::StrToDB($first_subject);
        $second_subject = common::StrToDB($second_subject);
        $third_subject = common::StrToDB($third_subject);
        $four_subject = common::StrToDB($four_subject);
        $query = "SELECT * FROM itdc_master_subject_tbl WHERE sid IN ('$first_subject','$second_subject','$third_subject','$four_subject') ORDER By FIELD(sid, '$first_subject','$second_subject','$third_subject','$four_subject')";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $result = $ObjDB->SelectQuery();
        return $result;
    }

    public function UpdateRegistrationRazorPayOrderId() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->receipt);
        $razorpay_order_id = common::StrToDB($this->razorpay_order_id);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_registration_payment_tbl SET razorpay_order_id='$razorpay_order_id' WHERE order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        return $RES;
    }

    public function GetProgramList() {
        $RES = "invalid";
        $qualifying_examination = common::StrToDB($this->qualifying_examination);
        $subject_one = common::StrToDB($this->subject_one);
        $subject_two = common::StrToDB($this->subject_two);

        $dy = "";

        $query = "SELECT * FROM itdc_program_list_tbl WHERE status='10' AND program_id!='76' AND (((((open_to='') OR (open_to IS NULL) OR (FIND_IN_SET('$subject_one',open_to)) OR (FIND_IN_SET('$subject_two',open_to))) AND ((open_program_requied='') OR (open_program_requied IS NULL) OR (FIND_IN_SET('$qualifying_examination',open_program_requied)))) OR ((FIND_IN_SET('$qualifying_examination',open_to_program))))) ORDER BY program_name ASC";
//        $query = "SELECT * FROM itdc_program_list_tbl WHERE status='10' AND (((((open_to='') OR (open_to IS NULL) OR (FIND_IN_SET('$subject_one',open_to)) OR (FIND_IN_SET('$subject_two',open_to))) AND ((open_program_requied='') OR (open_program_requied IS NULL) OR (FIND_IN_SET('$qualifying_examination',open_program_requied)))) OR ((FIND_IN_SET('$qualifying_examination',open_to_program))))) ORDER BY program_name ASC";
//        $query = "SELECT * FROM itdc_program_list_tbl WHERE status='10' AND (((((open_to='') OR (open_to IS NULL) OR (FIND_IN_SET('$subject_one',open_to)) OR (FIND_IN_SET('$subject_two',open_to))) AND ((open_program_requied='') OR (open_program_requied IS NULL) OR (FIND_IN_SET('$qualifying_examination',open_program_requied)))) AND ((open_to='') OR (open_to IS NULL) OR (FIND_IN_SET('$subject_one',open_to)) OR (FIND_IN_SET('$subject_two',open_to))) AND ((open_to_program='')) OR (open_to_program IS NULL) OR (FIND_IN_SET('$qualifying_examination',open_to_program)))) ORDER BY program_name ASC";
//        $query = "SELECT * FROM itdc_program_list_tbl WHERE status='10' AND (((((open_to='') OR (open_to IS NULL) OR (FIND_IN_SET('$subject_one',open_to)) OR (FIND_IN_SET('$subject_two',open_to))) AND ((open_program_requied='') OR (open_program_requied IS NULL) OR (FIND_IN_SET('$qualifying_examination',open_program_requied)))) OR ((open_to='') OR (open_to IS NULL) OR (FIND_IN_SET('$subject_one',open_to)) OR (FIND_IN_SET('$subject_two',open_to))) AND ((open_to_program='')) OR (open_to_program IS NULL) OR (FIND_IN_SET('$qualifying_examination',open_to_program)))) ORDER BY program_name ASC";
//        $query = "SELECT * FROM itdc_program_list_tbl WHERE status='10' AND ((((open_to='') OR (open_to IS NULL) OR (FIND_IN_SET('$subject_one',open_to)) OR (FIND_IN_SET('$subject_two',open_to))) OR ((open_to_program='') OR (open_to_program IS NULL) OR (FIND_IN_SET('$qualifying_examination',open_to_program)))) OR (((open_to='') OR (open_to IS NULL) OR (FIND_IN_SET('$subject_one',open_to)) OR (FIND_IN_SET('$subject_two',open_to))) AND ((open_program_requied='') OR (open_program_requied IS NULL) OR (FIND_IN_SET('$qualifying_examination',open_program_requied))))) ORDER BY program_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetProgramPaidOrNot($program_id) {
        $RES = "invalid";
        $program_id = common::StrToDB($program_id);
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_selected_program_tbl WHERE program_id='$program_id' AND login_id='$student_id' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetProgramDetails() {
        $RES = "invalid";
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT * FROM itdc_program_list_tbl WHERE status='10' AND program_id='$program_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetPaymentForMultiReceiptDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT a.*, b.unique_id, b.entrance_roll_number FROM itdc_registration_payment_tbl a, itdc_selected_program_tbl b WHERE a.student_loginid=b.login_id AND a.student_loginid='$student_id' AND a.program_id=b.program_id AND a.program_id='$program_id' AND a.payment_status='10' ORDER BY a.id DESC LIMIT 1";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetMultiReceiptDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT b.unique_id FROM itdc_selected_program_tbl b WHERE b.login_id='$student_id' AND b.program_id='$program_id' AND b.payment_status='10' LIMIT 1";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetUGProgramList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_ugprogram_tbl WHERE status='10' ORDER BY program_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetSubjectList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_mastersubject_tbl WHERE status='10' ORDER BY subject_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetDetailsForMultipleProgramDegree() {
        $RES = "invalid";
        $program_name = "";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT id FROM itdc_selected_program_tbl WHERE login_id='$student_id' AND eligible_forprogram='20' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        $count = mysqli_num_rows($RES);
        return $count;
    }
    
        
    public function GetCollegeMatrixList() {
        $RES = "invalid";
        $program_id = common::StrToDB($this->program_id);
        $cid = common::StrToDB($this->cid);
        if(!empty($cid)){
       $query = "SELECT * FROM itdc_college_list_tbl WHERE status='10' AND cid='$cid' AND program_id='$program_id'";
        }else{
        $query = "SELECT * FROM itdc_college_list_tbl WHERE status='10' AND program_id='$program_id'";   
        }
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
     public function GetCollegeMatrixSubject() {
        $RES = "invalid";
        $program_id = common::StrToDB($this->program_id);
        $cid = common::StrToDB($this->cid);
        $query = "SELECT * FROM itdc_college_subject_tbl WHERE status='10' AND program_id='$program_id' AND college_id='$cid'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
    
        public function GetCollegeMatrixListInitial() {
        $RES = "invalid";
        $program_id = common::StrToDB($this->program_id);
        $cid = common::StrToDB($this->cid);
        if(!empty($cid)){
       $query = "SELECT * FROM itdc_college_list_tbl_100824 WHERE status='10' AND cid='$cid' AND program_id='$program_id'";
        }else{
        $query = "SELECT * FROM itdc_college_list_tbl_100824 WHERE status='10' AND program_id='$program_id'";   
        }
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
     public function GetCollegeMatrixSubjectInitial() {
        $RES = "invalid";
        $program_id = common::StrToDB($this->program_id);
        $cid = common::StrToDB($this->cid);
        $query = "SELECT * FROM  itdc_college_subject_tbl_100824 WHERE status='10' AND program_id='$program_id' AND college_id='$cid'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
    
    
    public function GetStuRollDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT * FROM itdc_selected_program_tbl WHERE login_id='$student_id' AND program_id='$program_id' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetAllotedSeatForAllotedPage() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();
        $query = "SELECT a.* FROM itdc_student_choice_tbl a, itdc_college_list_tbl b WHERE a.college_id=b.cid AND a.program_id=b.program_id AND a.status='10' AND a.student_id='$student_id' AND a.program_id='$program_id' AND a.reg_number='$reg_number' AND a.seat_allotment_status='10' ORDER BY a.choice_series ASC";

//        $query = "SELECT * FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number' AND seat_allotment_status='10' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetOGMasterSubjectList() {
        $program_id = common::StrToDB($this->program_id);
        $RES = "invalid";
        $query = "SELECT sid, subject_name, subject_name_hindi FROM itdc_college_subject_tbl WHERE status='10' AND program_id='$program_id' ORDER BY subject_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
        public function GetAllotedSubject() {
        $program_id = common::StrToDB($this->program_id);
        $subject_id = common::StrToDB($this->subject_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
                  $employee_ward_str = "";
        if($program_id != "58"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
        if($program_id=="55") {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch WHERE res.login_id=ch.student_id AND res.test_code='321' AND (((ch.seat_allotment_status_c1='10') AND (res.upgrade_option_flag='30')) OR ((ch.seat_allotment_status='10') AND (res.seat_allotment_status='10'))) $employee_ward_str AND ch.subject_one='$subject_id' $category_str;";
        } else {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch WHERE res.login_id=ch.student_id AND res.program_id='$program_id' AND (((ch.seat_allotment_status_c1='10') AND (res.upgrade_option_flag='30')) OR ((ch.seat_allotment_status='10') AND (res.seat_allotment_status='10'))) $employee_ward_str AND ch.subject_one='$subject_id' $category_str;";
        }
        
        $RES = "invalid";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
            public function GetAllotedCollege() {
        $program_id = common::StrToDB($this->program_id);
        $college_id = common::StrToDB($this->college_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
              
            $employee_ward_str = "";
        if($program_id != "58"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
        
        
        $RES = "invalid";
        
        if($program_id == "55"){
        
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch WHERE res.login_id=ch.student_id AND res.test_code='321' AND (((ch.seat_allotment_status_c1='10') AND (res.upgrade_option_flag='30')) OR ((ch.seat_allotment_status='10') AND (res.seat_allotment_status='10'))) $employee_ward_str AND ch.college_id='$college_id' $category_str;";
        
        }else{
            $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch WHERE res.login_id=ch.student_id AND res.program_id='$program_id' AND (((ch.seat_allotment_status_c1='10') AND (res.upgrade_option_flag='30')) OR ((ch.seat_allotment_status='10') AND (res.seat_allotment_status='10'))) $employee_ward_str AND ch.college_id='$college_id' $category_str;";
        }
        
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
       public function GetPaidSubject() {
        $program_id = common::StrToDB($this->program_id);
        $subject_id = common::StrToDB($this->subject_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
               $employee_ward_str = "";
        if($program_id != "58"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
        if($program_id=="55") {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch WHERE res.login_id=ch.student_id AND res.test_code='321' AND ch.seat_allotment_status='10' AND ch.payment_status ='10' $employee_ward_str AND ch.subject_one='$subject_id' $category_str;";
        } else {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch WHERE res.login_id=ch.student_id AND res.program_id='$program_id' AND ch.seat_allotment_status='10' AND ch.payment_status ='10' $employee_ward_str AND ch.subject_one='$subject_id' $category_str;";
        }
        
        $RES = "invalid";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
            public function GetPaidCollege() {
        $program_id = common::StrToDB($this->program_id);
        $college_id = common::StrToDB($this->college_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
               $employee_ward_str = "";
        if($program_id != "58"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
        
        $RES = "invalid";
        
            if($program_id == "55"){
        
       $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch WHERE res.login_id=ch.student_id AND res.test_code='321' AND ch.seat_allotment_status='10'  AND ch.payment_status ='10' $employee_ward_str AND ch.college_id='$college_id' $category_str;";
        
        }else{
            $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch WHERE res.login_id=ch.student_id AND res.program_id='$program_id' AND ch.seat_allotment_status='10'  AND ch.payment_status ='10' $employee_ward_str AND ch.college_id='$college_id' $category_str;";
        }
        
        
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
     public function GetVerifiedSubject() {
        $program_id = common::StrToDB($this->program_id);
        $subject_id = common::StrToDB($this->subject_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
                   $employee_ward_str = "";
        if($program_id != "58"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
        if($program_id=="55") {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.test_code='321' AND sp.doc_verified='10' AND ch.seat_allotment_status='10' $employee_ward_str AND ch.subject_one='$subject_id' $category_str;";
        } else {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.program_id='$program_id' AND sp.doc_verified='10' AND ch.seat_allotment_status='10' $employee_ward_str AND ch.subject_one='$subject_id' $category_str;";
        }
        
        $RES = "invalid";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
      public function GetVerifiedCollege() {
        $program_id = common::StrToDB($this->program_id);
        $college_id = common::StrToDB($this->college_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
               $employee_ward_str = "";
        if($program_id != "58"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
        
        $RES = "invalid";
        
        
        if($program_id == "55"){
        
       $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.test_code='321' AND ch.seat_allotment_status='10' AND sp.doc_verified='10' $employee_ward_str AND ch.college_id='$college_id' $category_str;";
        }else{
           $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.program_id='$program_id' AND ch.seat_allotment_status='10' AND sp.doc_verified='10' $employee_ward_str AND ch.college_id='$college_id' $category_str;";
 
        }
        
        
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
    
     public function GetVerifiedWithUpgradeSubject() {
        $program_id = common::StrToDB($this->program_id);
        $subject_id = common::StrToDB($this->subject_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
           $employee_ward_str = "";
        if($program_id != "23"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
        if($program_id=="55") {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.test_code='321' AND sp.doc_verified='10' AND (((ch.seat_allotment_status_c1='10') AND (res.upgrade_option_flag='30')) OR ((ch.seat_allotment_status='10') AND (res.seat_allotment_status='10'))) AND ch.subject_one='$subject_id' $category_str;";
        } else {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.program_id='$program_id' AND sp.doc_verified='10' AND (((ch.seat_allotment_status_c1='10') AND (res.upgrade_option_flag='30')) OR ((ch.seat_allotment_status='10') AND (res.seat_allotment_status='10'))) AND ch.subject_one='$subject_id' $category_str;";
        }
        
        $RES = "invalid";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
      public function GetVerifiedWithUpgradeCollege() {
        $program_id = common::StrToDB($this->program_id);
        $college_id = common::StrToDB($this->college_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
            $employee_ward_str = "";
        if($program_id != "23"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
        
        
        
        
        $RES = "invalid";
        
        if($program_id == "55"){
            $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.test_code='321' AND (((ch.seat_allotment_status_c1='10') AND (res.upgrade_option_flag='30')) OR ((ch.seat_allotment_status='10') AND (res.seat_allotment_status='10'))) AND sp.doc_verified='10' AND ch.college_id='$college_id' $category_str;";
        
        }else{
            $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.program_id='$program_id' AND (((ch.seat_allotment_status_c1='10') AND (res.upgrade_option_flag='30')) OR ((ch.seat_allotment_status='10') AND (res.seat_allotment_status='10'))) AND sp.doc_verified='10' AND ch.college_id='$college_id' $category_str;";
        
        }
        
       
        
        
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        
        
        
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
    public function GetRejectByCollegeSubject() {
        $program_id = common::StrToDB($this->program_id);
        $subject_id = common::StrToDB($this->subject_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
           $employee_ward_str = "";
        if($program_id != "23"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
         if($program_id == "55"){
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.test_code='321' AND sp.doc_verified='30' AND ((ch.seat_allotment_status='60') AND (ch.seat_allotment_status='60') AND (res.seat_allotment_status='60')) AND ch.subject_one='$subject_id' $category_str;";
        } else {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.program_id='$program_id' AND sp.doc_verified='30' AND ((ch.seat_allotment_status='60') AND (ch.seat_allotment_status='60') AND (res.seat_allotment_status='60')) AND ch.subject_one='$subject_id' $category_str;";
        }
        
        $RES = "invalid";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
      public function GetRejectByCollegeCollege() {
        $program_id = common::StrToDB($this->program_id);
        $college_id = common::StrToDB($this->college_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
            $employee_ward_str = "";
        if($program_id != "23"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
         if($program_id == "55"){
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.test_code='321' AND sp.doc_verified='30' AND ((ch.seat_allotment_status='60') AND (ch.seat_allotment_status='60') AND (res.seat_allotment_status='60')) AND ch.college_id='$college_id' $category_str;";
        } else {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.program_id='$program_id' AND sp.doc_verified='30' AND ((ch.seat_allotment_status='60') AND (ch.seat_allotment_status='60') AND (res.seat_allotment_status='60')) AND ch.college_id='$college_id' $category_str;";
        }
        
        
        $RES = "invalid";
       $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
    public function GetRejectByCollegeApplicationSubject() {
        $program_id = common::StrToDB($this->program_id);
        $subject_id = common::StrToDB($this->subject_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
           $employee_ward_str = "";
        if($program_id != "23"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
        if($program_id == "55"){
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.test_code='321' AND ((ch.seat_allotment_status='60') AND (ch.seat_allotment_status='60') AND (res.seat_allotment_status='60')) AND ch.subject_one='$subject_id' $category_str;";
        } else {
        $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.program_id='$program_id' AND ((ch.seat_allotment_status='60') AND (ch.seat_allotment_status='60') AND (res.seat_allotment_status='60')) AND ch.subject_one='$subject_id' $category_str;";
        }
        
        $RES = "invalid";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
      public function GetRejectByCollegeApplicationCollege() {
        $program_id = common::StrToDB($this->program_id);
        $college_id = common::StrToDB($this->college_id);
        $category_val = common::StrToDB($this->category_val);
        
        $category_str  = "";
        if(!empty($category_val)){
            
            if($category_val == "General"){
                 $category_str = " AND (res.allotment_under_category='GC-OP' || res.allotment_under_category='GC-GP' || res.allotment_under_category='GC-GEX' || res.allotment_under_category='GC-GS' || res.allotment_under_category='GC-GF' )";
            }else if($category_val == "General (EWS)"){
                $category_str = " AND res.allotment_under_category='EWS-OP'";
            }else if($category_val == "OBC"){
                $category_str = " AND (res.allotment_under_category='BC-OP' || res.allotment_under_category='BC-BP' || res.allotment_under_category='BC-BEX' || res.allotment_under_category='BC-BS' || res.allotment_under_category='BC-BF')";
            }else if($category_val == "SC"){
                 $category_str = " AND (res.allotment_under_category='SC-OP' || res.allotment_under_category='SC-SP' || res.allotment_under_category='SC-SEX' || res.allotment_under_category='SC-SS' || res.allotment_under_category='SC-SF')";
            }else if($category_val == "ST"){
                $category_str = " AND (res.allotment_under_category='ST-OP')";
            }
            
        }
        
            $employee_ward_str = "";
        if($program_id != "23"){
         $employee_ward_str = " AND res.employee_ward_quota='20' ";
        }
         if($program_id == "55"){
             $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.test_code='321' AND ((ch.seat_allotment_status='60') AND (ch.seat_allotment_status='60') AND (res.seat_allotment_status='60')) AND ch.college_id='$college_id' $category_str;";
        
         } else {
             $query = "SELECT count(res.login_id) as AllotedApplicant FROM itdc_result_tbl res, itdc_student_choice_tbl ch, itdc_selected_program_tbl sp 
        WHERE res.login_id=ch.student_id AND res.login_id=sp.login_id AND res.program_id='$program_id' AND ((ch.seat_allotment_status='60') AND (ch.seat_allotment_status='60') AND (res.seat_allotment_status='60')) AND ch.college_id='$college_id' $category_str;";
        
         }
        
        
        $RES = "invalid";
       $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    public function GetStuNewcproDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT a.* FROM itdc_selected_program_tbl a WHERE a.login_id='$student_id' AND a.program_id='$program_id' AND a.payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetStuNewDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT a.*, b.category, b.general_rank, b.category_rank, b.weightage, b.obtained_marks, b.weightage_marks, b.marks_with_weightage, b.program_name FROM itdc_selected_program_tbl a, itdc_result_tbl b WHERE a.unique_id=b.registration_number AND a.login_id='$student_id' AND a.program_id='$program_id' AND a.payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
    
    
    
}

?>