<?php

include_once 'class_db.php';
include_once 'common.php';

class class_counselling {

    public function GetStudentDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT a.registration_fee_status, a.test_roll_number, a.final_submit, a.first_final_submit, a.application_status, a.admission_date, a.last_date, a.payment_last_date, a.counseling_formsubmit, a.meritlist_number, a.merit_number, a.admission_fee_status, a.employee_ward_kota, b.*, c.program_name FROM itdc_login_tbl a, itdc_student_details_tbl b, itdc_program_list_tbl c WHERE a.login_id=b.login_id AND b.course=c.program_id AND a.login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetFinalDate() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_settings_tbl";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetResultDataforDashboard() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT a.*, b.employee_ward_kota, b.final_submit FROM itdc_result_tbl a, itdc_login_tbl b WHERE a.login_id=b.login_id AND a.login_id='$student_id' LIMIT 0;";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetDatafornoCounsellingDashboard() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT a.program_id, a.seat_payment_status, a.unique_id, d.final_submit, d.employee_ward_kota, c.program_name, c.nomerit_msg FROM itdc_selected_program_tbl a, itdc_student_details_tbl b, itdc_program_list_tbl c, itdc_login_tbl d WHERE a.login_id=b.login_id AND a.program_id=c.program_id AND a.login_id=d.login_id AND c.program_id IN ('1','2','3','5') AND a.payment_status='10' AND a.seat_allotment_status='10' AND a.login_id='$student_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetProgramPaidOrNot($program_id) {
        $RES = "invalid";
        $program_id = common::StrToDB($program_id);
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT * FROM itdc_selected_program_tbl WHERE program_id='$program_id' AND login_id='$student_id' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetProgramData() {
        $RES = "invalid";
        $course = common::StrToDB($this->course);
        $query = "SELECT * FROM itdc_program_list_tbl WHERE program_id='$course' AND status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function InsertCounsellingPaymentDetail() {
        $log = new common();
        $ObjDB = new class_db();
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $course = common::StrToDB($this->course);
        $student_rollnumber = common::StrToDB($this->student_rollnumber);
        $pay_amount = common::StrToDB($this->pay_amount);

        $payment_uniqueid = "DDUCG" . date("ymdHis") . mt_rand(11, 99) . $student_id;
        $query = "INSERT INTO itdc_counselling_payment_tbl SET order_id='$payment_uniqueid', program_id='$course', student_loginid='$student_id', counselling_fees='$pay_amount', payable_fees='$pay_amount',payment_date='$add_date'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Initiate Counselling Payment, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $payment_uniqueid;
    }

    public function UpdateCounsellingRazorPayOrderId() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->receipt);
        $razorpay_order_id = common::StrToDB($this->razorpay_order_id);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_counselling_payment_tbl SET razorpay_order_id='$razorpay_order_id' WHERE order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        return $RES;
    }

    public function GetSubjectOneMasterList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_subject_tbl WHERE status='10' AND (find_in_set('1', subject_number) <> 0) ORDER BY subject_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetSubjectTwoMasterList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_subject_tbl WHERE status='10' AND (find_in_set('2', subject_number) <> 0) ORDER BY subject_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetSubjectThreeMasterList() {
        $RES = "invalid";
        $query = "SELECT * FROM itdc_master_subject_tbl WHERE status='10' AND (find_in_set('3', subject_number) <> 0) ORDER BY subject_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetCollegeList() {
        $RES = "invalid";
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT * FROM itdc_college_list_tbl WHERE status='10' AND program_id='$program_id' ORDER BY cid ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetMasterSubjectListForCounselling() {
        $RES = "invalid";
        $query = "SELECT sid, subject_name FROM itdc_master_subject_tbl WHERE status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetStuCounsellingChoiceList() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();

        $query = "SELECT a.*, b.seat_allotment_fee FROM itdc_student_choice_tbl a, itdc_college_list_tbl b WHERE a.college_id=b.cid AND a.program_id=b.program_id AND a.status='10' AND a.student_id='$student_id' AND a.program_id='$program_id' AND a.reg_number='$reg_number' ORDER BY a.choice_series ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function CheckSubjectSeat($subject_id, $student_type) {
        $student_id = common::StrToDB($this->student_id);
        $subject_id = common::StrToDB($subject_id);
        $student_type = common::StrToDB($student_type);
        $available_seat = 0;
        $RES = "invalid";
        $ObjDB = new class_db();
        if ($student_type == 10) {
            $query_allseat = "SELECT subject_seat FROM itdc_master_subject_tbl WHERE sid='$subject_id'";
        } else {
            $query_allseat = "SELECT selffinance_subject_seat AS subject_seat FROM itdc_master_subject_tbl WHERE sid='$subject_id'";
        }
        $ObjDB->sproc_name = $query_allseat;
        $RESSEAT = $ObjDB->SelectQuery();
        if (mysqli_num_rows($RESSEAT) > 0) {
            list($subject_seat) = mysqli_fetch_row($RESSEAT);
            $query = "SELECT * FROM itdc_student_details_tbl WHERE login_id!='$student_id' AND student_type='$student_type' AND (first_subject='$subject_id' OR second_subject='$subject_id' OR third_subject='$subject_id')";
            $ObjDB->sproc_name = $query;
            $RES = $ObjDB->SelectQuery();
            $count = mysqli_num_rows($RES);
            $available_seat = $subject_seat - $count;
            if ($available_seat < 0) {
                $available_seat = 0;
            }
        }
        return $available_seat;
    }

    public function CheckSubjectMajorMinor($first_id, $second_id, $third_id) {
        $student_id = common::StrToDB($this->student_id);
        $first_id = common::StrToDB($first_id);
        $second_id = common::StrToDB($second_id);
        $third_id = common::StrToDB($third_id);
        $RES = "invalid";
        $ObjDB = new class_db();
        $query_allseat = "SELECT sid FROM itdc_master_subject_tbl WHERE sid IN ('$first_id', '$second_id', '$third_id') AND major_minor='10'";
        $ObjDB->sproc_name = $query_allseat;
        $RESSEAT = $ObjDB->SelectQuery();
        $count = mysqli_num_rows($RESSEAT);
        return $count;
    }

    public function UpdateStudentSubjectChoice() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $first_subject = common::StrToDB($this->first_subject);
        $second_subject = common::StrToDB($this->second_subject);
        $third_subject = common::StrToDB($this->third_subject);
        $select_institute = common::StrToDB($this->select_institute);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();

        $query_dataforseries = "SELECT choice_series FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number'";
        $ObjDB->sproc_name = $query_dataforseries;
        $result_dataforseries = $ObjDB->SelectQuery();
        $count_dataforseries = mysqli_num_rows($result_dataforseries);
        $choice_series = $count_dataforseries + 1;

        $add_date = date("Y-m-d H:i:s");
        $query = "INSERT itdc_student_choice_tbl SET subject_one='$first_subject', subject_two='$second_subject', subject_three='$third_subject', student_id='$student_id', college_id='$select_institute', choice_series='$choice_series', program_id='$program_id', reg_number='$reg_number', add_date='$add_date'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Subject Choice, Student Id - " . $student_id;

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function GetandCheckCGPaymentOrderId() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $order_id = common::StrToDB($this->order_id);
        $ObjDB = new class_db();
        $query = "SELECT a.*, b.category, b.registration_number, b.login_id, b.student_name FROM itdc_counselling_payment_tbl a, itdc_student_details_tbl b WHERE a.student_loginid=b.login_id AND a.razorpay_order_id='$order_id' AND a.payment_status='20' LIMIT 1";
//        $query = "SELECT a.*, b.category FROM itdc_counselling_payment_tbl a, itdc_student_details_tbl b WHERE a.student_loginid=b.login_id AND a.razorpay_order_id='$order_id' LIMIT 1";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function UpdateCounsellingPaymentSuccess() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->order_id);
        $course = common::StrToDB($this->course);
        $payment_notes = common::StrToDB($this->payment_notes);
        $razorpay_signature = common::StrToDB($this->razorpay_signature);
        $razorpay_payment_id = common::StrToDB($this->razorpay_payment_id);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_counselling_payment_tbl SET payment_status='10', razorpay_payment_id='$razorpay_payment_id', razorpay_signature='$razorpay_signature', payment_notes='$payment_notes', payment_date='$add_date' WHERE razorpay_order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_update = "UPDATE itdc_selected_program_tbl SET counselling_fee_status='10' WHERE login_id='$student_id' AND program_id='$course'";
        $ObjDB->sproc_name = $query_update;
        $RESUPDATE = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Counselling Payment Success, razorpay_order_id - " . $order_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RESUPDATE;
    }

    public function UpdateCounsellingPaymentFailure() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $order_id = common::StrToDB($this->order_id);
        $payment_notes = common::StrToDB($this->payment_notes);
        $razorpay_payment_id = common::StrToDB($this->razorpay_payment_id);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_counselling_payment_tbl SET payment_status='30', razorpay_payment_id='$razorpay_payment_id', payment_notes='$payment_notes' WHERE razorpay_order_id='$order_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Counselling Payment Failure, razorpay_order_id - " . $order_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function GetCGPaymentForMultiReceiptDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT a.*, b.unique_id, b.entrance_roll_number FROM itdc_counselling_payment_tbl a, itdc_selected_program_tbl b WHERE a.student_loginid=b.login_id AND a.student_loginid='$student_id' AND a.program_id=b.program_id AND a.program_id='$program_id' AND a.payment_status='10' ORDER BY a.id DESC LIMIT 1";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetProgramDetails() {
        $RES = "invalid";
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT * FROM itdc_program_list_tbl WHERE status='10' AND program_id='$program_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function DeleteStudentChoice() {
        $add_date = date("Y-m-d H:i:s");
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $cid = common::StrToDB($this->cid);
        $position = common::StrToDB($this->position);
        $Obj_db = new class_db();

        $query = "UPDATE itdc_student_choice_tbl SET status='30', choice_series='0' WHERE cid ='$cid' AND lock_choice='20'";
        $Obj_db->sproc_name = $query;
        $result = $Obj_db->ExecuteQuery();

        $querycheck = "SELECT * FROM itdc_selected_program_tbl WHERE unique_id='$reg_number' AND program_id='$program_id' AND upgrade_seat='30'";
        $Obj_db->sproc_name = $querycheck;
        $resultcheck = $Obj_db->SelectQuery();
        if (mysqli_num_rows($resultcheck) > 0) {
            $rowcheck = mysqli_fetch_assoc($resultcheck);
            $get_choiceposition = $rowcheck['choice_series'];
        }

        $query_position = "UPDATE itdc_student_choice_tbl SET choice_series=choice_series-1 WHERE status='10' AND reg_number='$reg_number' AND program_id='$program_id' AND student_id='$student_id' AND choice_series>'$position'";
        $Obj_db->sproc_name = $query_position;
        $result_postion = $Obj_db->ExecuteQuery();

        return $result;
    }

    public function UpdateStudentChoicePosition() {
        $add_date = date("Y-m-d H:i:s");
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $cid = common::StrToDB($this->cid);
        $position = common::StrToDB($this->position);
        $current_position = common::StrToDB($this->current_position);
        $Obj_db = new class_db();
        $query_one = "UPDATE itdc_student_choice_tbl SET choice_series='$current_position' WHERE choice_series ='$position' AND reg_number='$reg_number' AND program_id='$program_id' AND student_id='$student_id'";
        $Obj_db->sproc_name = $query_one;
        $result_one = $Obj_db->ExecuteQuery();

        $query_two = "UPDATE itdc_student_choice_tbl SET choice_series='$position' WHERE cid ='$cid'";
        $Obj_db->sproc_name = $query_two;
        $result_two = $Obj_db->ExecuteQuery();
        return $result_two;
    }

    public function GetStuProgramDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT a.* FROM itdc_selected_program_tbl a WHERE a.login_id='$student_id' AND a.program_id='$program_id' AND a.unique_id='$reg_number'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function LockStudentChoice() {
        $add_date = date("Y-m-d H:i:s");
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $Obj_db = new class_db();
        $query_one = "UPDATE itdc_selected_program_tbl SET lock_choice='10' WHERE unique_id='$reg_number' AND program_id='$program_id' AND login_id='$student_id'";
        $Obj_db->sproc_name = $query_one;
        $result_one = $Obj_db->ExecuteQuery();

        $query = "UPDATE itdc_student_choice_tbl SET lock_choice='10' WHERE reg_number='$reg_number' AND program_id='$program_id' AND student_id='$student_id'";
        $Obj_db->sproc_name = $query;
        $result = $Obj_db->ExecuteQuery();

        return $result_one;
    }

    public function AddStudentOCChoice() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $select_institute = common::StrToDB($this->select_institute);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();

        $query_dataforseries = "SELECT choice_series FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number'";
        $ObjDB->sproc_name = $query_dataforseries;
        $result_dataforseries = $ObjDB->SelectQuery();
        $count_dataforseries = mysqli_num_rows($result_dataforseries);
        $choice_series = $count_dataforseries + 1;

        $query_checkduplicate = "SELECT choice_series FROM itdc_student_choice_tbl WHERE status='10' AND college_id='$select_institute' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number'";
        $ObjDB->sproc_name = $query_checkduplicate;
        $result_checkduplicate = $ObjDB->SelectQuery();
        $count_checkduplicate = mysqli_num_rows($result_checkduplicate);
        if ($count_checkduplicate == 0) {
            $add_date = date("Y-m-d H:i:s");
            $query = "INSERT itdc_student_choice_tbl SET student_id='$student_id', college_id='$select_institute', choice_series='$choice_series', program_id='$program_id', reg_number='$reg_number', add_date='$add_date'";
            $ObjDB->sproc_name = $query;
            $RES = $ObjDB->ExecuteQuery();

            $action_by = common::StrToDB($this->action_by);
            $action_bytype = common::StrToDB($this->action_bytype);
            $action_notes = "Action - Subject Choice, Student Id - " . $student_id;

            $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
            $ObjDB->sproc_name = $query_activitylog;
            $result_activitylog = $ObjDB->ExecuteQuery();
            return "10<!explode>Choice successfully added.";
        } else {
            return "20<!explode>You have already added this choice.<br/>इस विकल्प का आप पहले चयन कर चुके है | ";
        }
    }

    public function GetOGSubjectList() {
        $RES = "invalid";
        $college_id = common::StrToDB($this->college_id);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();

        $query = "SELECT * FROM itdc_college_subject_tbl WHERE status='10' AND college_id='$college_id' AND program_id='$program_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function AddStudentOGChoice() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $select_institute = common::StrToDB($this->select_institute);
        $select_subject = common::StrToDB($this->select_subject);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();

        $query_dataforseries = "SELECT choice_series FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number'";
        $ObjDB->sproc_name = $query_dataforseries;
        $result_dataforseries = $ObjDB->SelectQuery();
        $count_dataforseries = mysqli_num_rows($result_dataforseries);
        $choice_series = $count_dataforseries + 1;

        $query_checkduplicate = "SELECT choice_series FROM itdc_student_choice_tbl WHERE status='10' AND college_id='$select_institute' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number' AND subject_one='$select_subject'";
        $ObjDB->sproc_name = $query_checkduplicate;
        $result_checkduplicate = $ObjDB->SelectQuery();
        $count_checkduplicate = mysqli_num_rows($result_checkduplicate);
        if ($count_checkduplicate == 0) {
            $add_date = date("Y-m-d H:i:s");
            $query = "INSERT itdc_student_choice_tbl SET student_id='$student_id', subject_one='$select_subject', college_id='$select_institute', choice_series='$choice_series', program_id='$program_id', reg_number='$reg_number', add_date='$add_date'";
            $ObjDB->sproc_name = $query;
            $RES = $ObjDB->ExecuteQuery();

            $action_by = common::StrToDB($this->action_by);
            $action_bytype = common::StrToDB($this->action_bytype);
            $action_notes = "Action - Subject Choice, Student Id - " . $student_id;

            $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
            $ObjDB->sproc_name = $query_activitylog;
            $result_activitylog = $ObjDB->ExecuteQuery();
            return "10<!explode>Choice successfully added.";
        } else {
            return "20<!explode>You have already added this choice.<br/>इस विकल्प का आप पहले चयन कर चुके है | ";
        }
    }

    public function GetOGMasterSubjectList() {
        $program_id = common::StrToDB($this->program_id);
        $RES = "invalid";
        $query = "SELECT sid, subject_name, subject_name_hindi FROM itdc_college_subject_tbl WHERE status='10' AND program_id='$program_id' ORDER BY subject_name ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetTSSubjectOneList() {
        $RES = "invalid";
        $college_id = common::StrToDB($this->college_id);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();

        $query = "SELECT * FROM itdc_college_subject_tbl WHERE status='10' AND college_id='$college_id' AND program_id='$program_id' ORDER BY subject_name ASC";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetTSSubjectTwoList() {
        $RES = "invalid";
        $dy = "";
        $college_id = common::StrToDB($this->college_id);
        $program_id = common::StrToDB($this->program_id);
        $subject_one = common::StrToDB($this->subject_one);
        $ObjDB = new class_db();

        $query_one = "SELECT subject_group FROM itdc_college_subject_tbl WHERE status='10' AND sid='$subject_one' AND college_id='$college_id' AND program_id='$program_id' ORDER BY subject_name ASC";
        $ObjDB->sproc_name = $query_one;
        $result_one = $ObjDB->SelectQuery();
        list($subject_group) = mysqli_fetch_row($result_one);
        $subject_group_arr = explode("-", $subject_group);
        if ($subject_group_arr[0] == "1") {
            $dy = " AND subject_group!='$subject_group'";
        }

        $query = "SELECT * FROM itdc_college_subject_tbl WHERE status='10' AND college_id='$college_id' AND sid!='$subject_one' $dy AND program_id='$program_id' ORDER BY subject_name ASC";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetTSSubjectThreeList() {
        $RES = "invalid";
        $college_id = common::StrToDB($this->college_id);
        $program_id = common::StrToDB($this->program_id);
        $subject_one = common::StrToDB($this->subject_one);
        $subject_two = common::StrToDB($this->subject_two);
        $ObjDB = new class_db();

        $query_one = "SELECT subject_group FROM itdc_college_subject_tbl WHERE status='10' AND sid='$subject_one' AND college_id='$college_id' AND program_id='$program_id' ORDER BY subject_name ASC";
        $ObjDB->sproc_name = $query_one;
        $result_one = $ObjDB->SelectQuery();
        list($subject_group) = mysqli_fetch_row($result_one);
        $subject_group_arr = explode("-", $subject_group);
        if ($subject_group_arr[0] == "1") {
            $dy .= " AND subject_group!='$subject_group'";
        }

        $query_two = "SELECT subject_group FROM itdc_college_subject_tbl WHERE status='10' AND sid='$subject_two' AND college_id='$college_id' AND program_id='$program_id' ORDER BY subject_name ASC";
        $ObjDB->sproc_name = $query_two;
        $result_two = $ObjDB->SelectQuery();
        list($subject_newgroup) = mysqli_fetch_row($result_two);
        $subject_newgroup_arr = explode("-", $subject_newgroup);
        if ($subject_newgroup_arr[0] == "1") {
            $dy .= " AND subject_group!='$subject_newgroup'";
        }

        if (($subject_group_arr[0] == "2") && (($subject_newgroup_arr[0] == "2"))) {
            $dy .= " AND subject_group!='2-2'";
        }
        if (($subject_group_arr[0] == "3") && (($subject_newgroup_arr[0] == "3"))) {
            $dy .= " AND subject_group!='3-2'";
        }

        $query = "SELECT * FROM itdc_college_subject_tbl WHERE status='10' AND college_id='$college_id' AND sid!='$subject_one' AND sid!='$subject_two' $dy AND program_id='$program_id' ORDER BY subject_name ASC";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function AddStudentTSChoice() {
        $RES = "invalid";
        $errorflagmsg = "";
        $errorflag = 0;
        $student_id = common::StrToDB($this->student_id);
        $select_institute = common::StrToDB($this->select_institute);
        $select_subject_one = common::StrToDB($this->select_subject_one);
        $select_subject_two = common::StrToDB($this->select_subject_two);
        $select_subject_three = common::StrToDB($this->select_subject_three);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();

        $query_dataforseries = "SELECT choice_series FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number'";
        $ObjDB->sproc_name = $query_dataforseries;
        $result_dataforseries = $ObjDB->SelectQuery();
        $count_dataforseries = mysqli_num_rows($result_dataforseries);
        $choice_series = $count_dataforseries + 1;

        $query_checkduplicate = "SELECT choice_series FROM itdc_student_choice_tbl WHERE status='10' AND college_id='$select_institute' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number' AND subject_one='$select_subject_one' AND subject_two='$select_subject_two' AND subject_three='$select_subject_three'";
        $ObjDB->sproc_name = $query_checkduplicate;
        $result_checkduplicate = $ObjDB->SelectQuery();
        $count_checkduplicate = mysqli_num_rows($result_checkduplicate);
        if ($count_checkduplicate == 0) {


            $query_one = "SELECT subject_group FROM itdc_college_subject_tbl WHERE status='10' AND sid='$select_subject_one' AND college_id='$college_id' AND program_id='$program_id'";
            $ObjDB->sproc_name = $query_one;
            $result_one = $ObjDB->SelectQuery();
            list ($subject_onegroup) = mysqli_fetch_row($result_one);
            $subject_onegroup_arr = explode("-", $subject_onegroup);

            $query_two = "SELECT subject_group FROM itdc_college_subject_tbl WHERE status='10' AND sid='$select_subject_two' AND college_id='$college_id' AND program_id='$program_id'";
            $ObjDB->sproc_name = $query_two;
            $result_two = $ObjDB->SelectQuery();
            list ($subject_twogroup) = mysqli_fetch_row($result_two);
            $subject_twogroup_arr = explode("-", $subject_twogroup);

            $query_three = "SELECT subject_group FROM itdc_college_subject_tbl WHERE status='10' AND sid='$select_subject_three' AND college_id='$college_id' AND program_id='$program_id'";
            $ObjDB->sproc_name = $query_three;
            $result_three = $ObjDB->SelectQuery();
            list ($subject_threegroup) = mysqli_fetch_row($result_three);
            $subject_threegroup_arr = explode("-", $subject_threegroup);

            if (($subject_onegroup_arr[0] == "2") && ($subject_twogroup_arr[0] == "2") && ($subject_threegroup_arr[0] == "2")) {
                $errorflag = 1;
                $errorflagmsg = "20<!explode>You have select invalid choice.";
            } elseif (($subject_onegroup_arr[0] == "3") && ($subject_twogroup_arr[0] == "3") && ($subject_threegroup_arr[0] == "3")) {
                $errorflag = 1;
                $errorflagmsg = "20<!explode>You have select invalid choice.";
            } elseif (($subject_onegroup_arr[0] == "1") && ($subject_twogroup_arr[0] == "1")) {
                $errorflag = 1;
                $errorflagmsg = "20<!explode>You have select invalid choice.";
            } elseif (($subject_onegroup_arr[0] == "1") && ($subject_threegroup_arr[0] == "3")) {
                $errorflag = 1;
                $errorflagmsg = "20<!explode>You have select invalid choice.";
            } elseif (($subject_twogroup_arr[0] == "1") && ($subject_threegroup_arr[0] == "3")) {
                $errorflag = 1;
                $errorflagmsg = "20<!explode>You have select invalid choice.";
            }

            if (($select_subject_one == "6") || ($select_subject_two == "6") || ($select_subject_three == "6")) {
                if (($select_subject_one == "20") || ($select_subject_two == "20") || ($select_subject_three == "20")) {
                    
                } else {
                    $errorflag = 1;
                    $errorflagmsg = "20<!explode>Taking math alongside statistics is mandatory.<br>सांख्यिकी के साथ गणित लेना अनिवार्य है।";
                }
            }

            if ($errorflag == 0) {
                $add_date = date("Y-m-d H:i:s");
                $query = "INSERT itdc_student_choice_tbl SET student_id='$student_id', subject_one='$select_subject_one', subject_two='$select_subject_two', subject_three='$select_subject_three', college_id='$select_institute', choice_series='$choice_series', program_id='$program_id', reg_number='$reg_number', add_date='$add_date'";
                $ObjDB->sproc_name = $query;
                $RES = $ObjDB->ExecuteQuery();

                $action_by = common::StrToDB($this->action_by);
                $action_bytype = common::StrToDB($this->action_bytype);
                $action_notes = "Action - Subject Choice, Student Id - " . $student_id;

                $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
                $ObjDB->sproc_name = $query_activitylog;
                $result_activitylog = $ObjDB->ExecuteQuery();
                return "10<!explode>Choice successfully added.";
            } else {
                return $errorflagmsg;
            }
        } else {
            return "20<!explode>You have already added this choice.<br/>इस विकल्प का आप पहले चयन कर चुके है | ";
        }
    }

    public function InsertSeatAllotmentPaymentDetail() {
        $log = new common();
        $ObjDB = new class_db();
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $course = common::StrToDB($this->hidden_programid);
        $student_rollnumber = common::StrToDB($this->student_rollnumber);
        $pay_amount = common::StrToDB($this->pay_amount);
        $hidden_collegeid = common::StrToDB($this->hidden_collegeid);

        $payment_uniqueid = "DDUSA" . date("ymdHis") . mt_rand(11, 99) . $student_id;
        $query = "INSERT INTO itdc_seatallotment_payment_tbl SET order_id='$payment_uniqueid', college_id='$hidden_collegeid', program_id='$course', student_loginid='$student_id', seat_allotment_fees='$pay_amount', payable_fees='$pay_amount',payment_date='$add_date'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Initiate Seatallotment Payment, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $payment_uniqueid;
    }

    public function UpdateSeatAllotmentRazorPayOrderId() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->receipt);
        $razorpay_order_id = common::StrToDB($this->razorpay_order_id);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_seatallotment_payment_tbl SET razorpay_order_id='$razorpay_order_id' WHERE order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        return $RES;
    }

    public function GetandCheckSAPaymentOrderId() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $order_id = common::StrToDB($this->order_id);
        $ObjDB = new class_db();
        $query = "SELECT a.*, b.category, b.registration_number, b.login_id, b.student_name FROM itdc_seatallotment_payment_tbl a, itdc_student_details_tbl b WHERE a.student_loginid=b.login_id AND a.razorpay_order_id='$order_id' AND a.payment_status='20' LIMIT 1";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function UpdateSeatAllotmentPaymentSuccess() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->order_id);
        $course = common::StrToDB($this->course);
        $payment_notes = common::StrToDB($this->payment_notes);
        $razorpay_signature = common::StrToDB($this->razorpay_signature);
        $razorpay_payment_id = common::StrToDB($this->razorpay_payment_id);
        $paid_amount = common::StrToDB($this->paid_amount);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_seatallotment_payment_tbl SET payment_status='10', razorpay_payment_id='$razorpay_payment_id', razorpay_signature='$razorpay_signature', payment_notes='$payment_notes', payment_date='$add_date' WHERE razorpay_order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_update = "UPDATE itdc_selected_program_tbl SET seat_payment_status='10', seat_payment_id='$razorpay_payment_id', seat_payment_date='$add_date'  WHERE login_id='$student_id' AND program_id='$course'";
        $ObjDB->sproc_name = $query_update;
        $RESUPDATE = $ObjDB->ExecuteQuery();

        $query_update = "UPDATE itdc_student_choice_tbl SET payment_status='10', paid_amount='$paid_amount', payment_id='$razorpay_payment_id', payment_date='$add_date' WHERE student_id='$student_id' AND program_id='$course' AND seat_allotment_status='10'";
        $ObjDB->sproc_name = $query_update;
        $RESUPDATE = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Seat Allotment Payment Success, razorpay_order_id - " . $order_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RESUPDATE;
    }

    public function UpdateSeatAllotmentPaymentFailure() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $order_id = common::StrToDB($this->order_id);
        $payment_notes = common::StrToDB($this->payment_notes);
        $razorpay_payment_id = common::StrToDB($this->razorpay_payment_id);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_seatallotment_payment_tbl SET payment_status='30', razorpay_payment_id='$razorpay_payment_id', payment_notes='$payment_notes' WHERE razorpay_order_id='$order_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Seat Allotment Payment Failure, razorpay_order_id - " . $order_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function GetProgramCollegeSeatData() {
        $RES = "invalid";
        $hidden_collegeid = common::StrToDB($this->hidden_collegeid);
        $query = "SELECT * FROM itdc_college_list_tbl WHERE cid='$hidden_collegeid' AND status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetProgramCollegeSeatDataForPayment() {
        $RES = "invalid";
        $hidden_collegeid = common::StrToDB($this->college_id);
        $student_id = common::StrToDB($this->student_id);
        $course = common::StrToDB($this->course);
        $query = "SELECT b.* FROM itdc_student_choice_tbl a, itdc_college_list_tbl b WHERE a.college_id=b.cid AND a.program_id=b.program_id AND a.college_id='$hidden_collegeid' AND a.student_id='$student_id' AND a.program_id='$course' AND a.seat_allotment_status='10' AND a.status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetStudentDataForForCounsellingPdf() {
        $result = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT a.*, b.upgrade_seat, b.choice_round, b.choice_series FROM itdc_result_tbl a, itdc_selected_program_tbl b WHERE a.sp_id=b.id AND a.login_id='$student_id' AND a.program_id='$program_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetOnlyAllotedSeatForSeatAllotmentPDF() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();
        $query = "SELECT a.*, b.seat_allotment_fee FROM itdc_student_choice_tbl a, itdc_college_list_tbl b WHERE a.college_id=b.cid AND a.program_id=b.program_id AND a.status='10' AND a.student_id='$student_id' AND a.program_id='$program_id' AND a.reg_number='$reg_number' AND a.seat_allotment_status='10' ORDER BY a.choice_series ASC";

//        $query = "SELECT * FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number' AND seat_allotment_status='10' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetAllotedSeatForSeatAllotmentPDF() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();
        $query = "SELECT a.*, b.seat_allotment_fee FROM itdc_student_choice_tbl a, itdc_college_list_tbl b WHERE a.college_id=b.cid AND a.program_id=b.program_id AND a.status='10' AND a.student_id='$student_id' AND a.program_id='$program_id' AND a.reg_number='$reg_number' AND a.seat_allotment_status='10' ORDER BY a.choice_series ASC";

//        $query = "SELECT * FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number' AND seat_allotment_status='10' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetUploadedDocumentList() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $query = "SELECT a.*, b.document_name FROM itdc_upload_document_tbl a, itdc_master_uploads_tbl b WHERE a.document_type=b.did AND a.student_id='$student_id' AND a.status='10' ORDER BY a.document_type ASC";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function UpdateUpgradeSeatStatus() {
        $RES = "invalid";
        $add_date = date('Y-m-d');
        $student_id = common::StrToDB($this->student_id);
        $program_id = common::StrToDB($this->program_id);
        $action_status = common::StrToDB($this->action_status);
        $query = "UPDATE itdc_selected_program_tbl SET upgrade_seat='$action_status', upgrade_date='$add_date' WHERE login_id='$student_id' AND program_id='$program_id'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        return $RES;
    }

    public function GetAllotedSeatForSeatPayment() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();
        $query = "SELECT a.*, b.seat_allotment_fee FROM itdc_student_choice_tbl a, itdc_college_list_tbl b WHERE a.college_id=b.cid AND a.program_id=b.program_id AND a.status='10' AND a.student_id='$student_id' AND a.program_id='$program_id' AND a.reg_number='$reg_number' AND a.seat_allotment_status='10' ORDER BY a.choice_series ASC";

//        $query = "SELECT * FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number' AND seat_allotment_status='10' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetCounPendingPaymentData() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $ObjDB = new class_db();
        $query = "SELECT login_id FROM itdc_selected_program_tbl WHERE absent='P' AND counselling_fee_status='20' AND login_id='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetDirectAdmisionForCounsellingPdf() {
        $result = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT a.*, b.entrance_roll_number, b.seat_payment_status, b.unique_id, b.alloted_subject, b.allotment_under_category, c.program_name, d.employee_ward_kota, c.regular_sfs, c.sfs_fullfee, c.fix_allotment_fee, c.fixuniversity_emp_allotment_fee FROM itdc_student_details_tbl a, itdc_selected_program_tbl b, itdc_program_list_tbl c, itdc_login_tbl d WHERE a.login_id=b.login_id AND b.program_id=c.program_id AND a.login_id=d.login_id AND a.login_id='$student_id' AND b.program_id='$program_id' AND b.seat_payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetDetailsforDirectAdmissionPayment() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT a.*, b.regular_sfs, b.sfs_fullfee, b.fix_allotment_fee, b.fixuniversity_emp_allotment_fee, b.scst_optional_allotment_fee, b.program_name, c.employee_ward_kota, d.category FROM itdc_selected_program_tbl a, itdc_program_list_tbl b, itdc_login_tbl c, itdc_student_details_tbl d WHERE a.program_id=b.program_id AND a.login_id=c.login_id AND c.login_id=d.login_id AND a.login_id='$student_id' AND a.program_id='$program_id' AND a.unique_id='$reg_number' AND a.seat_allotment_status='10' AND a.payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function InsertDirectAdmissionPaymentDetail() {
        $log = new common();
        $ObjDB = new class_db();
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $course = common::StrToDB($this->hidden_programid);
        $student_rollnumber = common::StrToDB($this->student_rollnumber);
        $pay_amount = common::StrToDB($this->pay_amount);
        $scst_fees = common::StrToDB($this->scst_fees);
        $employee_ward_kota = common::StrToDB($this->employee_ward_kota);
        $full_amount = common::StrToDB($this->full_amount);

        $payment_uniqueid = "DDUDA" . date("ymdHis") . mt_rand(11, 99) . $student_id;
        $query = "INSERT INTO itdc_seatallotment_payment_tbl SET order_id='$payment_uniqueid', full_amount='$full_amount', scst_fees='$scst_fees', employee_ward_kota='$employee_ward_kota', program_id='$course', student_loginid='$student_id', seat_allotment_fees='$pay_amount', payable_fees='$pay_amount',payment_date='$add_date'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Initiate Seatallotment Payment, Student Id - " . $student_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $payment_uniqueid;
    }

    public function GetandCheckDirectPaymentOrderId() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $order_id = common::StrToDB($this->order_id);
        $ObjDB = new class_db();
        $query = "SELECT a.*, b.category, b.registration_number, b.login_id, b.student_name FROM itdc_seatallotment_payment_tbl a, itdc_student_details_tbl b WHERE a.student_loginid=b.login_id AND a.razorpay_order_id='$order_id' AND a.payment_status='20' LIMIT 1";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetandCheckSeatAllotPaymentOrderId() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $order_id = common::StrToDB($this->order_id);
        $ObjDB = new class_db();
        $query = "SELECT a.*, b.category, b.registration_number, b.login_id, b.student_name FROM itdc_seatallotment_payment_tbl a, itdc_student_details_tbl b WHERE a.student_loginid=b.login_id AND a.razorpay_order_id='$order_id' AND a.payment_status='20' LIMIT 1";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function UpdateDirectAdmissionPaymentSuccess() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $student_id = common::StrToDB($this->student_id);
        $order_id = common::StrToDB($this->order_id);
        $course = common::StrToDB($this->course);
        $payment_notes = common::StrToDB($this->payment_notes);
        $razorpay_signature = common::StrToDB($this->razorpay_signature);
        $razorpay_payment_id = common::StrToDB($this->razorpay_payment_id);
        $paid_amount = common::StrToDB($this->paid_amount);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_seatallotment_payment_tbl SET payment_status='10', razorpay_payment_id='$razorpay_payment_id', razorpay_signature='$razorpay_signature', payment_notes='$payment_notes', payment_date='$add_date' WHERE razorpay_order_id='$order_id' AND student_loginid='$student_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $query_update = "UPDATE itdc_selected_program_tbl SET seat_payment_status='10', seat_payment_id='$razorpay_payment_id', seat_payment_date='$add_date'  WHERE login_id='$student_id' AND program_id='$course'";
        $ObjDB->sproc_name = $query_update;
        $RESUPDATE = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Direct Admission Payment Success, razorpay_order_id - " . $order_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RESUPDATE;
    }

    public function UpdateDirectAdmissionPaymentFailure() {
        $RES = "invalid";
        $add_date = date('Y-m-d H:i:s');
        $order_id = common::StrToDB($this->order_id);
        $payment_notes = common::StrToDB($this->payment_notes);
        $razorpay_payment_id = common::StrToDB($this->razorpay_payment_id);
        $ObjDB = new class_db();
        $query = "UPDATE itdc_seatallotment_payment_tbl SET payment_status='30', razorpay_payment_id='$razorpay_payment_id', payment_notes='$payment_notes' WHERE razorpay_order_id='$order_id'";
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->ExecuteQuery();

        $ObjDB = new class_db();
        $action_by = common::StrToDB($this->action_by);
        $action_bytype = common::StrToDB($this->action_bytype);
        $action_notes = "Action - Direct Admission Payment Failure, razorpay_order_id - " . $order_id . ", Payment Notes - " . $payment_notes . ", Order Id - " . $order_id;
        $add_date = date("Y-m-d H:i:s");

        $query_activitylog = "INSERT INTO itdc_activity_log_tbl SET action_by='$action_by', action_bytype='$action_bytype', notes='$action_notes', add_date='$add_date'";
        $ObjDB->sproc_name = $query_activitylog;
        $result_activitylog = $ObjDB->ExecuteQuery();
        return $RES;
    }

    public function GetDirectAdmissionPaymentDetails() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $query = "SELECT a.* FROM itdc_seatallotment_payment_tbl a WHERE a.student_loginid='$student_id' AND a.program_id='$program_id' AND a.payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetDetailsforSeatAllotmentPayment() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
//        $query = "SELECT a.* FROM itdc_selected_program_tbl a WHERE a.login_id='$student_id' AND a.program_id='$program_id' AND a.unique_id='$reg_number'";
        
        $query = "SELECT a.*, b.college_fixfee, b.pract_subjectfee_ba, b.regular_sfs, b.sfs_fullfee, b.fix_allotment_fee, b.fixuniversity_emp_allotment_fee, b.scst_optional_allotment_fee, b.program_type, b.practical_subject_list, b.program_name, c.employee_ward_kota, d.category FROM itdc_selected_program_tbl a, itdc_program_list_tbl b, itdc_login_tbl c, itdc_student_details_tbl d WHERE a.program_id=b.program_id AND a.login_id=c.login_id AND c.login_id=d.login_id AND a.login_id='$student_id' AND a.program_id='$program_id' AND a.unique_id='$reg_number' AND a.payment_status='10' AND a.seat_allotment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetAllotedSeatForAllotedPage() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();
        $query = "SELECT a.* FROM itdc_student_choice_tbl a, itdc_college_list_tbl b WHERE a.college_id=b.cid AND a.program_id=b.program_id AND a.status='10' AND a.student_id='$student_id' AND a.program_id='$program_id' AND a.reg_number='$reg_number' AND a.seat_allotment_status='10' ORDER BY a.choice_series ASC";

//        $query = "SELECT * FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number' AND seat_allotment_status='10' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function CounsellingSeatAllotmentFeeDeatils() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();
        $query = "SELECT * FROM itdc_seatallotment_payment_tbl WHERE payment_status='10' AND student_loginid='$student_id' AND program_id='$program_id' ORDER BY id ASC";

//        $query = "SELECT * FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number' AND seat_allotment_status='10' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function AllowForSecondRoundCounselling() {
        $add_date = date("Y-m-d H:i:s");
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $Obj_db = new class_db();

        $query_one = "UPDATE itdc_selected_program_tbl a, itdc_result_tbl b, itdc_student_choice_tbl c SET b.choice_lock_status='20', a.choice_round=NULL, a.lock_choice='20', c.lock_choice='20', a.seat_allotment_status='20', a.allotment_date=NULL, a.allotment_under_category=NULL, a.choice_series=NULL, a.choice_pk_id=NULL, c.seat_allotment_status='20', b.seat_allotment_status='20', b.allotment_under_category=NULL, b.choice_series=NULL, b.choice_pk_id=NULL, a.request_forcoun_two='10' WHERE a.unique_id=b.registration_number AND a.unique_id=c.reg_number AND a.unique_id='$reg_number' AND a.program_id='$program_id' AND a.login_id='$student_id' AND a.seat_allotment_status='50'";
        $Obj_db->sproc_name = $query_one;
        $result_one = $Obj_db->ExecuteQuery();

        return $result_one;
    }

    public function GetChoiceDetailsForProviousSeat($choice_pk_id_c1) {
        $RES = "invalid";
        $choice_pk_id_c1 = common::StrToDB($choice_pk_id_c1);
        $ObjDB = new class_db();
        $query = "SELECT * FROM itdc_student_choice_tbl WHERE cid='$choice_pk_id_c1'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetPaidFeeCaseOfUpgrade($student_id, $program_id) {
        $RES = "invalid";
        $student_id = common::StrToDB($student_id);
        $program_id = common::StrToDB($program_id);
        $ObjDB = new class_db();
        $query = "SELECT SUM(payable_fees) AS payable_fees FROM itdc_seatallotment_payment_tbl WHERE student_loginid='$student_id' AND program_id='$program_id' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }

    public function GetCounsellingSeatAllotmentFeeDeatils() {
        $RES = "invalid";
        $student_id = common::StrToDB($this->student_id);
        $reg_number = common::StrToDB($this->reg_number);
        $program_id = common::StrToDB($this->program_id);
        $ObjDB = new class_db();
        $query = "SELECT SUM(payable_fees) AS payable_fees, ANY_VALUE(razorpay_payment_id) AS razorpay_payment_id, ANY_VALUE(payment_date) AS payment_date FROM itdc_seatallotment_payment_tbl WHERE payment_status='10' AND student_loginid='$student_id' AND program_id='$program_id' ORDER BY id DESC";

//        $query = "SELECT * FROM itdc_student_choice_tbl WHERE status='10' AND student_id='$student_id' AND program_id='$program_id' AND reg_number='$reg_number' AND seat_allotment_status='10' AND payment_status='10'";
        $ObjDB = new class_db();
        $ObjDB->sproc_name = $query;
        $RES = $ObjDB->SelectQuery();
        return $RES;
    }
}

?>