<?php
include_once 'session/session.php';
include_once 'classes/settings.php';
include_once 'classes/class_db.php';
$contact_number = $_SESSION['contact_number'];
$otp_session = $_SESSION['otp'];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['otp'])) {
    $otp_input = trim($_POST['otp']);
    if ($otp_input == $otp_session) {
        $_SESSION['verified'] = true;
        unset($_SESSION['otp']); 
        header("Location:member_form.php"); 
        exit;
    } else {
        $error = "Invalid OTP. Please try again.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Verify OTP</title>
<link href="images/logo.jpeg" rel="icon">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    body {
        background-color: #f8f9fa;
        display: flex; 
        align-items: center;
        justify-content: center;
        min-height: 100vh;
        margin: 0;
    }
    .card {
        max-width: 400px;
        padding: 25px;
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        width: 90%;
    }
</style>
</head>
<body>
<div class="card">
    <h2 class="text-center mb-4 text-primary">Verify OTP</h2>
    <p class="text-center mb-3">Please enter the OTP sent to <?php echo htmlspecialchars($contact_number); ?></p>
    <?php if(isset($error)): ?>
        <div class="alert alert-danger text-center"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="mb-3">
            <label class="form-label fw-bold">Enter OTP</label>
            <input type="text" name="otp" class="form-control form-control-lg text-center" 
                   placeholder="6-digit code" inputmode="numeric" pattern="[0-9]*" 
                   maxlength="6" required>
        </div>
        <div class="d-grid gap-2">
            <button type="submit" class="btn btn-success btn-lg">Verify & Login</button>
        </div>
    </form>
    
    <div class="text-center mt-3">
        <a href="index.php" class="text-decoration-none text-muted">Go back to change number</a>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>