<?php

include_once 'classes/settings.php';
$ObjDB = new class_settings();
$conn = $ObjDB->MyConnectDB();
if (!isset($_SESSION['verified'])) {
    header("Location:index.php");
    exit;
}
$contact_number = $_SESSION['contact_number'];
$result = mysqli_query($conn, "SELECT * FROM bni_members_tbl WHERE contact_number='$contact_number'");
$row = mysqli_fetch_assoc($result);

if (!$row) {
    die("No member found with this contact number.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle photo upload
    $photo_path = $row['photo']; // Keep existing photo by default

    if (isset($_FILES['photo_file']) && $_FILES['photo_file']['error'] === UPLOAD_ERR_OK) {
        $file_tmp = $_FILES['photo_file']['tmp_name'];
        $file_name = basename($_FILES['photo_file']['name']);
        $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
        $allowed = ['jpg', 'jpeg', 'png', 'gif'];

        if (in_array($ext, $allowed)) {
            $upload_dir = 'images';
            if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
            $new_name = $upload_dir . '/' . time() . '_' . $file_name;
            if (move_uploaded_file($file_tmp, $new_name)) {
                $photo_path = $new_name;
            }
        }
    }

    // Escape inputs
    $full_name = mysqli_real_escape_string($conn, $_POST['full_name']);
    $category = mysqli_real_escape_string($conn, $_POST['category']);
    $brief_personal_desc = mysqli_real_escape_string($conn, $_POST['brief_personal_desc']);
    $brief_business_desc = mysqli_real_escape_string($conn, $_POST['brief_business_desc']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);
    $facebook_link = mysqli_real_escape_string($conn, $_POST['facebook_link']);
    $youtube_link = mysqli_real_escape_string($conn, $_POST['youtube_link']);
    $their_give = mysqli_real_escape_string($conn, $_POST['their_give']);
    $their_ask = mysqli_real_escape_string($conn, $_POST['their_ask']);

    // Update database
    $update_query = "UPDATE bni_members_tbl SET
        photo='$photo_path',
        full_name='$full_name',
        category='$category',
        brief_personal_desc='$brief_personal_desc',
        brief_business_desc='$brief_business_desc',
        address='$address',
        facebook_link='$facebook_link',
        youtube_link='$youtube_link',
        their_give='$their_give',
        their_ask='$their_ask',
        timestamp=NOW()
        WHERE contact_number='$contact_number'";

    if (mysqli_query($conn, $update_query)) {
        $success = "Data updated successfully!";
        $result = mysqli_query($conn, "SELECT * FROM bni_members_tbl WHERE contact_number='$contact_number'");
        $row = mysqli_fetch_assoc($result);
    } else {
        $error = "Failed to update data: " . mysqli_error($conn);
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>BNI Member Profile</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
      <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            background-color: #f8f9fa;
        }
        header.navbar {
            background-color: #343a40;
        }
        header .navbar-brand, header .nav-link {
            color: #fff !important;
        }
        footer {
            background-color: #343a40;
            color: #fff;
            padding: 15px 0;
            margin-top: 40px;
            text-align: center;
        }
    </style>
</head>

<header class="navbar navbar-expand-lg navbar-dark mb-4">
    <div class="container-fluid">
        <a class="navbar-brand fw-bold" href="listing.php">BNI Members</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <?php if (isset($_SESSION['verified'])): ?>
                    <!-- <li class="nav-item"><a class="nav-link" href="member_form.php">Profile</a></li>
                    <li class="nav-item"><a class="nav-link" href="listing.php">Listing</a></li> -->
                    <li class="nav-item  btn btn-danger "><a class="nav-link" href="logout.php"><b>Logout</b></a></li>
                <?php else: ?>
                    <li class="nav-item"><a class="nav-link" href="index.php">Login</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</header>
<body class="p-3">
          <div class="container py-5">
    <div class="row align-items-center bg-white shadow-lg rounded-4 p-4 mx-auto" style="max-width: 900px;">
        
        <!-- LEFT: Profile Photo -->
        <div class="col-md-5 text-center mb-4 mb-md-0">
            <img src="<?php echo !empty($row['photo']) ? htmlspecialchars($row['photo']) : 'images/default-user.png'; ?>" 
                 alt="Profile Photo"
                 class="img-fluid rounded-4 shadow-sm"
                 style="object-fit: cover; width: 100%; max-width: 300px; height: auto;">
        </div>

        <!-- RIGHT: Profile Info -->
        <div class="col-md-7">
            <h2 class="fw-bold text-dark mb-1"><?php echo htmlspecialchars($row['full_name']); ?></h2>
            <h5 class="text-primary mb-3"><?php echo htmlspecialchars($row['category'] ?: 'Member'); ?></h5>
            
            <p class="text-muted mb-3" style="line-height: 1.6;">
                <?php echo nl2br(htmlspecialchars($row['brief_personal_desc'] ?: 'No personal description available.')); ?>
            </p>
            
            <p class="text-muted mb-4" style="line-height: 1.6;">
                <?php echo nl2br(htmlspecialchars($row['brief_business_desc'] ?: 'No business description available.')); ?>
            </p>

            <ul class="list-unstyled mb-4">
                <li class="mb-2">
                    <i class="bi bi-telephone text-primary me-2"></i>
                    <?php echo htmlspecialchars($row['contact_number']); ?>
                </li>
                <?php if (!empty($row['address'])): ?>
                <li class="mb-2">
                    <i class="bi bi-geo-alt text-primary me-2"></i>
                    <?php echo htmlspecialchars($row['address']); ?>
                </li>
                <?php endif; ?>
                <?php if (!empty($row['facebook_link'])): ?>
                <li class="mb-2">
                    <i class="bi bi-envelope text-primary me-2"></i>
                    <a href="<?php echo htmlspecialchars($row['facebook_link']); ?>" target="_blank" class="text-decoration-none text-primary">
                        Facebook Profile
                    </a>
                </li>
                <?php endif; ?>
            </ul>

            <!-- Social Icons -->
            <div class="d-flex gap-3">
                <?php if (!empty($row['facebook_link'])): ?>
                <a href="<?php echo htmlspecialchars($row['facebook_link']); ?>" target="_blank" class="text-secondary fs-4">
                    <i class="bi bi-facebook"></i>
                </a>
                <?php endif; ?>
                <?php if (!empty($row['youtube_link'])): ?>
                <a href="<?php echo htmlspecialchars($row['youtube_link']); ?>" target="_blank" class="text-secondary fs-4">
                    <i class="bi bi-youtube"></i>
                </a>
                <?php endif; ?>
                <a href="#" class="text-secondary fs-4"><i class="bi bi-twitter"></i></a>
                <a href="#" class="text-secondary fs-4"><i class="bi bi-linkedin"></i></a>
                <a href="#" class="text-secondary fs-4"><i class="bi bi-instagram"></i></a>
            </div>
        </div>
    </div>
</div>

<footer>
    <div class="container">
        <p class="mb-0">&copy; <?php echo date("Y"); ?> BNI Members Portal | All Rights Reserved</p>
    </div>
</footer>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
