<?php
session_start();
include_once 'classes/settings.php';
$ObjDB = new class_settings();
$conn = $ObjDB->MyConnectDB();

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo "<h3 class='text-center text-danger mt-5'>Invalid member ID!</h3>";
    exit;
}

$id = intval($_GET['id']);
$query = "SELECT * FROM bni_members_tbl WHERE ask_id = $id LIMIT 1";
$result = mysqli_query($conn, $query);

if (!$result || mysqli_num_rows($result) === 0) {
    echo "<h3 class='text-center text-danger mt-5'>Member not found!</h3>";
    exit;
}

$member = mysqli_fetch_assoc($result);
mysqli_free_result($result);
mysqli_close($conn);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo htmlspecialchars($member['full_name']); ?> | BNI Member</title>
  <link href="images/logo.jpeg" rel="icon">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body { background-color: #f8f9fa; }
    .profile-card {
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 4px 15px rgba(0,0,0,0.1);
      overflow: hidden;
    }
    .profile-photo img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      border-right: 2px solid #eee;
    }
    .social-icons a {
      color: #0d6efd;
      font-size: 1.3rem;
      margin-right: 10px;
    }
    .social-icons a:hover {
      color: #0056b3;
    }
  </style>
</head>
<body>

<header class="bg-dark text-white text-center py-3 mb-4">
  <div class="container">
    <h2 class="fw-bold mb-0"><i class="bi bi-person-circle me-2"></i>Member Details</h2>
  </div>
</header>

<div class="container mb-5">
  <div class="profile-card row g-0">
    <!-- Left side: Image -->
    <div class="col-md-4 profile-photo">
      <img src="<?php echo htmlspecialchars(!empty($member['photo']) ? $member['photo'] : 'images/default-profile.png'); ?>" alt="Member Photo">
    </div>

    <!-- Right side: Details -->
    <div class="col-md-8 p-4">
      <h3 class="fw-bold text-primary"><?php echo htmlspecialchars($member['full_name']); ?></h3>
      <p class="text-secondary mb-2"><i class="bi bi-briefcase me-2"></i><?php echo htmlspecialchars($member['category']); ?></p>
      <p class="text-muted small"><?php echo htmlspecialchars($member['brief_business_desc']); ?></p>

      <hr>

      <p><i class="bi bi-telephone-fill text-primary me-2"></i><?php echo htmlspecialchars($member['contact_number']); ?></p>
      <?php if (!empty($member['address'])): ?>
      <p><i class="bi bi-geo-alt-fill text-danger me-2"></i><?php echo htmlspecialchars($member['address']); ?></p>
      <?php endif; ?>

      <div class="social-icons mt-3">
        <?php if (!empty($member['facebook_link'])): ?>
          <a href="<?php echo htmlspecialchars($member['facebook_link']); ?>" target="_blank"><i class="bi bi-facebook"></i></a>
        <?php endif; ?>
        <?php if (!empty($member['youtube_link'])): ?>
          <a href="<?php echo htmlspecialchars($member['youtube_link']); ?>" target="_blank"><i class="bi bi-youtube"></i></a>
        <?php endif; ?>
      </div>

      <?php if (!empty($member['their_give']) || !empty($member['their_ask'])): ?>
        <hr>
        <?php if (!empty($member['their_give'])): ?>
          <p><strong>They Give:</strong> <?php echo htmlspecialchars($member['their_give']); ?></p>
        <?php endif; ?>
        <?php if (!empty($member['their_ask'])): ?>
          <p><strong>They Ask:</strong> <?php echo htmlspecialchars($member['their_ask']); ?></p>
        <?php endif; ?>
      <?php endif; ?>
    </div>
  </div>

  <div class="text-center mt-4">
    <a href="members_list.php" class="btn btn-outline-primary"><i class="bi bi-arrow-left"></i> Back to Directory</a>
  </div>
</div>

<footer class="bg-dark text-center text-white py-3 mt-5">
  <p class="mb-0">&copy; <?php echo date("Y"); ?> BNI Members Portal | All Rights Reserved</p>
</footer>

</body>
</html>
