<?php
include_once 'session/session.php';
include_once 'classes/settings.php';
include_once 'classes/class_db.php';
if (!isset($_SESSION['contact_number']) || !isset($_SESSION['otp'])) {
    header("Location: index.php");
    exit;
}

$contact_number = $_SESSION['contact_number'];
$otp_session = $_SESSION['otp'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['otp'])) {
    $otp_input = trim($_POST['otp']);
    if ($otp_input == $otp_session) {
        $_SESSION['verified'] = true;
        header("Location: member_form.php");
        exit;
    } else {
        $error = "Invalid OTP. Please try again.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Verify OTP</title>
<link href="images/logo.jpeg" rel="icon">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
<div class="container">
    <h2 class="mb-4">Verify OTP for <?php echo htmlspecialchars($contact_number); ?></h2>
    <?php if(isset($error)): ?>
        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <form method="post">
        <div class="mb-3">
            <label class="form-label">Enter OTP</label>
            <input type="text" name="otp" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-success">Verify</button>
    </form>
</div>
</body>
</html>
