<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}
include_once '../classes/settings.php';
include_once '../classes/class_db.php';
$ObjDB = new class_settings();
$conn = $ObjDB->MyConnectDB();
$id = intval($_GET['id']);
$result = mysqli_query($conn, "SELECT * FROM bni_members_tbl WHERE ask_id = $id");
$row = mysqli_fetch_assoc($result);
if (!$row) die("Member not found!");
$success = "";
$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = mysqli_real_escape_string($conn, $_POST['full_name']);
    $company = mysqli_real_escape_string($conn, $_POST['Company']);
    $category = mysqli_real_escape_string($conn, $_POST['category']);
    $brief_personal_desc = mysqli_real_escape_string($conn, $_POST['brief_personal_desc']);
    $brief_business_desc = mysqli_real_escape_string($conn, $_POST['brief_business_desc']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);
    $facebook_link = mysqli_real_escape_string($conn, $_POST['facebook_link']);
    $youtube_link = mysqli_real_escape_string($conn, $_POST['youtube_link']);
    $instagram_link = mysqli_real_escape_string($conn, $_POST['instagram_link']);
    $their_give = mysqli_real_escape_string($conn, $_POST['their_give']);
    $their_ask = mysqli_real_escape_string($conn, $_POST['their_ask']);
    $photo_name = $row['photo'];
    if (isset($_FILES['photo']) && $_FILES['photo']['error'] !== UPLOAD_ERR_NO_FILE) {
        $file = $_FILES['photo'];
        if ($file['error'] === UPLOAD_ERR_OK) {
            $file_tmp = $file['tmp_name'];
            $file_name = basename($file['name']);
            $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
            $allowed = ['jpg', 'jpeg', 'png', 'gif'];
            if (!in_array($ext, $allowed)) {
                $error = "Invalid file type! Only JPG, JPEG, PNG, GIF allowed.";
            } elseif ($file['size'] > 5 * 1024 * 1024) {
                $error = "File too large! Maximum 5 MB allowed.";
            } else {
                $upload_dir = '../images/';
                if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
                $photo_name = time() . '_' . preg_replace("/[^A-Za-z0-9_.-]/", "_", $file_name);
                $upload_path = $upload_dir . $photo_name;
                if (move_uploaded_file($file_tmp, $upload_path)) {
                    if (!empty($row['photo']) && file_exists($upload_dir . $row['photo'])) {
                        unlink($upload_dir . $row['photo']);
                    }
                } else {
                    $error = "Failed to move uploaded file!";
                }
            }
        } else {
            $error = "File upload failed!";
        }
    }
    if (empty($error)) {
        $query = "UPDATE bni_members_tbl SET photo='$photo_name', full_name='$full_name', Company='$company', category='$category',brief_personal_desc='$brief_personal_desc', brief_business_desc='$brief_business_desc', address='$address', facebook_link='$facebook_link', youtube_link='$youtube_link',instagram_link='$instagram_link', their_give='$their_give', their_ask='$their_ask', timestamp=NOW() WHERE ask_id=$id";
        if (mysqli_query($conn, $query)) {
            $success = "Member updated successfully!";
            $result = mysqli_query($conn, "SELECT * FROM bni_members_tbl WHERE ask_id = $id");
            $row = mysqli_fetch_assoc($result);
        } else {
            $error = "Database error: " . mysqli_error($conn);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Member</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #f4f6f9;
            font-family: "Poppins", sans-serif;
        }
        header {
            background: linear-gradient(90deg, #212529, #343a40);
        }
        .card {
            border: none;
            border-radius: 15px;
            transition: all 0.3s ease;
        }
        .card:hover {
            box-shadow: 0 6px 25px rgba(0, 0, 0, 0.1);
        }
        .form-control, textarea {
            border-radius: 10px;
        }
        .btn-primary {
            background-color: #007bff;
            border-radius: 10px;
            border: none;
        }
        .btn-primary:hover {
            background-color: #0056b3;
        }
        .btn-secondary {
            border-radius: 10px;
        }
        .rounded-circle {
            border: 2px solid #ddd;
        }
        .alert {
            border-radius: 10px;
        }
        label {
            font-weight: 500;
        }
    </style>
</head>
<body>
<header class="text-white p-3 shadow-sm">
    <div class="container d-flex justify-content-between align-items-center">
        <h4 class="mb-0">BNI Admin Dashboard</h4>
        <a href="admin_logout.php" class="btn btn-danger btn-sm px-3">Logout</a>
    </div>
</header>

<div class="container mt-5 mb-5">
    <div class="card shadow p-4 bg-white">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3 class="text-dark mb-0">Edit Member</h3>
            <a href="admin_dashboard.php" class="btn btn-outline-secondary btn-sm"> Back</a>
        </div>

        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Full Name</label>
                    <input type="text" name="full_name" class="form-control" value="<?php echo $row['full_name']; ?>" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label>Company</label>
                    <input type="text" name="Company" class="form-control" value="<?php echo $row['Company']; ?>" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label>Category</label>
                    <input type="text" name="category" class="form-control" value="<?php echo $row['category']; ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label>Address</label>
                    <input type="text" name="address" class="form-control" value="<?php echo $row['address']; ?>">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Photo</label><br>
                    <?php if (!empty($row['photo'])) { ?>
                        <img src="../images/<?php echo $row['photo']; ?>" width="80" height="80" class="rounded-circle mb-2">
                    <?php } ?>
                    <input type="file" name="photo" class="form-control">
                    <small class="text-muted">Max 5 MB | JPG, JPEG, PNG, GIF only</small>
                </div>

                <div class="col-md-12 mb-3">
                    <label>Brief Personal Description</label>
                    <textarea name="brief_personal_desc" class="form-control" rows="2"><?php echo $row['brief_personal_desc']; ?></textarea>
                </div>
                <div class="col-md-12 mb-3">
                    <label>Brief Business Description</label>
                    <textarea name="brief_business_desc" class="form-control" rows="2"><?php echo $row['brief_business_desc']; ?></textarea>
                </div>

                <div class="col-md-4 mb-3">
                    <label>Facebook Link</label>
                    <input type="text" name="facebook_link" class="form-control" value="<?php echo $row['facebook_link']; ?>">
                </div>
                <div class="col-md-4 mb-3">
                    <label>YouTube Link</label>
                    <input type="text" name="youtube_link" class="form-control" value="<?php echo $row['youtube_link']; ?>">
                </div>
                <div class="col-md-4 mb-3">
                    <label>Instagram Link</label>
                    <input type="text" name="instagram_link" class="form-control" value="<?php echo $row['instagram_link']; ?>">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Their Give</label>
                    <input type="text" name="their_give" class="form-control" value="<?php echo $row['their_give']; ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label>Their Ask</label>
                    <input type="text" name="their_ask" class="form-control" value="<?php echo $row['their_ask']; ?>">
                </div>
            </div>

            <div class="text-end mt-3">
                <button type="submit" class="btn btn-primary px-4"> Update Member</button>
            </div>
        </form>
    </div>
</div>
</body>
</html>
