<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}
include_once '../classes/settings.php';
include_once '../classes/class_db.php';
$ObjDB = new class_settings();
$conn = $ObjDB->MyConnectDB();
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "UPDATE bni_members_tbl SET status = 3 WHERE ask_id = $id");
    header("Location: admin_dashboard.php");
    exit;
}
$result = mysqli_query($conn, "SELECT * FROM bni_members_tbl WHERE status = 1 ORDER BY full_name ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>BNI Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- DataTables -->
    <link href="https://cdn.datatables.net/2.0.5/css/dataTables.bootstrap5.min.css" rel="stylesheet">

    <style>
        body {
            background-color: #f3f6fa;
            font-family: "Poppins", sans-serif;
        }

        header {
            background: linear-gradient(90deg, #0d6efd, #6610f2);
        }

        .table th {
            background-color: #343a40 !important;
            color: white;
            text-align: center;
            vertical-align: middle;
        }

        .table td {
            vertical-align: middle;
        }

        .status-active {
            color: green;
            font-weight: 600;
        }

        .card {
            border-radius: 10px;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
            border: none;
        }

        .btn-primary, .btn-success, .btn-danger {
            border-radius: 8px;
        }

        table.dataTable thead th {
            border-bottom: none;
        }

        .dataTables_wrapper .dataTables_filter input {
            border-radius: 8px;
            border: 1px solid #ccc;
            padding: 6px;
        }
    </style>
</head>
<body>

<header class="text-white py-3 shadow-sm">
    <div class="container d-flex justify-content-between align-items-center">
        <h3 class="m-0">BNI Admin Dashboard</h3>
        <a href="admin_logout.php" class="btn btn-light btn-sm fw-bold">Logout</a>
    </div>
</header>

<div class="container mt-5">
    <div class="card p-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0 fw-semibold"> Members Lists</h4>
            <a href="admin_add_member.php" class="btn btn-success">
                <i class="bi bi-plus-circle"></i> Add Member
            </a>
        </div>

        <div class="table-responsive">
            <table id="membersTable" class="table table-striped table-bordered align-middle">
                <thead>
                    <tr>
                        <th>Photo</th>
                        <th>Full Name</th>
                        <th>Company</th>
                        <th>Category</th>
                        <th>Contact</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($row = mysqli_fetch_assoc($result)): ?>
                    <tr>
                        <td class="text-center">
                            <?php if (!empty($row['photo'])): ?>
                                <img src="../images/<?php echo $row['photo']; ?>" 
                                     width="60" height="60" 
                                     style="object-fit:cover;border-radius:50%;box-shadow:0 0 5px rgba(0,0,0,0.2);">
                            <?php else: ?>
                                <span class="text-muted">No photo</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['Company']); ?></td>
                        <td><?php echo htmlspecialchars($row['category']); ?></td>
                        <td><?php echo htmlspecialchars($row['contact_number']); ?></td>
                        <td class="text-center">
                            <span class="status-active">Active</span>
                        </td>
                        <td class="text-center">
                            <a href="admin_edit_member.php?id=<?php echo $row['ask_id']; ?>" 
                               class="btn btn-sm btn-primary me-1">Edit</a>
                            <a href="admin_dashboard.php?delete=<?php echo $row['ask_id']; ?>" 
                               class="btn btn-sm btn-danger"
                               onclick="return confirm('Are you sure you want to delete this member?');">
                               Delete
                            </a>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
  $(document).ready(function() {
    $('#membersTable').DataTable({
      responsive: true,
      pageLength: 10,
      lengthChange: true,
      ordering: true,
      autoWidth: false,
      language: {
        search: "_INPUT_",
        searchPlaceholder: "Search members..."
      },
      columnDefs: [
        { orderable: false, targets: [1, 6] } // disable ordering for Photo and Action columns
      ]
    });
  });
</script>

</body>
</html>
