<?php
include_once '../session/admin-session.php';
include_once '../classes/class_admin.php';
include_once '../classes/validation.php';
include_once '../classes/common.php';
include_once '../classes/transcriptcal.php';
include_once '../classes/sgpa.php';
include_once 'read-configration.php';

$ObjDB = new class_db();
$objadm = new class_admin();
$val = new validation();

 require_once('../tcpdf/tcpdf.php');
 
$issuedate = $val->ValidateString($_REQUEST["issuedate"]);
$stu_roll = $val->ValidateString($_REQUEST["rollno"]);

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, 'pt', PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('IISER Pune');
$pdf->SetTitle('IISER Pune');
$pdf->SetSubject('Learning');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
$pdf->SetMargins(20, 20, 20, true);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
$pdf->SetAutoPageBreak(trUE, PDF_MARGIN_BOTTOM);
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

  $objadm->roll_number = $stu_roll;
  $res_StudentDet = $objadm->GetStudentDetailsbyRollNumber();

$num = mysqli_num_rows($res_StudentDet);
if ($num != 1)
    die("Incorrect Roll Number");
$row = mysqli_fetch_array($res_StudentDet);
$stu_name = $row["name"];
$batch = $row["batch"];
$dob = $row["dob"];
$sem_now = $row["sem_now"];
$reg_status = $row["reg_status"];
$sem_reg = $sem_now + 1;
$reg_file = "isr_reg_" . $batch."_tbl";
$complition_year = "ongoing";
$photo = "../stu_photos/" . substr($stu_roll, 2) . ".JPG";

$roll_year = substr($stu_roll, 0, 4);

$base_period = (($roll_year - 2006) * 2);
$admission_period = $base_period + 1;

// $period = $semb1 - 1;
$period = $semb1;

$file_name = $stu_roll . '.pdf';
// $file_pass = $stu_roll . $dob_pass;
// $file_pass = "12345";
$file_pass = "";

$pdf->SetFont('helvetica', '', 10);
$pdf->AddPage();
$pdf->SetProtection(array('print-high', 'copy'), $file_pass, null, 0, null);
$pdf->SetAlpha(0.1);

// $pdf->Image('../image/IISER_RoundStamp7', $myX, $myY, $ImageW, $ImageH, '', '', '', true, 150);

//$pdf->Image('../image/IISER_RoundStamp7.png', '150', '150', '300', '300', '', '', '', true, 150);

$pdf->SetAlpha(1);

$view_tbl = "";

include "sub-list-finder.php";

$view_tbl .= '<html><body><style type="text/css">
                    body, html{
                        font-family: arial;
                        font-size: 10px;
                    }
                    td{
                        padding: 1px;
                    }
                </style>
            <center><img src="../image/Transcript_head_1_transparent.png" width="600" border="0" alt="" align="center"></center>
            <br/>
            <table cellspacing="0" cellpadding="1" width = "100%" align="center">
                <tr><td align="center" style="font-size: 12px;"><b>Consolidated Transcript</b></td></tr>
            </table>
            <br/>
            <table cellspacing="0" cellpadding="1" width = "100%" align="center">
                <tr><td width="130" align="left">Name of the student</td><td align="left"><b>' . strtoupper($stu_name) . '</b></td><td width="120" align="left">Year of Joining</td><td align="left"><b>' . substr($stu_roll, 0, 4) . '</b></td></tr>
                <tr><td align="left">Roll Number</td><td align="left"><b>' . $stu_roll . '</b></td><td align="left">Year of Completion</td><td align="left"><b>In progress</b></td></tr>
            </table>';

$query1 = "SELECT a.sub_code, a.grade, b.sub_crdit FROM $reg_file a, isr_curriculum_tbl b where a.stu_roll = '$stu_roll' and a.sub_code = b.sub_code and a.sub_list = b.sub_list and a.sub_flag = 'Y' and a.sem < 9 order by a.sem, b.sub_crdit desc, b.sub_code";
$ObjDB->sproc_name = $query1;
$res_query1 = $ObjDB->SelectQuery();

$tot_credit = 0;
$tot_cr_val = 0;

while ($row1 = mysqli_fetch_array($res_query1)) {
    $sub_code = $row1['sub_code'];
    $grade = $row1['grade'];
    $crdit = $row1['sub_crdit'];
    $tot_credit = $tot_credit + $crdit;
    $grade_value = GetGradeValue($reg_file, $grade);
    $cr_val = $crdit * $grade_value;
    $tot_cr_val = $tot_cr_val + $cr_val;
}

$cgpa = round(($tot_cr_val / $tot_credit), 1);

$query = "SELECT a.b1_sem AS substr, a.sub_code, a.grade, a.sem, b.sub_title, b.sub_crdit from $reg_file a, isr_curriculum_tbl b where a.sub_list = b.sub_list and a.grade in ('A+', 'A', 'B+', 'B', 'C+', 'C', 'D', 'P', 'i', 'F') and a.sub_flag = 'Y' and a.stu_roll = '$stu_roll' and a.sub_code = b.sub_code order by a.b1_sem, a.sub_code";
$ObjDB->sproc_name = $query;
$res_query = $ObjDB->SelectQuery();

$total_rows = mysqli_num_rows($res_query);
$left_rows = ceil($total_rows / 2);
$right_rows = $total_rows - $left_rows;
$row_count = 0;

$leftColumn = "";
$rightColumn = "";
$bio_credits = 0;
$chm_credits = 0;
$mth_credits = 0;
$phy_credits = 0;
$hss_credits = 0;
$idc_credits = 0;
$tdc_credits = 0;
$ecs_credits = 0;
$ds_credits = 0;
$se_credits = 0;

$sem_break = 4;
$right_sem = $sem_break + 1;
$old_sem = 1;

while ($row = mysqli_fetch_array($res_query)) {
    $row_count++;
    $sub_code = $row["sub_code"];
    $sub_title = $row["sub_title"];
    $grade = $row["grade"];
    $sem = $row["sem"];
    $substr = $row["substr"];
    if ($row_count == 1) {
        $base_sem = $substr;
    }
    $sem_show = $substr - $base_sem + 1;
    $sub_credit = $row["sub_crdit"];
    if (substr($sub_code, 0, 2) == 'MT' and $grade != '')
        $mth_credits = $mth_credits + $sub_credit;
    if (substr($sub_code, 0, 2) == 'BI' and $grade != '')
        $bio_credits = $bio_credits + $sub_credit;
    if (substr($sub_code, 0, 2) == 'PH' and $grade != '')
        $phy_credits = $phy_credits + $sub_credit;
    if (substr($sub_code, 0, 2) == 'CH' and $grade != '')
        $chm_credits = $chm_credits + $sub_credit;
    if (substr($sub_code, 0, 2) == 'HS' and $grade != '')
        $hss_credits = $hss_credits + $sub_credit;
    if (substr($sub_code, 0, 2) == 'ID' and $grade != '')
        $idc_credits = $idc_credits + $sub_credit;
    if (substr($sub_code, 0, 2) == 'TD' and $grade != '')
        $tdc_credits = $tdc_credits + $sub_credit;
    if (substr($sub_code, 0, 2) == 'EC' and $grade != '')
        $ecs_credits = $ecs_credits + $sub_credit;
    if (substr($sub_code, 0, 2) == 'DS' and $grade != '')
        $ds_credits = $ds_credits + $sub_credit;
    if (substr($sub_code, 0, 2) == 'SE' and $grade != '')
        $se_credits = $se_credits + $sub_credit;

    if ($row_count <= $left_rows) {
        if ($substr != $old_sem) {
            if ($row_count > 1) {
                $leftColumn .= '<tr style="line-height: 3px;"><td colspan="5">&nbsp;</td></tr>';
            }
            $old_sem = $substr;
        }
        $leftColumn .= '<tr><td style="border: 0px #ddd solid;">' . $sem_show . '</td><td style="border: 0px #ddd solid;">' . $sub_code . '</td><td style="border: 0px #ddd solid;text-align:left;">' . $sub_title . '</td><td style="border: 0px #ddd solid;" align=center>' . round($sub_credit) . '</td><td style="border: 0px #ddd solid;">&nbsp;' . $grade . '</td></tr>';
    } else {
        if ($substr != $old_sem) {
            $rightColumn .= '<tr style="line-height: 3px;"><td colspan="5">&nbsp;</td></tr>';
            $old_sem = $substr;
        }
        $rightColumn .= '<tr><td style="border: 0px #ddd solid;">' . $sem_show . '</td><td style="border: 0px #ddd solid;">' . $sub_code . '</td><td style="border: 0px #ddd solid;text-align:left;">' . $sub_title . '</td><td style="border: 0px #ddd solid;" align=center>' . round($sub_credit) . '</td><td style="border: 0px #ddd solid;">&nbsp;' . $grade . '</td></tr>';
    }
}

$view_tbl .= '<br/><table cellspacing="0" cellpadding="1" align="center" width="100%">
    <tr>
        <td>';
$total_credit_registered = 0;
$total_credit_cleared = 0;
$total_credit_gpa = 0;
$total_total_mul = 0;
$total_credit_cgpa = 0;
$total_total_mul_cgpa = 0;

for ($peri = $admission_period; $peri <= $period; $peri++) {

    $qry = "SELECT distinct a.sub_code, a.grade, b.sub_crdit, b.sub_title FROM $reg_file a, isr_curriculum_tbl b where b.sub_list = a.sub_list and a.grade in ('A+', 'A', 'B+', 'B', 'C+', 'C', 'D', 'P', 'i', 'F') and a.sub_code = b.sub_code and a.sub_flag in ('Y','T') and a.stu_roll = '$stu_roll' and a.b1_sem = '$peri' order by a.sub_code";
   $ObjDB->sproc_name = $qry;
   $res_qry = $ObjDB->SelectQuery();
  

    $credit_registered[$peri] = 0;
    $credit_cleared[$peri] = 0;
    $credit_gpa[$peri] = 0;
    $total_mul[$peri] = 0;
    $total_mul_cgpa[$peri] = 0;

    while ($row = mysqli_fetch_array($res_qry)) {
        $sub_code = $row['sub_code'];
        $sub_credit = $row['sub_crdit'];
        $sub_title = $row['sub_title'];
        $grade = $row['grade'];

        if ($grade == "A+") {
            $var = 10;
        }
        if ($grade == "A") {
            $var = 9;
        }
        if ($grade == "B+") {
            $var = 8;
        }
        if ($grade == "B") {
            $var = 7;
        }
        if ($grade == "C+") {
            $var = 6;
        }
        if ($grade == "C") {
            $var = 5;
        }
        if ($grade == "D") {
            $var = 4;
        }
        if ($grade == "F") {
            $var = 0;
        }
        if ($grade == "I") {
            $var = 0;
        }
        if ($grade == "P") {
            $var = 0;
        }

        $mul_value = $sub_credit * $var;
        $credit_registered[$peri] = $credit_registered[$peri] + $sub_credit;
        if ($grade == "A+" or $grade == "A" or $grade == "B+" or $grade == "B" or $grade == "C+" or $grade == "C" or $grade == "D" or $grade == "P") {
            $credit_cleared[$peri] = $credit_cleared[$peri] + $sub_credit;
        }
        if ($grade == "A+" or $grade == "A" or $grade == "B+" or $grade == "B" or $grade == "C+" or $grade == "C" or $grade == "D" or $grade == "F") {
            $credit_gpa[$peri] = $credit_gpa[$peri] + $sub_credit;
            $total_mul[$peri] = $total_mul[$peri] + $mul_value;
        }
        if ($grade == "A+" or $grade == "A" or $grade == "B+" or $grade == "B" or $grade == "C+" or $grade == "C" or $grade == "D"  or $grade == "F") {
            $credit_cgpa[$peri] = $credit_cgpa[$peri] + $sub_credit;
            $total_mul_cgpa[$peri] = $total_mul_cgpa[$peri] + $mul_value;
        }
    }
    $gpa[$peri] = round(($total_mul[$peri] / $credit_gpa[$peri]), 1);

    $total_credit_registered = $total_credit_registered + $credit_registered[$peri];
    $total_credit_cleared = $total_credit_cleared + $credit_cleared[$peri];
    $total_credit_gpa = $total_credit_gpa + $credit_gpa[$peri];
    $total_total_mul = $total_total_mul + $total_mul[$peri];

    $total_credit_cgpa = $total_credit_cgpa + $credit_cgpa[$peri];
    $total_total_mul_cgpa = $total_total_mul_cgpa + $total_mul_cgpa[$peri];
}
$cgpa = round(($total_total_mul_cgpa / $total_credit_cgpa), 1);
$view_tbl .= '<table cellspacing="0" cellpadding="1" width = "100%">
                <tr>
                    <td colspan="4" style="border: 0px #ddd solid;"><b>Semester-wise performance</b></td>
                </tr>
                <tr>
                    <td style="border: 0px #ddd solid;"><b>Semester</b></td>
                    <td style="border: 0px #ddd solid;"><b>Credits Registered</b></td>
                    <td style="border: 0px #ddd solid;"><b>Credits Completed</b></td>
                    <td style="border: 0px #ddd solid;"><b>GPA</b></td>
                </tr>';
for ($jj = $admission_period; $jj <= $period; $jj++) {
    
             $qsem = "select new_name from isr_iiser_sem_tbl where sem_num = '$jj'";
    $ObjDB->sproc_name = $qsem;
    $res_qsem = $ObjDB->SelectQuery();
    list($sem_name) = mysqli_fetch_row($res_qsem);
    
    $view_tbl .= '<tr>';
    if ($credit_registered[$jj] > 0) {
        $view_tbl .= '<td style="border: 0px #ddd solid;">' . $sem_name . '</td>
                      <td style="border: 0px #ddd solid;">' . $credit_registered[$jj] . '</td>
                      <td style="border: 0px #ddd solid;">' . $credit_cleared[$jj] . '</td>
                      <td style="border: 0px #ddd solid;">' . number_format($gpa[$jj], 1) . '</td>';
    }
    $view_tbl .= '</tr>';
}
$view_tbl .= '<tr>
                    <td style="border: 0px #ddd solid;"><b>Cumulative</b></td>
                    <td style="border: 0px #ddd solid;">' . $total_credit_registered . '</td>
                    <td style="border: 0px #ddd solid;">' . $total_credit_cleared . '</td>
                    <td style="border: 0px #ddd solid;">' . number_format($cgpa, 1) . '</td>
             </tr>
            </table>
            </td>
            <td>
        <table cellspacing="0" cellpadding="1" width="100%">
                <tr>
                    <td style="border: 0px #ddd solid;" colspan="2"><b>Discipline-wise credit distribution</b></td>
                </tr>

                <tr>
                    <td style="border: 0px #ddd solid;width:80%;text-align:left;">&nbsp;Biology</td>
                    <td style="border: 0px #ddd solid;width:20%;">' . $bio_credits . '</td>
                </tr>
                <tr>
                    <td style="border: 0px #ddd solid;text-align:left;">&nbsp;Chemistry</td>
                    <td style="border: 0px #ddd solid;">' . $chm_credits . '</td>
                </tr>
                <tr>
                    <td style="border: 0px #ddd solid;text-align:left;">&nbsp;Data Science</td>
                    <td style="border: 0px #ddd solid;">' . $ds_credits . '</td>
                </tr>
                <tr>
                    <td style="border: 0px #ddd solid;text-align:left;">&nbsp;Earth and Climate Science</td>
                    <td style="border: 0px #ddd solid;">' . $ecs_credits . '</td>
                </tr>
                <tr>
                    <td style="border: 0px #ddd solid;text-align:left;">&nbsp;Humanities and Social Sciences</td>
                    <td style="border: 0px #ddd solid;">' . $hss_credits . '</td>
                </tr>
         <!--       <tr>
                    <td style="border: 0px #ddd solid;text-align:left;">&nbsp;Inter Disciplinary Courses</td>
                    <td style="border: 0px #ddd solid;">' . $idc_credits . '</td>
                </tr>  -->
                <tr>
                    <td style="border: 0px #ddd solid;text-align:left;">&nbsp;Mathematics</td>
                    <td style="border: 0px #ddd solid;">' . $mth_credits . '</td>
                </tr>
                <tr>
                    <td style="border: 0px #ddd solid;text-align:left;">&nbsp;Physics</td>
                    <td style="border: 0px #ddd solid;">' . $phy_credits . '</td>
                </tr>

                <tr>
                    <td style="border: 0px #ddd solid;text-align:left;">&nbsp;Science Education</td>
                    <td style="border: 0px #ddd solid;">' . $se_credits . '</td>
                </tr>
                <tr>
                    <td style="border: 0px #ddd solid;text-align:left;">&nbsp;Transdisciplinary</td>
                    <td style="border: 0px #ddd solid;">' . $tdc_credits . '</td>
                </tr>

        </table>
</td></tr></table><br/>';
if ($add_project == 'Y') {
    $view_tbl .= '<table cellspacing="0" cellpadding="1" align="center">
    </table>';
}


if ($leftColumn != "") {
    $leftColumn = '<table cellspacing="0" cellpadding="1" align="center" width="100%">
		<tr>
                <td style="border: 0px #ddd solid;width:7%;"><b>Sem</b></td>
                <td style="border: 0px #ddd solid;width:13%;"><b>Code</b></td>
                <td style="border: 0px #ddd solid;width:66%;"><b>Course Title</b></td>
                <td style="border: 0px #ddd solid;width:7%;"><b>CR</b></td>
                <td style="border: 0px #ddd solid;width:7%;"><b>GR</b></td>
                </tr>' . $leftColumn . '</table>';
}
if ($rightColumn != "") {

    $rightColumn = '<table cellspacing="0" cellpadding="1" align="center" width="100%">
		<tr>
                <td style="border: 0px #ddd solid;width:7%;"><b>Sem</b></td>
                <td style="border: 0px #ddd solid;width:13%;"><b>Code</b></td>
                <td style="border: 0px #ddd solid;width:66%;"><b>Course Title</b></td>
                <td style="border: 0px #ddd solid;width:7%;"><b>CR</b></td>
                <td style="border: 0px #ddd solid;width:7%;"><b>GR</b></td>
                </tr>' . $rightColumn . '</table>';
}

$view_tbl .= '<br/><table cellspacing="0" cellpadding="1" align="center">
    <tr>
        <td>' . $leftColumn . '</td>
        <td>' . $rightColumn . '</td>
    </tr>
    </table>
    <br/>&nbsp;<br/><table cellspacing="0" cellpadding="1" align="center">
    <tr>
        <td style="border: 0px #ddd solid;" style="text-align:center;">Grade Values: A+ = 10; A = 9, B+ = 8, B = 7; C+ = 6; C = 5; D = 4;<br/>
            P = pass, but credits not counted towards GPA; I = incomplete, 0 credits; F = fail, 0 credits.</td>
    </tr>
</table>
<table cellspacing="0" cellpadding="1" align="center">
    <tr>
        <td style="text-align:left;color:red;"><BR/><BR/><br/>Date of issue:' . $issuedate . '</td>
        <td rowspan="2">&nbsp;</td>

        <td rowspan="2"><IMG SRC="../image/new_dean3.jpg" WIDTH="120" HEIGHT="41" BORDER="0" ALT="Dean, Academics"></td>
	</tr>
		<tr><td style="text-align:left; text-decoration: overline;">
		This is an electronically generated transcript
		</td></tr>
	</table></body></html>';

//echo $view_tbl;

$pdf->writeHTML($view_tbl, true, false, true, false, '');
//$pdf->Output();
$pdf->Output($file_name, 'D');
exit();
?>