<?php
include_once '../session/admin-session.php';
include_once '../classes/class_admin.php';
include_once '../classes/validation.php';
include_once '../classes/common.php';
include_once 'read-configration.php';

ob_start();
$ObjDB = new class_db();
$objadm = new class_admin();
$val = new validation();

$batch = $val->ValidateString($_REQUEST['batch']);
$reg_file = "isr_reg_".$batch."_tbl";
include_once 'sub-list-finder.php';

$i = 1;

$objadm->batch = $batch;
$BatchArr = $objadm->GetStudentDetailsbyBatch();

?>
<div class="container-fluid">
    <div class="row">
        <div class="col-xl-12 col-xxl-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Credit Distribution <?php echo $batch; ?></h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered align-middle">
                            <thead>
                                <tr>
                                    <th >&nbsp;
                                    <th >Roll
                                    <th >Name
                                    <th >BIO
                                    <th >CHM
                                    <th >ECS
                                    <th >IDC
                                    <th >HSS
                                    <th >MTH
                                    <th >PHY
                                    <th >TOT
                                    <th >Highest
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                while ($rowm = mysqli_fetch_array($BatchArr)) {
	$stu_roll = $rowm['roll'];
	$stu_name = ucwords(strtolower($rowm['name']));
	?>
	<tr>
	<td ><?php echo $i; ?></td>
	<td ><?php echo $stu_roll; ?><Td ><?php echo $stu_name; ?>
	<?php 
	if($batch == 'b12' or $barch == 'r10') {
		$query="SELECT a.sub_code, a.grade, a.sem, b.sub_title, b.sub_crdit from $reg_file a, isr_curriculum_tbl b where b.sub_list = a.sub_list and a.sem >= 5 and a.sem <= 8 and a.sub_flag = 'Y' and a.stu_roll = '$stu_roll' and a.sub_code = b.sub_code and a.grade in ('O', 'A', 'B', 'C', 'D', 'S') order by a.sub_code";
	} else {
		$query="SELECT a.sub_code, a.grade, a.sem, b.sub_title, b.sub_crdit from $reg_file a, isr_curriculum_tbl b where b.sub_list = a.sub_list and a.sem >= 5 and a.sem <= 8 and a.sub_flag = 'Y' and a.stu_roll = '$stu_roll' and a.sub_code = b.sub_code and a.grade in ('A+', 'A', 'B+', 'B', 'C+', 'C', 'D', 'S') order by a.sub_code";
	}
        $ObjDB->sproc_name = $query;
        $res_query = $ObjDB->SelectQuery();

	$bio_credits = 0;
	$chm_credits = 0;
	$mth_credits = 0;
	$phy_credits = 0;
	$hss_credits = 0;
	$idc_credits = 0;
	$ecs_credits = 0;

	while ($row = mysqli_fetch_array($res_query)) {
		$col_rows++;
		$sub_code = $row["sub_code"];
		$grade= $row["grade"];
		$sem= $row["sem"];
		$sub_credit= $row["sub_crdit"];

		if (substr($sub_code,0,2) == 'MT') $mth_credits = $mth_credits + $sub_credit;
		if (substr($sub_code,0,2) == 'BI') $bio_credits = $bio_credits + $sub_credit;
		if (substr($sub_code,0,2) == 'PH') $phy_credits = $phy_credits + $sub_credit;
		if (substr($sub_code,0,2) == 'CH') $chm_credits = $chm_credits + $sub_credit;
		if (substr($sub_code,0,2) == 'HS') $hss_credits = $hss_credits + $sub_credit;
		if (substr($sub_code,0,2) == 'ID') $idc_credits = $idc_credits + $sub_credit;
		if (substr($sub_code,0,2) == 'TD') $idc_credits = $idc_credits + $sub_credit;
		if (substr($sub_code,0,2) == 'EC') $ecs_credits = $ecs_credits + $sub_credit;

	}
	$total = $bio_credits + $chm_credits + $mth_credits + $phy_credits + $hss_credits + $idc_credits + $ecs_credits;
	$highest = max($bio_credits, $chm_credits, $mth_credits, $phy_credits, $hss_credits, $idc_credits, $ecs_credits);
	$dept = '';
	if ($highest == $bio_credits) $dept = 'BIO';
	if ($highest == $chm_credits) $dept = 'CHM';
	if ($highest == $mth_credits) $dept = 'MTH';
	if ($highest == $phy_credits) $dept = 'PHY';
	if ($highest == $hss_credits) $dept = 'HSS';
	if ($highest == $idc_credits) $dept = 'IDC';
	if ($highest == $ecs_credits) $dept = 'ECS';
	
	?>
	<td ><?php echo $bio_credits;?></td>
	<td ><?php echo $chm_credits;?></td>
	<td ><?php echo $ecs_credits;?></td>
	<td ><?php echo $idc_credits;?></td>
	<td ><?php echo $hss_credits;?></td>
	<td ><?php echo $mth_credits;?></td>
	<td ><?php echo $phy_credits;?></td>
	<td ><?php echo $total ;?></td>
	<td ><?php echo $dept ;?> (<?php echo $highest ;?>)</td></tr>

	<?php
	$i++;
} ?>
                               
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$pagemaincontent = ob_get_contents();
ob_clean();
$PAGENAME = 'reports-credit-distribution-view';
$HTMLTITLE = '';
$HTMLDESCRIPTION = '';
$HTMLKEYWORDS = '';
include("admin-master.php");
?>