<?php
include_once '../session/admin-session.php';
include_once '../classes/class_admin.php';
include_once '../classes/validation.php';
include_once '../classes/common.php';
include_once '../classes/transcriptcal.php';
include_once '../classes/sgpa.php';
include_once 'read-configration.php';

ob_start();
$ObjDB = new class_db();
$objadm = new class_admin();
$val = new validation();
$message = "";
if ($_POST) {

    $stu_roll = $val->ValidateString($_REQUEST['rollno']);
    $major_subject = "";
    $objadm->roll_number = $stu_roll;
    $query = $objadm->GetStudentDetailsbyRollNumber();
    $num = mysqli_num_rows($query);
    if ($num > 0) {
        $row = mysqli_fetch_array($query);
        $stu_roll = $row["roll"];
        $stu_name = $row["name"];
        $batch = $row["batch"];

        $dob = $row["dob"];
        $sem_now = $row["sem_now"];
        $reg_status = $row["reg_status"];
        $issuedate = $val->ValidateString($_REQUEST["issuedate"]);

        $fee_OK = $row["fee_OK"];
        $cgpa_OK = $row["cgpa_OK"];

        $sem_reg = $sem_now + 1;
        $reg_file = "isr_reg_" . $batch . "_tbl";
        $reg_set = 0;
    } else {
        $message = "No Records Found!";
    }
}
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-xl-12 col-xxl-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Transcript</h5>
                </div>
                <div class="card-body">
                    <div class="row"><div class="col-lg-12"><?php echo $message; ?></div></div>
                    <form class="" method="POST" >
                        <div class="row">
                            <div class="col-lg-4">
                                <label>Issue Date:</label>
                                <input type="text" readonly="" name="issuedate"  id="issuedate" class="form-control datebox" placeholder="d-M-Y" autocomplete="off" value="<?php echo DATE('d-m-Y'); ?>"/>
                            </div>
                            <div class="col-lg-4">
                                <label>Roll Number:</label>
                                <input type="text" name="rollno"  class="form-control"/>
                            </div>
                            <div class="col-lg-4">
                                <INPUT class="btn btn-primary" type="submit" value="Submit" name="Submit"/>
                            </div>
                        </div>
                    </form>
                    <br/><br/>
                    <?php if ($_POST && $num > 0) { ?>
                        <table class="table table-bordered align-middle">
                            <tr>
                                <td><strong>Name of the Student: </strong><?php echo ucwords(strtolower($stu_name)); ?></td>
                                <td><strong>Roll Number: </strong><?php echo $stu_roll; ?></td>
                            </tr>
                        </table>
                        <?php
                        $query = "SELECT distinct sem from $reg_file";
                        $ObjDB->sproc_name = $query;
                        $res_Query = $ObjDB->SelectQuery();
                        $numberofrows = mysqli_num_rows($res_Query);
                        $tot_credit = 0;
                        $tot_credit_value = 0;
                        $tot_credit_obtained = 0;
                        $tot_cr = 0;
                        $tot_cr_val = 0;

                        if (substr($batch, 0, 1) == 'r') {
                            $jj = 11;
                        } else {
                            $jj = 1;
                        }
                        if ($numberofrows > 10) {
                            $goupto = 10;
                        } else {
                            $goupto = $numberofrows + $jj - 1;
                        }

                        for ($i = $jj; $i <= $goupto; $i++) {
                            $spi = "";
                            $cpi = "";
                            $cos = "";
                            $tco = "";
                            ?>
                            <table class="table table-bordered align-middle">
                                <thead>
                                    <tr><th colspan="7"> Semester : <?php echo $i; ?></th></tr>
                                </thead>
                                <?php
                                $to_cal = 1;

                                $grade_list = "('A+', 'A', 'B+', 'B', 'C+', 'C', 'D', 'P', 'F', 'I')";
                                $query = "SELECT a.sub_code, a.grade, a.grade_flag, b.sub_title, b.sub_crdit from $reg_file a, isr_curriculum_tbl b where b.sub_list = a.sub_list and a.sub_flag = 'Y' and a.sem = '$i' and a.stu_roll = '$stu_roll' and a.sub_code = b.sub_code and a.grade in $grade_list order by a.sub_code";
                                $ObjDB->sproc_name = $query;
                                $res_query = $ObjDB->SelectQuery();
                                
                                $j = 1;
                                $sum_cr[$i] = 0;
                                $sum_crshow[$i] = 0;
                                $sum_cr_val[$i] = 0;

                                while ($row = mysqli_fetch_array($res_query)) {
                                    $how_clear = "";
                                    $sub_code = $row["sub_code"];
                                    $grade = $row["grade"];
                                    $grade_flag = $row["grade_flag"];

                                    echo "<TR><TD width=20>" . $j++ . "</TD>";
                                    echo "<TD wodth=80>" . $sub_code . "</TD>";
                                    $sub_credit = $row["sub_crdit"];

                                    if (($grade != "I") and ($grade != "P")) {
                                        $sum_cr[$i] = $sum_cr[$i] + $sub_credit;
                                    }
                                    if (($grade != "I") and ($grade != "F")) {
                                        $sum_crshow[$i] = $sum_crshow[$i] + $sub_credit;
                                    }
                                    $sub_title = $row["sub_title"];
                                    echo "<TD width=400>" . $sub_title . "</TD>";
                                    echo "<TD width=50>" . $sub_credit . "</TD>";
                                    echo "<TD width=50>&nbsp;" . $grade . "</TD>";
                                    $grade_value = GetGradeValue($reg_file, $grade);
                                    $credit_value = $grade_value * $sub_credit;
                                    echo "<TD width=50>&nbsp;" . $grade_value . "</TD>";
                                    echo "<TD width=50>&nbsp;" . $credit_value . "</TD>";
                                    $sum_cr_val[$i] = $sum_cr_val[$i] + $credit_value;
                                }
                                
                                if($sum_cr[$i]>0){
                                ?>
                                
                                <tr><td colspan=3>&nbsp;
                                    <td><?php echo $sum_cr[$i]; ?>
                                    <td colspan=2>&nbsp;
                                    <td><?php echo $sum_cr_val[$i]; ?></tr>
                                <tr><td colspan=3><B>SGPA</B>: <?php echo '(' . $sum_cr_val[$i] . ' / ' . $sum_cr[$i] . ') = ' . ($sum_cr_val[$i] / $sum_cr[$i]); ?>
                                    <td colspan=3><B>Credit Obtained</B>: <?php echo $sum_crshow[$i]; ?></tr>
                            </table>
                            <?php
                                }
                            $tot_credit = $tot_credit + $sum_cr[$i];
                            $tot_credit_value = $tot_credit_value + $sum_cr_val[$i];
                            $tot_credit_obtained = $tot_credit_obtained + $sum_crshow[$i];
                        }
                        $cgpa = $tot_credit_value / $tot_credit;
                        ?>
                    <br/>
                    <table class="table table-bordered align-middle">
<tr><td><B>CGPA</B>: <?php echo '(' . $tot_credit_value . ' / ' . $tot_credit . ') = ' . ($tot_credit_value / $tot_credit); ?>
<td><B>Total Credit Obtained</B>: <?php echo $tot_credit_obtained; ?></tr>
</table>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php
$pagemaincontent = ob_get_contents();
ob_clean();
$PAGENAME = 'reports-cgpa-sgpa';
$HTMLTITLE = '';
$HTMLDESCRIPTION = '';
$HTMLKEYWORDS = '';
include("admin-master.php");
?>